#include "problem.h"
#include "problemdef.h"

inline int64_t abs64(int64_t val) {
	return val < 0 ? -val : val;
}
inline int32_t abs32(int32_t val) {
	return val < 0 ? -val : val;
}

BOP::BOP(size_t pid) : pid(pid) {
	u = get_u();
	v = get_v();
	xdim = static_cast<int32_t>(u.size());
	sizePF = 1;
	for (int32_t i = 0; i < xdim; i++) sizePF += abs32(u[i] - v[i]);
	sizePS = 1;
	for (int32_t i = 0; i < xdim; i++) sizePS *= (1 + abs32(u[i] - v[i]));	
}
int32_t BOP::getDim()
{
	return xdim;
}

int32_t BOP::f1(IntVec const &x) {
	int64_t sum = 0; // calculate with 64 bit to avoid integer overflow
	size_t n = x.size();
	for (size_t i = 0; i < n; i++) {
		int64_t lx = x[i], lu = u[i], diff = abs64(lx - lu);
		sum += diff;
	}
	if (sum >= INT32_MAX) return INT32_MAX; // clip to 32 bit value
	return static_cast<int32_t>(sum);
}
int32_t BOP::f2(IntVec const &x) {
	int64_t sum = 0; // calculate with 64 bit to avoid integer overflow
	size_t n = x.size();
	for (size_t i = 0; i < n; i++) {
		int64_t lx = x[i], lv = v[i], diff = abs64(lx - lv);
		sum += diff;
	}
	if (sum >= INT32_MAX) return INT32_MAX; // clip to 32 bit value
	return static_cast<int32_t>(sum);
}
int32_t BOP::getSizePF() {
	return sizePF;
}
int32_t BOP::getSizePS() {
	return sizePS;
}
IntVec BOP::get_u() {
	return umat[pid];
}
IntVec BOP::get_v() {
	return vmat[pid];
}
IntVec BOP::get_x(size_t xid) {
	return xmat[pid];
}
