#include "mutation.h"
#include "random.h"

void MutationLaplaceSubspace::mutate(double q, IntVec &x) {
	Lrnd lrnd;
	Urnd urnd;
	size_t n = x.size();
	double pm = 1. / n;
	for (size_t k = 0; k < n; k++) {
		if (urnd.rnd() >= pm) continue;
		int32_t dv = lrnd.rnd(1 - q);
		x[k] += dv;
	}
}

void MutationLaplaceFullspace::mutate(double q, IntVec &x) {
	Lrnd lrnd;
	size_t n = x.size();
	for (size_t k = 0; k < n; k++) {
		int32_t dv = lrnd.rnd(1 - q);
		x[k] += dv;
	}
}