#pragma once
#include <vector>
#include <set>
#include <string>
#include <tuple>
#include <cmath>

typedef std::vector<double> DblVec;

typedef std::vector<int32_t> IntVec;
typedef std::vector<IntVec> MatVec;
typedef std::set<int32_t> IntSet;

typedef std::tuple< //
	IntVec,			// x
	IntVec,			// fx
	double,			// step size s
	DblVec>			// path length (CSA vector)
Ind_t;    											// individual 

#define get_xvec(ind) std::get<0>(ind)
#define get_fx(ind) std::get<1>(ind)
#define get_s(ind) std::get<2>(ind)
#define get_p(ind) std::get<3>(ind)

typedef std::vector<Ind_t> Pop_t;					// population of individuals