library(raster)
library(abind)
library(tidyverse)
library(lubridate)
library(cubature)
library(mosaic)
library(stats)
library(units)
################## FUNCTION: raster_as ####
raster_as=function(matrix_to_rasterise, reference_raster){
  output=raster(matrix_to_rasterise)
  extent(output)=extent(reference_raster)
  crs(output)=crs(reference_raster)
  
  return(output)
}

################## FUNCTION: I requirement limit #######
B_limit=function(){
  B_limit=as.character(menu(c("Critical Point","Field Capacity"),title="Up to which Water Content Irrigation contributes/contributed to?"))
  return(B_limit)
}

################## FUNCTION: Irrigation units #######
I_units=function(){
  Irr_req=as.character(menu(c("mm","m3","both"),title="which Units do you want irrigation volumes to be expressed in?"))
  return(Irr_req)
}






###########################################################################################################################################################
### OBJECTIVE: DEFINE RANGES OF IRRIGATION REQUIREMETNS (MAX AND MIN) ACCORDING TO THE AVAILABLE IRRIGATION SYSTEM PER CELL AND BLUE WATER REQUIREMENTS ###
###########################################################################################################################################################


crop="maize" #(e.g. "rice","olive","vine","barley","sorghum","wheat","potato","sugarbeet","temperate fruit","other pulses","other cereals")
B_l=B_limit()# chose the blue water (B) limit, 1=Critical Point, 2=Field Capacity
from_B_to_I=I_units() #chose the units for irrigation water output: mm, m3, both

year_start=as.numeric(readline(prompt = "Enter the first year of interest:")) # e.g. interested in hy=1998-1999, enter 1998
year_end=as.numeric(readline(prompt = "Enter the last year of interest:")) #e.g. interested in hy=1998-1999, enter 1999


saving_location="C:/Users/Nike/OneDrive/Desktop/WaterCROP pulito/output/"
input_location="C:/Users/Nike/OneDrive/Desktop/WaterCROP pulito/input/"




#### UPLOAD FILES
load(paste0(input_location,"irrigation/irrigation_system_per_cell_ha.RData"))#irr_system_per_cell: ha irrigated for each irrigation system per cell 
ha_irr=raster(paste0(input_location,"crop/MAIZ_ha_irrigated.tif")) #irrigated ha for maize
ita=raster(paste0(input_location,"functional/italy.tif"))#raster of 0s and 1s to define the italian territory

file_code_crop=read.table(paste0(input_location,"functional/crop_code_file.txt"), sep=",", header = TRUE)
code=file_code_crop$code[which(file_code_crop$crop==crop)]


# B2Imax-min CODE:
years=seq(year_start,year_end,by=1)
for(y in 2:length(years)){
  
  year_1= years[y-1]
  year_2= years[y]
  
print(paste0("Working on years: ", year_1,"-", year_2))


blue_map_file=paste0(saving_location, year_1,"-",year_2,"/MAIZ_B",B_l,"_B_",year_1,"-",year_2,"_lgp_irr_WCv2.tif") #blue water requirement computed by WaterCROPv2
blue_map_r=raster(blue_map_file)
blue_map=as.matrix(blue_map_r)

m_index=read.table(paste0(input_location,"functional/matrix_index_cells.txt"), sep=",") #matrix of indexes of cells

possible_crops=c("maize","rice","olive","vine","barley","sorghum","wheat","potato","sugarbeet","temperate fruit","other pulses","other cereals")
p=which(possible_crops==crop)

{switch_crop=p}
switch (switch_crop, 
        
        "1"={ #Maiz
          
          possible_sys=c("scorrimento superficiale ed infiltrazione laterale","aspersione (a pioggia)","microirrigazione")
          
        },
        
        "2"={#rice
          
          possible_sys=c("sommersione")
          
        },
        
        "3"={ #olive
          
          possible_sys="microirrigazione"
          
        },
        
        "4"={ #vine
          
          possible_sys="microirrigazione"
          
        },
        
        "5"={#barley
          
          possible_sys=c("aspersione (a pioggia)", "microirrigazione")
          
        },
        
        "6"={ #sorghum
          
          possible_sys=c("asperione (a pioggia)","microirrigazione")
          
        },
        
        "7"={ #Wheat
          
          possible_sys=c("aspersione (a pioggia)", "microirrigazione")
          
        },
        
)
efficienze=c(0.55,0.25,0.75,0.90, 0.7)#scorriemnto&infiltrazione, #sommersione, #aspersione,#microirrigazione. #altro

types=cbind.data.frame(names(irr_systems_per_cell[[203]][1:5]),efficienze,seq(1:length(efficienze)))
colnames(types)=c("irrigation_system","efficiency","index")



#MIN MAPS
print("Working on MIN")
min_irr=matrix(NaN, 139,142)
dummy2=irr_systems_per_cell

types=types[order(types$efficiency, decreasing=TRUE),]



for(r in 1:dim(m_index)[1]){
  for(c in 1:dim(m_index)[2]){
    y=m_index[r,c] # scorre sull'elenco delle celle
    
    
    dummy2[[y]][1:6]=0
    
    if(length(irr_systems_per_cell[[y]])>0 & !is.na(blue_map[r,c])){ 
      
      k=which(irr_systems_per_cell[[y]][1:4]>0)#5=other system, 6=total
      n=names(irr_systems_per_cell[[y]])[k]#just to get names of available systems
      
      f=intersect(possible_sys,n) #intersection between possible and available irrigation systems
      
      if(length(f)==0){#empty intersection
        dummy2[[y]][5]=types$efficiency[types$irrigation_system=="altro sistema"] #let's attribute irrigation to "other system"
      }#f=0
      
      if(length(f)==1){# 1 possible+available irrigation system
        l=types$index[which(types$irrigation_system %in% f)] 
        d=ha_irr[r,c]
        
        if (d>0 & d<=irr_systems_per_cell[[y]][l]){ #the entire cultivation requirement is satisfied by the irrigation system "l"  
          dummy2[[y]][l]=types$efficiency[types$irrigation_system==names(irr_systems_per_cell[[y]][l])]
          d=0
        }else if(d>0 & d>irr_systems_per_cell[[y]][l]){
          av=irr_systems_per_cell[[y]][l]
          dummy2[[y]][l]=(av/ha_irr[r,c])/types$efficiency[types$irrigation_system==names(irr_systems_per_cell[[y]][l])] #attribuiamo al sistema presente
          d=d-av
          dummy2[[y]][5]=(d/ha_irr[r,c])/types$efficiency[types$irrigation_system=="altro sistema"]#the residual is attributed to "other system"  
        }
      }#f=1
      
      if(length(f)>1){#there are several possible+available irrigation systems: irrigation has to be subdivided among them
        l=types$index[which(types$irrigation_system %in% f)] #index referring to the orther of irrigation system in irr_system
        
        s=1
        d=ha_irr[r,c] #remaining ha
        
        while(s<=length(l) & d>0){ #keeps going till the ha are not finished or there no more possible+available irrigation systems
          
          if(d>irr_systems_per_cell[[y]][l[s]]){
            av=irr_systems_per_cell[[y]][l[s]]
            dummy2[[y]][l[s]]=(av/ha_irr[r,c])/types$efficiency[types$irrigation_system==names(irr_systems_per_cell[[y]][l[s]])]
            d=d-av
          }else if(d<irr_systems_per_cell[[y]][l[s]]){
            av=d
            dummy2[[y]][l[s]]=(av/ha_irr[r,c])/types$efficiency[types$irrigation_system==names(irr_systems_per_cell[[y]][l[s]])]
            d=0
          }
          s=s+1
        }#while
        
        if(d>0 & s>length(l)){ # in case possible+preset irrigation systems are not enough to satisfy the [ha] requested
          dummy2[[y]][5]=(d/ha_irr[r,c])/types$efficiency[types$irrigation_system=="altro sistema"]
        }
        
      }#f>1
      
      min_irr[r,c]= sum(blue_map[r,c]*dummy2[[y]]) #blue_map è in mm 
      
    }else{ #celle NULL (no irrigation cells)
      next
    }
    
  }#c
}#r




#MAX MAPS
print("working on: MAX")
max_irr=matrix(NaN, 139,142)
dummy2=irr_systems_per_cell
types=types[order(types$efficiency, decreasing=FALSE),]

for(r in 1:dim(m_index)[1]){
  for(c in 1:dim(m_index)[2]){
    y=m_index[r,c] # scorre sull'elenco delle celle
    print(y)
    
    dummy2[[y]][1:6]=0
    
    if(length(irr_systems_per_cell[[y]])>0 & !is.na(blue_map[r,c])){ #considera celle irrigate in generale e irrigate per il crop considerato
      
      k=which(irr_systems_per_cell[[y]][1:4]>0)#5=altro sistema, 6=totale
      n=names(irr_systems_per_cell[[y]])[k]#just to get names of available systems
      
      f=intersect(possible_sys,n) #intersezione tra irrigazioni possibili e irrigazioni presenti
      
      if(length(f)==0){#non c'è un tipo di irrigazione presente+possibile,
        dummy2[[y]][5]=types$efficiency[types$irrigation_system=="altro sistema"] # attribuiamo l'irrigazione ad altro sistema
      }
      
      if(length(f)==1){#c'è un solo tipo di irrigazione possibile+presente
        l=types$index[which(types$irrigation_system %in% f)]
        d=ha_irr[r,c]
        
        if(d<=irr_systems_per_cell[[y]][l]){
          dummy2[[y]][l]=types$efficiency[types$irrigation_system==names(irr_systems_per_cell[[y]][l])]
          d=0
          
        }else if(d>irr_systems_per_cell[[y]][l]){
          av=irr_systems_per_cell[[y]][l]
          dummy2[[y]][l]=(av/ha_irr[r,c])/types$efficiency[types$irrigation_system==names(irr_systems_per_cell[[y]][l])]
          d=d-av
          dummy2[[y]][5]=(d/ha_irr[r,c])/types$efficiency[types$irrigation_system=="altro sistema"]
          d=0
        }
        
      }
      if(length(f)>1){#ci sono diversi tipi di irrigazione possibile+presente e quindi la ripartizione deve essere fatta su questi tipi di irrigazione
        l=types$index[which(types$irrigation_system %in% f)] #index è riferito all'ordine dei sistemi di irrigazione nella lista irr_system
        
        s=1
        d=ha_irr[r,c] #ha rimanenti da irrigare
        
        while(s<=length(l) & d>0){ #fino a quando gli ha non sono tutti irrigati o finiscono gli ettari irrigati con un sistema possibile
          
          if(d>irr_systems_per_cell[[y]][l[s]]){
            av=irr_systems_per_cell[[y]][l[s]]
            dummy2[[y]][l[s]]=(av/ha_irr[r,c])/types$efficiency[types$irrigation_system==names(irr_systems_per_cell[[y]][l[s]])]
            d=d-av
          }else if(d<irr_systems_per_cell[[y]][l[s]]){
            av=d
            dummy2[[y]][l[s]]=(av/ha_irr[r,c])/types$efficiency[types$irrigation_system==names(irr_systems_per_cell[[y]][l[s]])]
            d=0
          }
          s=s+1
        }#while
        
        if(d>0 & s>length(l)){ # in case possible+preset irrigation systems are not enough to satify the ha requested
          dummy2[[y]][5]=(d/ha_irr[r,c])/types$efficiency[types$irrigation_system=="altro sistema"]
        }
        
      }
      max_irr[r,c]= sum(blue_map[r,c]*dummy2[[y]]) #blue_map è in mm 
      
    }else{ #celle NULL (no irrigation cells)
      next
    }
    
  }#c
}#r




if(from_B_to_I=="2" | from_B_to_I=="3"){
  
  units="m3"
  #from mm to m3
  min_irr_m3=min_irr*as.matrix(ha_irr)*10 
  max_irr_m3=max_irr*as.matrix(ha_irr)*10 
  
  max_irr_m3_r=raster_as(max_irr_m3, ita)
  min_irr_m3_r=raster_as(min_irr_m3, ita)
  
  writeRaster(max_irr_m3_r,paste0(saving_location,year_1,"-",year_2,"/", code,"_B",B_l,"_Imax_",units,"_",year_1,"-",year_2,"_lgp_irr_WCv2.tif"))
  writeRaster(max_irr_m3_r,paste0(saving_location,year_1,"-",year_2,"/", code,"_B",B_l,"_Imin_",units,"_",year_1,"-",year_2,"_lgp_irr_WCv2.tif"))
  
  
  print(paste0("printing: ", code,"_B",B_l,"_Imax_",units,"_",year_1,"-",year_2,"_lgp_irr_WCv2.tiff"))
  print(paste0("printing: ", code,"_B",B_l,"_Imin_",units,"_",year_1,"-",year_2,"_lgp_irr_WCv2.tiff"))
  
}
if(from_B_to_I=="1" | from_B_to_I=="3"){
  
  units="mm"
  max_irr_r=raster_as(max_irr, ita)
  min_irr_r=raster_as(min_irr, ita)
  
  
  writeRaster(max_irr_r,paste0(saving_location,year_1,"-",year_2,"/", code,"_B",B_l,"_Imax_",units,"_",year_1,"-",year_2,"_lgp_irr_WCv2.tif"))
  writeRaster(max_irr_r,paste0(saving_location,year_1,"-",year_2,"/", code,"_B",B_l,"_Imin_",units,"_",year_1,"-",year_2,"_lgp_irr_WCv2.tif"))
  
  
  print(paste0("printing: ", code,"_B",B_l,"_Imax_",units,"_",year_1,"-",year_2,"_lgp_irr_WCv2.tiff"))
  print(paste0("printing: ", code,"_B",B_l,"_Imin_",units,"_",year_1,"-",year_2,"_lgp_irr_WCv2.tiff"))
  
}






}# end loop: years (y)


