# shipgrav
[![build status](https://github.com/PFPE/shipgrav/workflows/tests/badge.svg)](https://github.com/PFPE/shipgrav/actions)
[![codecov](https://codecov.io/gh/PFPE/shipgrav/branch/main/graph/badge.svg)](https://codecov.io/gh/PFPE/shipgrav)

shipgrav is a Python package designed for reading, processing, and reducing marine gravity data from UNOLS ships. It is created and maintained by PFPE for the marine gravimetry community. The shipgrav repository also contains scripts with example workflows for gravity data processing and reduction.

## Dependencies
python 3.9+\
numpy\
scipy\
pandas 2.0+\
statsmodels\
tomli\
pyyaml\
tqdm

To run the example scripts, you will also need matplotlib, geographiclib, and pooch. To run the example scripts in jupyter, you will also need jupyterlab and jupytext.

## Installation
shipgrav can be installed from PyPI using `pip`. Detailed instructions are in the [documentation](https://shipgrav.readthedocs.io/).

## Documentation and usage
The shipgrav documentation is available online at [shipgrav.readthedocs.io](https://shipgrav.readthedocs.io/). It can also be accessed offline by building the contents of the `docs` folder using sphinx.

## Contributing to shipgrav
Please do! If you have ideas for how to make shipgrav better, you can raise an issue on github or contact PFPE.

If you raise an issue on github, please include as much detail as possible about any errors you are encountering or any proposed enhancements to the code. Include the text of any error messages, and if the issue is unexpected behavior from the code without any visible error messages, describe both what the code is doing and what you think it *should* be doing instead. PFPE may ask for additional details and/or copies of data files in order to reproduce and diagnose an issue.

Additions or enhancements to the code are also welcome. Contributors are invited to fork the repository and submit pull requests for the maintainers to review.
