close all
clear all
clc

%% Parameters
file_name = 'Essai_Corrosion1.h5';  % File name to load
n_state = 100 ;                     % State number for which signals should be loaded
n_act   = 2 ;                       % Actuating piezoelectric transducer
n_sen   = 4 ;                       % Sensing piezoelectric transducer

%% Read data
file_info = h5info(file_name); % Get HDF5 file informations
Time_Response = h5read(file_name,['/State_' num2str(n_state) '/200kHz_5cycles/Actionneur' num2str(n_act) '/measured_data_rep_1.mat']) ; % Load the corresponding piezoelectric measurements 
t_vec   = Time_Response(:,1) ; % Extract time vector (sec)
act_sig = Time_Response(:,2) ; % Extract actuator signal (V)
sen_sig = Time_Response(:,find(n_sen==setdiff([1:4],n_act))+2); % Extract sensor signal (V)
time       = h5read(file_name,'/EC_data/EC_time') ;      % Extract EC time (min)
potiential = h5read(file_name,'/EC_data/EC_potential') ; % Extract EC potential (V)
current    = h5read(file_name,'/EC_data/EC_current') ;   % Extract EC current (A)

%% Plot data
a = figure();
set(a,'windowstyle','docked')
plot(t_vec,[act_sig/max(act_sig) sen_sig/max(sen_sig)])
grid on
ylim([-1 1])
xlabel('Time (sec)')
ylabel('Normalized amplitude')
legend(['Normalized actuator signal (PZT ' num2str(n_act) ')'],['Normalized sensor signal (PZT ' num2str(n_sen) ')'])
title(['State ' num2str(n_state) ' | V_E_C=' num2str(potiential(n_state)) ' V and I_E_C=' num2str(current(n_state)) ' A at t=' num2str(time(n_state)) 'min.'])