## EROSPOT Software part 1
Soil erosion in agriculture reduces yield potential and at the same time damages surrounding ecosystems, especially water bodies through sediment, nutrient and pesticide inputs. In the EROSPOT project, high-risk locations (hotspots) polluting water bodies through water erosion were identified on farmland at sub-field level through the automated processing of high-resolution geodata. The hotspots indicate high priority locations for erosion control and are thus of value for farmers, advisors, policy makers and society. 
The method published by Melzer et al. (2023) consists of three main steps: i) preprocessing geodata at the watershed level for the erosion model InVEST SDR (Natural Capital Project 2024) ii) calculating an erosion raster by InVEST SDR, iii) identifying hotspots based on the InVEST SDR output “sed_export.tif”.
The high resolution of input data, in particular a digital elevation model (DEM) based on a 1x1 meter grid, places high demands on computing power. Analysis on large areas (federal states or nations) are requiring a division of calculations into smaller catchment areas. Given the high amount of processing steps, automation is mandatory. In addition, automation enables the rapid recalculation of outputs, e.g. to map land use scenarios or actual changes by time. The three presented steps where thus completely automated in python to calculate 1x1 meter resolution raster datasets and respective sharply delineated hotspots (vector data) for individual watersheds. The automation was adapted to datasets available in the federal state of Bavaria (south Germany) but allows nation-wide calculations (for Germany and other countries with similar data availability). Results are shown by the EROSPOT 3D Web App: www.erospot.de  

**More information provided by the file "User guide to run EROSPOT software part 1"**
