<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
    xmlns:tei="http://www.tei-c.org/ns/1.0"
    xmlns:functx="http://www.functx.com"
    xmlns:gumpi="gumpi"
    version="3.0">
    
    <xsl:param name="create-keys" select="false()"/>
    
    <xsl:include href="http://www.xsltfunctions.com/xsl/functx-1.0-nodoc-2007-01.xsl"/>
    
    <xsl:output indent="yes" encoding="UTF-8" method="xml" exclude-result-prefixes="#all" omit-xml-declaration="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:variable name="top" select="/"/>
    <xsl:key name="persName-index" match="tei:persName" use="gumpi:normalize-persName(.)"/>
    <xsl:key name="works-index" match="tei:title[ancestor::tei:text]" use="normalize-space(.)"/>
    
    <xsl:template match="node() | @*" mode="#all">
        <xsl:copy>
            <xsl:apply-templates select="node() | @*" mode="#current"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="tei:text">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
            <xsl:if test="$create-keys">
                <xsl:element name="back" namespace="http://www.tei-c.org/ns/1.0">
                    <xsl:element name="listPerson" namespace="http://www.tei-c.org/ns/1.0">
                        <xsl:for-each-group select=".//tei:persName" group-by="gumpi:normalize-persName(.)">
                            <xsl:sort select="gumpi:normalize-persName(.)"/>
                            <xsl:element name="person" namespace="http://www.tei-c.org/ns/1.0">
                                <xsl:attribute name="xml:id" select="gumpi:generate-id(current-group()[1], 'A')"/>
                                <xsl:element name="persName" namespace="http://www.tei-c.org/ns/1.0">
                                    <xsl:value-of select="gumpi:normalize-persName(current-group()[1])"/>
                                </xsl:element>
                            </xsl:element>
                        </xsl:for-each-group>
                    </xsl:element>
                    <xsl:element name="listBibl" namespace="http://www.tei-c.org/ns/1.0">
                        <xsl:for-each-group select=".//tei:title" group-by="normalize-space(.)">
                            <xsl:sort select="normalize-space(.)"/>
                            <xsl:element name="bibl" namespace="http://www.tei-c.org/ns/1.0">
                                <xsl:attribute name="xml:id" select="gumpi:generate-id(current-group()[1], 'B')"/>
                                <xsl:value-of select="normalize-space(current-group()[1])"/>
                            </xsl:element>
                        </xsl:for-each-group>
                    </xsl:element>
                </xsl:element>
            </xsl:if>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="tei:div[parent::tei:body]">
        <xsl:for-each-group select="*" group-starting-with="tei:pb">
            <xsl:element name="div" namespace="http://www.tei-c.org/ns/1.0">
                <xsl:apply-templates select="current-group()"/>
            </xsl:element>
        </xsl:for-each-group>
    </xsl:template>
    
    <xsl:template match="tei:persName">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$create-keys">
                <xsl:attribute name="key" select="gumpi:generate-id(., 'A')"/>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="tei:title[ancestor::tei:text]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$create-keys">
                <xsl:attribute name="key" select="gumpi:generate-id(., 'B')"/>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="tei:abbr" mode="index"/>
    
    <xsl:function name="gumpi:normalize-persName" as="xs:string?">
        <xsl:param name="persName" as="element(tei:persName)"/>
        <xsl:variable name="processed-name">
            <xsl:apply-templates select="$persName" mode="index"/>
        </xsl:variable>
        <xsl:variable name="tokens" select="$processed-name => replace('\+', '') => normalize-space() => tokenize('\s+')"/>
        <xsl:choose>
            <xsl:when test="count($tokens) gt 1">
                <xsl:value-of select="$tokens[last()] || ', ' || string-join(subsequence($tokens, 1, count($tokens) -1), ' ')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$tokens"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <xsl:function name="gumpi:generate-id" as="xs:string?">
        <xsl:param name="node" as="node()"/>
        <xsl:param name="prefix" as="xs:string"/>
        <xsl:variable name="running-number" as="xs:integer">
            <xsl:choose>
                <xsl:when test="$prefix = 'A'">
                    <xsl:value-of select="key('persName-index', gumpi:normalize-persName($node), $top)[1] => generate-id() => substring(4) => xs:int()"/>
                </xsl:when>
                <xsl:when test="$prefix = 'B'">
                    <xsl:value-of select="key('works-index', normalize-space($node), $top)[1] => generate-id() => substring(4) => xs:int()"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="new-id" select="
            concat($prefix, 
                functx:reverse-string(
                    functx:pad-string-to-length(
                        functx:reverse-string(
                            gumpi:int2hex($running-number)
                        )
                        , '0', 4
                    )
                )
            )"/>
        <xsl:variable name="check-digit" select="gumpi:compute-check-digit($new-id)"/>
        <xsl:value-of select="concat($new-id, $check-digit)"/>
    </xsl:function>
    
    <xsl:function name="gumpi:hex2int" as="xs:integer?">
        <!-- Taken from http://blog.sam.liddicott.com/2006/04/xslt-hex-to-decimal-conversion.html -->
        <xsl:param name="str" as="xs:string"/>
        <xsl:if test="$str != ''">
            <xsl:variable name="len" select="string-length($str)"/>
            <xsl:value-of select="
                if ( $len lt 2 ) then string-length(substring-before('0 1 2 3 4 5 6 7 8 9 AaBbCcDdEeFf',$str)) idiv 2
                else gumpi:hex2int(substring($str,1,$len - 1))*16 + gumpi:hex2int(substring($str,$len))
                "/>
        </xsl:if>
    </xsl:function>
    
    <xsl:function name="gumpi:int2hex" as="xs:string">
        <xsl:param name="number" as="xs:integer"/>
        <xsl:variable name="chars" select="('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F')" as="xs:string+"/>
        <xsl:variable name="div" select="$number div 16" as="xs:decimal"/>
        <xsl:variable name="count" select="floor($div)" as="xs:decimal"/>
        <xsl:variable name="remainder" select="($div - $count) * 16" as="xs:decimal"/>
        <xsl:value-of select="concat(
            if($count gt 15) 
            then gumpi:int2hex(xs:integer($count))
            else if($number gt 15) then $chars[$count +1]
            else (),
            $chars[$remainder +1]
            )"/>
    </xsl:function>
    
    <xsl:function name="gumpi:compute-check-digit" as="xs:string">
        <xsl:param name="id" as="xs:string"/>
        <xsl:variable name="weights" select="(2, 4, 6, 8, 9, 5, 3)" as="xs:decimal+"/>
        <xsl:variable name="weighted-codepoints" as="xs:decimal*">
            <xsl:for-each select="string-to-codepoints($id)">
                <xsl:variable name="pos" select="position()"/>
                <xsl:sequence select=". * $weights[$pos]"/>
            </xsl:for-each>
        </xsl:variable>
        <xsl:value-of select="gumpi:int2hex(sum($weighted-codepoints) mod 16)"/>
    </xsl:function>
    
</xsl:stylesheet>