## Supplementary material to DESI's publication "Semi-analytical covariance matrices for two-point correlation function for DESI 2024 data" to comply with the data management plan.

**Important note: this version (2.0) of the supplementary material corresponds to the JCAP version of the article, or [v3](https://arxiv.org/abs/2404.03007v3) and [above on arXiv](https://arxiv.org/abs/2404.03007).**
Version 1.0 corresponds to arXiv [v1](https://arxiv.org/abs/2404.03007v1) and [v2](https://arxiv.org/abs/2404.03007v2).

Contents: ASDF files ([reading instructions for Python](https://asdf.readthedocs.io/en/latest/asdf/overview.html#reading-files)).
This format was chosen because it supports both nested dictionary-like structures and `numpy` arrays.

List and short descriptions:
* `normalized_errorbars.asdf`: data from Figures 3 and 4, projected errorbars for the BAO scales from each RascalC single-mock run, divided by those from the EZmock sample covariance. **BAO model has been updated to use spline-based broadband terms, instead of polynomial in 1.0. This only resulted in minor differences.**
* `shot_noise_rescaling.asdf`: source data for Tables 2 and 4, the shot-noise rescaling values for all the data and single-mock runs for different tracers, pre- and post-recon, SGC and NGC.
* `shot_noise_rescaling_extra.asdf`: source data for Table 3, the shot-noise rescaling values for all the data and a single realization of different mocks for LRG and ELG, pre-recon only, SGC and NGC. **New in version 2.0.**
* `comparison_measures_RascalC_sample_cov.asdf`: source data for Tables 5-10, the covariance matrix comparison measures computed between the (inverted) RascalC covariance from each single-mock run and the EZmock sample covariance, and perfect reference values for them. Includes different ranges for correlation function multipoles and projections to different cosmological parameters using an inverse Fisher matrix. **BAO model has been updated to use spline-based broadband terms, instead of polynomial in 1.0. This only resulted in minor differences.**
* `measures_perfect_ref_samples.asdf`: 10000 realizations of the covariance matrix comparison measures from multivariate normal samples with a known (unity) covariance matrix and different numbers of bins, to study the distribution of these quantities in the perfect case.
* `measures_perfect_ref_stats.asdf`: means and standard deviations of the covariance matrix comparison measures in the perfect case for 1000 samples and different numbers of bins. Each has three variants: empirical, theoretical and fiducial. Empirical are estimated using the samples saved in the previous file. Theoretical are calculated with formulas from <https://arxiv.org/abs/2306.06320>. Fiducial value is chosen between the previous two for each quantity's mean and std independently: the theoretical is preferred, unless the empirical estimate is at least 3 sigma different. The fiducial statistical properties have been used in the "Perfect" rows of Tables 5-10.