## Why plan an energy system?

A sustainable energy system can lift people out of poverty around the world. But, how can we provide access for all while avoiding past pitfalls and not creating new ones?

The truth is that, to achieve this goal, a fundamental transformation of the energy system is required. This is a difficult task, especially given that modern energy systems are highly complex and capital intensive. In addition, these systems constantly interact with many other systems such as the environment, natural resource systems, and infrastructure.

Therefore, to achieve this, countries will have to undertake comprehensive, systematic analyses and planning to identify and avoid expensive stop-gap measures and long-term ”lock-in” into inadequate and unsustainable infrastructures. This can be challenging as, in many instances, short-term pressures for immediate actions take precedence over long-term consideration for sustainability.

## Importance of Energy Planning 

Differing economies and geographies require different solutions to the challenge of providing affordable energy. There is no 'one size fits all' energy system. 

For instance, in developing countries, access to affordable energy services is important to combat energy poverty. This is especially true for rural areas, but it is also increasingly true for large metropolitan areas as urbanization accelerates. These countries have 2 billion people without electricity, and nearly 3 billion people relying on dirty fuels for cooking and heating.

In contrast, the developed countries of Europe, North America, and Asia struggle with the replacement of ageing plants and equipment, with some 40 percent of existing capacity stock scheduled for retirement by 2040.

However, investment decisions are clouded by demand uncertainty due to factors such as efficiency improvements, the emergence of smart-grids, and potential developments of new electricity markets such as electric vehicles.

Competitive and private sector dominated energy markets rely on clear and consistent government energy–environment policies to align their investment decisions with sustainable development objectives.

## What is energy planning?

Energy planning is the act of assessing the ability of a regional system to provide dependable energy services under constantly changing conditions. For example, variables such as the cost of materials and fuels, investment costs in technologies, demand levels, and distribution may all change.

Drawing on the field of operations research, electricity planning applies advanced analytical methods and tools to make better decisions when faced with complex decisions. This process must be done iteratively due to the fast transformations that can take place over a very limited period.

Energy planning models allow for the most cost-effective way of delivering energy to the final consumer. Of course, the most cost-effective way of providing energy changes in different parts of the world. However, quantitative energy modelling offers a promising tool to better make decisions under uncertainty.

The main barriers for developing countries are the lack of adequate data and a shortage of skilled human resources to perform the analysis. Therefore, investment decisions are often based on ill-informed policy targets and the need for ad-hoc stop-gap measures. These measures, therefore, tend to focus on cheap and quick-to-build technologies, which can result in higher environmental and operating costs. Given that such actions serve the supply shortfalls of already-connected consumers, increasing access is rarely part of the strategy. 

## Acting on energy planning

Energy planning, however, is not an end in itself. Energy planning requires more than solely the mastering of energy modelling tools. Simply planning without subsequent implementation is an ineffective use of resources. Implementation requires a functional institutional framework to ensure the availability of funding, the timely readiness of energy infrastructure investments, and a mechanism to oversee progress and quality control.

It is true that sound project economics mobilizes the necessary finance, which is particularly the case for large infrastructure investments. 

Finally, the physical deployment of infrastructure needs to match schedule logistics. For example, the introduction of a large hydropower plant may exceed current electricity demand. This may make it difficult to pay dividends and service debt. However, shortages may also result when electricity demand grows faster than supply – which leads to stop-gap measures and delayed economic development. 

## Benefits of energy systems models

Quantified models of complex systems can help decision makers in multiple ways. From a technical perspective, they allow analysts to compare different system configurations without incurring the upfront costs of building them. This enables the mitigation of uncertainty. 

From a practical perspective, they facilitate the design of systems in a way that accounts for local resources, demands, and constraints that are placed upon real life electricity systems. This enables minimization of consumer electricity bills by allowing governmental institutions to structure tariffs optimally.

The development of scenarios can serve as an effective communication tool for non-partisan political commitment, which will help both to garner and mobilize private sector support, and to solicit agreement from society at large. 

For developing countries, the impact of even minor system improvements often can have disproportionally high positive economic and environmental returns.
