from paralex import paralex_factory

freq_per_million = {
    "name": "frequency_per_million",
    "type": "number",
    "title": "Frequency per million token",
    "description": "Frequency for this row, per million tokens",
}

extra_cols_cells = [
    {
        "name": "flexique",
        "type": "string",
        "title": "Cell label in flexique",
        "description": "Dot separated, leipzig-gloss style label from flexique.",
    },
    {
        "name": "decomposed",
        "type": "string",
        "title": "Cell label, decomposed in semantic features",
        "description": "Cell decomposition using temporal & anaphoric dimensions, according to Verkuyl et al. (2004) and Bonami & Boyé (2005).",
    },
    {
        "name": "GRACE",
        "type": "string",
        "title": "Cell label in GRACE format",
        "description": "Cell tag following the GRACE format (Rajman et al., 1997).",
    },
    {
        "name": "ftb",
        "type": "string",
        "title": "Cell label in FTB format",
        "description": "Cell tag following the French TreeBank (FTB) format.",
    },
    freq_per_million
]

extra_cols_lexeme = [
    {
        "name": "variants",
        "type": "string",
        "title": "orthographic variants",
        "descripton": "orthographic variants for this lexeme, separated by slashes."
    },
    freq_per_million
]

package = paralex_factory("Vlexique: French Verbal Paradigms in Phonemic Notation",
                          {"cells": {"path": "vlexique_cells.csv",
                                     "schema":
                                         {"fields":
                                              extra_cols_cells
                                          }
                                     },
                           "forms": {"path": "vlexique_paradigms.csv",
                                     "schema":
                                         {"fields":
                                              [freq_per_million]
                                          }
                                     },
                           "lexemes": {"path": "vlexique_lexemes.csv",
                                       "schema": {"fields": extra_cols_lexeme}},
                           "sounds": {"path": "vlexique_sounds.csv"},
                           "features-values": {"path": "vlexique_features.csv"},
                           "tags": {"path": "vlexique_tags.csv"}
                           },
                          related_identifiers=[{'identifier': 'http://www.llf.cnrs.fr/fr/flexique-fr.php',
                                                'relation': 'isDerivedFrom',
                                                },
                                               {'identifier': 'http://redac.univ-tlse2.fr/lexiques/demonette.html',
                                                'relation': 'isDerivedFrom',
                                                },
                                               ],
                          contributors=[
                              {'title': 'Sacha Beniamine', 'organization': 'University of Surrey',
                               'orcid': '0000-0003-2584-3576'},
                              {'title': 'Maximin Coavoux', 'organization': 'CNRS', 'orcid': '0000-0003-4089-4558'},
                              {'title': 'Olivier Bonami', 'organization': 'U. Paris Cité',
                               'orcid': '0000-0003-0688-3855'},
                          ],
                          licenses=[{'name': 'CC-BY-NC-SA-4.0',
                                     'title': 'Attribution-NonCommercial-ShareAlike 4.0 International  (CC BY-NC-SA 4.0) ',
                                     'path': 'https://creativecommons.org/licenses/by-nc-sa/4.0/'}],
                          keywords=["french", "verbs", "paradigms", "paralex"],
                          name="vlexique",
                          version="2.0.2",
                          languages_iso639=["fra", ]
                          )

package.infer()
package.to_json("vlexique.package.json")
