print_brms_fit <- function(m,shifty=0){
  if("brmsfit" %in% class(m)){
    #f <- formula(m)
    #rv <- all.vars(f$formula)[attr(terms(f$formula), "response")]
    #m$data[[rv]]<- m$data[[rv]] - shifty
    s <- summary(m)
    f<- s$fixed
    f$Estimate <- f$Estimate - shifty
    a <- rbind(f, s$spec_pars, s$cor_pars)
    
    return(a)
   
  }
  stop(class(s), "not a brmssummary object")
}

brms_fit_tbl <- function(mod, target, pairs=T, digits =2,...){
  if("brmsfit" %in% class(mod)){
    isphylo <- "A" %in% all.vars(mod$formula$formula)
    phylotext <- ifelse(isphylo, " yes", " no")
    if(pairs){
      tbl <- brms_pairs_tbl(mod, target, ...)
      #rename HPD columns to  l-95% CI and u-95% CI
      colnames(tbl)[grep("HPD", colnames(tbl))] <- c("l-95% CI", "u-95% CI")
      
    }else{
    tbl <- lazerhawk::brms_SummaryTable(mod, round=digits, ...)
    }
    
    #add a column as the first column as model name
    tbl <- cbind(list(Phylogeny = phylotext, Predictor = target), tbl)
    # keep the phylo name only on first row
    #tbl[2:nrow(tbl),1] <- ""
    #add a last empty row
    tbl <- rbind(tbl, NA)
  }
  return(tbl)
  
  stop(class(mod), "not a brmsfit object")
}

brms_pairs_tbl <- function(mod, yvar, astrology = T, ...){
  emms <- emmeans::emmeans(mod, yvar)
  #get the pairs
  pairs <- summary(pairs(emms))
  #split the contrast to 2 columns
  pairs <- cbind(do.call(rbind, strsplit(pairs$contrast, " - ")), pairs)
  colnames(pairs)[1:2] <- c("group1", "group2")
  pairs$contrast <- NULL
  
  #get the significance
  if(astrology){
    pairs$Notable <- ifelse(pairs$lower.HPD * pairs$upper.HPD > 0, "*", "")
  }
  return(pairs)
}


plot_conditional_effects <- function(mod, shifty=0, max.y = Inf, min.y =-Inf, ...){
  if("brmsfit" %in% class(mod)){
    ce <- tryCatch(
      ce <-  conditional_effects(mod,plot=F, ask =F, ...),
      error = function(e) {
        print(e)
        ce <- NULL
        return(NULL)
      }
    )
    if(is.null(ce)) return(NULL)
    items <- c("estimate__", "lower__", "upper__")
    for(i in 1:length(ce)){
            ce[[i]][,items] <- ce[[i]][,items] + shifty
            ce[[i]] <- ce[[i]][ce[[i]][,"upper__"] < max.y & ce[[i]][,"lower__"] > min.y,]
    }
    if(length(ce) == 0) return(NULL)
    ps <- plot(ce,plot=F, ask =F)
    
    
    return(ps)
  }else{
    stop(class(mod), "not a brmsfit object")
  }
}

print_conditional_effects <- function(m,shifty=0, ...){
  if("brmsfit" %in% class(m)){
    f <- formula(m)
    vars <- all.vars(f$formula)
    rv <- all.vars(f$formula)[attr(terms(f$formula), "response")]
    items <- c("effect1__", "estimate__", "lower__", "upper__")
    newNames <- c("Effect", "estimate", "CI_low", "CI_high")
    ce <- conditional_effects(mod,plot=F, ask =F, ...)
    ce <- lapply(ce, function(x){
      x[,items[-1]] <- x[,items[-1]] + shifty
      x[newNames] <- x[items]
      x[newNames]
    })
      

    return(do.call(rbind,ce))
    
  }
  stop(class(m), "not a brmsfit object")
}

simple_brms_summary <- function(model, main_effect = "Order", response = "toxicity tolerance", significance_level = 0.95) {
  # Get model summary
  summary <- summary(model)
  
  # Extract fixed effects
  fixed_effects <- summary$fixed
  
  # Find the rows corresponding to the main effect
  effect_rows <- grep(paste0("^", main_effect), rownames(fixed_effects), value = TRUE)
  
  if (length(effect_rows) == 0) {
    return(paste0("Error: ", main_effect, " not found in model fixed effects."))
  }
  
  # Initialize summary string
  summary_string <- paste0(main_effect, " as a predictor of ", response, ":\n")
  
  # Loop through each level of the predictor
  for (row in effect_rows) {
    # Extract relevant statistics
    estimate <- fixed_effects[row, "Estimate"]
    ci_lower <- fixed_effects[row, paste0("l-", significance_level*100, "% CI")]
    ci_upper <- fixed_effects[row, paste0("u-", significance_level*100, "% CI")]
    
    # Determine if the effect is significant
    is_significant <- ci_lower * ci_upper > 0
    
    # Create the summary string for this level
    level_summary <- paste0(
      "  ", row, " ", 
      ifelse(is_significant, "significantly", "did not significantly"), 
      " predict ", response, 
      " (Estimate = ", round(estimate, 3),
      ", ", significance_level*100, "% CI: [", 
      round(ci_lower, 3), ", ", round(ci_upper, 3), "]).\n"
    )
    
    # Append to the main summary string
    summary_string <- paste0(summary_string, level_summary)
  }
  browser()
  # Add overall significance if there are multiple levels
  if (length(effect_rows) > 1) {
    # Formulate the hypothesis for overall effect
    hyp <- paste0(paste(effect_rows[-1], collapse = " + "), "=0")
  
    overall_test <- hypothesis(model, hyp)
    
    # Extract the evidence ratio
    evidence <- exp(overall_test$log_BF[1])
    
    overall_summary <- paste0(
      "\nOverall, there is ", 
      ifelse(evidence > 3, "strong", ifelse(evidence > 1, "weak", "no")),
      " evidence for an effect of ", main_effect, " on ", response,
      " (Bayes Factor = ", round(evidence, 2), ")."
    )
    
    summary_string <- paste0(summary_string, overall_summary)
  }
  
  return(summary_string)
}
summarize_brms_model <- function(model, remove="", significance_level = 0.95) {
  # Get model summary
  summary <- summary(model)
  # Extract fixed effects
  fixed_effects <- summary$fixed
  
  # Extract random effects
  random_effects <- summary$random
  
  # Create text summary
  text_summary <- paste0(
    "\n\nFixed effects:\n"
  )
  
  # Summarize fixed effects
  for (i in 1:nrow(fixed_effects)) {
    effect_name <- gsub(remove, "",rownames(fixed_effects)[i])
    estimate <- as.numeric(fixed_effects[i, "Estimate"])
    ci_lower <- as.numeric(fixed_effects[i, paste0("l-", significance_level*100, "% CI")])
    ci_upper <- as.numeric(fixed_effects[i, paste0("u-", significance_level*100, "% CI")])
    
    text_summary <- paste0(
      text_summary,
      effect_name, ": Est.= ", round(estimate, 3),
      " (", significance_level*100, "% CI: ", round(ci_lower, 3), " to ", round(ci_upper, 3), ")",
      ifelse(ci_lower * ci_upper > 0, "*", ""),
      "\n"
    )
  }
  
  # Summarize random effects
  text_summary <- paste0(
    text_summary,
    "\nRandom effects:\n"
  )
  
  for (group in names(random_effects)) {
    variance <- random_effects[[group]]["sd", "Estimate"]^2
    
    
    text_summary <- paste0(
      text_summary,
      group, ": Variance = ", round(variance, 3), "\n"
    )
  }
  # Model fit statistics
  text_summary <- paste0(
    text_summary,
    "\nModel fit:\n",
    "R-squared: ", round(bayes_R2(model)[1], 3), "\n"
  )
  
  return(text_summary)
}



