fit_brm <- function(fitFormula, family,
                     fnameparts,
                     data2use, covMatTree,
                     bayesVars){
  
  fnameparts <- paste0(fnameparts,collapse = "_")
  if(nchar(fnameparts) > 60){
    fnameparts <- substr(fnameparts, 1, 60)
  }
  modFname <- paste0("./stanFits/",
                     form2str(fitFormula),
                     "_", fnameparts,"_iter-",
                     bayesVars[["iter"]], "_",
                     "LC50", ".rds")
  
  if(!file.exists(modFname)){
    #fit a BRM model on yvar
    mod <- brm(formula = fitFormula,
               data = data2use,
               family = family,
               data2 = list(A = covMatTree),
               save_pars = brms::save_pars(all = T),
               chains = bayesVars[["chains"]],
               cores = bayesVars[["cores"]],
               iter = bayesVars[["iter"]],
               warmup = bayesVars[["warmup"]],
               control = list(adapt_delta = bayesVars[["adapt_delta"]],
                              max_treedepth = bayesVars[["max_treedepth"]]))
    mod <- add_criterion(mod, "waic")
    mod <- add_criterion(mod, "loo")
    saveRDS(mod, modFname)
  } else {
    mod <- readRDS(modFname)
  }
  return(mod)
}