check_assumptions <- function(model, main = "", print=T, theme=ggplot2::theme_bw()) {
  # Calculate fitted values and residuals
  fitted.values <- predict(model)
  residuals <- resid(model)
  
  # Create residuals vs fitted values plot
  p1 <- ggplot2::ggplot(data.frame(fitted.values, residuals),
                        ggplot2::aes(x = fitted.values, y = residuals)) +
    ggplot2::geom_point() +
    ggplot2::geom_hline(yintercept = 0, linetype = "dashed") +
    theme +
    ggplot2::labs(x = "Fitted Values", y = "Residuals",
                  title = main,
                  subtitle = "Residuals vs Fitted Values")
  
  # Create Q-Q plot
  p2 <- ggplot2::ggplot(data.frame(residuals), 
                       ggplot2::aes(sample = residuals)) +
    ggplot2::stat_qq() +
    ggplot2::stat_qq_line() +
    theme+
    ggplot2::labs(subtitle = "Normal Q-Q Plot", title = main)
  
  # Create residuals vs order plot
  p3 <- ggplot2::ggplot(data.frame(residuals), 
                       ggplot2::aes(x = 1:length(residuals), y = residuals)) +
    ggplot2::geom_point() +
    ggplot2::geom_hline(yintercept = 0, linetype = "dashed") +
    theme +
    ggplot2::labs(x = "Order of Data", y = "Residuals",
                  title = main,
                  subtitle = "Residuals vs Order of Data")
  if(print){
    print(p1)
    print(p2)
    print(p3)
  }
  
  # Return the plots
  invisible(list(p1, p2, p3))
}