analysis_flow <- function(predictor,
                          fdf,
                          byesParams = list(cores = 4,
                                            chains = 4,
                                            iter = 1000 * 4,
                                            warmup = 1000,
                                            max_treedepth = 15,
                                            adapt_delta = 0.95), 
                          response="tox_conc_z",
                          extraVars = "+ log_maxLength",
                          fitFamily = lognormal(),
                          substance = "all_substances",
                          subsetting = "some_filtering",
                          astrology = T,
                          pairs=T,
                          digits=2,
                          varMap = c(),
                          ylim = c(-1.2, 1.2),
                          shifty = 0,
                          verbose= F){
  
  fdf <- fdf[complete.cases(fdf[c(predictor,response)]),]
  yvar <- predictor
  resp <- response
  varName <- if(yvar %in% names(varMap)) varMap[[yvar]] else yvar
  tbls <- list()
  fitFormula <- formula(paste0(resp, "~", yvar, extraVars,
                               " + (1|ref_number) +  (1 | gr(sp, cov = A))"))
  if(verbose)  print("Fitting model with phylogeny")
  mod1 <- fit_brm(fitFormula, fitFamily, c(substance, subsetting),
                  fdf, covMatTree, byesParams)
  tbls[[paste(yvar, "_phylo")]] <- brms_fit_tbl(mod1, yvar, astrology=astrology, pairs=pairs, digits=digits)
 
  #plot the airBreathing from the brm model
  #cat("mod1:", paste0(deparse(formMod)))  
  ps <- plot_conditional_effects(mod1, shifty=shifty)
  p1  <- ps[[1]] + theme_bw() + 
    labs(y = "LC50 concentration (z-scores)", x= varName) +
    theme(axis.text.x = element_text(angle = 45, hjust = 1, size = 10))


  fitFormula <- formula(paste0(resp, "~", yvar, extraVars,
                               " + (1|ref_number) +  (1 |sp)"))
  if(verbose) print("Fitting model without phylogeny")
  mod2 <- fit_brm(fitFormula, fitFamily, c(substance, subsetting),
                  fdf, covMatTree, byesParams)
  

  ps <- plot_conditional_effects(mod2, shifty=shifty)
  p2  <- ps[[1]] + theme_bw() + 
    labs(y = "LC50 concentration (z-scores)", x= varName) +
    theme(axis.text.x = element_text(angle = 45, hjust = 1, size = 10))

  tbls[[paste(yvar, "no_phylo")]] <- brms_fit_tbl(mod2, yvar, astrology=astrology, pairs=pairs)
  
  p1$data$Phylogeny <- "yes"
  p2$data$Phylogeny <- "no"
  plotdata <- rbind(p1$data, p2$data)
  
  groupAgg <- aggregate(formula(paste0(resp,"~", yvar)), data = fdf[!is.na(fdf[yvar]),], FUN = length)
  
  fs1 <- ggplot(plotdata, aes(x = .data[[yvar]], y = estimate__, color = Phylogeny)) +
    #stat_summary(data = fdf, fun = mean, aes(x = .data[[yvar]], y=.data[[resp]]+shifty, color="no"), color="black") +
    geom_point(data = fdf, aes(x = .data[[yvar]], y = .data[[resp]]+shifty, color="no"), position = position_jitter(width = 0.25), alpha = 0.1, color="gray") + 
    coord_cartesian(ylim = ylim) +
    theme_bw() +
    labs(y = "LC50 concentration (z-scores)", x = varName) +
    theme(axis.text.x = element_text(angle = 45, hjust = 1, size = 10))
  
  if(pairs){
    fs1 <- fs1 + geom_pointrange(aes(ymin = lower__, ymax = upper__), position = position_dodge(width = 0.5))
  } else {
    fs1 <- fs1 + geom_line(aes(y = estimate__)) +
      geom_ribbon(aes(ymin = lower__, ymax = upper__, fill=Phylogeny), alpha = 0.2, color=NA)
  }
  
  
  #add n of datapoints from fdf to the top of the plot
  if(pairs){
    fs1 <- fs1 + geom_text(data = groupAgg, aes(x = .data[[yvar]], y = ylim[2], label = .data[[resp]], colour = "no"), size = 3, vjust = 0.5, colour="black")
  }
  return(list(fig = fs1, tbl = do.call(rbind, tbls)))
}



print_half_prop <- function(df, name_col, proportion_col="proportion", suffix=".",
                            prefix="") {
  # Sort the data frame by the proportion column in decreasing order
  df <- df[order(df[[proportion_col]], decreasing = TRUE),]
  
  # Initialize cumulative sum and list to store the selected classes
  cum_sum <- 0
  selected_classes <- c()
  
  # Loop over the sorted data frame to accumulate proportions until >50%
  for (i in 1:nrow(df)) {
    cum_sum <- cum_sum + df[i, proportion_col]
    selected_classes <- c(selected_classes, paste(df[i, name_col], 
                                                  " (", round(df[i, proportion_col], 1), "%)", sep=""))
    if (cum_sum > 50) {
      break
    }
  }
  if(i== 1){
    text <- paste(prefix,name_col, 
                  selected_classes[length(selected_classes)], suffix)
  }
  else{
    # Join the selected classes with commas, and "and" before the last element
    text <- paste(prefix,paste0(name_col, "s"), 
                  paste(selected_classes[1:(length(selected_classes)-1)], collapse = ", "),
                  "and", selected_classes[length(selected_classes)], suffix)
  }
  return(text)
}
