# Managing Releases

*These instructions are primarily intended for the maintainers of Teamware.*

Note: Releases are always made from the `master` branch of the repository.

## Steps to making a release

1. **Update the changelog** - This has to be done manually, go through any pull requests to `dev` since the last release.
   - In github pull requests page, use the search term `is:pr merged:>=yyyy-mm-dd` to find all merged PR from the date since the last version change.
   - Include the changes in the `CHANGELOG.md` file; the changelog section _MUST_ begin with a level-two heading that starts with the relevant version number in square brackets (`## [N.M.P] Optional descriptive suffix`) as the GitHub workflow that creates a release from the eventual tag depends on this pattern to find the right release notes.  Each main item within the changelog should have a link to the originating PR e.g. \[#123\](https://github.com/GateNLP/gate-teamware/pull/123).
1. **Update and check the version numbers** - from the teamware directory run `python version.py check` to check whether all version numbers are up to date. If not, update the master `VERSION` file and run `python version.py update` to update all other version numbers and commit the result. Alternatively, run `python version.py update <version-string>` where `<version-string>` is the version number to update to, e.g. `python version.py update 2.1.0`. Note that `version.py` requires `pyyaml` for reading `CITATION.cff`, `pyyaml` is included in Teamware's dependencies.
1. **Create a version of the documentation** - Run `npm run docs:create_version`, this will archive the current version of the documentation using the version number in `package.json`.  
1. **Create a pull request from `dev` to `master`** including any changes to `CHANGELOG.md`, `VERSION`.
1. **Create a tag** - Once the dev-to-master pull request has been merged, create a tag from the resulting `master` branch named `vN.M.P` (i.e. the new version number prefixed with the letter `v`).  This will trigger two GitHub workflows:
    - one that builds versioned Docker images for this release and pushes them to `ghcr.io`, updating the `latest` image tag to point to the new release
    - one that creates a "release" on GitHub with the necessary artifacts to make the `https://gate.ac.uk/get-teamware.sh` installation mechanism work correctly.  The release notes for this release will be generated by extracting the matching section from `CHANGELOG.md`.
1. **Update the Helm chart** - Create a new branch on [https://github.com/GateNLP/charts](https://github.com/GateNLP/charts) to update the `appVersion` of the `gate-teamware` Helm chart to match the version that was just created by the tag workflow.  You must also update the chart `version`, bumping the major version number if the new chart is not backwards-compatible with the old.  Submit a pull request to the `main` branch, which will publish the new chart when it is merged.
