templates = {}

# MedQA

templates["medqa5"] = {}
templates["medqa5"]["one_shot"] = lambda question, choices: f"""Task: Your task is to answer medical questions with the provided choices. Only output the answer option (A/B/C/D/E) as answer.
Input Format: The input consists of a question followed by several choices.
Output: Answer each question by providing one of the following options: A, B, C, D, E.

Example
Input: A 23-year-old pregnant woman at 22 weeks gestation presents with burning upon urination. She states it started 1 day ago and has been worsening despite drinking more water and taking cranberry extract. She otherwise feels well and is followed by a doctor for her pregnancy. Her temperature is 97.7°F (36.5°C), blood pressure is 122/77 mmHg, pulse is 80/min, respirations are 19/min, and oxygen saturation is 98% on room air. Physical exam is notable for an absence of costovertebral angle tenderness and a gravid uterus. Which of the following is the best treatment for this patient?
A. Ampicillin
B. Ceftriaxone
C. Ciprofloxacin
D. Doxycycline
E. Nitrofurantoin
Output: E

Input: {question}
{choices}
Output:"""

templates["medqa5"]["zero_shot"] = lambda question, choices: f"""Task: Your task is to answer medical questions with the provided choices. Only output the answer option (A/B/C/D/E) as answer.
Input Format: The input consists of a question followed by several choices.
Output: Answer each question by providing one of the following options: A, B, C, D, E.

Input: {question}
{choices}
Output:"""

templates["medqa"] = {}
templates["medqa"]["one_shot"] = lambda question, choices: f"""TASK: Your task is to answer medical questions with the provided choices. Only output the answer option (A/B/C/D) as answer.
INPUT: The input is a question followed by several choices.
OUTPUT: Answer each question by providing one of the following options: A, B, C, D.

Example

INPUT: A 23-year-old pregnant woman at 22 weeks gestation presents with burning upon urination. She states it started 1 day ago and has been worsening despite drinking more water and taking cranberry extract. She otherwise feels well and is followed by a doctor for her pregnancy. Her temperature is 97.7°F (36.5°C), blood pressure is 122/77 mmHg, pulse is 80/min, respirations are 19/min, and oxygen saturation is 98% on room air. Physical exam is notable for an absence of costovertebral angle tenderness and a gravid uterus. Which of the following is the best treatment for this patient?
A. Ampicillin 
B. Ceftriaxone
C. Doxycycline
D. Nitrofurantoin

OUTPUT: D

INPUT: {question}
{choices}

OUTPUT:""" 

templates["medqa"]["zero_shot"] = lambda question, choices: f"""TASK: Your task is to answer medical questions with the provided choices. Only output the answer option (A/B/C/D) as answer.
INPUT: The input is a question followed by several choices.
OUTPUT: Answer each question by providing one of the following options: A, B, C, D.

INPUT: {question}
{choices}

OUTPUT:""" 

# PubMedQA
templates["pubmedqa"] = {}
templates["pubmedqa"]["one_shot"] = lambda title, abstract: f"""TASK: Your task is to answer biomedical questions using the given abstract. Only output yes, no, or maybe as answer. 
INPUT: The input is a question followed by an abstract. 
OUTPUT: Answer each question by providing one of the following options: yes, no, maybe.


Example

INPUT: Does hippocampal atrophy on MRI predict cognitive decline? ["To investigate whether the presence of hippocampal atrophy (HCA) on MRI in Alzheimer's disease (AD) leads to a more rapid decline in cognitive function. To investigate whether cognitively unimpaired controls and depressed subjects with HCA are at higher risk than those without HCA of developing dementia.", 'A prospective follow-up of subjects from a previously reported MRI study.', 'Melbourne, Australia.', 'Five controls with HCA and five age-matched controls without HCA, seven depressed subjects with HCA and seven without HCA, and 12 subjects with clinically diagnosed probable AD with HCA and 12 without HCA were studied. They were followed up at approximately 2 years with repeat cognitive testing, blind to initial diagnosis and MRI result.', 'HCA was rated by two radiologists blind to cognitive test score results. Cognitive assessment was by the Cambridge Cognitive Examination (CAMCOG).', 'No significant differences in rate of cognitive decline, mortality or progression to dementia were found between subjects with or without HCA.']

OUTPUT: no


INPUT: {title} {abstract}

OUTPUT:"""

templates["pubmedqa"]["zero_shot"] = lambda title, abstract: f"""TASK: Your task is to answer biomedical questions using the given abstract. Only output yes, no, or maybe as answer. 
INPUT: The input is a question followed by an abstract. 
OUTPUT: Answer each question by providing one of the following options: yes, no, maybe.

INPUT: {title} {abstract}

OUTPUT:"""

# BIOSSES
templates["biosses"] = {}
templates["biosses"]["one_shot"] = lambda sent1, sent2: f"""***INPUT***
the input is a pair of sentences named sentence1 and sentence2

***OUTPUT***
the output is the semantic similarity in a continuous number from 0 (no relation) to 4 (equivalent)

***DOCUMENTATION***
0, the two sentences are on different topics.
1, the two sentences are not equivalent, but are on the same topic. 
2, the two sentences are not equivalent, but share some details.
3, the two sentences are roughly equivalent, but some important information differs/missing.
4, The two sentences are completely or mostly equivalent, as they mean the same thing.

***EXAMPLES***
Example
Input: sentence1: The mammalian Arp, BAF53 (BRG-associated factor), and ?-actin were initially found as components of the mammalian SWI/SNF-like BAF chromatin-remodeling complex. sentence2: In addition, Arp4-related BAF53 and ?-actin are components of the human SWI/SNF complex and could play a role in its signal-regulated binding to the chromatin/nuclear matrix
Output: 3.4

***Test***
Input: sentence1: {sent1} sentence2: {sent2}
Output:"""

templates["biosses"]["zero_shot"] = lambda sent1, sent2: f"""***INPUT***
the input is a pair of sentences named sentence1 and sentence2

***OUTPUT***
the output is the semantic similarity in a continuous number from 0 (no relation) to 4 (equivalent)

***DOCUMENTATION***
0, the two sentences are on different topics.
1, the two sentences are not equivalent, but are on the same topic. 
2, the two sentences are not equivalent, but share some details.
3, the two sentences are roughly equivalent, but some important information differs/missing.
4, The two sentences are completely or mostly equivalent, as they mean the same thing.

***Test***
Input: sentence1: {sent1} sentence2: {sent2}
Output:"""

# MS2

templates["ms2"] = {}
templates["ms2"]["one_shot"] = lambda abstracts: f"""	
Prompt:
***TASK*** the task is to summarize an input biomedical literature in six sentences 
***INPUT*** the input is a biomedical literature ***OUTPUT*** the output is the summary of an input biomedical literature in six sentences ***DOCUMENTATION*** 
***EXAMPLES*** 
Input:
Output:

Example:
***TASK*** the task is to summarize an input biomedical literature in six sentences 
***INPUT*** the input is a biomedical literature 
***OUTPUT*** the output is the summary of an input biomedical literature in six sentences 
***DOCUMENTATION*** 
***EXAMPLES*** 
Input: To investigate the frequency and risk factors of major depressive disorder ( MDD ) after mild to moderate traumatic brain injury ( TBI ) , 69 TBI and 52 general trauma ( GT ) patients were prospect ively recruited and studied at 3-months postinjury . There was a nonsignificant difference in the proportion of MDD patients in the TBI and GT groups . Therefore , a composite MDD group ( TBI and GT patients ) was compared to patients who were nondepressed . Female gender was related to MDD , but no other risk factors were identified . MDD was associated with disability ( Glasgow Outcome Scale , Community Integration Question naire ) and cognitive impairment . MDD was comorbid with posttraumatic stress disorder . Implication s for postacute management of mild to moderate TBI are discussed OBJECTIVE To conduct a prospect i ve study of the occurrence of psychological disorders and comorbidities after spinal cord injury ( SCI ) , determine psychotropic medication usage , and establish predictors of psychological disorders after transition to the community . DESIGN Longitudinal design with multiple measures . SETTING Assessment occurred in SCI units and the community . PARTICIPANTS Adults with SCI ( N=88 ) admitted over a period of 32 months into 3 SCI units . INTERVENTIONS Participants completed inpatient rehabilitation for an acute SCI . Longitudinal assessment occurred up to 6 months postdischarge . MAIN OUTCOME MEASURES Measures were chosen that had a theoretical and clinical foundation for contributing to recovery after SCI . The Mini International Neuropsychiatric Interview , a structured diagnostic psychiatric interview , was conducted to determine the presence of psychological disorders . Medical measures included severity of secondary conditions or complications . Psychological measures included measures of anxiety and depressive mood , resilience , pain catastrophization , self-efficacy , and cognitive capacity . RESULTS Rates of psychological disorders of 17 % to 25 % were substantially higher than rates found in the Australian community . The occurrence of psychological disorder comorbidities was also very high . Anxiety was significantly elevated in those with a psychological disorder . Psychotropic medications were prescribed to more than 36 % of the sample , with most being antidepressants . Factors predictive of psychological disorders included years of education , premorbid psychiatric/psychological treatment , cognitive impairment , secondary complications , resilience , and anxiety . CONCLUSIONS SCI can have a substantial negative impact on mental health that does not change up to 6 months postdischarge . Findings suggest a substantial minority experience increased psychosocial distress after the injury and after transitioning into the community . Additional re sources should be invested in improving the mental health of adults with SCI Background There is considerable evidence showing that injured people who are involved in a compensation process show poorer physical and mental recovery than those with similar injuries who are not involved in a compensation process . One explanation for this reduced recovery is that the legal process and the associated retraumatization are very stressful for the cl aim ant . The aim of this study was to empower injured cl aim ants in order to facilitate recovery . Methods Participants were recruited by three Dutch cl aims settlement offices . The participants had all been injured in a traffic crash and were involved in a compensation process . The study design was a r and omized controlled trial . An intervention website was developed with ( 1 ) information about the compensation process , and ( 2 ) an evidence -based , therapist-assisted problem-solving course . The control website contained a few links to already existing websites . Outcome measures were empowerment , self-efficacy , health status ( including depression , anxiety , and somatic symptoms ) , perceived fairness , ability to work , cl aims knowledge and extent of burden . The outcomes were self-reported through online question naires and were measured four times : at baseline , and at 3 , 6 , and 12 months . Results In total , 176 participants completed the baseline question naire after which they were r and omized into either the intervention group ( n = 88 ) or the control group ( n = 88 ) . During the study , 35 participants ( 20 % ) dropped out . The intervention website was used by 55 participants ( 63 % ) . The health outcomes of the intervention group were no different to those of the control group . However , the intervention group considered the received compensation to be fairer ( P < 0.01 ) . The subgroup analysis of intervention users versus nonusers did not reveal significant results . The intervention website was evaluated positively . Conclusions Although the web-based intervention was not used enough to improve the health of injured cl aim ants in compensation processes , it increased the perceived fairness of the compensation amount . Trial registration Netherl and s Trial Register OBJECTIVE To compare differences in functional outcomes between urban and rural patients with traumatic brain injury ( TBI ) . DESIGN A longitudinal , prospect i ve , multicentre study of a 2-year cohort from the Brain Injury Rehabilitation Program ( BIRP ) for New South Wales , with follow-up at 18 months after injury . PARTICIPANTS 198 patients ( 147 urban , 51 rural ) with severe TBI from the 11 participating rehabilitation units . MAIN OUTCOME MEASURES Demographic and injury details collected prospect ively using a st and ardised question naire , and measures from five vali date d instruments ( Disability Rating Scale , Mayo-Portl and Adaptability Inventory , Sydney Psychosocial Reintegration Scale , Medical Outcomes Study Short Form and the General Health Question naire--28-item version ) administered at follow-up to document functional , psychosocial , emotional and vocational outcomes . RESULTS Demographic details , injury severity , lengths of stay in intensive and acute care wards were similar for both rural and urban groups . There were no significant group differences in functional outcomes , including return to work , at follow-up . CONCLUSIONS Our findings contrast with previous research that has reported poorer outcomes after TBI for rural residents , and suggest that the integrated network of inpatient , outpatient and outreach services provided throughout NSW through the BIRP provides effective rehabilitation for people with severe TBI regardless of where they live & NA ; Psychological distress is a feature of chronic whiplash‐associated disorders , but little is known of psychological changes from soon after injury to either recovery or symptom persistence . This study prospect ively measured psychological distress ( General Health Question naire 28 , GHQ‐28 ) , fear of movement/re‐injury ( TAMPA Scale of Kinesphobia , TSK ) , acute post‐traumatic stress ( Impact of Events Scale , IES ) and general health and well being ( Short Form 36 , SF‐36 ) in 76 whiplash subjects within 1 month of injury and then 2 , 3 and 6 months post‐injury . Subjects were classified at 6 months post‐injury using scores on the Neck Disability Index : recovered ( < 8 ) , mild pain and disability ( 10–28 ) or moderate/severe pain and disability ( > 30 ) . All whiplash groups demonstrated psychological distress ( GHQ‐28 , SF‐36 ) to some extent at 1 month post‐injury . Scores of the recovered group and those with persistent mild symptoms returned to levels regarded as normal by 2 months post‐injury , parallelling a decrease in reported pain and disability . Scores on both these tests remained above threshold levels in those with ongoing moderate/severe symptoms . The moderate/severe and mild groups showed elevated TSK scores at 1 month post‐injury . TSK scores decreased by 2 months in the group with residual mild symptoms and by 6 months in those with persistent moderate/severe symptoms . Elevated IES scores , indicative of a moderate post‐traumatic stress reaction , were unique to the group with moderate/severe symptoms . The results of this study demonstrated that all those experiencing whiplash injury display initial psychological distress that decreased in those whose symptoms subside . Whiplash participants who reported persistent moderate/severe symptoms at 6 months continue to be psychologically distressed and are also characterised by a moderate post‐traumatic stress reaction Abstract Dysregulations of the hypothalamus – pituitary – adrenal ( HPA ) axis have been discussed as a physiological substrate of chronic pain and fatigue . The aim of the study was to investigate possible dysregulations of the HPA axis in chronic whiplash‐associated disorder ( WAD ) . In 20 patients with chronic WAD and 20 healthy controls , awakening cortisol responses as well as a short circadian free cortisol profile were assessed before and after administration of 0.5 mg dexamethasone . In comparison to the controls , chronic WAD patients had attenuated cortisol responses to awakening , normal cortisol levels during the day , and showed enhanced and prolonged suppression of cortisol after the administration of 0.5 mg dexamethasone . Dysregulations of the HPA axis in terms of reduced reactivity and enhanced negative feedback suppression exist in chronic WAD . The observed endocrine abnormalities could serve as a systemic mechanism of symptoms experienced by chronic WAD patients The question as to whether mild traumatic brain injury ( mTBI ) results in persisting sequelae over and above those experienced by individuals sustaining general trauma remains controversial . This prospect i ve study aim ed to document outcomes 1 week and 3 months post-injury following mTBI assessed in the emergency department ( ED ) of a major adult trauma center . One hundred and twenty-three patients presenting with uncomplicated mTBI and 100 matched trauma controls completed measures of post-concussive symptoms and cognitive performance ( Immediate Post-Concussion Assessment and Cognitive Testing battery ; ImPACT ) and pre-injury health-related quality of life ( SF-36 ) in the ED . These measures together with measures of psychiatric status ( the Mini-International Neuropsychiatric Interview [ MINI ] ) pre- and post-injury , the Hospital Anxiety and Depression Scale , Visual Analogue Scale for Pain , Functional Assessment Question naire , and PTSD Checklist-Specific , were re-administered at follow-up . Participants with mTBI showed significantly more severe post-concussive symptoms in the ED and at 1 week post-injury . They performed more poorly than controls on the Visual Memory subtest of the ImPACT at 1 week and 3 months post-injury . Both the mTBI and control groups recovered well physically , and most were employed 3 months post-injury . There were no significant group differences in psychiatric function . However , the group with mild TBI was more likely to report ongoing memory and concentration problems in daily activities . Further investigation of factors associated with these ongoing problems is warranted OBJECTIVE To conduct a descriptive study investigating the effect of access to motor vehicle accident ( MVA ) compensation on recovery outcomes at 24 months after injury . DESIGN AND SETTING Longitudinal cohort study conducted in two Level 1 trauma hospitals in Victoria , Australia . Participants were 391 r and omly selected injury patients with moderate-to-severe injuries . Compensable and non-compensable patients were compared at 24 months after injury on a number of health outcomes . MAIN OUTCOME MEASURES Health outcomes at 24 months , including anxiety and depression severity , quality of life and disability . RESULTS Medical records identified two groups of compensation patients : MVA-compensable and non-compensable patients . After controlling for baseline variables , the MVA-compensable patients , at 24 months , had higher levels of post-traumatic stress disorder , anxiety and depression , and were less likely to have returned to their pre-injury number of work hours . However , some patients in the non-compensable group had accessed other forms of compensation ( eg , private health care or compensation for victims of crime ) . When these were removed from the non-compensable group , the differences between MVA-compensable and non-compensable groups all but disappeared . CONCLUSION Our findings do not 
Output:Increased psychological distress remains elevated in SCI , mTBI and WAD for at least 3 years post-MVC .


Input: {abstracts}
Output:"""

templates["ms2"]["zero_shot"] = lambda abstracts: f"""***TASK*** the task is to summarize an input biomedical literature in six sentences 
***INPUT*** the input is a biomedical literature ***OUTPUT*** the output is the summary of an input biomedical literature in six sentences ***DOCUMENTATION*** 
***EXAMPLES*** 
Input: {abstracts}
Output:"""

templates["pubmed"] = {}
templates["pubmed"]["one_shot"] = lambda full_text: f"""***TASK*** the task is to summarize an input biomedical literature in six sentences
***INPUT*** the input is a biomedical literature ***OUTPUT*** the output is the summary of an input biomedical literature in six sentences
***DOCUMENTATION*** 
***EXAMPLES***
Input:
Output:

Example:

***TASK*** the task is to summarize an input biomedical literature in six sentences ***INPUT*** the input is a biomedical literature 
***OUTPUT*** the output is the summary of an input biomedical literature in six sentences 
***DOCUMENTATION*** 
***EXAMPLES*** 
Input: mast cells ( mcs ) belong to the innate - compartment of the immune system and are widely known for their role in allergic reactions via their binding to ige receptor ( alvarez - errico et al . , 2009 ) . mcs are a common cellular component of both connective and mucosal tissues ( kitamura and ito , 2005 ) . beside this , mcs contain a wide range of biologically active molecules , including biogenic amines , heparin or heparan sulfate proteoglycans , neutral proteases , and neuropeptides . in addition , upon stimulation , they also produce and eject a large number of factors ( wilhelm et al . , 2000 ) . taking these characteristics together , it is clear that even a small number of such potent unicellular glands have a significant effect on different physiological processes . in addition to the very well known and described mechanism of mc activation and posterior degranulation throughout ige receptor , several other alternative but not redundant mechanisms of mc activation have been described ( mousli et al . , 1994 ; bradding , 2005 ; kim et al . , , 2005 ; vasiadi et al . , 2006 ; narita et al . , 2007 ; zaitsu et al . , 2007 ; jensen et al . , 2010 ; jing et al . , 2011 ; walter et al . , we will discuss in this review the current bibliography evidences about the effect of female sex hormones on mc functionality . female sex steroid hormones act primarily via their receptors : estrogen via estrogen receptor er or er , progesterone via progesterone receptor pr - a or pr - b ( carey et al . , 2007 ) . steroid receptors are best described as nuclear receptors acting as transcription factors on gene expression . however , in the past decade abundant evidences accumulated showing addition binding sides localized at the plasma membrane ( levin , 2011 ) , whose activation is more often involved in the rapid effects of steroids occurring within seconds to minutes ( watson et al . , 1999 ; watson and gametchu , 2003 ) . in this regard , it has been shown that classical er at the membrane but not in the nucleus mediates 17 - estradiol ( e2 ) - induced rapid signaling to kinase activation ( levin , 2011 ) . similarly , extra - nuclear pr induces activation of erk / mapk kinases , which lead to cell surviving as well as cells migration ( levin , 2011 ) . we and other authors have demonstrated the expression of , estradiol and progesterone receptors in human , mouse , and rat mcs ( theoharides et al . , 1993 ;( 2007 ) have shown mrna expression of er but not er in human and mouse mcs . alongside the authorshave also shown that e2 rapidly stimulated mc degranulation which could be blocked by tamoxifen , a tissue specific er antagonist , clearly indicating that estradiol - induced mc degranulation throughout one of its receptors . bone marrow - derived mcs ( bmmcs ) isolated from er knockout animals did not degranulate in response to e2 treatment confirming that the e2 effect on mcs is more likely mediated by the er ( zaitsu et al . , 2007 ) . due to the rapid onset of e2 effect on mc activationthe authors concluded that e2 in this context does not function through the classical ( genomic ) mechanisms , which require enhanced mrna and protein synthesis over 2 h or longer period and proposed that the effect is mediated by a membrane - associated ( non - genomic ) form of er ( zaitsu et al . we were additionally able to show that the human mast cell line ( hmc - 1 ) treated in vitro with physiological concentration of e2 and p4 significantly increased the synthesis of - tryptase , which is a serine proteinase abundantly produced by mcs , and is a marker of mc maturation . beside , e2 and p4 treatment induced degranulation of hmc - 1 in vitro ( jensen et al . , 2010 ) . supporting the idea of female sex hormones having an effect on mc function , kirmaz et al . ( 2004 ) have demonstrated that allergen skin prick tests ( spt ) , a very sensitive and specific tests to detect allergic sensitization in atopic patients , is altered in women upon hormonal changes during the menstrual cycle . in addition to female sex hormone receptor expression , mcs have been also shown to express androgen receptor ( chen et al . , 2010 ) . however , testosterone treatment had no effect on mc degranulation ( chen et al . , 2010 ) . the idea that female sex hormones , e2 and p4 , may affect mc functionality and therefore have an influence on the symptoms of mc - associated disorders has long been suggested . asthma and other allergic diseases of the airway are up to three times more common in women than in men during the early to middle adulthood and remains so through the reproductive years ( de marco et al . , 2002 ; mannino et al . , 2002 ; schatz and camargo , 2003 ) . a number of clinical and epidemiological studies suggested that female sex hormones are accountable for these differences . beside this , postmenopausal women taken hormone replacement therapy had higher risk of new onset of asthma ( barr et al . , 2004 ) . furthermore , 3040 % of women who had asthma , experience a worsening of their symptoms during the perimenstrual phase of the menstrual cycle ( perimenstrual asthma ) being the time point when e2 and p4 concentrations are changing rapidly ( vrieze et al . , 2003 ) . in this context , it is of great importance to mention that the prevalence and morbidity of asthma and other allergic diseases have increased dramatically during the last 30 years , particularly in developing countries ( burr et al . , 2006 ) . ( 2007 ) have nicely demonstrated that this may be related to the increase of low concentrations of environmental like - estrogen compounds . these estrogen - like compounds , called xenoestrogens , are present in the environmental pollutants mainly in water and food . they are able not only to activate mcs but enhance mc degranulation upon allergen cross - linking of ige which may explain the above described increment of allergic diseases in the last years in developing countries ( narita et al . , 2007 ) . in an animal model of allergic disease , the role of female sex hormone was tested . female mice have reportedly an increased susceptibility to allergic airway disease in compared with male mice ( reviewed in carey et al . , 2007 ) . levels of ige are much higher in allergic female mice compared to their syngeneic male ( corteling and trifilieff , 2004 ) . female rats that underwent ovariectomization developed less airway inflammation compared with sham controls animals ( ligeiro de oliveira et al . however , estrogen replacement in the ovariectomized animals re - established airway inflammation levels of intact females ( ligeiro de oliveira et al . , 2004 ) . treatment of intact female rats with the selective estrogen receptor antagonist tamoxifen also reduced the development of allergic airway disease ( ligeiro de oliveira et al . , 2004 ) . thus , the direct effect of these hormones on disease development is hereby demonstrated . beyond the well - documented effects of estradiol and progesterone on mc function in mc - associated diseases , for instance , estradiol was showed to be a potent inducer of ovarian mc degranulation , which seems to be a necessary factor during the process of oocyte ovulation ( jaiswal and krishna , 1996 ; tamura and kogo , 1999 ) . the presence of mcs in the uterus has been already described in many species including human ( drudy et al . , 1991 ) , mouse ( padilla et al . ,1990 ) , rat ( aydin et al . , 1998 ) , hamster ( harvey , 1964 ) as well as goat ( karaca et al . , 2008 ) . besides , the number of mcs in the uterus was shown to fluctuate during estrous cycle suggesting an influence of female sex hormones on mc recruitment to the uterus ( aydin et al . , 1998 ) . ovariectomized mice , in which estradiol and progesterone are almost absent , have less number of uterine mcs compared to control , non - ovariectomized animals ( jensen et al . , 2010 ) . hormonal replacement , estradiol alone or in combination with progesterone , restored the number of uterine mcs after ovariectomization , which was comparable to the levels observed in control mice ( jensen et al . , 2010 ) . hormonal replacement additionally induced an augmentation in the levels of mc - related proteases expression in the uterus as well as boosted mc degranulation ( jensen et al . , 2010 ) . this is of particular importance because upon degranulation , mcs release several molecules ( histamine , proteases , metalloproteinases , pro - angiogenic factors ) , all very well known to account for the process of embryo implantation . mast cells , the so - called unicellular glands , once solely known as effectors cells of the innate immune system only activated by ige cross - linking to the ige receptor upon allergen stimulation are now known to be much more plastic and susceptible to be activated by several factors including female sex hormones , estradiol and progesterone . strong data in the last years reinforced the idea that these hormones are crucial component of mc behavior not only in physiological conditions but also in several mc pathological situations . deciphering the mechanisms by which female sex hormones activate mcs and under which conditions these happens , alongside with explanation why female sex hormones have these effects is of crucial interest for a better understanding of the physiology of these cells . the authors declare that the research was conducted in the absence of any commercial or financial relationships that could be construed as a potential conflict of interest . 
Output: female sex hormones have long been suspected to have an effect on mast cell ( mc ) behavior . this assumption is based on the expression of hormone receptors in mcs as well as on the fact that many mc - related pathophysiological alterations have a different prevalence in females than in males . further , serum ige levels are much higher in allergic female mice compared to male mice . ovariectomized rats developed less airway inflammation compared to sham controls . following estrogen replacement ovariectomized rats re - established airway inflammation levels found in intact females . in humans , a much higher asthma prevalence was found in women at reproductive age as compared to men . serum levels of estradiol and progesterone have been directly correlated with the clinical and functional features of asthma . around 3040 % of women who have asthma experienced worsening of their symptoms during the perimenstrual phase , the so - called perimenstrual asthma . postmenopausal women receiving hormone replacement therapy have an increased risk of new onset of asthma . beside , estrus cycle dependent changes on female sex hormones are related to changes on mc number in mouse uterine tissue and estradiol and progesterone were shown to induce uterine mc maturation and degranulation . we will discuss here the currently available information concerning the role of these female sex hormones on mc behavior .

Input: {full_text}
Output:""" 

templates["pubmed"]["zero_shot"] = lambda full_text: f"""***TASK*** the task is to summarize an input biomedical literature in six sentences
***INPUT*** the input is a biomedical literature ***OUTPUT*** the output is the summary of an input biomedical literature in six sentences

Input: {full_text}
Output:"""

templates["cochrane"] = {}
templates["cochrane"]["one_shot"] = lambda source: f"""***TASK*** the task is to simplify the input abstract of a biomedical literature 
***INPUT*** the input is the abstract of a biomedical literature 
***OUTPUT*** the output is the simplified abstract for the input abstract of a biomedical literature ***DOCUMENTATION*** 
***EXAMPLES*** 
Input:
Output:

Example:
***TASK*** the task is to simplify the input abstract of a biomedical literature 
***INPUT*** the input is the abstract of a biomedical literature 
***OUTPUT*** the output is the simplified abstract for the input abstract of a biomedical literature ***DOCUMENTATION*** 
***EXAMPLES*** 
Input: Two trials (n = 190), at low risk of bias, were included in the review and both presented data on first time failure at the tooth level. Pooling of the data showed a statistically significant difference in favour of molar bands, with a hazard ratio of 2.92 (95% confidence intervals (CI) 1.80 to 4.72). No statistically significant heterogeneity was shown between the two studies. Data on first time failure at the patient level were also available and showed statistically different difference in favour of molar bands (risk ratio 2.30; 95% CI 1.56 to 3.41) (risk of event for molar tubes = 57%; risk of event for molar bands 25%). One trial presented data on decalcification again showing a statistically significant difference in favour of molar bands. No other adverse events identified. From the two well-designed and low risk of bias trials included in this review it was shown that the failure of molar tubes bonded with either a chemically-cured or light-cured adhesive was considerably higher than that of molar bands cemented with glass ionomer cement. One trial indicated that there was less decalcification with molar bands cemented with glass ionomer cement than with bonded molar tubes cemented with a light-cured adhesive. However, given there are limited data for this outcome, further evidence is required to draw more robust conclusions. 
Output: The evidence in this review, which was carried out together with Cochrane Oral Health, is up-to-date as of 15 February 2017. We included two studies that evaluated 190 participants. Both trials were conducted in the UK and both compared bonded molar tubes with molar bands. From the limited data of two studies at low risk of bias, it would appear that bonded molar tubes are associated with a higher failure rate than with molar bands.

Input: {source}
Output:"""

templates["cochrane"]["zero_shot"] = lambda source: f"""***TASK*** the task is to simplify the input abstract of a biomedical literature 
***INPUT*** the input is the abstract of a biomedical literature 
***OUTPUT*** the output is the simplified abstract for the input abstract of a biomedical literature ***DOCUMENTATION*** 

Input: {source}
Output:"""


templates["plos"] = {}
templates["plos"]["one_shot"] = lambda article: f"""***TASK*** the task is to simplify the input abstract of a biomedical literature 
***INPUT*** the input is the abstract of a biomedical literature 
***OUTPUT*** the output is the simplified abstract for the input abstract of a biomedical literature 
***DOCUMENTATION*** 
***EXAMPLES*** 
Input:
Output:

Example:
***TASK*** the task is to simplify the input abstract of a biomedical literature 
***INPUT*** the input is the abstract of a biomedical literature 
***OUTPUT*** the output is the simplified abstract for the input abstract of a biomedical literature 
***DOCUMENTATION*** 
***EXAMPLES*** 
Input: Human CMV (HCMV) is a universally distributed pathogen that infects 50–90% of the world's population. Asymptomatic in healthy people, HCMV infection may lead to increased morbidity and mortality in immunocompromised individuals. Overall survival following transplantation is decreased when either the donor or the recipient is HCMV-seropositive [1,2,3]. Because of drug-related adverse effects and drug resistance there is growing interest for immunotherapy as an adjunct to antiviral therapy. Understanding the mechanisms developed by the immune system to control HCMV is therefore critical to enable the design of new curative or preemptive protocols aimed at enhancing patient immune defense against this virus. Effective immune control of HCMV has been compellingly shown to rely on both conventional lymphocytes and NK cells [4]. However, as we initially reported, HCMV also induces a robust γδ T cell response in organ transplant recipients [5]; and later, γδ T cell response to HCMV was extended to several other situations not always associated to immunosuppression; such as immunodeficiencies, bone marrow transplantation, pregnancy, elderly and also in healthy individuals [6,7,8,9,10,11,12]. HCMV-mediated persistent expansion of γδ T cells in transplant recipients is associated with infection resolution [13], and implies tissue-associated Vδ2-negative γδ T cells which acquire a terminally differentiated phenotype upon HCMV pressure [10,14]. When isolated in vitro, these lymphocytes were shown to kill HCMV-infected cells, limit virus propagation and produce IFNγ through recognition of opsonized viruses [15,16]. Several features of γδ T cells might explain their specific relationship to HCMV: (i) they are not MHC restricted, and thus not affected by HCMV strategies to inhibit HLA molecules, (ii) they recognize self-antigens on the surface of stressed cells such as virus infected cells [17,18] and (iii) they are located at external body surfaces (eg gut and lung) and organs (eg liver) involved in HCMV transmission and replication [19]. Moreover, HCMV-reactive γδ T cells exhibit dual reactivity against tumor cells, due to the recognition of stress-induced self-antigens shared by HCMV-infected and tumor cells [15,18,20]. In agreement with this, HCMV-infection and/or γδ T cell expansion have been associated with reduced cancer risk in kidney transplant recipients [21] and with graft-versus leukemia effect in bone marrow transplant recipients [22,23,24]. All these specificities are consistent with an antiviral protective role of γδ T cells against HCMV and they thus represent valuable candidates for anti-HCMV immunotherapy especially in immunocompromised patients vulnerable to neoplasia. However, their role in protection and specific contribution within the global anti-CMV immune response has not been firmly established, nor their anatomical sites of activation and intervention. The aim of the present study was therefore to take advantage of the murine model of CMV infection to address these questions and to assess the respective ability of αβ and γδ T cells alone to protect mice from CMV infection. Murine CMV (MCMV) has been widely used to model the immune response to HCMV in mice since it reproduces with reasonable accuracy the antiviral response of CD8 T cells and NK cells [25]. Murine γδ T cells have been implicated in MCMV infection only once [26], and their sufficiency for protection has not yet been addressed. We show herein that γδ T cells are as competent as αβ T cells to control MCMV infection and protect mice from death encouraging the development of novel anti-viral immunotherapeutic protocols based on γδ T cell manipulation. In mice, MCMV-specific αβ T cells control viral spread and protect infected mice from death [27] but little is known regarding the implication of γδ T cells. To evaluate the respective contribution of αβ and γδ T cells to the immune response against MCMV, mice deficient for γδ T cells (TCRδ−/−), for αβ T cells (TCRα−/−) or for both T cell subsets (CD3ε−/−) were challenged with 105 plaque forming units (PFU) of salivary gland MCMV. This dose was reported to be sublethal for C57BL/6 mice (as described at http://mutagenetix.utsouthwestern.edu/protocol/protocol_rec.cfm?protocolid=5). Accordingly, 100% of CD3ε+/− control mice survived MCMV infection, whereas CD3ε−/− died about 4 weeks after viral challenge (Fig. 1A), confirming the critical role of T cells in controlling MCMV infection. CD3ε−/− mice were extremely sensitive to MCMV despite the presence of NK cells [28] since they died at doses of MCMV as low as 2.103 PFU (Fig. 1B). Unexpectedly, both TCRδ−/− and TCRα−/− mice survived as long as CD3ε+/− control mice. These results reveal that the presence of either αβ or γδ T cell subset was sufficient to protect mice from MCMV infection, disclosing the potentially critical function of γδ T cells in the immune response against MCMV. To examine whether this protection against CMV by γδ T cells relies on the control of viral loads, the kinetics of MCMV spread in T cell deficient versus T cell competent mice was determined in various organs. Comparison between each mouse line is shown in Fig. 2 and comparison between different time points is shown in S1 Fig. In the absence of T cells, MCMV DNA copy numbers increased substantially from day 3 to 24, with up to 107 copies (/100ng DNA) in the spleen and lungs of CD3ε−/− mice before death. Interestingly, γδ T cells alone (in TCRα−/− mice) were sufficient to prevent an increase of viral load in all organs, except the salivary glands which are known to support prolonged virus replication even in wild-type mice (S1 Fig.). At the end of these experiments, MCMV copies were much lower in T cell bearing mice than in mice without T cells (Fig. 2), underlining the inability of C57BL/6 mice to control MCMV infection in the absence of T cells. It was of particular interest to see that in the lungs γδ T cells were as potent as αβ T cells to control the viral load except at day 14. As a whole, these results suggest independent control of MCMV spread by the αβ and γδ T cell subsets, revealing that γδ T cells are sufficient to control viral load and can substitute for the absence of αβ T cells. Hepatitis and pneumonitis are common features of CMV pathogenesis in both humans and mice. Hepatitis can be assessed in living infected mice through the quantification of transaminase levels in the serum. As shown in Fig. 3A, aspartate aminotransferase (AST) and alanine aminotransferase (ALT) only increased in the absence of all T cells (CD3ε−/− mice), reaching up to 8 fold the basal level before death of CD3ε−/− mice. Accordingly, histological analysis of livers from CD3ε−/− infected mice before death (day 22) showed typical features of active hepatitis, with many large granulomas mainly composed of histiocytic cells associated with multiple apoptotic hepatocytes (Fig. 3B). In contrast, only a few small granulomas were observed in TCRα−/− mice livers at that time point. Furthermore, CD3ε−/− mice presented an active pneumopathy with large granulomas and hemorrhagic foci at day 22, while TCRα−/− lung histology was close to normal with only a slight increase of inflammatory cells in the inter-alveolar septa (Fig. 3B). In conclusion, CD3ε−/− mice showed clear evidences of both liver and lung diseases 3 weeks post MCMV infection, in agreement with the high viral loads found at that time in these organs. In contrast, liver and lung disorders were not observed in TCRα−/− mice, emphasizing the ability of γδ T cells to control MCMV infection and associated organ disease. Whether γδ T cells limit organ disease only as a consequence of viral replication control or also by producing mediators of tissue repair deserves further attention. We next sought to analyze whether the control of MCMV spread was associated with an amplification of γδ T cells in infected organs. S2 Fig. shows the gating strategy used for γδ T cell flow cytometry analysis. After a slight decrease at day 3, γδ T cell numbers increased importantly in the lungs until day 21 (approximately 8 fold), and this rise persisted until the end of the experiment. A significant but more modest and transient increase was also observed in the liver (approximately 2 fold from day 3 to 7). By contrast and to our surprise given their preponderance in gut intraepithelial lymphocytes, no significant variation of γδ T cells was observed in the intestine. In the spleen, γδ T cells levels remained stable until day 21 when they decreased (Fig. 4A). In conclusion, control of MCMV infection by γδ T cells in TCRα−/− mice is associated with a transient γδ T cell increase in the liver, and a delayed but strong and persistent expansion of γδ T cells in the lungs. We next asked whether γδ T cells responding to MCMV differentiate into effector-memory cells as we observed previously in humans [10,14]. After a transient decrease early post MCMV challenge, the proportion of effector memory (EM, CD44+CD62L−) γδ T cells increased in the spleen, liver and lungs concomitantly with a decrease of central memory (CM, CD44+CD62L+) γδ T cells. Effector memory γδ T cells reached more than 80% in the liver and lungs at day 56 (Fig. 4B and 4C). Consistent with the absence of variation in γδ T cell numbers in the intestine, no modification of γδ T cells phenotype could be observed in this organ. These results confirm that MCMV induces a marked response of γδ T cells in the lungs and liver, which is more modestly seen in the spleen and absent from the intestine. The subsets of murine γδ T lymphocytes expressing the Vγ1 or Vγ4 chains of the TCR predominate in the spleen, liver and lungs, whereas intestinal γδ T cells are almost exclusively Vγ7+ (nomenclature of Heilig and Tonegawa [29]). We assessed the quantity, repertoire and memory phenotype of these γδ T lymphocyte subsets in the liver, spleen and lungs. Not surprisingly, low proportions of Vγ1+ γδ T cells were found in the intestine (S2 Fig.). As observed in Fig. 5A, the expansion of γδ T cells in the lungs and liver after day 3 concerned mainly Vγ1+ but also Vγ4+ γδ T cells. Both subsets followed the kinetics of total γδ T cells (Fig. 4A). Analysis of subsets also showed a response of Vγ1+, but not Vγ4+ T cells, in the spleen (Fig. 4A and Fig. 5A). The proportion of EM cells among both Vγ1+ and Vγ4+ γδ T cells increased after day 3 in the lungs, liver and spleen (Fig. 5B). In contrast, Vγ7+ γδ T cell numbers/memory phenotype did not vary significantly upon MCMV infection (Fig. 5A and Fig. 5B), as could be expected from the analysis of the whole γδ T cell population in the intestine (Fig. 4A and Fig. 4C). The complementary-determining-region (CDR3)γ1 and CDR3γ4 length profile of liver, spleen and lung-derived γδ T cells were not different between uninfected and infected mice for 14 days (S3 Fig. and S4 Fig.), indicating that there were no major changes in these CDR3 repertoires after expansion. γδ T cells development in CD3ε−/− mice was reconstituted by bone marrow (BM) transfer experiments using TCRα−/− mice as donors (referred to as TCRα−/− > CD3ε−/− mice). This method allowed the generation of the BM-derived Vγ1+ and Vγ4+ γδ T cell subsets that were increased upon MCMV infection. Control BM transplants were also performed with TCRδ−/− donors (TCRδ−/− > CD3ε−/− mice) and with CD3ε+/− donors (CD3ε+/− > CD3ε−/− mice). γδ and/or αβ T cell reconstitution was allowed to establish for 3 months before MCMV infection of the mice. γδ T cell subset percentages were analyzed in blood from live mice throughout reconstitution (Fig. 6A). Two months after grafting, the percentages of blood γδ and/or αβ T cells (among total lymphocytes) had reached a plateau (Fig. 6A). The proportion of peripheral blood γδ T cells in CD3ε+/− > CD3ε−/− mice was lower than that found in TCRα−/− > CD3ε−/− mice (Fig. 6A, lower panel), in accordance with previous findings which showed that γδ T cells in TCRα−/− outnumbered γδ T cells in C57BL/6 mice [30]. When infected with MCMV at 3 months post-graft, TCRα−/− > CD3ε−/− mice survived MCMV infection as efficiently as CD3ε+/− > CD3ε−/− and TCRδ−/− > CD3ε−/− mice, in marked contrast with CD3ε−/− > CD3ε−/− mice (Fig. 6B). In a second experimental 
Output: γδ T cells are unconventional T lymphocytes that play a unique role in host protection against pathogens. Human Cytomegalovirus (HCMV) is a widespread virus that can cause severe organ disease such as hepatitis and pneumonitis in immune-compromised patients. Our decade-long study conveys compelling evidence for the implication of human γδ T cells in the immune response against HCMV, but their protective role could not be formally demonstrated in humans. In the present study we use the murine model of CMV infection which allows the spatial and temporal analysis of viral spread and anti-viral immune responses. We show that, in the absence of αβ T cells, γδ T cells control MCMV-induced hepatitis, pneumonitis and death by restricting viral load in the liver, lungs and spleen. γδ T cells expand in these organs and display memory features that could be further incorporated into vaccination strategies. In conclusion, γδ T cells represent an important arm in the immune response against CMV infection that could be particularly important in the context of αβ T cell immune-suppression.

Input: {article}
Output:"""

templates["plos"]["zero_shot"] = lambda article: f"""***TASK*** the task is to simplify the input abstract of a biomedical literature 
***INPUT*** the input is the abstract of a biomedical literature 
***OUTPUT*** the output is the simplified abstract for the input abstract of a biomedical literature 
***DOCUMENTATION*** 
Input: {article}
Output:"""

templates["plos2"] = {}
templates["plos2"]["one_shot"] = lambda article: f"""***TASK*** the task is to simplify the input abstract of a biomedical literature 
***INPUT*** the input is the abstract of a biomedical literature 
***OUTPUT*** the output is the simplified abstract for the input abstract of a biomedical literature 

***EXAMPLES*** 
Input: Functionally analogous enzymes are those that catalyze similar reactions on similar substrates but do not share common ancestry, providing a window on the different structural strategies nature has used to evolve required catalysts. Identification and use of this information to improve reaction classification and computational annotation of enzymes newly discovered in the genome projects would benefit from systematic determination of reaction similarities. Here, we quantified similarity in bond changes for overall reactions and catalytic mechanisms for 95 pairs of functionally analogous enzymes (non-homologous enzymes with identical first three numbers of their EC codes) from the MACiE database. Similarity of overall reactions was computed by comparing the sets of bond changes in the transformations from substrates to products. For similarity of mechanisms, sets of bond changes occurring in each mechanistic step were compared; these similarities were then used to guide global and local alignments of mechanistic steps. Using this metric, only 44% of pairs of functionally analogous enzymes in the dataset had significantly similar overall reactions. For these enzymes, convergence to the same mechanism occurred in 33% of cases, with most pairs having at least one identical mechanistic step. Using our metric, overall reaction similarity serves as an upper bound for mechanistic similarity in functional analogs. For example, the four carbon-oxygen lyases acting on phosphates (EC 4.2.3) show neither significant overall reaction similarity nor significant mechanistic similarity. By contrast, the three carboxylic-ester hydrolases (EC 3.1.1) catalyze overall reactions with identical bond changes and have converged to almost identical mechanisms. The large proportion of enzyme pairs that do not show significant overall reaction similarity (56%) suggests that at least for the functionally analogous enzymes studied here, more stringent criteria could be used to refine definitions of EC sub-subclasses for improved discrimination in their classification of enzyme reactions. The results also indicate that mechanistic convergence of reaction steps is widespread, suggesting that quantitative measurement of mechanistic similarity can inform approaches for functional annotation.  
Output:  When species evolve, their genes duplicate and diverge to allow for adaptation of their functional repertoires to the changing environment. In this scenario, unrelated genes can convergently evolve to produce proteins with the same molecular function, termed "functionally analogous." A quantitative determination of the reaction similarities among functionally analogous enzymes could provide insight about the different structural solutions nature has used to evolve similar catalysts. Bond changes between substrates and products, and between successive reaction intermediates, were used to compare the reactions catalyzed and the mechanisms of catalysis for 95 pairs of functionally analogous enzymes. Less than half of the reactions catalyzed by unrelated enzymes, but defined as similar by the Enzyme Commission (EC) classification, are similar in terms of bond changes, suggesting that this classification often fails to capture quantitative differences between many enzyme reactions. Furthermore, we addressed for the first time whether the chemical mechanisms by which similar overall reactions are achieved in functional analogs are also similar. We conclude that convergence of reaction is often accompanied by convergence of chemical mechanism. These results will be useful for classifying enzymes, guiding functional annotation of newly determined enzyme sequences and structures and for informing the engineering of enzymes with new functions.

Input: {article}
Output:"""

templates["plos2"]["zero_shot"] = lambda article: f"""***TASK*** the task is to simplify the input abstract of a biomedical literature 
***INPUT*** the input is the abstract of a biomedical literature 
***OUTPUT*** the output is the simplified abstract for the input abstract of a biomedical literature 

Input: {article}
Output:"""
