import logging
from livereco.api.parameters.beam_setup import BeamSetup
from livereco.api.parameters import Measurement


class ConeBeam(BeamSetup):
    def __init__(self):
        None

    @staticmethod
    def z12(setup: BeamSetup, measurement: Measurement):
        return setup.z02 - measurement.z01

    @staticmethod
    def get_fr(setup: BeamSetup, measurement: Measurement, verbose=False):
        z12 = ConeBeam.z12(setup, measurement)

        lam = 1.2398 / setup.energy
        M = (z12 + measurement.z01) / measurement.z01
        dx_eff = setup.px_size / M
        z_eff = z12 / M
        fr_eff = dx_eff**2 / lam / z_eff

        logging.info(f"{'Energy':<17}{setup.energy}")
        logging.info(f"{'Lambda':<17}{round(lam,6)}")
        logging.info(f"{'Magnification':<17}{round(M,2)}")
        logging.info(f"{'Effective dx':<17}{int(dx_eff)}")
        logging.info(f"{'Effective z12':<17}{int(z_eff)}")
        logging.info(f"{'Fresnel Number':<17}{fr_eff}")

        return fr_eff

    def calc_geometry_p05(path_raw, energy, holder):
        motor_pos = load_motor_log(path_raw + "/" + scanname)
        o_stage_y = float(motor_pos["OpticsStage1_y"])
        slider1 = float(motor_pos["GraniteSlab_1"])
        slider2 = float(motor_pos["GraniteSlab_2"])
        sf1_y = float(motor_pos["OpticsSF1_y"])

        detDistInit = 20264  # mm
        posInit = -66.244  #
        offset = slider1 + o_stage_y + sf1_y + holder + self.fzp_f  # % mm

        self.z02 = (detDistInit - offset) * 1e6
        self.z01 = (posInit + slider2 - offset) * 1e6
        return self.z01, self.z02
