import sys

member_value_adapter = None

try:
    import torch
except Exception:
    pass

if "torch" in sys.modules:
    from livereco.api.parameters.type_conversion.member_value_adapter_torch import (
        MemberValueAdapterTorch,
    )

    member_value_adapter = MemberValueAdapterTorch
else:
    from livereco.api.parameters.type_conversion.member_value_adapter_numpy import (
        MemberValueAdapterNumpy,
    )

    member_value_adapter = MemberValueAdapterNumpy

from livereco.api.parameters.beam_setup import BeamSetup
from livereco.api.parameters.data_dimensions import DataDimensions
from livereco.api.parameters.measurement import Measurement
from livereco.api.parameters.options import Options
from livereco.api.parameters.padding import Padding
from livereco.api.parameters.reco_params import RecoParams
from livereco.api.parameters.regularization import Regularization
from livereco.api.parameters.flatfield_components_params import FlatfieldComponentsParams
from livereco.api.parameters.flatfield_correction_params import FlatfieldCorrectionParams
