# Contributing to AWQP Low-Cost Water Sampler project

First off, thank you for considering contributing to the AWQP Low-Cost Water Sampler project repository. It's people like you that make this tool useful and educational for everyone. 

## Getting Started

1. **Fork the repository**: This will allow you to make changes without affecting the main project.
2. **Clone your fork locally**: This will allow you to make changes on your own machine.
3. **Set up the development environment**: Ensure you have VS code and applicable C++ plugins, or use the [Particle IDE online](https://build.particle.io/).

## Code of Conduct

By participating in this project, you are expected to uphold our Code of Conduct. Please report unacceptable behavior to [ansley.brown@colostate.edu](mailto:ansley.brown@colostate.edu).

## How to Contribute

1. **Find an issue or feature request**: Look for open issues or feature requests to work on. If the issue or feature request doesn't already exist, please create one.
2. **Work on your changes**: Make your changes and improvements in your local environment. Ensure you follow the coding standards of the project.
3. **Write tests**: If possible, add tests for the changes you make. This ensures that your changes work correctly and that future changes won't break your additions.
4. **Commit your changes**: Make sure to write a good commit message. This helps others understand the changes you made.
5. **Push to your fork**: Push your changes to your forked repository on GitHub.
6. **Create a pull request**: Finally, create a pull request against the main repository. Ensure you provide a description of the changes you made.

## Resources

If you are new to C++ for microcontrollers or the Particle Boron platform, or want to refresh your knowledge:

- [C++ Reference](https://en.cppreference.com/)
- [Particle Boron Documentation](https://docs.particle.io/boron/)

## Feedback

If you're unsure about anything, need help with the setup, or want to discuss a feature or bug, please open a new issue in the repository.

## Thank You!

Once again, thank you for your contributions. Your efforts will help improve the AWQP Low-Cost Water Sampler project and make it a valuable resource for the community.
