chasenid2pos = {
    "00": "？",
    "01": "名詞",
    "02": "名詞-一般",
    "03": "名詞-固有名詞",
    "04": "名詞-固有名詞-一般",
    "05": "名詞-固有名詞-人名",
    "06": "名詞-固有名詞-人名-一般",
    "07": "名詞-固有名詞-人名-姓",
    "08": "名詞-固有名詞-人名-名",
    "09": "名詞-固有名詞-組織",
    "10": "名詞-固有名詞-地域",
    "11": "名詞-固有名詞-地域-一般",
    "12": "名詞-固有名詞-地域-国",
    "13": "名詞-代名詞",
    "14": "名詞-代名詞-一般",
    "15": "名詞-代名詞-縮約",
    "16": "名詞-副詞可能",
    "17": "名詞-サ変接続",
    "18": "名詞-形容動詞語幹",
    "19": "名詞-数",
    "20": "名詞-非自立",
    "21": "名詞-非自立-一般",
    "22": "名詞-非自立-副詞可能",
    "23": "名詞-非自立-助動詞語幹",
    "24": "名詞-非自立-形容動詞語幹",
    "25": "名詞-特殊-",
    "26": "名詞-特殊-助動詞語幹",
    "27": "名詞-接尾",
    "28": "名詞-接尾-一般",
    "29": "名詞-接尾-人名",
    "30": "名詞-接尾-地域",
    "31": "名詞-接尾-サ変接続",
    "32": "名詞-接尾-助動詞語幹",
    "33": "名詞-接尾-形容動詞語幹",
    "34": "名詞-接尾-副詞可能",
    "35": "名詞-接尾-助数詞",
    "36": "名詞-接尾-特殊",
    "37": "名詞-接続詞的",
    "38": "名詞-動詞非自立的",
    "39": "名詞-引用文字列",
    "40": "名詞-ナイ形容詞語幹",
    "41": "接頭詞",
    "42": "接頭詞-名詞接続",
    "43": "接頭詞-動詞接続",
    "44": "接頭詞-形容詞接続",
    "45": "接頭詞-数接続",
    "46": "動詞",
    "47": "動詞-自立",
    "48": "動詞-非自立",
    "49": "動詞-接尾",
    "50": "形容詞",
    "51": "形容詞-自立",
    "52": "形容詞-非自立",
    "53": "形容詞-接尾",
    "54": "副詞",
    "55": "副詞-一般",
    "56": "副詞-助詞類接続",
    "57": "連体詞",
    "58": "接続詞",
    "59": "助詞",
    "60": "助詞-格助詞",
    "61": "助詞-格助詞-一般",
    "62": "助詞-格助詞-引用",
    "63": "助詞-格助詞-連語",
    "64": "助詞-接続助詞",
    "65": "助詞-係助詞",
    "66": "助詞-副助詞",
    "67": "助詞-間投助詞",
    "68": "助詞-並立助詞",
    "69": "助詞-終助詞",
    "70": "助詞-副助詞／並立助詞／終助詞",
    "71": "助詞-連体化",
    "72": "助詞-副詞化",
    "73": "助詞-特殊",
    "74": "助動詞",
    "75": "感動詞",
    "76": "記号",
    "77": "記号-一般",
    "78": "記号-句点",
    "79": "記号-読点",
    "80": "記号-空白",
    "81": "記号-アルファベット",
    "82": "記号-括弧開",
    "83": "記号-括弧閉",
    "84": "その他",
    "85": "その他-間投",
    "86": "フィラー",
    "87": "非言語音",
    "88": "語断片",
    "89": "未知語",
}

chasenid2pos_en = {
    "00": "?",
    "01": "N",
    "02": "N.g",
    "03": "N.Prop",
    "04": "N.Prop.g",
    "05": "N.Prop.n",
    "06": "N.Prop.n.g",
    "07": "N.Prop.n.s",
    "08": "N.Prop.n.f",
    "09": "N.Prop.o",
    "10": "N.Prop.p",
    "11": "N.Prop.p.g",
    "12": "N.Prop.p.c",
    "13": "N.Pron",
    "14": "N.Pron.g",
    "15": "N.Pron.sh",
    "16": "N.Adv",
    "17": "N.Vs",
    "18": "N.Ana",
    "19": "N.Num",
    "20": "N.bnd",
    "21": "N.bnd.g",
    "22": "N.bnd.Adv",
    "23": "N.bnd.Aux",
    "24": "N.bnd.Ana",
    "25": "N.spec",
    "26": "N.spec.Aux",
    "27": "N.Suff",
    "28": "N.Suff.g",
    "29": "N.Suff.n",
    "30": "N.Suff.p",
    "31": "N.Suff.Vs",
    "32": "N.Suff.Aux",
    "33": "N.Suff.Ana",
    "34": "N.Suff.Adv",
    "35": "N.Suff.msr",
    "36": "N.Suff.spec",
    "37": "N.Conj",
    "38": "N.V.bnd",
    "39": "N.Phr",
    "40": "N.nai",
    "41": "Pref",
    "42": "Pref.N",
    "43": "Pref.V",
    "44": "Pref.Ai",
    "45": "Pref.Num",
    "46": "V",
    "47": "V.free",
    "48": "V.bnd",
    "49": "V.Suff",
    "50": "Ai",
    "51": "Ai.free",
    "52": "Ai.bnd",
    "53": "Ai.Suff",
    "54": "Adv",
    "55": "Adv.g",
    "56": "Adv.P",
    "57": "Adn",
    "58": "Conj",
    "59": "P",
    "60": "P.c",
    "61": "P.c.g",
    "62": "P.c.r",
    "63": "P.c.Phr",
    "64": "P.Conj",
    "65": "P.bind",
    "66": "P.Adv",
    "67": "P.ind",
    "68": "P.coord",
    "69": "P.fin",
    "70": "P.advcoordfin",
    "71": "P.prenom",
    "72": "P.advzer",
    "73": "P.spec",
    "74": "Aux",
    "75": "Interj",
    "76": "Sym",
    "77": "Sym.g",
    "78": "Sym.p",
    "79": "Sym.c",
    "80": "Sym.w",
    "81": "Sym.a",
    "82": "Sym.bo",
    "83": "Sym.bc",
    "84": "Other",
    "85": "Other.indir",
    "86": "Fill",
    "87": "Nss",
    "88": "Frgm",
    "89": "Unknown",
}

ipadic2unidic = {
    "？": "？",  # FIXME
    "未知語": "未知語",  # FIXME
    "名詞-一般": "名詞-普通名詞-一般",
    "名詞-固有名詞": "名詞-固有名詞-一般",  # FIXME
    "名詞-固有名詞-一般": "名詞-固有名詞-一般",
    "名詞-固有名詞-人名": "名詞-固有名詞-人名-一般",
    "名詞-固有名詞-人名-一般": "名詞-固有名詞-人名-一般",
    "名詞-固有名詞-人名-姓": "名詞-固有名詞-人名-姓",
    "名詞-固有名詞-人名-名": "名詞-固有名詞-人名-名",
    "名詞-固有名詞-組織": "名詞-固有名詞-組織名",
    "名詞-固有名詞-地域-一般": "名詞-固有名詞-地名-一般",
    "名詞-固有名詞-地域-国": "名詞-固有名詞-地名-国",
    "名詞-代名詞-一般": "代名詞",
    "名詞-代名詞-縮約": "代名詞",
    "名詞-副詞可能": "名詞-普通名詞-副詞可能",
    "名詞-サ変接続": "名詞-普通名詞-サ変可能",
    "名詞-形容動詞語幹": "名詞-普通名詞-形状詞可能",
    "名詞-数": "名詞-数詞",
    "名詞-非自立-一般": "名詞-普通名詞-一般",
    "名詞-非自立-副詞可能": "名詞-普通名詞-副詞可能",
    "名詞-非自立-助動詞語幹": "名詞-普通名詞-一般",
    "名詞-非自立-形容動詞語幹": "名詞-普通名詞-形状詞可能",
    "名詞-特殊-助動詞語幹": "名詞-普通名詞-一般",
    "名詞-接尾-一般": "接尾辞-名詞的-一般",
    "名詞-接尾-人名": "接尾辞-名詞的-人名",
    "名詞-接尾-地域": "接尾辞-名詞的-地名",
    "名詞-接尾-サ変接続": "接尾辞-名詞的-サ変可能",
    "名詞-接尾-助動詞語幹": "接尾辞-名詞的-一般",
    "名詞-接尾-形容動詞語幹": "接尾辞-名詞的-一般",
    "名詞-接尾-副詞可能": "接尾辞-名詞的-副詞可能",
    "名詞-接尾-助数詞": "接尾辞-名詞的-助数詞",
    "名詞-接尾-特殊": "接尾辞-名詞的-一般",
    "名詞-接続詞的": "名詞-普通名詞-一般",
    "名詞-動詞非自立的": "名詞-普通名詞-一般",
    "名詞-引用文字列": "名詞-普通名詞-一般",
    "名詞-ナイ形容詞語幹": "名詞-普通名詞-一般",
    "接頭詞": "接頭辞",
    "接頭詞-名詞接続": "接頭辞",
    "接頭詞-動詞接続": "接頭辞",
    "接頭詞-形容詞接続": "接頭辞-形容詞接続",
    "接頭詞-数接続": "接頭辞-名詞的-助数詞",
    "動詞-自立": "動詞-一般",
    "動詞-非自立": "動詞-非自立可能",
    "動詞-接尾": "接尾辞-動詞的",
    "形容詞-自立": "形容詞-一般",
    "形容詞-非自立": "形容詞-非自立可能",
    "形容詞-接尾": "接尾辞-形容詞的",
    "副詞-一般": "副詞",
    "副詞-助詞類接続": "副詞",
    "連体詞": "連体詞",
    "接続詞": "接続詞",
    "助詞-格助詞-一般": "助詞-格助詞",
    "助詞-格助詞-引用": "助詞-格助詞",
    "助詞-格助詞-連語": "助詞-格助詞",
    "助詞-接続助詞": "助詞-接続助詞",
    "助詞-係助詞": "助詞-係助詞",
    "助詞-副助詞": "助詞-副助詞",
    "助詞-間投助詞": "助詞-格助詞",
    "助詞-並立助詞": "助詞-準体助詞",
    "助詞-終助詞": "助詞-終助詞",
    "助詞-副助詞／並立助詞／終助詞": "助詞-副助詞",
    "助詞-連体化": "助詞-格助詞",
    "助詞-副詞化": "助詞-格助詞",
    "助詞-特殊": "助詞-格助詞",
    "助動詞": "助動詞",
    "感動詞": "感動詞-一般",
    "記号-一般": "記号-一般",
    "記号-句点": "その他-句点",
    "記号-読点": "その他-読点",
    "記号-空白": "その他-空白",
    "記号-アルファベット": "記号-文字",
    "記号-括弧開": "その他-括弧開",
    "記号-括弧閉": "その他-括弧閉",
    "その他-間投": "その他-一般",
    "フィラー": "感動詞-フィラー",
    "非言語音": "その他-一般",
    "語断片": "その他-一般",
}


# Adapted from:
# https://github.com/explosion/spaCy/tree/master/spacy/lang/ja

TAG_MAP = {
    "？": "X",
    "未知語": "X",
    # Explanation of Unidic tags:
    # https://www.gavo.t.u-tokyo.ac.jp/~mine/japanese/nlp+slp/UNIDIC_manual.pdf
    # Universal Dependencies Mapping: (Some of the entries in this mapping are updated to v2.6 in the list below)
    # http://universaldependencies.org/ja/overview/morphology.html
    # http://universaldependencies.org/ja/pos/all.html
    "記号-一般": "NOUN",  # this includes characters used to represent sounds like ドレミ
    "記号-文字": "NOUN",  # this is for Greek and Latin characters having some meanings, or used as symbols, as in math
    "感動詞-フィラー": "INTJ",
    "感動詞-一般": "INTJ",
    "空白": "SPACE",
    "形状詞-一般": "ADJ",
    "形状詞-タリ": "ADJ",
    "形状詞-助動詞語幹": "AUX",
    "形容詞-一般": "ADJ",
    "形容詞-非自立可能": "ADJ",  # XXX ADJ if alone, AUX otherwise
    "助詞-格助詞": "ADP",
    "助詞-係助詞": "ADP",
    "助詞-終助詞": "PART",
    "助詞-準体助詞": "SCONJ",  # の as in 走るのが速い
    "助詞-接続助詞": "SCONJ",  # verb ending て0
    "助詞-副助詞": "ADP",  # ばかり, つつ after a verb
    "助動詞": "AUX",
    "接続詞": "CCONJ",  # XXX: might need refinement
    "接頭辞": "NOUN",
    "接尾辞-形状詞的": "PART",  # がち, チック
    "接尾辞-形容詞的": "AUX",  # -らしい
    "接尾辞-動詞的": "PART",  # -じみ
    "接尾辞-名詞的-サ変可能": "NOUN",  # XXX see 名詞,普通名詞,サ変可能,*
    "接尾辞-名詞的-一般": "NOUN",
    "接尾辞-名詞的-助数詞": "NOUN",
    "接尾辞-名詞的-副詞可能": "NOUN",  # -後, -過ぎ
    "代名詞": "PRON",
    "動詞-一般": "VERB",
    "動詞-非自立可能": "AUX",  # XXX VERB if alone, AUX otherwise
    "副詞": "ADV",
    "補助記号-ＡＡ-一般": "SYM",  # text art
    "補助記号-ＡＡ-顔文字": "PUNCT",  # kaomoji
    "補助記号-一般": "SYM",
    "補助記号-括弧開": "PUNCT",  # open bracket
    "補助記号-括弧閉": "PUNCT",  # close bracket
    "補助記号-句点": "PUNCT",  # period or other EOS marker
    "補助記号-読点": "PUNCT",  # comma
    "名詞-固有名詞-一般": "PROPN",  # general proper noun
    "名詞-固有名詞-人名-一般": "PROPN",  # person's name
    "名詞-固有名詞-人名-姓": "PROPN",  # surname
    "名詞-固有名詞-人名-名": "PROPN",  # first name
    "名詞-固有名詞-地名-一般": "PROPN",  # place name
    "名詞-固有名詞-地名-国": "PROPN",  # country name
    "名詞-助動詞語幹": "AUX",
    "名詞-数詞": "NUM",  # includes Chinese numerals
    "名詞-普通名詞-サ変可能": "NOUN",  # XXX: sometimes VERB in UDv2; suru-verb noun
    "名詞-普通名詞-サ変形状詞可能": "NOUN",
    "名詞-普通名詞-一般": "NOUN",
    "名詞-普通名詞-形状詞可能": "NOUN",  # XXX: sometimes ADJ in UDv2
    "名詞-普通名詞-助数詞可能": "NOUN",  # counter / unit
    "名詞-普通名詞-副詞可能": "NOUN",
    "連体詞": "DET",  # XXX this has exceptions based on literal token
    # GSD tags. These aren't in Unidic, but we need them for the GSD data.
    "外国語": "PROPN",  # Foreign words
    "絵文字・記号等": "SYM",  # emoji / kaomoji ^^;
}

# mapping from tag bi-gram to pos of previous token
TAG_ORTH_MAP = {
    "空白": {" ": "SPACE", "　": "X"},
    "助詞-副助詞": {"たり": "PART"},
    "連体詞": {
        "あの": "DET",
        "かの": "DET",
        "この": "DET",
        "その": "DET",
        "どの": "DET",
        "彼の": "DET",
        "此の": "DET",
        "其の": "DET",
        "ある": "PRON",
        "こんな": "PRON",
        "そんな": "PRON",
        "どんな": "PRON",
        "あらゆる": "PRON",
    },
}


TAG_BIGRAM_MAP = {
    # This covers only small part of AUX.
    ("形容詞-非自立可能", "助詞-終助詞"): ("AUX", None),
    ("名詞-普通名詞-形状詞可能", "助動詞"): ("ADJ", None),
    # ("副詞", "名詞-普通名詞-形状詞可能"): (None, "ADJ"),
    # This covers acl, advcl, obl and root, but has side effect for compound.
    ("名詞-普通名詞-サ変可能", "動詞-非自立可能"): ("VERB", "AUX"),
    # This covers almost all of the deps
    ("名詞-普通名詞-サ変形状詞可能", "動詞-非自立可能"): ("VERB", "AUX"),
    ("名詞-普通名詞-副詞可能", "動詞-非自立可能"): (None, "VERB"),
    ("副詞", "動詞-非自立可能"): (None, "VERB"),
    ("形容詞-一般", "動詞-非自立可能"): (None, "VERB"),
    ("形容詞-非自立可能", "動詞-非自立可能"): (None, "VERB"),
    ("接頭辞", "動詞-非自立可能"): (None, "VERB"),
    ("助詞-係助詞", "動詞-非自立可能"): (None, "VERB"),
    ("助詞-副助詞", "動詞-非自立可能"): (None, "VERB"),
    ("助詞-格助詞", "動詞-非自立可能"): (None, "VERB"),
    ("補助記号-読点", "動詞-非自立可能"): (None, "VERB"),
    ("形容詞-一般", "接尾辞-名詞的-一般"): (None, "PART"),
    ("助詞-格助詞", "形状詞-助動詞語幹"): (None, "NOUN"),
    ("連体詞", "形状詞-助動詞語幹"): (None, "NOUN"),
    ("動詞-一般", "助詞-副助詞"): (None, "PART"),
    ("動詞-非自立可能", "助詞-副助詞"): (None, "PART"),
    ("助動詞", "助詞-副助詞"): (None, "PART"),
}


def unidic2ud_map(orth, tag, next_tag):
    """If necessary, add a field to the POS tag for UD mapping.
    Under Universal Dependencies, sometimes the same Unidic POS tag can
    be mapped differently depending on the literal token or its context
    in the sentence. This function returns resolved POSs for both token
    and next_token by tuple.
    """

    # Some tokens have their UD tag decided based on the POS of the following
    # token.

    # apply orth based mapping
    if tag in TAG_ORTH_MAP:
        orth_map = TAG_ORTH_MAP[tag]
        if orth in orth_map:
            return orth_map[orth], None  # current_pos, next_pos

    # apply tag bi-gram mapping
    if next_tag:
        tag_bigram = tag, next_tag
        if tag_bigram in TAG_BIGRAM_MAP:
            current_pos, next_pos = TAG_BIGRAM_MAP[tag_bigram]
            # print(f"Warning: mapping {tag} {next_tag} => {current_pos} {next_pos}")
            if current_pos is None:  # apply tag uni-gram mapping for current_pos
                return (
                    TAG_MAP[tag],
                    next_pos,
                )  # only next_pos is identified by tag bi-gram mapping
            else:
                return current_pos, next_pos

    # apply tag uni-gram mapping
    return TAG_MAP[tag], None
