#!/usr/bin/env python3.6

""" Automation to split trajectory """
import os
import numpy as np

#########################################
# Set Configs
XTC_FILE: str = '3-run' #'step5_1'
TPR_FILE: str = '3-run' #'step5_1'

STEPS_SIZE: int = 1000000 #1us
STEPS_INTERVAL: int = 1000000 #200000 # 200ns

INPUT_FOLDER: str = '/media/marieli/MARI/bepe_fias_oct23/rosiglitazone/rosi_param_december/1_AA-reference'

OUTPUT_FOLDER: str = '/media/marieli/MARI/bepe_fias_oct23/rosiglitazone/rosi_param_december/1_AA-reference/frags'

REQUIRED_FILES: dict = {
        'lowrmfs_py': '/home/thallmair-shared/data/goncalves/automations/rmsf_frags_AA/get_BB-lowRMSF_01.py',
        'rmfs_sh': f'/home/thallmair-shared/data/goncalves/automations/rmsf_frags_AA/RMSF_AA_BB_01.sh',
        'index': f'{INPUT_FOLDER}/index_BB.ndx',
        'tpr_file': f'{INPUT_FOLDER}/step5_1.tpr',
        'fix_residue': '/home/thallmair-shared/data/goncalves/automations/rmsf_frags_AA/fix_residue.sh' 
    }
#########################################

def cut_xtc_trajectory(
        xtc_file: str,
        tpr_file: str,
        init_timestamp: int,
        final_timestamp: int,
        output_folder: str,
        input_folder: str,
):
    # Calculate timestamp folder ref
    folder_timestamp = str(round(final_timestamp/1000)) # from pico to nano add ns suffix

    # Create timestamp folder dir
    current_folder = f'{OUTPUT_FOLDER}/{folder_timestamp}ns'
    os.system(f'mkdir {current_folder}')

    # Create trajectory cut
    gmx_command = f'echo "1 0" | gmx trjconv -f {input_folder}/{xtc_file}.xtc -s {input_folder}/{tpr_file}.tpr -center -b {init_timestamp} -e {final_timestamp} -o {current_folder}/{xtc_file}.xtc'
    os.system(gmx_command)

    # Copy required files
    for file_path in REQUIRED_FILES.values():
        os.system(f'cp {file_path} {output_folder}/{folder_timestamp}ns/{file_path.split("/")[-1]}')

    ## Execute RMSF_AA_BB to each trajectory CUT
    os.system(f"cd {current_folder} && ./RMSF_AA_BB_01.sh")

    # Execute fix residue
    os.system(f"cd {current_folder} && ./fix_residue.sh")

    # Deletando o lixo
    for extensao in ["\#*", "*.tpr", "*.ndx","*.sh", "*.py", "*.xtc", "*.tmp"]:
        os.system(f'cd {current_folder} && rm {extensao}')


if __name__ == '__main__':
    os.system(f'mkdir {OUTPUT_FOLDER}')

    # Create lists to iterate through traj size and interval set on configs
    initial_timestamps = np.arange(0, STEPS_SIZE+1, STEPS_INTERVAL)
    final_timestamps = np.arange(STEPS_INTERVAL, STEPS_SIZE+1, STEPS_INTERVAL)

    print(f"Cutting trajectory, {len(final_timestamps)} fragments!")
    for initial_ts, final_ts in zip(initial_timestamps[:-1], final_timestamps):
        cut_xtc_trajectory(
            XTC_FILE,
            TPR_FILE,
            initial_ts,
            final_ts,
            OUTPUT_FOLDER,
            INPUT_FOLDER
        )
    print("Finished")


   