#!/usr/bin/env python3.6

""" Automation to split trajectory """ 
import os
import numpy as np

#########################################
# Set Configs
XTC_FILE: str = '3-run'
TPR_FILE: str = '3-run'

STEPS_SIZE: int = 250000000 #250us
STEPS_INTERVAL: int = 250000000 # 250us

INPUT_FOLDER: str = 'path/to/rmsd'

OUTPUT_FOLDER: str = 'path/to/rmsd'

REQUIRED_FILES: dict = {
        'lowrmfs_py': 'get_BB-lowRMSD.py',
        'rmsd_sh': 'RMSD_CG_BB.sh',
        'index': f'{INPUT_FOLDER}/index_BB.ndx',
        'tpr_file': f'{INPUT_FOLDER}/3-run.tpr'
    }
#########################################

def cut_xtc_trajectory(
        xtc_file: str,
        tpr_file: str,
        init_timestamp: int,
        final_timestamp: int,
        output_folder: str,
        input_folder: str,
):
    # Calculate timestamp folder ref
    folder_timestamp = str(round(final_timestamp/1000)) # from pico to nano add ns suffix

    # Create timestamp folder dir
    current_folder = f'{OUTPUT_FOLDER}'
    os.system(f'mkdir {current_folder}')

    # Create trajectory cut
    gmx_command = f'echo "1 0" | gmx trjconv -f {input_folder}/{xtc_file}.xtc -s {input_folder}/{tpr_file}.tpr -center -b {init_timestamp} -e {final_timestamp} -o {current_folder}/{xtc_file}.xtc'
    os.system(gmx_command)

    # Copy required files
    for file_path in REQUIRED_FILES.values():
        os.system(f'cp {file_path} {output_folder}/{file_path.split("/")[-1]}')

    # Execute RMSD_CG_BB to each trajectory CUT
    os.system(f"cd {current_folder} && ./RMSD_CG_BB.sh")

    # Execute fix residue
    #os.system(f"cd {current_folder} && ./fix_residue.sh")

    # Cleaning
    for extensao in ["\#*", "*.tpr", "*.ndx","*.sh", "*.py", "*.xtc", "*.tmp"]:
        os.system(f'cd {current_folder} && rm {extensao}')
    



if __name__ == '__main__':
    os.system(f'mkdir {OUTPUT_FOLDER}')

    # Create lists to iterate through traj size and interval set on configs
    initial_timestamps = np.arange(0, STEPS_SIZE+1, STEPS_INTERVAL)
    final_timestamps = np.arange(STEPS_INTERVAL, STEPS_SIZE+1, STEPS_INTERVAL)

    print(f"Cutting trajectory, {len(final_timestamps)} fragments!")
    for initial_ts, final_ts in zip(initial_timestamps[:-1], final_timestamps):
        cut_xtc_trajectory(
            XTC_FILE,
            TPR_FILE,
            initial_ts,
            final_ts,
            OUTPUT_FOLDER,
            INPUT_FOLDER
        )
    print("Finished")


   