#!/usr/bin/env python3.6

#import sys,os,math,random,subprocess
import numpy as np
import time
import sys
import os
#import matplotlib.pyplot as plt

file_dat = 'rmsd_BBall.xvg'
path = '' 
thresh = 0.15


# # # # # # # # # # # # # # # # # #
#
#  read xvg file
#
def get_xvgdat(file_name, do_x2us, do_norm):
    xvgdat = np.loadtxt(file_name, dtype=float, comments=['#', '@'])
    xvgdat = xvgdat.T
    if do_x2us:
        xvgdat[0,:] = xvgdat[0,:] / 1000000.0
    
    if do_norm:
        max_dens = xvgdat[1:,:].max(1)
        for k in range(1, np.shape(xvgdat)[0]):
            xvgdat[k,:] = xvgdat[k,:] / max_dens[k]
    return xvgdat[0,:], xvgdat[1:,:]
#
# # # # # # # # # # # # # # # # # #

# main part
BBind, rmsd = get_xvgdat(file_dat, 0, 0)

print( np.shape(BBind), np.shape(rmsd) )

count = 0
indlist = np.array([])

for k in rmsd[0,:]:
    if k <= thresh:
        indlist = np.append( indlist, BBind[count] )
    count = count + 1

#by Marieli
print(" Checking if ind.tmp in -ls ")
print(os.listdir())
time.sleep(2)

if "ind.tmp" in os.listdir():
    last_ind = np.loadtxt("ind.tmp", dtype=int, comments=['#', '@'])
    print(f"comparando Last Index & ind: {len(last_ind)} - {len(indlist)}")
    time.sleep(2)
    print(f"testing: {set(last_ind) - set(indlist)}")
    time.sleep(2)
    if len(set(last_ind) - set(indlist)) == 0:
        print("It's a match!")
        np.savetxt('ind.tmp', indlist, fmt='%d', header='[ BB_rigid ]')
        time.sleep(2)
        print("Converged!")
        sys.exit(1)


# save the data
np.savetxt('ind.tmp', indlist, fmt='%d', header='[ BB_rigid ]')
print ('All indices with RMSD <= thresh saved!')
