#!/usr/bin/env python3.6

import os
import numpy as np

###Integral calculus

def calc_integral(current_folder_wt,current_folder_ph,aa_ini,aa_end):


    n_aa = 272 #protein lenght
    int_cut = 0.05      # cutoff value for integral values to be taken into account in vector column 2
    distMat = np.zeros([n_aa,n_aa])

    def get_xvgDat(file_name):

        keys, set = [], []

        with open(file_name) as f:
            for line in f:
                cols = line.split()
                if "@TYPE" not in line:        
                    if len(cols) == 2:
                        keys.append(float(cols[0]))
                        set.append(float(cols[1]))

        return np.array(keys,dtype=float), np.array(set,dtype=float)

    # main part
    for k in range(aa_ini,aa_end):
        #print(f"aa_ini={k}")
        for l in range(k+1,aa_end+1):
            #print(f"aa_end={l}")
            file_wt = f"{current_folder_wt}/disthist_{str(k)}-{str(l)}_ext.xvg"
            file_mut = f"{current_folder_ph}/disthist_{str(k)}-{str(l)}_ext.xvg"
            #print(file_wt)
            #print(file_mut)

            xax_wt, dat_wt = get_xvgDat(file_wt)
            xax_mut, dat_mut = get_xvgDat(file_mut)

            if np.sum(xax_mut-xax_wt)==0:
                d_dat = dat_mut - dat_wt
                tot_diff = np.sum(np.abs(d_dat)) * (xax_mut[1]-xax_mut[0])
            else:
                print('Something is not right with the x axes of the following files:')
                print(file_wt)
                print(file_mut)
                tot_diff = nan

          
            distMat[k-aa_ini,l-aa_ini] = tot_diff
            distMat[l-aa_ini,k-aa_ini] = tot_diff
            #print(tot_diff)
            

    # generate sum vector for each AA
    distVec = np.zeros([n_aa,9])
    distVec[:,0] = np.sum(distMat, axis=1) 
    distVec[:,1] = np.sum(distMat, axis=1) / (n_aa - 1)
    distVec[:,2] = np.max(distMat, axis=1)
    distVec[:,3] = np.sum(distMat * (distMat > int_cut), axis=1) 
    distVec[:,4] = np.sum(distMat * (distMat > int_cut), axis=1) / np.sum( (distMat > int_cut), axis=1 )
    distVec[:,5] = np.sum( (distMat > int_cut), axis=1 )
    distVec[:,6] = np.sum(distMat * (distMat > int_cut*2), axis=1) 
    distVec[:,7] = np.sum(distMat * (distMat > int_cut*2), axis=1) / np.sum( (distMat > int_cut*2), axis=1 )
    distVec[:,8] = np.sum( (distMat > int_cut*2), axis=1 )

    #save the data
    np.savetxt('po4_wt_distMat_0204.dat', distMat, fmt='%2.5f')
    np.savetxt('po4_wt_distVec_0204.dat', distVec, fmt='%2.5f')
    print('All integrations done and files saved!')



print("cheguei aqui")
calc_integral(
    current_folder_wt="/wt_folder",
    current_folder_ph="/po4_folder",
    aa_ini=204,
    aa_end=475
    )