import numpy as np


def problem_definitions(problem='2x2'):
    
    if problem == '2x2':
        c = [[1, 0], [0, 1]]
        d = [[1, 0], [0, 1]]
        a = [[0, 0], [0, 0]]
        b = [[1.2, -0.2], [-0.2, 1.1]]
        r = [[0, 0], [0, 0]] #R
        s = [[0.8, -0.35], [-0.35, 1.1]] # S
        fcffs = [3/4,3/4]
        gcffs = [1,1]
        pastvals = [0.1, 0.2, 0.3, 0.4, 0.4, 0.3, 0.2, 0.1] #[x,y,u,v]


        # # Parameters for the Closed Loop Simulation
        # ## Continuous Case
        comgone = [[3, -1], [-2, 5]]
        comgtwo = [[4, 0], [-1,2]]
        ctauone = 0.2
        ctautwo = 0.3
        csimpars = [comgone, comgtwo, ctauone, ctautwo]
        # ## Z-Case
        dtauone = 1.
        dtautwo = 1.
        domgone = [[.29, 0.], [.05, .6]]
        domgtwo = [[.5, .03], [0., .7]]
        dsimpars = [domgone, domgtwo, dtauone, dtautwo]
        ddt = 0.5
        # ## Other TS
        intlngth = .4
        intdstnc = .8
        atauone = .8
        atautwo = .8
        aomgone = [[1.8, 1.], [.0, 1.5]]
        aomgtwo = [[1.4, 0.], [1., 1.7]]
        asimpars = [aomgone, aomgtwo, atauone, atautwo]

    coeffs = [a, b, c, d, r, s]
    coeffnames = ['A', 'B', 'C', 'D', 'K', 'L']
    simparnames = ['Omega_one', 'Omega_two', 'tau_one', 'tau_two']

    prbdct = dict(fcffs=fcffs, gcffs=gcffs, pastvals=pastvals)
    for cnm, coeff in zip(coeffnames, coeffs):
        prbdct.update({cnm: np.array(coeff)})
    tsnames = ['R', 'hZ', 'ots']
    tssimpars = [csimpars, dsimpars, asimpars]
    for tsn, tsp in zip(tsnames, tssimpars):
        try:
            atsdict = {}
            for idx in range(2):
                atsdict.update({simparnames[idx]: np.array(tsp[idx])})
                atsdict.update({simparnames[idx+2]: tsp[idx+2]})
            prbdct.update({tsn: atsdict})
        except IndexError:
            pass
        try:
            prbdct['ots'].update(dict(intlngth=intlngth, intdstnc=intdstnc))
        except KeyError:
            pass
        try:
            prbdct['hZ'].update(dict(ddt=ddt))
        except KeyError:
            pass

    return prbdct


def get_delaysol(trackdelaytrange, pastvals):
    '''helper function that returns the delay value from a dictionary

    direct query may not work since the floating points may not match exactly
    '''
    def delaysol(t_minus_tau, soldict):
        if t_minus_tau < 0:
            return pastvals
        else:
            therealtmt = trackdelaytrange.pop(0)
            if np.allclose(therealtmt, t_minus_tau):
                return soldict[therealtmt]
            else:
                raise UserWarning('somethings wrong with the delay')
    return delaysol
