# For real 2*2 case
from data_plot_utils import plotit
from problem_definitions import problem_definitions, get_delaysol

import numpy as np

from jitcdde import jitcdde, y, t
from symengine import tanh

discretetime = False
mixedtime = False
continuotime = True


# ## define the problem coefficients
problem = '2x2'
#problem = '10x10'
if problem == '10x10':
    Nsteps = 20
    cfiltert = 5
else:
    Nsteps = 30
    cfiltert = None

pbdct = problem_definitions(problem=problem)
A = pbdct['A']
B = pbdct['B']
C = pbdct['C']
D = pbdct['D']
K = pbdct['K']#R
L = pbdct['L']#S
fcffs = pbdct['fcffs']
gcffs = pbdct['gcffs']
pastvals = pbdct['pastvals']


# ## problem rhs
n = A.shape[0]
nall = 4*n
xidx = range(n)

def get_bamrhs(omgone=None, omgtwo=None,
               taui=None, tauii=None, coupling=False):
    def bamrhs(myy=None):
        if myy is None:
            cy = y
            ffncs = [1]*n
            gfncs = [1]*n
        else:
            cy = myy
            ffncs = [1]*n
            gfncs = [1]*n
        for i in range(4*n):
            if i <= n-1:
                yield sum(- C[i, j]*cy(j)
                          + A[i, j]*fcffs[j]*(cy(j+n))
                          + B[i, j]*fcffs[j]*(cy(j+n, t-taui))
                          for j in xidx)
            elif i <= 2*n-1:
                yield sum(- D[i-n, j]*cy(j+n)
                          + K[i-n, j]*gcffs[j]*(cy(j))
                          + L[i-n, j]*gcffs[j]*(cy(j, t-tauii))
                          for j in xidx)
            elif i <= 3*n-1:
                unfrcdpart = sum(- C[i-2*n, j]*cy(j+2*n)
                                 + A[i-2*n, j]*fcffs[j]*(cy(j+3*n))
                                 + B[i-2*n, j]*fcffs[j]*(cy(j+3*n,
                                                                    t-taui))
                                 for j in xidx)
                if coupling:
                    frcdpart = sum(- omgone[i-2*n, j]*(cy(j+2*n)-cy(j))
                                   for j in xidx)
                    yield unfrcdpart + frcdpart
                else:
                    yield unfrcdpart
            elif i <= 4*n-1:
                unfrcdpart = sum(- D[i-3*n, j]*cy(j+3*n)
                                 + K[i-3*n, j]*gcffs[j]*(cy(j+2*n))
                                 + L[i-3*n, j]*gcffs[j]*(cy(j+2*n,
                                                                 t-tauii))
                                 for j in xidx)
                if coupling:
                    frcdpart = sum(- omgtwo[i-3*n, j]*(cy(j+3*n)-cy(j+n))
                                   for j in xidx)
                    yield unfrcdpart + frcdpart
                else:
                    yield unfrcdpart
    return bamrhs



if continuotime:
    stoptime = 30
    numpoints = 600
    Omega_one = pbdct['R']['Omega_one']
    Omega_two = pbdct['R']['Omega_two']
    tau_one = pbdct['R']['tau_one']
    tau_two = pbdct['R']['tau_one']

    fignum = [100, 200]
    for fignum, coupling in zip(fignum, [False, True]):
        bamrhs = get_bamrhs(omgone=Omega_one, omgtwo=Omega_two,
                            coupling=coupling, tauii=tau_two, taui=tau_one)
        DDE = jitcdde(bamrhs)
        DDE.constant_past(pastvals)
        times = DDE.t + np.linspace(0, stoptime, numpoints)

        # short pre-integration to take care of discontinuities
        # DDE.step_on_discontinuities()

        # integrating
        data = []
        for time in times:
            data.append(DDE.integrate(time))
        plotit(data, timerange=times, coupling=coupling, pname=problem,
               filterdata=cfiltert, fignum=fignum, nstates=n)
        #Calculation of K1

#Calculation for K & L from Theorem 1:
alpha=0.8
mu=0
beta=0.8
exp=2.718282
tau1 = pbdct['R']['tau_one']
tau2 = pbdct['R']['tau_one']
k1= alpha + (1+mu*alpha)*(abs(K[0,0])+ abs(K[0,1]))*gcffs[0] + (1+mu*alpha)*(exp**(alpha*tau2))*( abs(L[0,0]) + abs(L[0,1]))*gcffs[0] - C[0,0] 
k2= alpha + (1+mu*alpha)*(abs(K[1,0])+ abs(K[1,1]))*gcffs[1] + (1+mu*alpha)*(exp**(alpha*tau2))*(abs(L[1,0])+ abs(L[1,1]))*gcffs[1] - C[1,1]
KK1 = [k1 , k2]
print('Using theorem 1, K>',KK1)
l1 = alpha + (1+mu*alpha)*(abs(A[0,0])+ abs(A[0,1]))*fcffs[0] + (1+mu*alpha)*(exp**(alpha*tau1))*( abs(B[0,0]) + abs(B[0,1]))*fcffs[0] - D[0,0] 
l2=  alpha + (1+mu*alpha)*(abs(A[1,0])+ abs(A[1,1]))*fcffs[1] + (1+mu*alpha)*(exp**(alpha*tau1))*(abs(B[1,0])+ abs(B[1,1]))*fcffs[1] - D[1,1]
LL1 = [l1, l2]
print('Using theorem 1, L>',LL1)

#Calculation for K & L from Theorem 2
k3= beta +  (exp**(beta*mu))*( abs(A[0,0])*fcffs[0]+abs(A[1,0])*fcffs[1] )  + (exp**(beta*(mu+tau1)))*( abs(B[0,0])*fcffs[0]+abs(B[1,0])*fcffs[1] ) - C[0,0] 
k4= beta +  (exp**(beta*mu))*( abs(A[0,1])*fcffs[0]+abs(A[1,1])*fcffs[1] )  + (exp**(beta*(mu+tau1)))*( abs(B[0,1])*fcffs[0]+abs(B[1,1])*fcffs[1] ) - C[1,1] 
KK2 = [k3 , k4]
print('Using theorem 2, K>', KK2)
l3 = beta +  (exp**(beta*mu))*( abs(K[0,0])*gcffs[0]+abs(K[1,0])*gcffs[1] )  + (exp**(beta*(mu+tau2)))*( abs(L[0,0])*gcffs[0]+abs(L[1,0])*gcffs[1] ) - D[0,0] 
l4=  beta +  (exp**(beta*mu))*( abs(K[0,1])*gcffs[0]+abs(K[1,1])*gcffs[1] )  + (exp**(beta*(mu+tau1)))*( abs(L[0,1])*gcffs[0]+abs(L[1,1])*gcffs[1] ) - D[1,1] 
LL2 = [l3, l4]
print('Using theorem 2, L>', LL2)

V1 = Omega_one[0,0] - (alpha + (1+mu*alpha)*(abs(K[0,0])+ abs(K[0,1]))*gcffs[0] + (1+mu*alpha)*(exp**(alpha*tau2))*( abs(L[0,0]) + abs(L[0,1]))*gcffs[0] - C[0,0] )
V2 = Omega_one[1,1] - (alpha + (1+mu*alpha)*(abs(K[1,0])+ abs(K[1,1]))*gcffs[1] + (1+mu*alpha)*(exp**(alpha*tau2))*(abs(L[1,0])+ abs(L[1,1]))*gcffs[1] - C[1,1] )
W1 = Omega_two[0,0] - (alpha + (1+mu*alpha)*(abs(A[0,0])+ abs(A[0,1]))*fcffs[0] + (1+mu*alpha)*(exp**(alpha*tau1))*( abs(B[0,0]) + abs(B[0,1]))*fcffs[0] - D[0,0] )
W2 = Omega_two[1,1] - (alpha + (1+mu*alpha)*(abs(A[1,0])+ abs(A[1,1]))*fcffs[1] + (1+mu*alpha)*(exp**(alpha*tau1))*(abs(B[1,0])+ abs(B[1,1]))*fcffs[1] - D[1,1])
print('V1=', V1)
print('V2=', V2)
print('W1=', W1)
print('W2=', W2)


E11= Omega_one[0,0] - (beta +  (exp**(beta*mu))*( abs(A[0,0])*fcffs[0]+abs(A[1,0])*fcffs[1] )  + (exp**(beta*(mu+tau1)))*( abs(B[0,0])*fcffs[0]+abs(B[1,0])*fcffs[1] ) - C[0,0])
E12= Omega_one[1,1] - (beta +  (exp**(beta*mu))*( abs(A[0,1])*fcffs[0]+abs(A[1,1])*fcffs[1] )  + (exp**(beta*(mu+tau1)))*( abs(B[0,1])*fcffs[0]+abs(B[1,1])*fcffs[1] ) - C[1,1] ) 
E1= max(E11,E12)
E21= Omega_two[0,0] - (beta +  (exp**(beta*mu))*( abs(K[0,0])*gcffs[0]+abs(K[1,0])*gcffs[1] )  + (exp**(beta*(mu+tau2)))*( abs(L[0,0])*gcffs[0]+abs(L[1,0])*gcffs[1] ) - D[0,0] )
E22= Omega_two[1,1] - (beta +  (exp**(beta*mu))*( abs(K[0,1])*gcffs[0]+abs(K[1,1])*gcffs[1] )  + (exp**(beta*(mu+tau1)))*( abs(L[0,1])*gcffs[0]+abs(L[1,1])*gcffs[1] ) - D[1,1] )
E2=max(E21,E22)
print('E11=',E11)
print('E12=',E12)
print('E1=',E1)
print('E21=',E21)
print('E22=',E22)
print('E2=',E2)
if discretetime:
    pass
if mixedtime:
    pass
