(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   8389709,     154329]
NotebookOptionsPosition[   8356425,     153791]
NotebookOutlinePosition[   8356978,     153811]
CellTagsIndexPosition[   8356935,     153808]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Style initialization", "Section",
 CellChangeTimes->{{3.717588594007545*^9, 3.717588601006935*^9}, 
   3.741078761226367*^9, {3.8786334955410757`*^9, 3.8786335060362453`*^9}, {
   3.879570845131383*^9, 3.8795708466508207`*^9}, 
   3.886159967833623*^9},ExpressionUUID->"c33feec3-f5a3-419b-8b75-\
c93fc99c31de"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<MaTeX`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConfigureMaTeX", "[", 
   RowBox[{
    RowBox[{
    "\"\<pdfLaTeX\>\"", "\[Rule]", 
     "\"\<C:\\\\Users\\\\mtale\\\\AppData\\\\Local\\\\Programs\\\\MiKTeX\\\\\
miktex\\\\bin\\\\x64\\\\pdflatex.exe\>\""}], ",", 
    RowBox[{
    "\"\<Ghostscript\>\"", "\[Rule]", 
     "\"\<C:\\\\Program \
Files\\\\gs\\\\gs10.04.0\\\\bin\\\\gswin64c.exe\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"Power", "::", "infy"}], "]"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8525989973183193`*^9, 3.852599005494171*^9}, {
   3.853558781134458*^9, 3.853558787156198*^9}, {3.878792888984045*^9, 
   3.87879289017968*^9}, {3.878890901191628*^9, 3.8788909053826237`*^9}, {
   3.8790795397191877`*^9, 3.879079540643735*^9}, 3.8794010651500463`*^9, {
   3.9378988809129105`*^9, 3.9378989384617634`*^9}, {3.937899264804947*^9, 
   3.9378992866447906`*^9}, {3.937899330299675*^9, 3.9378993494938602`*^9}, 
   3.9378998928301163`*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"3c1e7087-86b5-42cc-9708-ff96941fc4d5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"EPFLcolor", "[", "f_", "]"}], ":=", 
   RowBox[{"Blend", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"RGBColor", "[", "\"\<#FF0000\>\"", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"RGBColor", "[", "\"\<#CAC7C7\>\"", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "5"}], ",", 
         RowBox[{"RGBColor", "[", "\"\<#413D3A\>\"", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "/", "5"}], ",", 
         RowBox[{"RGBColor", "[", "\"\<#007480\>\"", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"3", "/", "5"}], ",", 
         RowBox[{"RGBColor", "[", "\"\<#00A79F\>\"", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"4", "/", "5"}], ",", 
         RowBox[{"RGBColor", "[", "\"\<#B51F1F\>\"", "]"}]}], "}"}]}], "}"}], 
     ",", "f"}], "]"}]}], ";"}]], "Code",
 CellChangeTimes->{{3.85259477396282*^9, 3.852594783084371*^9}, {
  3.8525948676700373`*^9, 3.8525948763255053`*^9}, {3.852594940036779*^9, 
  3.852594973858303*^9}, {3.852595109002633*^9, 3.8525951391610107`*^9}, {
  3.852595175674271*^9, 3.852595199264771*^9}, {3.852595236033477*^9, 
  3.852595268367992*^9}, {3.8525956593688726`*^9, 3.852595731004485*^9}, {
  3.8526012587920303`*^9, 3.852601274287313*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"72c0ac46-f05b-47d4-86f7-ce0e4987b4ce"],

Cell["\<\
Define options for StyleForm function to be used for graphics axes and frame \
labels\
\>", "Text",
 CellChangeTimes->{{3.812981146451049*^9, 3.812981156982044*^9}, {
   3.812981193981235*^9, 3.812981201151393*^9}, {3.813317970673932*^9, 
   3.813317997023305*^9}, {3.81331802827654*^9, 3.813318167833707*^9}, {
   3.813318266008914*^9, 3.813318290878028*^9}, 3.8134724841649323`*^9, {
   3.813473137197812*^9, 3.813473172328422*^9}, {3.814791723293045*^9, 
   3.81479176958423*^9}, {3.82558947812132*^9, 3.825589488035255*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"123fd64c-66a2-4952-94a3-e1949aa5405b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"AR", "=", 
   RowBox[{"2", "/", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Imagesize", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<MaTeX`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Myfontsize", "=", "22"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"texStyle", "=", 
   RowBox[{"{", 
    RowBox[{"FontSize", "\[Rule]", "Myfontsize"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot", ",", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "Imagesize"}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "texStyle"}], ",", " ", 
    RowBox[{"AspectRatio", " ", "->", " ", "AR"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"LogLogPlot", ",", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "Imagesize"}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "texStyle"}], ",", " ", 
    RowBox[{"AspectRatio", " ", "->", " ", "AR"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ListPlot", ",", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "Imagesize"}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "texStyle"}], ",", " ", 
    RowBox[{"AspectRatio", " ", "->", " ", "AR"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ListLogPlot", ",", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "Imagesize"}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "texStyle"}], ",", " ", 
    RowBox[{"AspectRatio", " ", "->", " ", "AR"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ListLogLinearPlot", ",", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "Imagesize"}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "texStyle"}], ",", " ", 
    RowBox[{"AspectRatio", " ", "->", " ", "AR"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ListLogLogPlot", ",", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "Imagesize"}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "texStyle"}], ",", " ", 
    RowBox[{"AspectRatio", " ", "->", " ", "AR"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ListVectorPlot", ",", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "Imagesize"}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "texStyle"}], ",", " ", 
    RowBox[{"AspectRatio", " ", "->", " ", "AR"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ListLinePlot", ",", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "Imagesize"}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "texStyle"}], ",", " ", 
    RowBox[{"AspectRatio", " ", "->", " ", "AR"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.825589538293995*^9, 3.825589576422316*^9}, {
  3.8262701214699707`*^9, 3.826270121617186*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"3b6c3f77-f9b2-4ce0-931e-575bd83a320a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dashed", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Thickness", "[", ".003", "]"}], ",", "Dashed"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dotdashed", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Thickness", "[", ".003", "]"}], ",", "DotDashed"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dashedT", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Thickness", "[", ".004", "]"}], ",", "Dashed"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solidT", "=", 
   RowBox[{"{", 
    RowBox[{"Thickness", "[", ".004", "]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"solid", "=", 
    RowBox[{"{", 
     RowBox[{"Thickness", "[", ".003", "]"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"basestyle", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FontSize", "\[Rule]", " ", "t"}], ",", 
     RowBox[{"FontFamily", "\[Rule]", " ", "\"\<Times New Roman\>\""}], ",", 
     RowBox[{"FontColor", "\[Rule]", " ", "Black"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"style", "[", "kk_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Hue", "[", 
      RowBox[{"0.1", 
       RowBox[{"(", 
        RowBox[{"kk", "-", "1"}], ")"}]}], "]"}], ",", 
     RowBox[{"Thickness", "[", ".003", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stylec", "[", "kk_", "]"}], ":=", 
   RowBox[{"Hue", "[", 
    RowBox[{"0.1", 
     RowBox[{"(", 
      RowBox[{"kk", "-", "1"}], ")"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"styledashed", "[", "kk_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Hue", "[", 
      RowBox[{"0.1", 
       RowBox[{"(", 
        RowBox[{"kk", "-", "1"}], ")"}]}], "]"}], ",", 
     RowBox[{"Thickness", "[", ".003", "]"}], ",", "Dashed"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"styledotted", "[", "kk_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Hue", "[", 
      RowBox[{"0.1", 
       RowBox[{"(", 
        RowBox[{"kk", "-", "1"}], ")"}]}], "]"}], ",", 
     RowBox[{"Thickness", "[", ".003", "]"}], ",", "Dotted"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gray", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"Gray", ",", 
     RowBox[{"Thickness", "[", 
      RowBox[{".001", " ", "t"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"graydashed", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"Gray", ",", 
     RowBox[{"Thickness", "[", 
      RowBox[{".001", " ", "t"}], "]"}], ",", "Dashed"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"graydotted", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"Gray", ",", 
     RowBox[{"Thickness", "[", 
      RowBox[{".001", " ", "t"}], "]"}], ",", "Dotted"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"orange", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Darker", "[", "Orange", "]"}], ",", 
     RowBox[{"Thickness", "[", 
      RowBox[{".001", " ", "t"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"orangedashed", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Darker", "[", "Orange", "]"}], ",", 
     RowBox[{"Thickness", "[", 
      RowBox[{".001", " ", "t"}], "]"}], ",", "Dashed"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"orangedotted", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Darker", "[", "Orange", "]"}], ",", 
     RowBox[{"Thickness", "[", 
      RowBox[{".001", " ", "t"}], "]"}], ",", "Dotted"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bluedashed", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"Blue", ",", 
     RowBox[{"Thickness", "[", 
      RowBox[{".001", " ", "t"}], "]"}], ",", "Dashed"}], "}"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.418165733933077*^9, 3.418165759478509*^9}, {
   3.4182132170792313`*^9, 3.418213230231925*^9}, {3.426351945151115*^9, 
   3.426351957744825*^9}, {3.426691202153535*^9, 3.4266912756948633`*^9}, {
   3.426692308355781*^9, 3.426692358075486*^9}, {3.426692434410057*^9, 
   3.4266925104164124`*^9}, {3.4270304087637663`*^9, 
   3.4270304441187897`*^9}, {3.427030572763915*^9, 3.4270305924278*^9}, {
   3.428791384623765*^9, 3.428791392812167*^9}, {3.428791445789288*^9, 
   3.428791447037221*^9}, {3.642863509147401*^9, 3.642863509497505*^9}, {
   3.7319277730000362`*^9, 3.7319278534747066`*^9}, {3.731927974762946*^9, 
   3.731927996384246*^9}, {3.7371948126134863`*^9, 3.7371948191558247`*^9}, {
   3.7371975580416527`*^9, 3.737197594151801*^9}, 3.741079037673902*^9, {
   3.741080378844308*^9, 3.741080387378092*^9}, {3.748697443824881*^9, 
   3.748697445934285*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"a214a709-34c2-4a21-bb46-471ecff6969a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"color", "[", 
   RowBox[{"Color_", ",", "t_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Darker", "[", "Color", "]"}], ",", 
    RowBox[{"Thickness", "[", 
     RowBox[{".001", " ", "t"}], "]"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[37]:=",ExpressionUUID->"5bb2faa5-db04-42ac-96c5-d45ef77bd647"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"NIntegrate", "::", "\"\<slwcon\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Off", "[", 
     RowBox[{"NIntegrate", "::", "\"\<inum\>\""}], "]"}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"NSolve", "::", "\"\<precw\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"Clear", "::", "ssym"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"Part", "::", "pspec"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Off", "[", 
    RowBox[{"InterpolatingFunction", "::", "dmval"}], "]"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"Graphics", "::", "gptn"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"Clear", "::", "ssym"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"Unset", "::", "\"\<norep\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"ParametricPlot", "::", "\"\<pptr\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"Plot", "::", "\"\<plnr\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"Plot", "::", "\"\<plln\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], 
  StyleBox["]", "MessageName"]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.718375246052052*^9, 3.71837528908552*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"9e5f541d-090c-4b4f-ac85-82126e98cb32"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<PolygonPlotMarkers`\>\"", "]"}], "\n", 
 RowBox[{"allShapes", "=", 
  RowBox[{"PolygonMarker", "[", "All", "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FaceForm", "[", 
          RowBox[{"Hue", "@", 
           RowBox[{"Random", "[", "]"}]}], "]"}], ",", 
         RowBox[{"EdgeForm", "[", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
            RowBox[{"JoinForm", "[", "\"\<Miter\>\"", "]"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"PolygonMarker", "[", 
          RowBox[{"#", ",", "1"}], "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "30"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "1.5"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "0"}], ",", 
       RowBox[{"ImagePadding", "\[Rule]", "0"}]}], "]"}], ",", "#"}], "]"}], 
   "&"}], "/@", "allShapes"}], "\n"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.748873803258994*^9, 3.74887383351362*^9}, {
  3.825589643000291*^9, 3.825589647211521*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"64b07705-d49b-4882-9147-58df2ff2f2ed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "filled", " ", "marker", " ", "which", " ", "picks", " ", "up", " ", "the",
     " ", "PlotStyle", " ", "automatically"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"fm", "[", 
      RowBox[{"name_", ",", 
       RowBox[{"size_", ":", " ", "4"}]}], "]"}], ":=", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EdgeForm", "[", "]"}], ",", 
         RowBox[{"PolygonMarker", "[", 
          RowBox[{"name", ",", 
           RowBox[{"Offset", "[", "size", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"AlignmentPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"SeedRandom", "[", "25", "]"}], " ", 
   RowBox[{"(*", 
    RowBox[{"for", " ", "reproducibility"}], "*)"}], "\n", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Accumulate", "@", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"1", ",", "10"}], "]"}]}], "+", "i"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "6"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"fm", "/@", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Triangle\>\"", ",", "\"\<LeftTriangle\>\"", ",", 
         "\"\<Diamond\>\"", ",", "\"\<ThreePointedStar\>\"", ",", 
         "\"\<UpTriangleTruncated\>\"", ",", "\"\<Square\>\""}], "}"}]}]}], 
     ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"ColorData", "[", 
       RowBox[{"54", ",", "\"\<ColorList\>\""}], "]"}]}]}], 
    "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7488742339717484`*^9, 3.7488742464233294`*^9}, {
  3.748874545032621*^9, 3.7488745593368073`*^9}, {3.748874755796465*^9, 
  3.748874776281762*^9}, {3.748874836348013*^9, 3.748874836554493*^9}, {
  3.76217113315621*^9, 3.762171159290497*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"757dfd0e-e4b6-499b-b452-4defe44d1312"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "empty", " ", "marker", " ", "which", " ", "picks", " ", "up", " ", "the",
      " ", "PlotStyle", " ", "automatically"}], ",", 
    RowBox[{
     RowBox[{"see", " ", 
      RowBox[{"https", ":"}]}], "//", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"mathematica", ".", "stackexchange", ".", "com"}], "/", "a"}],
        "/", "158221"}], "/", "280"}]}]}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"em", "[", 
     RowBox[{"name_", ",", 
      RowBox[{"size_", ":", " ", "6"}]}], "]"}], ":=", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Dynamic", "@", 
         RowBox[{"EdgeForm", "@", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"CurrentValue", "[", "\"\<Color\>\"", "]"}], ",", 
            RowBox[{"JoinForm", "[", "\"\<Round\>\"", "]"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
            RowBox[{"Opacity", "[", "1", "]"}]}], "]"}]}]}], ",", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"FaceForm", "[", "White", "]"}]}], ",", 
        RowBox[{"PolygonMarker", "[", 
         RowBox[{"name", ",", 
          RowBox[{"Offset", "[", "size", "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"AlignmentPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"SeedRandom", "[", "2", "]"}], "\n", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Accumulate", "@", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"1", ",", "10"}], "]"}]}], "+", "i"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"em", "/@", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Triangle\>\"", ",", "\"\<Square\>\"", ",", "\"\<Diamond\>\""}], 
        "}"}]}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"PointLegend", "[", 
       RowBox[{"Automatic", ",", 
        RowBox[{"LegendMarkerSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"40", ",", "25"}], "}"}]}]}], "]"}]}]}], "]"}]}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.748874269275878*^9, 3.7488742692767487`*^9}, 
   3.7488744071037827`*^9, {3.8241786132248487`*^9, 3.824178635533183*^9}, {
   3.831022415692321*^9, 3.8310224173231373`*^9}, 3.831022512795442*^9, {
   3.831022614084773*^9, 3.831022734846986*^9}, {3.831022828325282*^9, 
   3.831022844452145*^9}, {3.831022878125074*^9, 3.831022922893375*^9}, 
   3.8310229685323677`*^9, {3.8310230249670362`*^9, 3.831023028148679*^9}, {
   3.831023146144985*^9, 3.831023237246505*^9}, {3.831024244801928*^9, 
   3.83102428039727*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"b50edf24-f396-4b05-aae4-ef86e2697790"]
}, Closed]],

Cell[CellGroupData[{

Cell["Anthony\[CloseCurlyQuote]s results", "Section",
 CellChangeTimes->{{3.860122844493791*^9, 3.860122849246522*^9}, {
   3.865570732758553*^9, 3.8655707339961348`*^9}, {3.867912829242787*^9, 
   3.867912831306251*^9}, {3.870931143478175*^9, 3.8709311490885353`*^9}, {
   3.87864039652927*^9, 3.878640397712892*^9}, 3.883553508385573*^9, {
   3.883553574907728*^9, 
   3.883553583843512*^9}},ExpressionUUID->"da6d80c8-7dee-45ea-83b9-\
683bf7dae4b6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ap", "=", 
   RowBox[{
   "Import", "[", 
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\AnthonyResults\\\\AnthonyData.csv\>\"\
", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ap", "[", 
       RowBox[{"[", "#", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "&"}], "/@", 
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"Dimensions", "[", "ap", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Rt", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ap", "[", 
       RowBox[{"[", "#", "]"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", 
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"Dimensions", "[", "ap", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pt", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ap", "[", 
       RowBox[{"[", "#", "]"}], "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}], "&"}], "/@", 
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"Dimensions", "[", "ap", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wt", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ap", "[", 
       RowBox[{"[", "#", "]"}], "]"}], "[", 
      RowBox[{"[", "4", "]"}], "]"}], "&"}], "/@", 
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"Dimensions", "[", "ap", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eta", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ap", "[", 
       RowBox[{"[", "#", "]"}], "]"}], "[", 
      RowBox[{"[", "5", "]"}], "]"}], "&"}], "/@", 
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"Dimensions", "[", "ap", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.867234657597815*^9, 3.867234663373391*^9}, 
   3.86723469534865*^9, {3.8672349234024878`*^9, 3.8672350696321383`*^9}, {
   3.867235118544586*^9, 3.867235120469136*^9}, {3.867235505579385*^9, 
   3.86723550976265*^9}, {3.867235546408277*^9, 3.867235673906365*^9}, {
   3.8672359170139933`*^9, 3.867235923253704*^9}, 3.867235984396661*^9, {
   3.8672360433468637`*^9, 3.867236086238798*^9}, {3.86723613130021*^9, 
   3.8672361997447367`*^9}, {3.8672394999772377`*^9, 3.867239522670719*^9}, {
   3.8672409178705883`*^9, 3.8672410901779623`*^9}, 3.8672413492369127`*^9, 
   3.867911990208853*^9, 3.86791284400399*^9, 3.87017159789921*^9, {
   3.8740458819402857`*^9, 3.874045882441588*^9}, {3.875067297792482*^9, 
   3.875067315978764*^9}, 3.87827316206883*^9, 3.887830786710086*^9, {
   3.887831012352241*^9, 3.88783103130503*^9}, {3.8878311200675097`*^9, 
   3.887831134023081*^9}, {3.887831168594872*^9, 3.88783120412682*^9}, {
   3.887831250638132*^9, 3.887831275313376*^9}, {3.887831574693674*^9, 
   3.8878315754592323`*^9}, 3.8878316461103697`*^9, 3.891325794483848*^9, 
   3.905873466591476*^9, {3.90587362621478*^9, 3.9058736490158663`*^9}, 
   3.905907452601782*^9, {3.937900059814415*^9, 3.9379000825338955`*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"eb206b36-7fbf-4ac3-8cee-b40b41d28927"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"t", ",", "wt"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.8740462835305233`*^9},
 CellLabel->"In[78]:=",ExpressionUUID->"b2ed334c-deea-47e8-90f4-d770d2203bae"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.003666666666666667], AbsoluteThickness[2], 
        StyleBox[PointBox[CompressedData["
1:eJxEnXm8zVUXxhEKRYlSSkmpECqSBk9RxkoaREUSpVCiDJWkUCkhlFQ0i5BC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          "]],
         FontSize->22]},
       Annotation[#, "Charting`Private`Tag#1"]& ],
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.003666666666666667], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2], FontSize -> 22], 
             Point[CompressedData["
1:eJxEnXm8zVUXxhEKRYlSSkmpECqSBk9RxkoaREUSpVCiDJWkUCkhlFQ0i5BC
uJM7z/M833Pn6fyGfaei1Lv2Ps85r3/ez+7l3nN+v73X8KzvWrv/3Fcemd+h
Xbt293Rt107/764v9J+T2HD1udclH/Uidm+7PmnfnMQd9asrF6Z50XTshc86
/nwSpwtvndIh24t+0am97vj1JIa9+HHutBwvJmeO3PbKHyfx4hP9q6+X9XLP
Vxf9GHoS4d7ddw2Rv/+dfc6WwuiTKIu6Lu7rTC9S/3mp+4XJJ7FkRe7Lwele
nOma+fH9WSfx2rm/3bo+1Yuxc6rTryk6iZWff/TXQ8levPzyA1NnVJzEF7sP
R5+T6MWut46kbKo/iXeO3/NuRZx83o2XPxDlnsSUmRtuz42Rz7tzbeJff8rv
3+HNPy9aPu/euolD/zuJfypDX5ofKZ/32NS45zoH4d9xZ6zGcC+2dn2u273d
g/DLmCee+u2UF6F9Ej9c3jsIV025KuibMC/qB9583oErgjDzxUe6BoV6ccnI
nRvKBwRhzDU/3ddT1rM2/pIYNjgIDd55S7aHePHhzp6TWm4Jwqp7CrYPlvWx
n1bF3XhHEH4f+vL37WVdftRz/zP3BiH1xxP7vcFe3NC15cO7Jv1//Xifp85b
+vD///7agZEb9j4RhKcTPtl0j6zj38xJXPfM/3+f+dfPB2HFhXc+Wifrq3d+
H+csDkLy/W9d/7x8vhesP7qlvB6Eq98M/btS1tv/vnJjh9VBmDH6aPxy+X7h
Xdafd/u6IGz5c/+OLvL9z31m5wO9P/7/87h18X+Jk7cFIXb9Of1nyvN6I7Jn
jxu+DELM4/PLekd48VP6qk2zvgtCtH69srav25Rxx/4g/PR26WM/yPO+fETL
1CW/BeGDvNZuy6O8GD/2KfmqQXhp+AVRE+T9bPr85Z7vhQfhgQ+vfeMyeX8n
f8zZciIuCD0XqhvbxXrR/u+67B1pQch7IKygRtYTH/6nz7K8IHw99KMPU+T9
vzb7uc9/Lg3C3Av1N/Ii5MjyovU1Qbih6dr6XQle1EWUzAy2gmBlKdkZXgy7
VH29szUIn4157d7VSV48dd2MK1L/ked79b3qOdlv372xcM4vHYPR6aOoL55J
8aIh7e0fPjg/GImLtkwaL/vzktLqa8IuDsayvJ5N98r5mHXr6ee/7BuMK8bu
2HW37Gf5y7+sHBCMmAOXjhud4UXGZ8tuPDQoGC9fuqtxhOz/Pt4Niz+6JRiX
vnvF9uFZXjxz767fFtwRHDgvH01tP3z3vcGB85T1Q6/X3pwUjJ6R328akCvP
88z1J2ZMC0bQkIG3XZUnz/O8zbd9MiMY+ilcni/Pc5b+BsE4v8Pg9y8p8CLn
92NhExcE49iig8N6FnpxxXkJHQYuCcbsvGH5FxR5MW9W8fhzVgbj3LG/v9Ol
2IstC8fF3L4mGIcPjLixU4kXeeHTu1zyfjBmXno8o12pnKdLXnqw+ZNgdHh3
9Bv/yPr5hau3pn8WjF+8wdf8VebFwfAtOQd3B+OxJ8YkNXtkf/b+4bKPfgrG
2YjwZU65F3ctPD5rwaFg/Dhk3BWNFV4sWNWv+OtjwVgoViGj0otfU2+WrRqM
Xqs+fS2lyou2AffPmxETjNDKXlcmVHsxZtWMn0emBOP5hz6Pia7xYn3qQm/P
nGD0OHnZy+G1XqQMWDPcLQ7GiQFfXRJS5+XPCcazn/Q7dbxe3rfvoKHL6W9e
ONLgxfcDTv7zfkswfn9uwIW/Nsr7Xpl8z/x/grHyfvfUDq8XN6eWrRvbMQT9
Dy9dsNXyYtWA5virzg9B4uWtF26y5fys7HzB2YtDsGz9ipMfOHJ+Ui+bVtg3
BFe4p59d53oxdcBNO44PCEF5RuxFC5UXcqbkRYdgoz62TV6c7tWu8rIRIbh1
b9Lcuc1e3PPSxdf/eWcI/vpAGxIv3j81cGH2uBB823x58H2tXqSJ9f1tSggm
z/76uXvaZD/q1/FoCC40/1D246k5oxY9FYKT+/ULkc/3lN7YIZjb+5V5/U7L
59NmdmEI5Jf06nRGPl/nCQm/LAtB+rNhIe3+9uKzp5684MM3Q/DZuI8W1cr6
9J+XXdp9XQjGHLqgd+U/8vkevOmpxo9C0FGsesJZ+Xzf3bMnflsIDp55enHM
v/L5/ny08scvQ7C0+MYrD/wnz2/7xdagH0LQd8KBmL3tLKwyBlWexw2rXv+k
vYXwMXe8Xn1Ensc2bZgsDCg6/fZLISGY+np8ypJzLNoJeR5lk5cv6mjh9/Xa
UYUgLOLSgY92stDrGs+F+7ND8MKQXakPdbbw9Irmx94vDsGQ7i+8PfJcC2EX
H5l9fnUImpxbh15xnoVOL8Z+V+8NwZdP/pF7aRcLCzptOPByawjm3PXehn9l
/euTX7hTzoagy95Ow850tfDnr/oghCL1g8xSTzcLMx9YJI8iFNtf2vNJ3PkW
vv12zbsf9Q7F3Tn9R0VdYOGcMfj4wn6h6HDcrtnX3cKUbY+kW9eFIn5n8Gdb
eljQp3Dp0FBseuOD8SsutKB3/Z+3heK26q7O0ossmGM/JhT/xObtntnTQlDo
Dzc/OSEUET//8NA9F1tof/GJ10dNDcX7G1/9d2AvC/N+XbEm5IlQmI/V28Iv
HbXhCkVrrj64Frp/Ozml34JQBJ/Y1NmV9at3d837fkko3tmlH4CFE59e2Xft
ylCM1+6ij4W+w0qu7bw2FN1m65NrYXXSV2JpQ5GBiJiNl1uIuVofhFB81v+T
11/ta+H60Ffesr4Ihf7Wi6+wsHHmsA1LvwtFp5dLUh690oLVam/+c38oEqfu
X31HPwsjJIrI/j0UW25ecVP/qyx8VqsNdCgev/i+knOvtnD6vbW1pVGh6KuP
l6x9djkUntySu3L6y/uUXVqXHYqf9Cm+xkLnnr0QWxyKhbtWfPXdAHmfh7Im
TqkOxc1v3ScuxULSZP0CQtE266J/XrnOwtDaR55+vC0UISj9ZfpAC1ve6/l8
4b+hWNv/l6fuvt5C81WZrzxzbhgmnLOy27U3WJgesnVVVY8wnF99X3DXG+V5
zZj23ot9wpCpj7OsfZ8zDMb8DpLnJdZw2Y1hjAvkedVUFj58cxiuWbTyjR+H
yPN67/uqnNFhqHvw/kEf3yTP66rn7CfHhnFfyPPSZnRyGJZdVPbhzGEWFupt
9lgYbm/+ZfQ9wy2k3PlQxtanw9BXop6LbrYwXKz4JfPD4Llpyzd/yVpbuy8X
h+GnHrMeLrvFgvl4y8Ng3OmtFmYcfOCvH98Ow81ZbbKzZX9N0p4iDG1Ho57Z
NtLClTVJ3Q5vDkOI7NY3brPwjuzukTvDsNvZGztllIWKfiYwwnMZry2/5XYL
c8xGD8ONR+4deNloC1G7l/+18Pcw2Nu75/4n6+vuvK2DCgrDUe2W77AYB4TB
mPE7LTQuO9b776QwPGUMo0W/F4b+2z7+av3d8v6aPfaBkjDUvKZPnrw//TVr
wnBg+sB/HoGFrUP0JwjDJ7/efeTae2S/mwMVhkdNYCf7/cBHRQvancJlxmFb
yJbdYZ13Cjo6yR9r4ZEhx49e3vMUIg4Gr9o/zoKOivZcfgobNn9w49b7LNxy
oGJT8oBTeODVxwtW3G9hx8TvPp825BSGmoBA7EPVs9/mjjgF83omWDBma8wp
nNTHbaKF/Hn6pJ/C269k7Tkr6+kTT086NvUU5sQ3TE+bJPup6sSjd8w4hYH7
j3f+Y7KF2+KvHfDCs6fQ+NG6P76aYuGLeVVDvC+egn6rLz9g4VITAJ3CttgF
Vz7+oIU3qnp03v3mKZjH+ZB8njgdIJ7Cne0fXHfBVAtPzruzbOqmU9BepkXW
+RP2Hnrrs1OIjdYb08KdVc+faL/nFH6+8t9dB6ZZOBmX+f7Qn0/BhH2PyOfx
BYKQILz9/Efl80z4d47n5Cn01m7oMfk8g7WFPoXCvm89e8vj8nkk2v006RRC
XtvWp+N0C3/psDL7FN6drr+xPJ9P2hc0lpzChNtvWpnxhJy3Vxf/3Kf2FAZt
vW/Y9zPk+XS/6fevnVMQYygHQN6XDtv+OoWMpBvENVnY99K7P//dLhyfH2y9
f+xTct6fvv3CTzuFY5V2w0/L5xvUZ0d2l3CMqSs4cEbWOrp7qXs4Oib+9HT5
LPm83dfNa39xOGqu0Z7BgmzS5M8vDafdlPertKMIZxxlIfZU2oklV4fjUbwy
6JFnLaz/TTugcJg0YK6F+76/84OvbwzH36v0jhP7b35AOEoyX5pYLGsdvSfe
Eo7vjo76K3KehbUrtYcOh7ycX7fPt+jvwzHZ6fvMm89b+O8pHeiHY8jEWy95
8AWxdw+ukRAoHOb4LhD7gpGzgyaF47hE9Ze/aOGumxtjHn4onPvEwt/XfHtT
7SPheGb8b8WZL8n57vXEjtVPhONe8dI/LLT4nMLRee0O8fAWbpdPtX9OOMzj
Wiz7p14HQOE4pI/Dyxb+KBo6Iu/FcGzptfXZ3q/I+zMbMRxL9WuT9YhTu87p
uCwco4zDFnuRPfAhe0U4Lv/54zV7XrUgxvnYurfCoa3ZhqUW/j2uHU44IiqW
1DyxzELovonySMPxfvTdEpJbeOvLf70TNobjRdndF75uIeHwxlG3bA7H0P/6
n22TtS/eCIcJ95dbGL+9rfMzO8ORO7qzuELx79qdfxVOvybn+8vbT5Z9G463
X2tIfGGVhYu0OfwpHHNS2ksEayFdh/e/hGOsWK9ub4r9k6i87ddwnHteTZ2S
tbZam46Go37O2T1Rb1kwbuZkOH4dqz2ahdqPb7AuCAvH1i/LO7/1tsW8JxzT
Vx/6Y+4a2d/bdKAQjtG5MYtHvOOPX8LpZy3mweHQUYxX1qEfz5UUKByRL0Z8
FPauPI+3+/S/qzAcH0z55M4f35PnIW9xYFk4Xvrhx6bl68Sern8yK6QyHA+c
DZEnKedlV82Ve+vCYdzHBgs+MxqOllHfXtj+fQueb29Iv74pHCZclrUxf3+G
48ulOoAVe/yzPmDh9PuyP8Lakj9tF4FxB18sfXWjPx6KwHVmA1nQ2cLFXSPQ
UKsdmvhTHRZ2j4COov+W9dTkNyQEjMCvX+jE3cJX+jH1iYAkNc8d/cRCXdun
YskiMD17zuUbNlsw6Xr/CFzxx01iYS20nM1eWT8wAv92v3/tmK1yXi5+Nipr
cAQ8L+iDb2GTfvzDI/DjpBvlR1kouFt7lgjuEws7hw2TEDMCL/39xPRd2y0Y
N44ImMe/Q+z7kxMk9IjARbfdFfrIZxbtdATyLu2yePTn4n/WPSNfLQInl1x9
bbedYj90GvdIBL5MGFVULOvcj779asETEZhjDIjEr/r4PS3Pq6POCOX9/nHy
5rufledlEkULIUk6MZfnNabdvge/stDFJAbyvD6/dM5VX1t43AQqETjkDpVM
1cJ33RqeqnlNnlfm3xIRWnBk96avkuc1+OK39+0R+63d69sRuH3doJFvfmNx
n8jzmq89k+wH/Vg/kOcV1v2rW7+z0F//800RiNTh8/diLw6dJ0dSntfppg5e
WU+M3i4eLgJG7vjBwvaCq2ULyfMSK/DDjxbKxRsv/zaC50j8ccfRNzz7UwSa
qzuJaxH7f1nM0im/RNCPWIgbOi105GF5XlfrbyzxsmRdy45FYPWq9m0Zsrbf
0gYtAkYW2G9BnMeaiacicO3R6qc3/iLnXZvP6AgYs3XAwrOek38uSZDnZSdE
jT1o4ZB2A6nyvCaUv9HrkEU9KQImTJB19rgRQe/ly/N6N6Y8+Vf5/jPDO75c
Is9L3t7uwxb1pQjqFPL9tXusjcA/H3eTlFi+f8gdce94IxDxcv4fNxyx8Err
Vy1hKgI/xDmLz8ha76Z9bRHUzyycd/WxD7f9HQET5h6TeGmGTpwjobOmdX9Y
GKZlnU6R6HG0w7jpxy3mGZHI2ZHWdNcJf7wZCZM+nJT4rrX5p2t6R9LvWug6
VJ+USDxzY9KFcUGSL4zTEVkk7n23Im5nsMW4N5J5lD8ejURdSKy8CfGH8jR/
GxqJxN5ayJD9bxxWJA6+rL+Y7H9tbm6PxNKHIx8oOiX5jg53x0TisX0F5xwM
t3DrxurPpo+LhG/bib3f82r5PRMjqa9JvJGf1X3Ng5EovUsnROIfzMGKpB5n
Uc+KpC5o4aln9JuOxIL0dMkwLPrVSEzWxznWQo+Muu5zX4jEkHf/OzgvzkJD
lyl3fbMoEpIUzJoSbyF6rDZMkRAj2OvKBIt+IRI6qrRl3bhFG+ZIvGkCI4nH
xTrdvzYSOjrem2RhTwed+UVCXqJ4PvGPd2rLG0n9x8Jjr137+X9bIlGrw/hU
2e8HN4inikTCXU3nnpMm71u7iS8j8YsOc9L88XEk7bqc9yd0wB2JRyUL3JRh
4XMdVv8SiZE3diqZnSnxacKre187HMl9a3HfRKL4ufpxl2b74+dI5j0W2r2m
LVok1u1O2Z+WY6FQu+2YSDxvAlELY7toxS6SOplFXSoSg/ZdnH5fvoW2N/SD
iIS70bNmcIH4vyMzW08WRiJTstCzsvbpOJE4elcPO7XQwsWTWm7ZWB0JI9MU
SX6yVgdykcyz5XwH6cQyEmPSu54/s8SiThGJc37PC0ap7O+HH03KPRMJk96W
Waj84NhfvdpFIe65zoMqZe3L46OwL+TK8qMeCwP7PSypcBRe2d0gb06+7xNa
mYnCtD/bT1xcIfGeNh+9o3Drw5f9N6ZSvq/3AfmVUTgtp/26Kvm+12kFKQpF
G8+KBbSwTqeT10VRP7Iw2yQ8UTDmoEbiu0u0EBeFef105mnhm6lVkzJHRmGC
EVTl/R64QkLoKMiXaxhdL++36m1xLVGwf2v5tluDhcn3Hv98xPgomK8v6+uM
AYyinmRBq+Qdp0VRTxJ/dos+QFF4cve5K16wLKRp+eqpKNz1Z7+ho21//B+F
DhIlX+VY2H2tdhxRqLpZH1TZn0bgiaLuLf5cm8NXo6DVmn1K7Nclw9c+tSIK
i2P+/f3NJgtGtnorClONcCf5pk5L343CLTr9brGgd3Ho+1H4c8aZ9E6t/nwh
CgW/XSSpmsSvWrb7NIp2zsKgKw/8t2xnFNZ6dWJvoaMJ2KPw3P0X/PTsXxYW
/T7+7vu+j8L95oOL/RVrkPtzFLq+o86//IxF/S8KlliDRln77GgU0rTs97cF
Sbrf/vhkFIxs9I+FZe/M+aTfqSgsX9Sx4vWzEo9psx0dhRkxfcUkSvwxOuPQ
2MQo3NFP7wiL5zAK7cwfGxc33Zv2fE4U7bCNNx96o+yvwiiIERRLbKNy/+/O
Rk8U9Scbk89t/O+Kmigs0q/lHJvvMQoP6XS9o43LjaAWhYuNgGZTd4tC25ru
4gJtrNTh4T9RyM+/TjI6G/LLbp3SIRpfBzXN3H2ujQlG6IiGBE0XLTnPhs6i
XrkgGs8u6h9/bxcbP96sA5JoXC9R9A1dbVzwyadP1PaJpp+wYcLYftHQnzKp
mw2t3na7NhopM0Z8/fX5NnWJaGy7QyeANu4YMPnN94ZF43WdjnW38Z2Wq0ZG
4wnvsODre9gQ4/b233dEw6RJF9rMP6Lx70CtrNloLcpbu2x8NMrFWvx2kQ2T
bj0QDXnZH+zsaeORE/3WN06LxgdBPeRJ2Mw3omHSml7y/bbP/+C5WdH0YzaM
/D43Gj0f0gqTfD+ToEejRf7f2Ets5hfROPmBE33gUhtG3nwtmnGjfL99g/dU
r4rG2+aF2zDp5ppoaDX5tstt5hPRuO71DrvO62szTo2mLivvzyT28rx+rWkX
cYW8P8mee3wejV91GHSlvL+5OqKLhs525vWzsdgc+Gj6WRvPzdUZazRGf3U6
54qrbZi0+FA0dSCbemY09Sobf4RNXJB0MhqRw/QDsFlXiWadwMa3YfO1ko2X
Xip48plrbdYlomHknetsfBz27ojnMqIx1Aj3Nlq0ec2NZlxso36XDkSjkTtd
v1DZb5fnD4qoiMaJX8+R1MRmPhDNOMCmbh2NOSZgt2HSt5ZojB33X8dLB9s4
JtnAjDPyvCSaOSvr/bt04BYDUw4cYuOby3XkHAMx6pJp2tDepev5Mdh6Qgd8
NvqYwlgM9Ssb3cOGS0oeg8dfartn8HCb+mgM9Ssbp0N1ghuDsz8U7q2UtX33
00uLb4xB2Vk1+9gtNqp0WDEsBj+U6QDWxgvPTr3zn5Ex0NW+xSNszCqfNbTi
zhhoK4eRsh/NQYrB0GW6QmJjog4LJ8RQZ7UZz8fAlIdGyfvqqIXKGJzo/Mfk
w7fL+1r3lrjEGOx6RieINnR0az0Tg7eMUGNj2M+vfJE1PwambHOn2Ad9fBfF
wJQF7rJhZPxXY9D5Ab0DbHw9RQtH8rxu0oGDjaudxyVyj4EJI8bYMLL8ezHY
XFbU8gJsfKHLhxvleRnB14Y5/ltiMMoYHpt5SgwkuZIA1WZ8HkM9y6b+GkM9
S86XDpt/jqGeJc9/9TVTPz0kz6tuj2fu/Tbj1hj6MRtdxCp3CpbnNWDdhL4T
bNZJ5Xm9qRNzG+9qdxoXAx2lhE20GSfJ8/pjzfwfJ9n4YKh+QPK8enx+xYrJ
NkwaXBCD2UaYtdHOJOTyvLRZesDGulZtOGPQ6ftPxWLZONcIGTF8TzbrJPK8
JOs4+ZCNNSagkud12yczPpoq38cI9zGsm8r30WXKjrEY9erSU+Om2bSbsbhM
l3UfkfM0uaHjiItijfr7j6x1lLP40ljuAxufbj1yeO+Vsdig0/7HbNZ7Y7EA
j9y34XF5P/lvPd13UCwm73xRMkobV2jZa3gsLnxDK2U29lylK3KxaMp8cO6F
M2xcEzWoNP6uWGQPnn9Zhax98XMsvrjgloT4mbLfdJo7KRZvPj/pnV1Pyn7T
7mxqLO41jtymjhbLvNLGPX1WyhGJRacz94mHtWHC2LmxSCq6SCyqnPd3L13d
6cVYHNTlO1k/oWXSV2KxedM9IYeesVGY4Llh1eux0Lt2xxyb8XEs4w4bL4/Q
lfVY/LNPyTewofK0gCnPq0MXLVWjg/mCsawr2Vg/Vie68rzutty8eWK/tPv9
Up7XZx1/3jffxmUHv9/f5btYaLVvy/M2BpmCbSzjehsHdZn0UCz1LRthpfrg
x1LfspnXxFLfkvM96et3BkbGUt+ykePVAWks9S0b1Ud04CrPyxSMbOrJsdS3
bMaxsTBp0Muyv/TrqIiFkYlfkfPy4ZtDVtfFUt+yYcJRR56XEQJt1o9jqW/J
+zAbSZ5Xux9ue3Wpjai1W4bM6RCH0pnB1thlNvXmOBiZ8DWxZ1qu7RGH9dv3
PPa3rH11mjhMMQGODeOOrojDTWnvBR9ZbuPDezUQEYemww8v3LXChji13bNv
jENOlwXXLFop/iQtRyx/HI7LKbt7lU3dPg4mDXzDhs6Szr07DqZcKGsje4yL
w7W6TPqm2NvG8NEDJsehsxGGxf9L1Hj44TjUDX9m9jurbe7rOBzqqStqYr90
OWZWHOvENm42AXIctFp31Ts20iWLvXNhHEb9dP0QJWtffBoHHa1HrpX99M7v
Nz6xMg5lnm7b9r0r+2mi9rBxiBitLYLEaz1u+HLp+jhs6KsLqDZ+O33itsc+
jsOLBhCxGY/GwaTBG2xkva8NThwkSLvUK+uqh7RSF8e4VuyVLlP/FIcT9bqQ
b2Nbu5HHFh2Mw66xtSOXf2gz/oyDSUM32jBl8KA43GsEMBuPmoQwjlyEzbwz
DvXHtYOVz6/L7Klx0Nn4iU3iH3v3+T0oJw5bm7TwJ5+/WAvBcVg25Zf+r26W
82oSnzgY+XuLzbp0HOMSef4rdQUyjvqWP76M4/e2cWiQVmzioKvqR7bZeLC3
tmjx1LfEH5qAMB4PmANus44YT78h+0e7rcvioaOqaz+X/bNSe6546ls2tCq3
f2A89S2bdap46ls2/W489S1//BhPfcvGbQ39Ly+5N576lk0/EU99y4a2yt9M
jcenq/RJEH+mZc/p8dS3/PFiPAyessfGQ1r+nhePvhfoCpcN74u6Ih5PHcrG
R49pwx+PqAlauLJxo0nk4/Hhjbqg4I8P47FQlw1+sPF8L+2J4/Fg0anfM2Xd
0QS88ehphFcb39drsCae3ILYn+zV4rLiEaS38V6bOlo8vnr4g3fG/WzjfG2m
9sVDe4FB+yRe0mWcw/G4zyRk8jx1ueh4PLSaWLHfpl4cD63aH/1F9vuXm+Uk
xeO3vboAY1Mfjuc+lf2y5LfvOmfFM860qQfHQ16ipLoSz76oM+d46tY2Tj56
x4z/auMhydK7JYfFHurylBMPg239ZuO9B25ZeklbPDYeLq/f8bvNenc8Fhkg
wmaekwBTVjhq4w1TSEuAKc8e88d3CSjQ6c0fNoyZuSwBwW9rhUzyqdt0oJIA
k7YdF/+qZdvrE/CcAXtsaEopdmgCbjCCs029NgE+DMpm3JSAdG3Wgm3qswnk
ocS+3JfvtkxOIO8k+/sRXZhJIJ9lw4RrMxPIb9n0cwlor83zKRvvrNYZVAJ5
JhtXGQAgAft0+TbCph1OgFbHL4q0sWJdlnjUBBi5QdYmTFmXgEu0vBRlI+0b
DQAk4C+NPUTb1FMTEDry8OPvxtisjyfAlHFjxZ6YwDkB85doZVHiGfMAEqAp
jPPj5TzW/vDnpl8TcIE5mDbydbn0jwQ4Wi5LkP0q0fpfoQkw8miizd+TwLxB
8oFxl2YfT05g3Vziy0fefsTKSiA3Y5OvS8A5BnyyqX8m0G/K5/3mQ9kZCcyj
5fMaIToBRu5N98dfCdSzJF4xhd4E6lk25pvANJF6lk2+LpF6ljzfu75ZlNg7
Ed/d/0fzWVmvMAl3IvUsm/plIiYZQMFmHT0Rg40gIfljSN3gibcmQquPL+fb
GGfAgkRkXfzZynsKbMbFifiide4N1xfa5OsSmffbqLhT7+xE3DN8goTcNr5a
rB9AIq75cLZEFDb5ukTUvTS47fMS8R8HteNLRGKUFhpl/5ZN3fT5y4nY/KMu
sNvk6xKx1CTMNvpf1bJo+upEjPI0R51XbqPoYU0QJUJXlwplvePdl4e9+HEi
8zQ5b0d/2dK0LRER2rxX2uTrErHhcS0E2zCy9HeJ5Bps8nWJrIPb+FnL478l
so4q/uTDc7c/eDIR+ls0yLqvThfDE/HlgWkScvnjpUSsNiCM5Bfa/aQlYpx2
hw02dcNEXGdAH5ucVyKMWffa5OsSYco6luTrZuMk4tOndaYg+1HL5a2JeM0I
sDZ1m0Ro6/e7Y2P47nsl00wiH2WTr0siHyXv/7pP6+b3SsLeI9sipjVJfDo9
bZLTNwkf6nS52WbenAQjj7SIPyi5SjKqJJjXKWsf95CEthue3hzZapOvS0L+
2mXjt7dJfvaZLhwnwYRDf9qswydxX9usgydRv5LnqdPNmUnUr2zs0xjOs0nU
r2wYuWBBEsTpL8v8W+y/lieWJFG/ssnXJeHJ1pOFG8/K+dZy05ok3KUxjn9t
xilJaG8ejI0DGiPYnESd1KGfTmLd22G9Pgnm2LZ3GN8kYdqPz/c42sGhvpaE
S96/VVJ7B++FJ357/x9J5Kcc6v5J1F0dcpZJzOsdmPJIShLPscN4JgmDJYtp
krXvXCThArPBHXz31QKJsJOQ2UcH+g7qlU4Uk3D01egn3+rqIEyn761J9CMO
OhlgLgmSlEaMON9h/JKMazROdIFDrioZta+M7d+huwPjpnslQ5Kl/CxZD+it
FdtkbN4/8IOgHg51k2S8aoQFh3xdMnkqh/FKMv2Wg9RN9V2m3JWMUr1tLnbQ
u/KfB2+4Lxm6KtOzl0N9KxkbdFlV1jebADSZdsth/TwZmur76hKH8Ukympdr
R+FgR7YOzJPJCTkwGNyyZMZd8vnEmw9/Kxlzto2UI+WQr0umji2fb4n+IsnU
q+TzGYE6mXqVw7gqmXqVA3163/4hmbqgwzpZMvUqh/XrZOriDg7/m/ZsWEgy
KrSc1t+h30pG9DP6AzlISTZ/mHc4tNPJ5KscrAjbIzslmXbawQOj9N9MJl/l
sN6cDF0tu3egQ74uGbt3aoPs4G5TYE2GOU6y7mmE5xSMzyqQzNThe09BNwNO
OzDm/pIU6CrvF4Mc6nIpOKKP0WAHzxf+u2PHwBRyOQ7jixQ8OeiVCbff5FD3
ScHV52uF3WH9NwUd5mvP5lAfSkHc+Ktn5w1zcKURwFOwb8+o3vuGO8zjU/DK
2o4xm292EDdFf+EUjDQAlIOvojUQl0K/5EBX6f5ckgKdZQ4d4cB8rVUp1F0d
/PzIkXOfXJuCdflfSAbioJsBXVKgVY6U2xzG/Skw5d1RDuPsFKiWyTM33O6g
jzHcKdD04uLRDuutKaxzO5j66SFdacds/TrudBg3pVCfclhPTWGc5TBeSKE+
5bDOlIKtukw1xmG9NAXLjMDmUK9Jwe0GQHVQsxV9VtopuPz71x8bea/DOkEK
POu0MOCQv0+BMU/jHKwdp59AKrlWB5Vl+gun4kFTOHLIIaaipzFcDnXVVOrQ
DnXMVHKRDrm3VNYhHcYDqZhrAFqHvzcV1xc+PvG0rM/T5nZKKjk7h3xdKrla
h3xdKgxW8oADTc2/ND8Vy00BxSFfn0ruRuzrCL0RUsllyv6S6Or026nQammX
h2V/GQE5FXJoix1Z+/K+VLxiGigc5lmpmKbTiUcc1u1TyfU65OtSUTxFP2EH
piz7eyrC9Nd/3IGmW+8LToWmV4dOd/B9v+8yroxOxaQFSSd7PSH2IPjZou+S
UzHYADcO63+pcL/79eqUGQ657lTqng4mGdA+FTtLtr2//kkHByQqne2kkiuW
/X6rJplSqUc5+LhZgyVp1KMcOJt1I0Ea9SgHJlzqmYYtoVrYcZDeQwuLaZAk
5GjUMw75ujRySA45yTScLdjca+uzDi42IG8ajMw118E53u8ffWJMGn7UWPxz
Drm7NBh5eZ7D554G4x7nO9Td0tDTBBYOda40GHz/eQfXm8JFGoIW6gRI9svC
gWWLlqVBV63eXyD2fLAmNtJw/7DvZ7z8ooP1jdNO9FufBl29efwlB6+bgD2N
ealDHj6NurBDTiMNptwm6/EGsEmDaVdZ7JCvS2Me4kBn3x8EpUFXIbe9Ip9H
hxtRadDU8rwl8nk0Vpmcho81Hviqw/pWGqY9rzM7h3XXNHJZDuPCNBjcXdYG
Y3TTcEqXFV5zyIWnQVNxJ153sESylevap+N50wjjkK9LxxAd1qxwWJdKp44j
598o8+m0cw79ajq+0LjzGw6+vujH0IhL06k/iX81iUc67jEb0cFj2v1cnU79
Sb5PzlPyN9Khd++O1Q7rWenkqxzWGdKhs6AH1zjst0knXyXnbWP84Y2j0smZ
OTjXJMzp5KscxC7WAmc6fmrSDlvep5aZ70/HQgOKOLhvmq4Ap+PmPy6s+mad
PM9x04+/8VA6dSkHkSPOv+qiR9Ohs9CZGxzyDOnYnRlxBu871GfT8Y5JWBz8
10UrVekw5VFZ+7i/dNp9sVe67PJSOgz+sNGBwSpeTscRebqff+SQk0vHSlMY
dTDBGNx0jNFy6yaHzy0dxqx94pBvSIemyK/c7GBKSj/ZWen4pYsmLhx01fLs
xnQsaXx5d4OsJUiWSDndqNshWx3mI+noo/GgT+X8HE+u/31nOnT2/+E28e/7
3p026et06iQO9d106sAO8nfP7PnNT+mYfK0mNh3MNg016ayzyfnUr/twOnJq
dSAp8YWWR46m44Ru59rpUBdIhylTfOHg0O5tpaPC0ukHHYwwIGU6uQuH/ULp
jIsc9o2l4/DVuiIq9nSXTnzSYcqBux3mmemMo+V5GBAlHVeawMRhXpdOjkPi
r33DZSek42fdFvetwzwqnXVBh30h6TBpwvcO85Z09L4yoRo/yPnTbvfPdJgw
5UeJHw0Yl45vPHNlS8j+0OFYuwzG8fL5tNzQKQMTTcOEAyOTd81gHcdh3TYD
WaVaQHVQ4jzcq+7iDBzTeOl+ByYN75PBuMBhnJiBe/7ees0tBxyM1Nv3mgyY
v3bQIfeeAZP+ydpX98ugLi/nU8tJwzOw9HSP+uO/OtRrMshPOTDb5I4MGPzw
N4dxQgbKekf8N/13iS8XaiAgAz/+uenXu484MHLQpAyYsP2og08/SxRPkYHh
8q26HXNYl8mAwfpl7etvyKAOIvFz9DmJPz2dga/zdIHdoZ/IoL7kkKPN4D5y
YMoQCzOoL8n+0xj0kgzqSw6G67Dp9QyYcD7EoW6egadMG4iDBJ12rMnA3SZR
c1ivy4DBdMLEfq5zF1R+kIH4Y9/O/eqUQ84xg31tDnXbDOrIDnoY4DgDIzMf
kf/iwGBhX2XgzJGrbrwmyuE+yyAvJfGUfiw/ZcC0F8n6vLu/fHzPLxnsd5T3
84hWbDKgqem9sQ77qTLInfr9SQZ0dPJ6vMPPmYG3n9DKpwMjh0ZnYM7hvn/c
lOiwby4DvjRc4mktM6ZmkNN3WN/LgFadypPlPMinOZifgeUGAJbvr+m5kgz+
Owdm21Vk4Mqltxa/k+awTysDlY+2+/iFdPH3xjBnwODrGbI/DXibwX45iUcM
+JsB02aX5bAvKYO6lsO8OBNFuj01W/IFjc91zmTeKvHGCS1sZ5KP8sebmdST
HPypw7zemeiuy3H5DvtcMqknOTBm4qpM6kmyn/U2vjaT/XMO85RMXKvbyGRt
yktDM1mXd9jflck+BgcmDRmdia05B8WySTyp2z/GZEJ7mTfKHJz5UgvLmbjC
AH8OLjDCdiZMmlIu+dHfujCXiagsHdg45L0z8aGWCyodGPc5IxOmPU7Wde+e
+Wz0rEz2wTmICn46esXcTJjjV+0gt0K/iEzsuWtI9q4ayQ/1NliUCYOH1zrU
1zPJQzkw5akVmeShxN6aRD8TmXdoUsDBI6bRMhO6+ntuo4ObdJvihkzMMoVk
h3WUTMC0lzoo//zMqke3ZsJgpJbs9/Sn9279LJOcgsN+skxs/kc3EMr71ub4
m0w8XvrJkiddOe+6jPxTJrkch9xoJjlnsa/eCRIRZCLyjEZcHerWmXi/+PxR
nmZ//JyJB3V7aYvDc5sJcWKfHWx1MNQIhpnUjxx00eW3pEzqRw73cSb1I79/
yaR+5HCfZFI/kvhfywueTPbbOXwPmdzXcl61+2jIZF+qw++Zif7GMDusP2ay
7u3w52Qi/l4N/jnsd8ki/+RCVx/3dsoi/+TCuI9uWTBmu73LPrQs8lAuhprG
3izTZXB+B5fxehZ+6jr+utdlvV/jNVdnwaQNsvb1t2Xhg+e00OVSj8uCcRey
9vHZWXjJFLJdchlZKF7QTlJqFyZsuTOLOpALHVW33ZNFfcqFOKsPZ4/Poj7l
YpUpWGThIh94yH7YLLyrX4+sjdw5PYt9XC6eNgFOFuaZQqgLgzc8m4WclboR
0cV8kxBkYbwBhlz2RWTBfL0uLkwb29IsaCptoaxNGLgii30mLusDWdBddXd3
ddHHFASy+JxdxoFZrMu55K+z2E/o4kP9P9uy4HvgLpTGvndm4TddnpG1r06W
RX3MxZmcKyQFzSLf5bLulIWOprDkwrSJH8oi7+WyjpPFON2Fr10/i3GES946
C6PvnyAu3iWXm4X9uvx/oYuuRvjKgtn2sl6697XD/6ZlkaNwaWezcLbtdc9X
sj7PgMNZMJhzT3mf5otmMQ90oVXvJTVZMDKzrO8x4HkW+xtd8tVZMF9L1nka
n/wzi/qcyz7ULPQywLeLxVf8dsmeDtm04y7fazY5UZd9mdkoeEZn8C4WmYaF
bEw2DdIuNO1/0WXZ7I900cE0TGZjiE4bL3Wpc2Uzj3HJf2STa3KpG2Vjjdng
LvvosuFeopV0lzpMNvRuTL1MzsMaLVRkk1eT/WqNXfb1+Gz2nbnQtP/MB7LJ
r7nkVrLZb+mybyqb+qALs51mZUNnzeOucJkXZ3NugUseJBtPGUDaZX6RjWR5
66tlfbMu87+Wjbu1+Ze1ry8mG1eZRNdlXT+b/Zou1gXrAkA22hsgxGWeko2l
Gz+papK1jrZWb81mHdBlH0U28zyX/TnZiNmsf6CLvztpgSIbpjwtax8fks0+
EBemnHIoG32MsOriIdPon0190oWROYOyqU+6GD33pjGdwrPJRbrkyrNhMEJZ
+7jvbBgZU9a+OlY2hj+gLZzL+kc2vtXtA7L2cc3Z6Klf/0DZP2YDZuO9aRpE
cTHXJ5iRx3Nh2t7tbMzfP0dCM5d+JZv9pC7Gmsa0bPJ5LvtrcnCjMVQuTLmn
cw45D5f1kRzGGS7PUQ4MdjRI9rtkc4/1yaE+6lIfzSHn7OL98gFzJ1+bg7Tn
dcbl8t/lsI/GZV9pDnVzv33OgTEfN8nv76gJ/hx0Mi/Mpa6Xg+Wv6oq8C91l
P3hiDmqv1G/MZTyfwz4DeV833Bfe/7EcJOjtPUzsiRHucsilumh3hyYDcsix
uOyPySFX5ZJ3zqEfcTHSuV0sVQ71WJc6RA51QJecSg6mmYZEl31SOezDc2HC
kY05uNX8cVEZpxuzc8gXutij09fPcmDc0QiX8XkO6wgu9dcc9n265JtzyB/K
+zfAcA6mmAfnsm6eQy7HZd6Rg5uMAXCZF+Swv1b8i3nROehhhDYXpg0rJQfv
6ON6u4up5sXlUA920U2XWQtyMFeX+WVt3IQnB1lath4t/vOy6Wp8TQ7u0xif
rFP36wedw7zNxTST8OeQ43DZb5lD7l2+z47VkinksF/XJfecy33h4nP9urvl
sn9X/LEpnOeSO3JpN3Nh2s5lbdpjrsyFwQJlrVW1kdfmMg6W92MK+rnooM09
XOrwucwrXeiug/NH5aJK4/yyXmESzFzyki7j51zqPC77JXPJT4q9bll3Xb+H
c/FzrBbyXXJ8uewPdrH9wZORwU/nsi/bJa+cC1Pul7XBC17MJUflUqfLhSnn
ydrXp5gL/bZeuM9lvScXw00Dhtg7jem8mwvzuu53qQvlUu92qcfkQke1XcfL
8zYFjlzq3xLP9B0Ue/rLXDxvAi6X81dykad/3AQX7vqExyJ+zmX/sUtOJBeD
jKMX+63T1WO5+FJjwbL2jcPIxflG2JH9rTHKyFw+N5dzVXLJibmce5ILE8bL
2tevmEsuw+UckVwYTGyKy76NXPKefnuZS33dpb6cS/7TZf04l3q7/DzjSHOZ
97iMO/PY7+ySm89D4mN6A0h8otPMHnnsf3ZZP8rDgYP5EgG4rKPlsc7jolRj
pQPyyL255I/zsES762kujDw3PA/lGleTta9Ok0fu3cWTRkDJQ9Q8bfBdLJyo
SYc89j255GDzYNzHoy77QfKo77vUN/KgKbI/Zf368ltunzw7Dy++ot+kS64y
j/3VLvWMPOjT9aWsfbxxHjlRF2tMgTwPRm6WtY/Ty8MenZbI+oX79E/OI9fn
UlfMo47p4mGzofNY93LJfeXhOQOquOwzzMP9RgCV52ESjDzWD+R8X9ttZ/jB
PFxvwEAXf/0zfOzKo3msJ/jtXx4MTSprMy4qIg/m4zzlUqfIg46OwmW95aFZ
p4ek5TGOl89vBijksU7jAlr2K84jNyb7Qz/Gyjxyii77dPJgzPNsl30zeTBy
oKznGQE/D6+ZRmKXdfk8VDfpBMJv7/IxXcscsvb1XeSzDijxe8PBtQd75rN+
IfvRJOb5uNw4IPFvh+ZJiJiPj3Q7kqzF+bz678B88rUu/Wg+FpuGYYkXDIid
T95W8qkRWijKx1TzBV3apXzyty7rXPnkMF32+eez39zle8+n7izx8Ik7Fx6f
lQ+DI8i66Lvkzl/My8fz5o+LN0zjez7rIy6MnL00H8b9vOCSM81nvcQfH+Zj
sAnQXPYZ57MuKvGAln825bPPw4UZ57I9H45u33zRJS+cjznmwLvkXfKRocto
svbpnPkYawIYl7pjPo7o47rQhZH9j+fDtA3J2rTvheWzDu+yPy6feZ3LPr98
1mNcmPAgK5/1GIknzUCQfPLBEs9qzLc8n9yPSz44n7ywy7k/+dDWXk4WdYJ8
bK7SG8hlvTsf7baKe13icr5UAeewSL60QhNEBajQ6d6rks8se+6NyJ4F7Gt0
mTcUMO5xMWrRU9sLri7AT1pGl/XXGr+4voBzIVzGWQX4oEU7DH88V8D6jwud
/d18dwH7alz6qQKYdlFZ+/rXCmDC4ddd1iUL6NdcnvMCmOOw3EXFp5UP1c8p
YN+l5CemkaEAJjxbIc/n6/FPDnqlgPyyy39XQC7GZZ2ngDyzy/kVBRivsQNZ
z4peMTf3owLuO3++XMD6kotjepzargJ01f9c1j4utABvmgTRpW5eAK92X2/K
+TADTgowyzTIuRgyWJ+4Aph06i2Xc9EKOLdA/OUELcQXsI9O4g0DfBXApM2r
JX7RZe/sApjw/m0XBtsuKoBpG5W1GdtVUcC6sN8eFXA+gEvuqYCcqj/+KmA9
y6WOU4j9uuwia5+uUcj5AS7z+kKcfV+/cJd5biE5fpd5XiF5a5f6ZSEeNkKX
2DNtvoYUkr92YeSOWwtxi26nlLUvLiwk9+i3P4Uw8vw6f3xViLbPtYF36TcL
6Wdc+o1C1stcmHR9TiEMxi9rXx9AIefQ+PPTQgw2P1D8ty7TLy+EaauTtW/u
QiG6G4PokgsvxBo5XamyNmP5Pi7Es0YYd8nPFCJTyzkbXeqJhZxn4JITLsRR
3QYra18feiH7xiTfeFMrHIX4TE7nAVk7enudLKSO6ZIbLaQf9cdLheyjdNl/
W0g+XM7reu3QC2HS3U9c6r6FMB9H1hcasLyQc9Zc6qCFjAtdzv0qRDuTALmc
w1UI40a2uNTNipjXSP5qgKsizm2S93+brpgU4TbjQF3qBkXYq8cUfuqyH6uI
9T+XnE0Rz53LvKkIZ7S5kLVvrk8RFpoXJvY76L38L8YWoViHq9vlfJ4dLCes
CEYu2SHP0wDVRZy/4LcnRTDYqax99fki8uou+0CKYNpAZO2bM1JELs7lnI8i
mMcta9+5KWJ90a+/FbG+6PK5FeFGkzC7WKvTx8+L4JuD6cKEVXuK0M0Igv74
pghvGQPmcq5AESw9rk/WvrpUEWabgMxvP4q4z1xyv0X4TZu/r1z2kRfhGiOY
iX02AG0R66ou6ydF7Kt10ZahGx6LWL8Uf2KA4iKY4ynr9frxtRb55HRZG9zp
bBG/h/i/27UgUgwjR3zjUkcsJk8v58eAhsXQ6uZpWR++XTc2FpNDcamTFOMV
k6C46Nx6k3iUYnLwLnoZkK8Y04wA4zIPLOZ8Ccm/DXhXjB+WaIcn+dBiTSoU
sz4q/keXox8rxgadtsjaF9cV408tJ/7oj0+KYcy7rH19PcUwYd6Pfv2qmHUA
l3a7mHUziafM4IViGHOzVz6faZgrhhkzJGtf30QxOWz59xqj/qqYeZTLPoFi
6qzy742AU8y4RJ6faVwvJu/vci5oMeuxLudaFrPv30V/IzAWs47nco5qMefi
yXk24H4xGnQ4IGtffaCYv9flPMtizr/w50vFMD9O1p/q9rV/izkPw+VcvBLu
W4lvf3yvdU33Epj06FcXF/XTCmoJ67viT3Q7VL8S1uldBOu23utLWGeU/a/b
CIeVwLSXy3q+AZ9KyLFIvqnL2Cghl+xCq7ftJ5aw38CFngJ368Ml+FuPC5S1
wSdnlLD/wEVfMyCpBCXHtGGQfFZjwgtKqPu55F5KcEpvP1nfYASTEtaPXfrB
EtaPXfZTlpCDFfv09dfnf/JpCYysKOv063XBswRG7j3usn+9hHGly/dUggnm
AbnsFyqBSf9OyH4x4EQJzDgOWfv600vYx+6PF0qw2gxacMnrlHDuict5WCWc
5+HXa0qYJ7nkqEvYB+eyH6iEXJ/LOYslnPfhwow9PK8UnUwC6pKLLeVcXr/e
Xco+FNdMtVrUv5R2yyVvUwp9Ostk7eMcS1kn8McDpexj9ustpaybueRnS9k3
6j/fpTDpbITYn1c1YVHKvM+FadOYX8q+Ppdzp0oRpd2drH1xZSm5D9lfeszT
mlJyUS7jglJyjZLf6baaLaXkWl3a+VK8aAy/y3lQpcwLXJgxRPtLWU93Yca7
HimFkZ9i5f0bQaiU9XWxN2N1xbOUOp3k/wakK+U8Ypf1v1L2ibkw4/ZKSxkX
SP6n26ZrSzmvxPWlr04pTLgk60FaTv+rlPNLXFxuBpaV4XojYLqct1TGOqQ/
Xyjj3DWX82jLWK/3679l7AeR/ajljpvKyPm67KcuY3+IS+6zDL9q9yLrtWm6
AFgGk76kyn7yATLse3PJx5dRF5LnawK6Muh/vV/WvrytDKack+7iFlPILfOZ
aVkbzOetMhiMWNY+zqqMPIBLrqkMpryQ6dLvl8GEe7L2+bUyLDYCkcs5Q2Uo
1XJDlnyepoYrzvm9jLqpy/6+Ms7bdTlvsgw3m4KeSx62jOfUX98q43sV/17b
Z0toaRlatfya65JnKCNf4NcXymDKgXkSHxvBrox1Bf/79MDgArL2zY3wkKNw
yft4OL9X9o/Gjbp72Eftcs6CB1otrZP1PD2e4lIPfGG3Sz7ew7kuLv5drTud
POz7EX+h25Gu85BX8NezPNih5ZNil7q9h3M1XXLNHnLfLvvmPewDEH+uw/m7
PORI/fVbD/tlxL+ZRiAPjJxc5lJH9MC4f1n7+ro91K3F/mp881EPTLopax+3
6mEd0UXD7zvlE3vIQ4g/uEmTAx4Y91Tutyce8hEuOU0P5w27zNs91IlcGFxz
mYdz1MR+GsHKw3kyLvM+D17S4bmsDf6z1sP5Mi7nrHnIwbvMIzzsz3E518xD
vkL220O6c8bDON8l/+shbyHxnRko6IHZfrL2xVkeGHm8TvytGSTh4VwHv3/y
wKTL9S77Dz3s43LpFz0wcm2Dv/7r4fxjf7zqgUkDGl1ySB54NeYqa59d85Df
cMkTe8hvuDynHhzW5SzLH896yMW5nCPkYX+Q2G/TeOXBOUYAFP+g20GrPPRz
LkwZut7DvkXxB7rtyfJwzpD4bz2GrMkDn9ziIkjLWH96YMYbydrXj+0hD+KS
DyrnfByX87fKYcrPTS52avykaznn5bho//7DPz7fo5zzclzO2S1HhA4fZO2r
65Zzfo6LmQa4LuccaZdzPsrRywjiLoaYglY543SXfQrl7E+S86nLhjeXUzfy
2+Nyck8Sn+jy5B3l/J7++KocxvzK2jfXoZxctuSnGn+bVA4T3svax6mXw8hH
p13q0OUw5kDWPp23HKZ8ccblPK5y1ildmHL/s+Uw5fS/Xc6bL4eRN2Tt67sv
J7/iYtPRx0o/WVLOOTgu5w2Uo16Xc8+60HT1c2+Usx/KJcdbjiT9eGXtm0df
Th3WhcEVPyznfGmXeXM5+wr8elA5dRLFPuZycjCK9eZy8i8KI6/VCkw5+RdF
7rKc/IuCwad/KSf/othHW07+RTGuLCfvouhPysm7KM5NKyfvoshTlJN3UTDl
uoRy8i6KfrScebuCwdCyysm7KJixUfnl5F0U48Vy8i6K3Fc5dSHF/t9y8i6K
fXrl5CIU9305eRfFeLKcfIvCALMBy8m3KIzSYzbaV5BvUbw/oQIm3ZK1j2up
IO+iGG9W8L8rmHJB7wryLgo7Ne57eQX5FgXzda6qYF4qz0tjW9dWkG9RML9u
UAX5FgU9fWrYsAryLQrhuo1kRAV1MMW+mArO21acs1JBvkVxLkoF+RYF3S2X
NbGCfIuCwUserCDfonheKsi3KPaLVpBvUdim5YdZFeRZFHX8CvIsCvP0mLMX
KsizKDxlPmAFeRZFbr+CPIsiZ1/B/jPF+KiCfItiflNBnU9xPn8FeRbF/rEK
8iyKPEYFeRZFHaWCdVnFemIFeRZ534/pjo4K2jnFOY8VrGso9q1XUJdW2Pf+
gtfO/a2CPItinlVBnkX2x+khae8FV5BnUexHrSDPomDGQsVWUIdSOKKvK0iq
IL+iOEevgvyKwhQjUFRQ11TkjSrIryjE3qon21TgkC739VPsV6ogv6Jgxtw0
VpBfUZy3UEF+RTGfriC/omDM7d8V5FcU59hXkl9RKNBtoJ0qyaso9jlWkldR
uN0A5JXkVRTfWyVMOX6A4nOoJL+iqO9Xkl9R7KOrJL+iYMZmDq4kr6I4R6mS
vIoiZ1BJXkVxPlIleRWFf7Ucd28leRWFPXpc9/hK8iqKddpK8ioKZhzotEry
KgrzDdhdSV5FMR6rJK+i8LIZ3FFJXkVR360kd6KwXY+vXVRJPkWxvlRJPkVx
XlIl+RTFfupK8imKfRuV7BNS0Lv34Q8qyaso8teV5FUU7y+pJJ+iGG9VMs5V
uMoMZqtk3URxDmol+RTF+Q6V5FMUXrtRT+CoJJ+i2F9ZST+uMMcMIqgkn6LI
W1eST1EYrse8x1SSTxF7qNPmxEryKbIf9djt9ErqrIr1zkryKHI+tAxdVEke
RXH+QyV5FMW5hpXkURR5j0py+4p8dSX5FMU5fpXkURT1w0ryKAojzOCxKvIo
inPrqsijKCT9pRtYq8ijKN6PUkUeRdFuVJFHEfut236vquK9OPL8LtEEZhV5
FEX+o4o6g/jT8nsmXjK8ijyK4nzGKvIoivXRKvIoin2IVeRPFCYZQaWK/Iki
d1BF/kSxbl9F/kQxHqpiHqxYR64ij6JYh60if6Lwtin8VZE/UZyTXUX+RLHP
qor8iYJp23mjivyJvO9aPWinivyJ4lybKvImivdtVMFs93GKfTpV5E8U9esq
8ieKOnIV63riv74pmnL591XkT8TfafP3cxV5E0VetIq8iX8/V5E3UcjopAXf
KvImCqZdOryKvInfflexj1ZRd6gibyL+Sl/3lFFF3kSer07H86rImyjmkVWs
Iymc0XJfZRXzRAU9FeGh+iryJop5QRX5EoXC8l8TLm+tgpFnZO3joatoxxTj
/2q+dwUzVrRzNXkTxX7zavIminpKNfkSBTPur081+RIF0+bTr5p8iSIfWk2+
RKGrDl8HVZMvkee1KXnAmuHV+ETjOA/77XM162QKO/QYqLuqyZfI79djp8ZW
ky9RMGOuJlZzn4q90untQ9XkSxQMdvBYNeMUiZd0+P1kNXkSxTn21fx7iv0x
1eRLFPX0avIlinPaq8mXiL3sqzshqsmXKN4fUU2uQLEOWE2eRLGPrZo8ifx+
jQdtqea5kvNoBqBWsy7oj8+r2afp36/VrAsp6u7V5EkUdetq8iSK88KqyZP4
441q8iSy/3T5N6KaPInivVHVrDMo3G2AnmreF6A4p6SaPInivJ1q2gHFvoxq
8iSK8zCqyZMo3i9UTX5EwcgGTdXkR8RemEJLNfkRxbkP1eRHFPu/ajhnQsGk
K91qyI8o7N2qAcsa8iMKg02BsoZxp2LcU0N+xL8/a2i3FI7q9H5QDfkRf/xQ
Q15E0e7XwLjf+Qqm7e7uGvIjin3bNeRHFM9pDfkRRX2whvyIxC86nZpeQ15E
8TnXkBdR5JVryIsodLu3++SdL9aQF1Gcw1ZDOyvxk26bX15DfsQfH9eQF5F8
SOMZ79ZQd1Rw9df5sIa8iMIdsy65+MvNNeRFFOuONeRFFPsIa8iHKPIoNZwf
J+/PAIk15EXEv892/l35aw15EX9+WENeRPHethrqTor3A9SQD5HPp68lSqgh
H6LYJ1VDPsTv/2vIhyjqdDV41ASOinxBDXkRxb6cGvIhinNXasiHyM8zhdEa
8iGKc0pqyIfIz5umLXQt+RDFfu5a8iGK85hrYdLw1xXnYNSSD1GM02vJeSjG
tbXU8RX1xlryIYp8Zy15EAWD142qJQ+iOJegljyInM+WF8QH1pIHUezjr2Ud
SM67ZOuLp9WSD1HobgDPWvIgYj9NQ0kteRDFfV5LHkRxX9SSB/HHp7WsK8rz
NS+8lnGpvK/Nl/388Zpa8iCKemAteRCFzkYArSUPolg3ryUPIudHj5/cVUse
RLHvtJZ1bMW5Y7XkPxTrerXkPxTnd9biY729ZP2GSZhqmScq1lVqyYMo3GgG
UtaS//Dvt1ryH4q6di35D8X71GrJfyj88I8e1FpLu69gyq8NteQ/JH8xg/9q
yX8o3sdTS/5D4g097vzfWvIfCuZ6qk515D8U58LUkf9QvK+ljryH7Ec9Fv+y
OvIeiv1IdTzninlMHfkPxbkfdeQ/xF9o3H5kHXVaxTiyjryHIr9QR95D8f69
OvIein68jryH5OsGQK/jPEDFuQd15D0UzHVj8+qoWynev1ZH3kPxnNaR91Aw
4d2qOvIeEj/o9u936sh3SLz3lB68Xke+Q7E+Usc59fI8dXlnRx15D/Hv5oDW
kfdQrMvXke9QrFvXUUdTrOvWcZ8q1j3ryHco1gXryHco1s3qYNyyrH11pTry
HX49q452VlEPriPfoXCbaSStoy6h2F9dxzqPYn2sjjyHvF9z0Ucd731RMOWY
s3XkOxR1tXrW/RR+12PMu9WT71D4+7PR4gHqyXcozuGpJ8+hmNfXk+eQ/WsG
BNWT51Cca1yPe0zDgD+eqyff4feX9YzDFeea1JPnUIxT68lzKPZv1pPnUIxz
6slzKN4fUs95iAoG31xQz7qXIn9eT55DcW5oPXkOBeMOVteT51D4TrLRLuvr
yXP49aJ68ht++1TPfSL5mB43tqsetxqBVLF+Wk+ew+8P68lzyPnQY2YP15Pf
EPult+PxevIbCjV6bF1YPfkNf/5QT35DcZ5wPfkNxbpcPfkNxblt9eQ3FOdp
1pPf8NujevIb8nl1m7CqZxypOO+invteUSduIK+hqJs2YKApYMr71ulAjwby
GwpGrrukgXUXRf2/gfyGnHcD3DeQ1xB7pq9THNJAXkPBjKG7tYG8hsJ1RnBt
oF0Xf2MG2jew70niIT0+b3ID417FPKGBvIZi3NxAXkPsoR6nOaeBvIbivMMG
nmtFHrOBfIbkA+NTI3cvb8BlZoMqzqduIK8h+ZUeL72+gbyGwuEEDaQ1kNcQ
/7P0u1nrtzeQz1A8Fw3kMxQueVBHMA2sQynet9TAe2AUf08D4ya/ftJAPkPy
eT3mNKKBfIZi3byBfIZfH2ygnVK856KBfIacD41blTWQz1CsszWQz5B8Tst9
dgP5DMU6TAP5DIXX73r+m1v+bSCfoVg/aiSfoZCsryW7oJE8hiJP1UgeQ1HH
bMR2XY6Wta8e30g+Q+IN00DVSD5DsQ+pkXU5xTnjjbS7Yr81/jO2kTyGwlgD
FDWSx/DrGY0wcmy42HczcKqRPIZi/2sjeQzFuTaN5DHE/i3Vg2obGTcozlNt
JI+hGIc0kr9Q9MuNnIep6KcayWNIvj/72C3lnzeSx1Cch9NIHsMf3zTSj/jz
u0byF4rvvZH8hd//NMLI9XEKZgxobCN5DMV7pBvJX4h91u3uuY3kLxTn4zRy
H0k8rHGZmkbyF4r1xkbyF4r3YDRSp1Psw24kf6E4H8dL/kLxPgcvdRA5P3o8
RW8v+QvFezH999gqzvn3krdQ5DO8uNoI7Ipzw7zkLxR1LS/rRgrmGtf7vOQt
FHUNL3kLheEmYPCSt1Cs73nJW/jjEy/ruIp5j5e8heL9U17yFor1cC95C4mn
dHvjOi95C8V7v7zkLRS5Ty/tuOIcYC/nyinORfGSt1C0k17yFv783su4VAXu
tfbxFYrzT/33Qis+Ry/5CkV+w0u74K+feclb+N+/l3yF2HPdjmZ7yVco3hfq
JV+h2HfvJV+h2K9pka9QnFNoka+QfFqPu7zUYt4m9tdc3Oy/t1TBXPN3vUW+
Qva/Hvs7zKIuppCrx0SMsshTqMA9l3caIELhuRv0ZDOLfIXk80YQt8hX+P2D
Rb5CkZewyFP4z79FnkLyJ92u86pFnkJBn94zqyzyFArTzAO3YNIJWfvmCVnk
KVTgHjYfT6E4P9kiT6Fgxs58b5GnUPSbFnkKhd7mYjiL9/Uoziv03/upyFNa
5CkU+yMt8hT+fNminZf4UI/xL7XIT6jAvT8+fkIF7tnxcQcqcK+Nj6dQgXtk
fPyEPG8dPp1nk5+QfE3Ljxfa5Cf8erdNfkJxrqJNfsKvb9vkJxTnldrkJxR1
bpv8hGI/mU1+QvEeUJv8hOSvBnDxz3lW7Ae3eY+m2K+xuqHFJj+hOGfMJj8h
9tUMgLDJTyjOJ7XJSyjO/7dZN5b8zgzcsclLKM5psqlzqcAcbh8/oQJzr328
hMKtfed9uvWITV7Cr4/Y5CX89XKbvIT//drULfz5qU0/rWCubSq1yUso3t9m
k5dQnJ9hk5fw6282+QgFE262d/jfVWBuqY+XUKzjOuQlJF7W14Ff4ZCX8Ncv
HPIRivPSHfIREk/o63lv88+tUZw/6bCvUfFeDYe8hOJ8Yod8hIIZiz7TIR+h
OL/FIR+hqGs55CMU7xlwsFmnT/8pbNfXGq12uI+b2L/vnxPSBDMG6BOHfEQT
7/9zyEc0Ma9wyEM0wYSH+xzyEE2879dhX2YT73N2yEc08f5uh3xEE/2eQx6i
ie/TPwe2ifdbOuQhmvCOSfgcxl1N1Bcc8hBNgbkqPh6iKTDHxK+3+ueG+Out
Pm7B5ft2A3Mw/Lyef+6En9f1z3nw5V9uYK6Cv//EP8fA35/lnxvg7z/09+n7
+2X9ffD+/m5/37l/voC/z9tX/3cDfdX+eSn+Pmbf/fZOoG/Ydy+iE/g9vnPn
BPpgffqEE+g79c8X9Pd5+u61dAJ9lb57TJxAH+ObptDiBPoGffNm7ECfns+e
24E+OF/8ZAf6znz3L9qBPi+fHuCfl+3iadPYYAf6mPTtpyOeswN9Q74+EjvQ
l3ObaWSzA30wfrvr7zvxcSt2oM/DZ8+tQF9F9Fu6km4F+hZ26rAkyILBCPa6
zFusAJfvE/qsAAff01xkbQW4c//9wf5946tvWQGu2sdRWgFu2XfvqRXghH1z
Ua0Al2uujWnywoS/GS51OG+AO/Vxed4A1+njlr0BrjJRl7l3ewPcou9eXW+A
E/Tp6N4Al2eufZzrpR33c2PeAGfmm6Ptpd1yeU+EN8BRjVifutDb0xvglnx8
VmOAE9K3Vy1pbAxwObnLtGVrDHAvvrmljQHOxHcvYmOA6/D1ZTQGOAofF9bI
e68U9ejGABfg4xAaA3V4X92sMVD39vUtNQbqzD7dsDFQ1zXjxi5uDNRNffay
MVCnNOPTvQ2BuqAvfmzg+fLrGg2BOpdvbmtDoM50YIu+IKQhUNfx6YsNgbqJ
GWOysiFQp/DNoW0I1AV89x40BHR4c/3dmAb2QSrOzW8I6Mq++TQNAR3Xp7s2
BHRT336rD+iSPjtcH9ABzfVwyfUB3S17vp6M/X+dy3fPZT15VX8cWM/zJHHr
nbrxpD6gk/jyjPqALuHLU+vJDyneP1UfyLN985TrA3mtKZP2rw/kkb57vusD
eZvvHtY6cun/1xV93LefI6ojZ614X2kdOWbFc14XiGvr9LVXX9cF4sjZ5oKQ
ukDc5rNrdYG4yMch1wXiEF99ti7g93337NXRXzVhpr5+8aa6gF87orGavnXk
5ppgMMDz6sipNTEvqeWcoyYsNEJ7LTmrJt4bV0uuqYn3u9aSG2qCGQt6oJb+
qSlQh/BxL02cS19LzqQJZrzx67WcI9LE+85ryUk0cX5CLTmEJugpRovG1LLu
34TU27TjrmVdvQl/aGzxslqelybej1jL89LEueE19KNNvO/TX9dsQoWWUTL8
dUT/9/PX6Zqov/nrYE3Ud2vYh9zE+65rmM82UTetYZ2kCacG6wtna1iXaGIf
dA11/ybyHTXU1Zs4d7yGunUT++hqqIc18V7TGuqwTYE6sE/nbGJfSDXPRxP7
wqrZVyXv1wxiqKYu1kT9rpq6UxPvPaqmztOEq7X7/qSaOkoT61fV1CmaeH9W
NXWAJvZxVNO/NLHvo5q8URPnlVczb2zi3P1q5mVNAW7Cl/c00S9UM69oYh2y
inF8E3WYKsbJTfR7VYxDmxlHVtGfNHMOdhW50maYsSk7q3gemvmeqshBNvNe
jirOyWrGX3rM/rwqxmvN0FPv7ny0ilxcM/mbKnJnzZw3VEWuq5m8YBU5qWby
p37uqDnATfm4nmaYtgxvJbmZZt4/UkkOpZl2qpKcRzPc4jdPVJ2oJEfRjMG+
QhvjsWZyE5Ws+zezvlbJunoz7xOrpF1txvuLP7ql77xK7n//961knbWZfdyV
rFs2009Wsi7YTN6xknFuM+8HrWQdqxnVJzRoXEH/0AwzBtiuYLzVTJ2lgnWN
ZvY9VrBO0My8voJ9lM142jSyVVD/a4YZT/xlBXXkZtrbCuqyzeSoKugPmjlH
uYJ9Xc3kRyqo0zUzHqugDtZMPq2C+70ZpqxxQwV1m2bO1aqgLtLMvroK6gzN
jIvKmcc3M+/09xU0U4/yc/qyPj3p2NQ4P/fezHuh/Bx5C/2kn8tu4bzkcu6z
FnK+5eSGWziHs5wcbgvnGJZzn7ZwH5Wzf7eF8/LLOSeshXOyy8kxtjCOKmd8
1MK+onLWR1vIj5dzf7fAlA3+8pADa6F/9VB/bOH90h5ySi3UVz207y2Mkz3k
aFpYf/GQS2lhX6aHnEcLvJd6Nyz+yMP8ogUGY3zTwzkVLZzv4WGdv4Xz6D3U
q1tgrk160MN8ooX+ycO4q4VcuYf2vIVcuod1xxYYLPpCD/OHFpzdEyUZhId1
sRbe11PGOlMLCsw1kWXsu21B07EXPuv4cxnzhRbO/y5jXaGFcV4Z+yj9n7eM
9ruF96D6+/haEH2enhzh74trwULTGFRK3bMFPQ0YUsp4pgXmur8TpdTlWugP
S5kPtMCUqVaXUjdq4X2RpdRhWhB1gW6MKqW9buEciVLa+Vb2H5QyD2/lnIsS
cv2tnBdcQk6+lfWrEnLmrYG+XN/cwVbGtSXcv60w7mxGCbnhVs4NLaGdbuW/
K6F9buX9OCXMn1shydHs86uLyVW28h6kYsYnreTaixnPt/Key2Jycq3k4orJ
nbWShysmt9XK+2KLGb+3YowxaMW0x630a8W0x63cL0XkWlqZBxaRC2mlPSzi
fQOtMGWqzUXkFlrZR1nEun8r50j55yK0kvv2zxVo5X4u4n5thbkeqGMR7W8r
dZZCvpdWzlEvZF2ulXN3ChlvtMJcV769kHWjVrxtLqApZF7ayjlDhaxjtHL/
FDL+bmX+WEhdvZVz5AoZX7TyvvMC2ttW1g8KGG/L7zMXyRZQZ2zlnNQC6nat
5MQLqIO10k8WUEdqox8uYHzdRv9XwL6ONsYRBcyb2rjv87nP2thnkM/92cY5
k/ncn23UX/L5c9s4fz+fuk8b4+l8cshtvP81n/FzG/PQfOo5bawT5TPObmNe
nU8Osw37x+mM1z8Hqw2F5xwM35KTR+6vLTB3yzdnqQ3/6bLLN3nkztrQqrGq
DXnkttrQOFrf+JzH+LiN92LlMT5oIyeYR86mjdxXHvWYtsCcNh/n0Ua9PZec
RBtmbHl+yK7UXHIGbeSOc7kf2/CMeSC53I9t5GBymR+2kTfMZZ21jXMlctkn
3sa+9Vz6nTa+x1zWydpgxjz9m0P/38b6Qw7rMm0w14wk5fyvp7N9rboM47gg
dsgopRTFLEO29MUEiXKa6ZVPCVGRL8SFUbYiKV9EFkEFZib5QBHVMMWkdLmc
ztzcppub287Zzn47ZzvbecR6kywsfVGkBbuffln73X7WP3DgHO5zX9/7e30f
8I2OgcNL3Jdj8KQlePUx9uYleOkx8rhK+N7Gz4M3IpSY9wrdZQmflaI/qoQv
ScH3TuTSKnicidxWJav9B07knCoZjWKQmorMdyU7o7XhwSL4Vck8XxRV5Pwp
+IQiuneFb78I36HwIxTRWSt4mSJ4VUkQxQRMKjLPlSzyAL1AjpqSWzVEBXSj
ChxXQGep6AstcB8q9koFdH0KvWeBXCRFbkSB+a3kUlSvXlkgZ0fRK15Ap6To
mSuQ26LA43l0MUpm7Zpbs7iQR0eiyJHNo7tQ+KDyzGuFzyRPDoOCP82zF1fo
XPPslce/v1cO5jlvSiKVWqx8IodekfecZ++nxEY1t3/n2JMpdFI59kyKPsoc
exklPla1PofvU6EHy8G7KXB+jvtOo0fO4bvT+H5y7Dc0OrkcPi4tR6Nay5k5
3gFa5ldGN3gWnKilNopluZLFR6PZd2fxnWj0IVneRxq8kWX+annEF+Fk4dO0
+NqZ17PcbxrfURYduRZfS7osC17U4mVJD2TRb2r5en8UVJ/lfGnxsqDLI+he
NbmsI+hCtVydFJ+7YscI+FCDt0bQHWqpiWLY547Ah2nxsr3fh9G1aXIzh7nP
NPh0mPmq0aMPg2s1e79h7hEtaz1BmUGnouHvM+g6tHjZ0sEM+E//3zN2a3+i
Zb0vOMswTzW6pQx8sJZp1VunHrk0xN5W874YYs+pxduo3xni/tISsR3BE0Pw
VRpd7xB7Ji2+pvO3id5AIz6mu3WQc2zk24eipIFBzpMRv1bdOIgP0MjuKGah
fJCcZ0OOfRpfmeHdlsZnZeiTSYPnDPdVmnlpOGdpclQNfGYa34cRX29WSsG7
jX/eoaigPgV+M+DLFPuN8c8bn+bV61Lozg3nP4VO25DDM4Bu2YCLBtD5Gnp2
BtDBGvq4BuCLjHT6ZpMB7icj3vY8FvC/MOhbAvhTQ49UwDw04usEXg3gJQ33
X4DuyYiPGY0FnB8Dv97P+THcc/3oIww9Qv3oMAz9af3oFAw9bP28F4x4mcS1
JPeRkXW+MDnJe9eIr8velwR/GfjcJLjXwjMmeUda/OV97AOsvO+D//qYdxbd
QB9+Botuto/9mhVvW17eh+/Pym2+QLcPvtKSC9rL+9XSd9OLj8qSO9gLvrLk
Vvcy36z4Grn7e8k5tfJ5RTTgEuB9K5tujxo2E/CPVnys4GcJ3qeW/WOC82J5
ZyfQgVt+lwQ8jkV/E2eeWfSZcfQzlpzXOPeNxScUR4dp2b/E0SlafFQ96Pas
RC03vzb3wJ9Yeid70HlZcnp6wEuWedUDP2jp8+hGN2OlzBeHdKMrseQadJNb
YeF7utAlWHJ9utjTW3nUF8d2cb9Yeo8vwvc5WRrFiD57Ed+3k2grv/NGJz5o
JxtmXLvn3S86wZ0OvNIJHnfojzrwjTr8Cx34KJ085YPcOzgfjl6QC5wPh8/1
ArnGjh6CdvgMJyq1YefCg+3cJ07GXrxal1nazj7HyakDb9d89FMb/IWTkxVT
Oxa+14Zvw0l94pvRzJw28I6TG+dXrKruOI+u38n1pwtbY8+fR+fuZNmaN4PD
4TnmvJNdS6ctWHzkHPsYJzM/be1uXnEOXbCTE6Obqyp/buV/72T5kihZsRU8
7WR4/4l9K+e1oqN06AdbuD+c7P1ryqKyLS3o7MZ/j7qWmwcmtaA7c+CoZvCM
k5ah+TM2r2pGp+SkXH7Z1DB6Fp2OkwNNRw//8+FZdCtOYmUvXX5m/ln4YAeO
agL3OtkRXP9xpLqJ8xDKskNtG6dPbuI8hLIyvfeOx2sb2X+EstZVxd9Y0wg+
DmXBrJe33Bec4b4IJVk5Y+Xm2Bl8waG8UpW899D6H/DFhvJV5Z5trXtO4xMN
5YXSc4sagwbmSygPvlXx58lYAz7BUP6Y/m/j8fWn8M2F9Dye5P0VSm0qObsq
qAefhPLllfauabF69hMh8/YE/FUo2+ccm/rBx9+zDw/ZH9YxT0K585POhn1T
6rgfQikvyy+5ufY4eCSUxzqv9mzf/R38VCjX7r7rYrK3Ft11KDWvPdw+e3It
uuNQiju2LXhy9TH5D6u4dpg=
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{0, 1.7924}, {0, 1.1267}}, 
            "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {400, 
              Rational[800, 3]}, "Axes" -> {True, True}, 
            "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3],
             "DefaultStyle" -> {
              Directive[
               PointSize[0.003666666666666667], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2], FontSize -> 22]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 1.7924}, {0, 1.1267}}, 
           "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {400, 
             Rational[800, 3]}, "Axes" -> {True, True}, 
           "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3], 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.003666666666666667], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2], FontSize -> 22]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{
       Annotation[{
         Directive[
          PointSize[0.003666666666666667], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2], FontSize -> 22], 
         Point[CompressedData["
1:eJxEnXm8zVUXxhEKRYlSSkmpECqSBk9RxkoaREUSpVCiDJWkUCkhlFQ0i5BC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          "]]}, "Charting`Private`Tag#1"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, "PlotRange" -> {{0, 1.7924}, {0, 1.1267}}, 
        "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {400, 
          Rational[800, 3]}, "Axes" -> {True, True}, 
        "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3], 
        "DefaultStyle" -> {
          Directive[
           PointSize[0.003666666666666667], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], FontSize -> 22]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListPlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[
    Rational[2, 3], 0.6666666666666666],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 22},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->Directive[
    GrayLevel[0]],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->400,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1.7924}, {0, 1.1267}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8740462852646914`*^9, 3.875067332078759*^9, 3.878273172320476*^9, 
   3.878279843556305*^9, {3.878286832252067*^9, 3.878286845492338*^9}, 
   3.878620248876781*^9, {3.878630302131282*^9, 3.878630317402557*^9}, 
   3.878630373780332*^9, 3.878631649023448*^9, 3.8786404017037888`*^9, 
   3.878720107155607*^9, 3.878792928129101*^9, 3.878794251117948*^9, 
   3.8788762771454687`*^9, 3.878881147688599*^9, 3.8788897105490303`*^9, 
   3.8789593348058043`*^9, 3.879079563482098*^9, 3.879401082240946*^9, 
   3.879485191427039*^9, 3.879564752106358*^9, 3.879570879222921*^9, 
   3.87958007621537*^9, 3.879580202859318*^9, 3.880520596892555*^9, 
   3.8805290135253677`*^9, 3.883048449096051*^9, 3.8834732726944304`*^9, 
   3.8835527315899363`*^9, 3.88355362799996*^9, 3.883814114041725*^9, 
   3.886051657235148*^9, 3.886133521066736*^9, 3.88615279248459*^9, 
   3.886160134325367*^9, 3.8878316547046957`*^9, 3.887876678124831*^9, 
   3.888056666131798*^9, 3.8881577701684303`*^9, 3.888166964471385*^9, 
   3.888169438699597*^9, 3.888170570664886*^9, 3.8881712168720407`*^9, 
   3.888192094087452*^9, 3.89132582301684*^9, 3.891928779522863*^9, 
   3.89218061506117*^9, 3.8924406183228197`*^9, 3.892464422751994*^9, 
   3.9045434498989687`*^9, 3.904635299026251*^9, 3.9058418565716743`*^9, 
   3.9058473318753557`*^9, 3.905860659117084*^9, 3.905873443039711*^9, 
   3.905907507392538*^9, 3.90644440421949*^9, 3.9064519385905848`*^9, 
   3.906515252932824*^9, 3.906516690040028*^9, 3.9065235757861967`*^9, 
   3.907047887105036*^9, 3.9070550860327997`*^9, 3.907057367060746*^9, 
   3.907821891055884*^9, 3.90833482679851*^9, 3.9083352522734118`*^9, 
   3.9379000912783337`*^9, 3.9379011416278133`*^9, 3.941680903950447*^9, 
   3.941701655157255*^9, 3.941701961664255*^9, 3.9417026512027283`*^9, 
   3.9431656863256073`*^9, 3.9432119989802246`*^9, 3.943215156857855*^9, 
   3.9432152922112446`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"94c0a807-9895-c84d-baa1-8489f7a25d4d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"t", ",", "Rt"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.860123007884138*^9, 3.860123023228994*^9}, 
   3.860123106921097*^9, {3.867241174197057*^9, 3.8672411799646177`*^9}, 
   3.8787936014332523`*^9},
 CellLabel->"In[79]:=",ExpressionUUID->"f7ace83e-a2c8-44dc-816a-e5374122ad89"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.003666666666666667], AbsoluteThickness[2], 
        StyleBox[PointBox[CompressedData["
1:eJxcfXf81tP/fqJoKKE0VZQoDRQNujSVhoZRWpTsREtKpWGVURr6RNFCIUmk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          "]],
         FontSize->22]},
       Annotation[#, "Charting`Private`Tag#1"]& ],
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.003666666666666667], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2], FontSize -> 22], 
             Point[CompressedData["
1:eJxcfXf81tP/fqJoKKE0VZQoDRQNujSVhoZRWpTsREtKpWGVURr6RNFCIUmk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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{0, 1.7924}, {0, 0.38326}}, 
            "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {400, 
              Rational[800, 3]}, "Axes" -> {True, True}, 
            "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3],
             "DefaultStyle" -> {
              Directive[
               PointSize[0.003666666666666667], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2], FontSize -> 22]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 1.7924}, {0, 0.38326}}, 
           "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {400, 
             Rational[800, 3]}, "Axes" -> {True, True}, 
           "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3], 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.003666666666666667], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2], FontSize -> 22]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{
       Annotation[{
         Directive[
          PointSize[0.003666666666666667], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2], FontSize -> 22], 
         Point[CompressedData["
1:eJxcfXf81tP/fqJoKKE0VZQoDRQNujSVhoZRWpTsREtKpWGVURr6RNFCIUmk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          "]]}, "Charting`Private`Tag#1"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, "PlotRange" -> {{0, 1.7924}, {0, 0.38326}}, 
        "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {400, 
          Rational[800, 3]}, "Axes" -> {True, True}, 
        "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3], 
        "DefaultStyle" -> {
          Directive[
           PointSize[0.003666666666666667], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], FontSize -> 22]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListPlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[
    Rational[2, 3], 0.6666666666666666],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 22},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->Directive[
    GrayLevel[0]],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->400,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1.7924}, {0, 0.38326}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.860123025368617*^9, 3.860123108007057*^9, 3.865570763922553*^9, 
   3.8672411810476027`*^9, 3.8672412386299973`*^9, 3.867241357862873*^9, 
   3.867302954007525*^9, 3.867905616561429*^9, 3.867913851979926*^9, 
   3.867915445075165*^9, 3.867924131820669*^9, 3.868526670208596*^9, 
   3.8685305512288513`*^9, 3.868535812692483*^9, 3.868541574902804*^9, 
   3.868541700795364*^9, 3.868547018724393*^9, 3.8685900685570583`*^9, 
   3.86859714630857*^9, 3.868608834105626*^9, 3.868609886737398*^9, 
   3.868613400182427*^9, 3.870171605827497*^9, 3.8702461891806726`*^9, 
   3.870250802843052*^9, 3.870753081867594*^9, 3.8708345918875847`*^9, 
   3.870851031076109*^9, 3.870931154767756*^9, 3.871456180765819*^9, 
   3.8714591162387667`*^9, 3.874045886409535*^9, 3.8750673334811993`*^9, 
   3.878273173816787*^9, 3.878279844239736*^9, 3.8782868463021917`*^9, 
   3.8786202498579683`*^9, {3.8786303028736057`*^9, 3.878630318448422*^9}, 
   3.8786303739610443`*^9, 3.878631649744602*^9, 3.878640402616662*^9, 
   3.878720107849152*^9, 3.878792928875444*^9, 3.8787942520386343`*^9, 
   3.878876278110527*^9, 3.87888114852255*^9, 3.878889711334271*^9, 
   3.8789593358001633`*^9, 3.879079564395422*^9, 3.879401082338333*^9, 
   3.879485192372991*^9, 3.879564752190277*^9, 3.879570879975699*^9, 
   3.8795800768316383`*^9, 3.879580202956357*^9, 3.880520598085696*^9, 
   3.880529013623811*^9, 3.883048450208576*^9, 3.883473272782549*^9, 
   3.883552731685281*^9, 3.8835536280921497`*^9, 3.883814114125133*^9, 
   3.88605166104261*^9, 3.886133521642264*^9, 3.886152792585094*^9, 
   3.886160137265869*^9, 3.88787667823699*^9, 3.888056666199691*^9, 
   3.888157771928269*^9, 3.888166966394018*^9, 3.888169438791369*^9, 
   3.888170570781056*^9, 3.88817121843265*^9, 3.888192095112177*^9, 
   3.891325823856555*^9, 3.8919287806815557`*^9, 3.892180615652792*^9, 
   3.8924406189894943`*^9, 3.892464422809607*^9, 3.904543450992754*^9, 
   3.904635299075213*^9, 3.905841856625147*^9, 3.9058473319238853`*^9, 
   3.9058606591826773`*^9, 3.905873443111081*^9, 3.905907507446917*^9, 
   3.9064444042674294`*^9, 3.906451938650793*^9, 3.906515253704887*^9, 
   3.906516690105721*^9, 3.906523575833675*^9, 3.907047887153141*^9, 
   3.907055086081812*^9, 3.907057367789847*^9, 3.907821891105476*^9, 
   3.908334826847454*^9, 3.908335252320979*^9, 3.9379000930815926`*^9, 
   3.937901144549284*^9, 3.941680903997757*^9, 3.941701655226776*^9, 
   3.941701961781267*^9, 3.9417026512344074`*^9, 3.943165687696018*^9, 
   3.9432119995549107`*^9, 3.943215160165825*^9, 3.943215293067461*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"b11dac8c-0d9f-8a49-8d59-4609ee8bab0c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"t", ",", "eta"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.860123007884138*^9, 3.860123023228994*^9}, {
  3.860123106921097*^9, 3.8601231326854677`*^9}, {3.867241244321414*^9, 
  3.867241271744285*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"f764e36c-c220-4d76-8f89-19d85d2d469b"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.003666666666666667], AbsoluteThickness[2], 
        StyleBox[PointBox[CompressedData["
1:eJxEXXmAjmX7lSJbVIhUSpZC2UqW4lgqWyRLCJFoIWUtkrRIpU0REqU9FaEk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          "]],
         FontSize->22]},
       Annotation[#, "Charting`Private`Tag#1"]& ],
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.003666666666666667], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2], FontSize -> 22], 
             Point[CompressedData["
1:eJxEXXmAjmX7lSJbVIhUSpZC2UqW4lgqWyRLCJFoIWUtkrRIpU0REqU9FaEk
M2PMvi/vzPu8+/bMvm8iLV/1u69rDr/++b43mXne+7nvaznXOefutuiZaUua
NmnSZFSrJk3kf/d8JP+cwI72NX2+/J+NlG+adM7dfwKjwt8/2Mt8Pn3s8Z2X
fHsCPXb9t+3Fv210TcrpMPzHE6jxtkiq+svGxPzB25/55QTy3p/371jz+Vl7
7xVfnTyBXyYeHrr3Txuf1168zZ90Asefn/J85A8bOf9b2vbyrBPYe9vnPw8x
n/9qlf/2Pc4T2PfoqN+fP2djzMISx42BE/h0e3hI7O82nn76vvtnF57A/sQX
1l9kPu954afsdypO4LPfukTffdY879Yu9yXWn8AX3U/87/Uz5nl3v5zxx7kT
+HL6rJGZv5nn/aZ8fL//TuCrV89uams+Tzx2f+qjzaOQ2CecdtdpG++3erT1
6LZRSHrohVYvNdg42TnjzWc7RvHn2qjoNbDFD9dGITXq13eam89XDd69paB7
FEoe+cx9e52N+Vu/z4jtG4XS99F5Xa2NN3dfOeHMoChcMuzmR76usXHs6/Wp
vYdHodmTKZ9XVNso+Nm+Z8HoKFz60eLiW8znm1udefOuCVHoOWryrXOrbMzs
PLfFqqlR6LWi6ulPKm283CthyzezonB3J+t4VoWNtA2ujM0LonDPuFV/tjOf
9W8/FoVHax8aM7Lcxg27v0itWx6FxV3/fPXlMhuP1/zSOnttFF5JLsj6sdTG
jr+v29p0YxQ2y3KU2Ihr+VqLoZuj8PneJ2Z1M58vXbD7vo5vR+GLrObmCW3c
tvy/jInboxC/uq7ggyIbzydc2e7mj6MQ6eLtE19o42vH+nfmfx4Fe+KzT11i
Ptf2fCdv+HdR+Lfh4WODCmx0uf3M/SuOROG/bv/8vta2ce+YuTlf/RqF69JL
8GXExju7nr7y1bgo3Lki5438sI0TX7m2/Zoahbv2P5XR0Xy+6O9y68PcKDw0
bmb7u0M2xk/9X+fVniisqx0xb1XQxpqHH931bTgKOz/s9dX+gI2Yn54NvFYa
hZ/valeb47dRHh+aE10Thfyic3f847PRv1PDvt1no+Bsv3PdKPN5bs/Z1+b8
LwptB6WnzfGa/fr8soXfXxKNvr4jV7zhsVGZ++KXb7SJxoSX9jz0i9u8/3DJ
jbHto/H4Ta9+Uewy7/+2Px/7+JpovJazrPpK89n8x9+v6x6NL9bOGDzaspG3
c3XvQ32iEX/tiBefcdroXL1l+VuDohFJ7Jm6L9/GgtF7jjwxPBr/yLHIs/HW
/RcN+GR0NIa8OdqcBBvOLzus2TAhGjMH9DnQ3nzu8tdNv85+IBqrPVeeHp1r
1rPFe3e8Ozsa77/49/AVOWY958s3iMaPPYtf/STbhuvosdjxT0SjYqxsIBvX
tkhv2mtFNC6t+u/a0kwbi+cH7714XTR6flC+pIP5vG3Z2OShm6IxdljeoTEZ
NjxxD7a86vVoPGKfOLci3Zynq5ZO/u3daHz8b/W4rWk2Hlu28X3Hzmi+NxsH
47a5Dn4SDc99sb7SFLM/O3559VtfR+Psb1/f2NF8vmvZ8flPHIrGgCv9q/ol
23hifdfgvmPRmHIiIXpeko0fcwbesOFkNOQtvJVo4/fu9yyenRyNr18Mz/gy
wcbI9bO/HZwdjSRZvnib6x4NE3xqquJsZHffNKA+GI1rqwrv6GI+d1j/wZrs
4mjMMt/itlPmfZvd9111NNYe/jf3kVibcSMa22eVdd520rzvdVmjlvwvGtlr
uzx5IMbGwJzI5jGXxKDq2ouPeqJtrO/+W9r1bWLQ8847mjZEmfOzrvll/7SP
wdjCrpOuN58vzbn6Af81MXixybSPh56wcX/3Wz883j0Ge78ZXvzYrzaOnKr+
5K5bYuBOXn77S8dt/NmhSdHVt8fgzFMPbjz0i41RS9vfdO7OGPR/683s1GM2
Xj/Va5k1NgaTB6266vefbeSa6HtkUgxen/rVY+3MZ30d02Pw1bl3fhzxk9mP
pxYOeWpuDCId4/978Kh5vrk3jG54NAb/xBwY/9oR83xHbjNLFoOhgeDuTw6b
52s+Lv371TF4UAOEjZ1zH7rszQ0x2Lb/j4Glh8zznbu6U9vNMTg0ruD5Duaz
hqm3YlBhdsutB83zfT7q07TtMei+edw1434wz3duetFXH8dgdN8Bi9d+b9ZP
E0sMNkx49Od3vzPrpwE1Bh/VTzKPZJ5v5PC1JT/FwGq7abL7WxvdA3++uDQm
Bm1vPbqv7hsbSwdcljguKQa3WHtKrzOfj752w6U9s2Lw+OnsO4Z8bd7vjfbl
31kx+Ozyi8yS2Jj33G8zXg/G4NTxCnNybcS2/+nhNiUx+Mt1rQmNNuNwDDQs
fW72X7MtPzx9NgbytiKfmf33kD4Z3j6xrOWf+22c+/GH23s3O4lUzydzrjSf
59z31MhDl51EyYvyzW189tmmV97qeBLX74s6PecTGxePxNuXdz2Jh6Jrxqze
Z2PS9mmOmp4nsW6R+63P9prz0V82/kkcfallMOpjG+bQm8h0EjVmV1h7bJgg
fJNr5Em0vrfn2qbmc9TJLwc+NO4k5BRc85GJh+1/XTvk/pN4yfzWwbvN+f3x
uU0xs04ian/skim7bMip+WjBSXjHfXPohZ022n42MbvrEyfR/jH/vx9+aGPl
iFaeL1acxOTNl93/4w4bv35w3TUvrzvJ92jjmv6hHs1fPomvJvQu//0DGxsz
9/Z7682TsB+fN/Ry8zn5hsOrnnj/JLpsee+N3u/buOnkMy/UfHQSM79M8I7Z
ZmPrnP5bVn1+Eqsnfd9t5Xs2as7Wvnfuu5M4+GR45dZ3bdw+qallHT2J8tev
SPjiHbPfyiRAn8SNX9995cm3zX4zWSuceBLzk54zK2bep2zfrJPYoAHBvM+Y
JiYjnMSxN7ebTGaj+ZUdkBI8ifpvUiYNedO8z0PO8ZNKTqJPyp8fT33DRuZE
eQEnscRk2ydft9GvbNq8mb+fhC7fFhPvXr3SrMxJnJTj8ZqN367Pf2bBpbE4
lyqJ1saDMe+vL24Xi0Glh0xENes1+4FXn+wcC5Ps1v7zilmvs5e/U3tDLLQM
MJ8lGq7uHYvk9H/a3vOyWa/SIv/UgbH4r2zAgodfMuslaWNYLIY3lzdn1ut6
ydyxWKMFllmv6Bv/iEyMxY9jMu7/bqONZZ++m9pmRiwqFv7zaeILJr7dOcWU
WrG4tEVpecMGGwO8lwWuWhKLMb2uHtbafJZo9/HyWLxw931v9njehj7es7E4
vmiTb8R6G7MP3vfHVy/GouGlo71nrTP7a0Kbpn1fj8Utn5asX/GcjetKM1sf
fi8Wj2khZHOfxeKzwKQuX6y1oWFufyxOvXL7o3lrbCxsery29EAs/tz/+E+V
q20kfvLsH8uOxuL2U3suvsR8boyTsXg6lD39ulU23vCcbf1sYiwO/N3kyztW
2qhafazj35mxMEHQnEgbT+oBiMV1Qx+/+8lnzPv7za79IRSL2Q/u2fHK0+b9
aWCK5fc09dst8gSxyP6gyeBjT5n9rgcqlnHO7Pcf3go80eQUNM0vtWGZ3VHT
4hQWPnu/SWU2pt1y/OcuV56C/PT+T9r4Oe3Z2E+7nGLetDHoh8J3srqfQru8
8raLHrfx4fjPdz1wyylMrLtmwYbHTHwolkLwFPQ4LbGxNi17xcUjT+FU31f+
O7jYhnfxO8+/ce8p/DlBCk+zn8bL/zuF258o/9ReZPZT8a/Th88+hae3XFP/
5yM27kjr0f3xR07hwJdTRrU3n7VMfPIUihJe3nbLQhudtAA6ha5aSJp6rLhd
8082nMJs3WA29+0pbJdjPd/GQ4vvjNz/zinuG5tx4RRaPPRyt+/n2rjTZKWL
Pj2FMet+Xpn0kKm/UvNf7/ftKWzUg2me5/uRs+YeOQVZpXOzzfOM+3ehfcKs
z9yLTelknqevROhTuPx5+S/N85hq94NMsz67n/x71oM2/vjuw5anrFN47Ze9
k1bONOvz7kW+qpBZHyv3460zzHlbufzbzmWn8NfpptVfTDfro4HfrM8Vd9x1
cpp5Xw1S0J/CM/2ffNv9gI0DS1/59u8mcTgweW+wbqo57xKWmsWhaFnuLS3N
54/6dP7QahmHrqbKvfF+s9/ltbeNg1QNd04xz9t28+KL2sdhe8oT182cbMP9
37CsXZ3iILvp6fvM+22ou63ftXFocXHuydcnmf7iVO6vK26Iw5huTU0oNfXG
EUlAcdiIwQ9HTbBx9xd3vrGvdxykqnGON/Fff0AcTm+QCsmGVO8Zg+Jwy56c
Kc3NZ/NSTIaOw6v97/u61b3n830cYidvMqWOjf/mpr/7zqg4mEN074i7bf77
ONy2tWTng2Nt/t44yKo9M8bUUwOrkqdOicO3Ev5G2/j7xs9uLZsWh8JiSVDm
fHeY9eHGWXG4TsoXmPwr5cq8OOYZG0P/SFj83cI4fCDtywizfyqkAIpD1vxJ
aZeaz78E+t3ueTIOl77wYudud5n3pwsVBy1b77R5zuPwgm5kEy+sXlNqn4vD
L+5OLZcPs2GC87HNL8Sh4czEOVuG2vj3uCScOPRt/+KBT4fYjLtxeGzgkT9/
vcPGC1pYxmH//cUT8gfbSD+8dcig9+IQWN5pT9Xt5+uNOHR8e2LlJebzvTt+
b75gdxye6pY2uuVtJr9LOt8bh2/w9/s3DrKZ1+NQML9f4Z0DbVwh4fDrOFz7
wiODZg6w4ZDy/vs4aHjpb+LfjgHO33+Mw/u/ykGwYZqJ4e/8HIdM919mZU3/
+dzez7ufiEPzs7eujrrFRtnbN9dcFhsHc1gTnX1t1qlx2KCFj9nf25eaCB4H
bTv7nK9f4lC//K+fru9tY8Vz7qejHXHo8/atpmU06/H2IlNKx0FO54ibzHrI
svvjEANpyM16bP9yWa9IHH6ff8X/nulp4ulrDzljiuIwUAO+OS9SJpXHYZk+
qI3tb+99bURNHL6WqvdGG/ZnNztuOh0H2x26y9XNhoa/c3HMYyYefysHLA7S
bV1qPg+N/T3rgybx2DbwuVu7XX++HopHWcqZzT272pBuoX2reOh2us7kU3+S
yXzxmCfh4VpTX2Y9b1YiHju7vbt25TU29hY0N18pHnmIT97axfRnv39gTmI8
Wj8snYINbde7xePeF24yKcj0D/9Y6yp6xUPbr0421zke0dKOX2X6HVn+AfE4
65ZGxYZJcuaox0PLtI42dvfvb0rMeLy+deW/vTrYKLk7ulVvxCP+WwmwJr5r
YxmP/6VIgWfDNGmf/jM+HneUtKpbdYXJP5sXVJZNjsdKLexM/DC7MH9aPKS6
+aqdiR+mqntiVjxKTTcb29bUr3L85sVjhKvbkMTLzPv95cTAEY/EQ8vSNqY/
zbzHfLN4HL1CMqGNlgV5KVcsi0d1/+ib2pnPM/XFxuMmc4pubmX60daVc0vX
xOMR3eA26szudayPx96tMzrPbWHit6TXF+Ph/vb1J9ZcavbDpHfv/OrVeNw6
splpTcx+WCiVWjzjpI1u8tffiWefa+LFoRbmSMYjZLqBpItNf520w2S4eHQ6
ntck3NTGDt8NZgvFY5rrkgfOXWSjwGTjZz+Lx9u/DTElt8nHCnTEo+iNY390
aGLi/9XJqyZ9H4+7JN38G0FqvwdODj4cjyNyjP8XwWdSJhyLRy9p3/6KoPYF
CWjx+NhEkTN/RGCSx6bxp+JxuQbGCF6X8JkUj9decPw052yEfWg8bvsmc9Gi
3yI4dPaeMXNz4vFt0UATeiPEk+JxnQIhEVhjb4961RuPDwSeqomg25y4S54O
xRN/iRBfiscLAqtURjBe0mNZPBquGGha4gh2xAxPfak6Hp9KeV4awTNn956J
bYhnXxmB7KYDv8fjTfn6RRG0uEEq03jiHxEUzpaVTMDqfskzl0Qi6P/0FxfF
NEtA+dK+v+8KRdDym2b9/2qVQPwiwnozAa3la/giGKCNcwJeavtbSTNvBK36
PWheaQLOSjh1RzBLG88ELNVGMcI4kEB8IcJ6NAEa9hwRzDareaRfAkzRd5Uv
J4JBmrAS8JwCRRFouBmaAJOMZ43MjGCOlLsjE7juEeahBLilnUqN4KVPVxaM
Gp8Abf+SI3jI6zSdXALr+AjzeAKejiszFX+EeFYCiv43+ea74yKYu6DHzyXz
EjB7mFReESi8tiiB/XeEdVcCNuzv2PloVASVLSfdtf+pBNQHN5iME0HSGOks
ErDkalnpCC7XH5QA/0wptCKo2vaxiTgJuP+DQx+98FOEdXkCFMY8EsGnTRfe
9eqWBAiadvzHCNbfmfBk/FsJKBv87JuVByOYoYV5AuatCva+7ocI+h3ckjRi
ZwIEHbn/O/O+pQz/OAH3auCMsD5OgJzmY19HEDNLCu4EPDmtlWnlIti1rZ2p
lBIQfnfFQ/WfR7AyfeU3aw4nYLommAi0PTqWAJN8P575aYT1cwJGaKERQZM1
EtESIOjgto8j8P/w17zlyQlQuOSjCMa0FMQuAa4y2WARXDvmwz0jHAmY2CMv
8+adEfz+vFSICVCYYEcEcqpO+BNw+759bd79IILvq6UBMe8ndXf0zm0RtJ9w
ZtDWkgTMukQqkwhqXn5wYVplAgQl+fvtCHHRBIzWRjFCXDYBGvbeNPt7qnyz
BPZfEcaJRPglrLwWQWx8p17TmyXi/vl/3pL7agS9uk41oTcRSR8tyL7oFfN9
Zx19tPvliRimgEkET0j46JiIsiaCqJnvW32f+ZWJmDdCOlHzfXsKgpSIPIEl
n49gs2zDnom495ffTCaJ4GFteBIRbbr1S5+LIOWqV67dMSARAyRNrI2w7khE
eI408Ob9/nCtKaETMV0TWIR1VSLSpEx+JoKJo4/vuv3eRIwQuHG5eV8aABNx
dNKMZy57KgJTtJrImch+IwJZzZ0PJrK/iCBX4Ku5iewnIqz/E9k/RPBJD0EY
E9kvmP2pAE8iCj8omlKxMAI9lisTMSt3gvkJJn5dNeDluc8lIst0cVPmRyDd
es0LiRitfxBhn5qIXzZLQI3g9KVS6CYSR4iwX0iEKdKvr5sZQUKcAL+JmGJO
a7cZEfS57of/Vu9ORKKpGmdMi+ASLdgTMVQBmAiekrL1i0RoGzklQlwnEYJq
J9wXIf6XCMfd3vozEyP4MrXOVEKJuOflke/fNCGC1j1ufvHtE4nEPSJY/dLC
d7ueSoR+/XsiUNgqKRGCUnw4NkKcMhHTNEGa/SvtRm4iNL3A7N/To3MfcyXC
BLVFt46MYIOMIfyJMMWjiUxmP353tG6rnUgc1rxPBUYTYW0UAC8C2X0/ViVi
QtRjp7PviKCLAmqJ0LJocIR5KpH1ZwTrpDz8XyLrzQjML7ttUtMk1pcRKIx9
aRLryQh+PCIbJYl1TQRfDZSCJAkKb/eO4LJ3P5hV1jkJjyrwHsGayozH13dN
gveXm38a3SsCQW9b90iCoIBrekSQb6qJht5JSOgvicPk0+4TN7zaPwkrTbT5
8YYIPhe4anASSk0UL+xq4pGMdYYnYa6pIjtcF2H/kQRHO0H0Ijgb8Ly8+t4k
KJxwdQRaRtyXhN+e3ex8pVME037t+lrVA0k8lxH2G0kI1U3tUN7efL8dS954
dH4S++wIFH5flIRUab8uN99PG/QkrN3e2WylCPuLJOLuESi8uSYJC9pI5Wa+
34G+n5asT2Ifb+KPtJubkjBBG7MI+4kk1qnmPMo2eSsJT8kxuzhC3CoJBTev
N62oeX+me263y7yfJYKYhonTmffz2T0mYoSxXA98EtZrwAvj0UXSsZr300IS
dxizCy9aMv2QeT/3XPb1I3+EiWea92NWbcfvYfxiTnnmiSRoW3ImjMZ2Ogk6
1jgdxmcC2yUnYYUG+jB2jlxjQmkS50thvB0rQEsSHjLR6vGaMM5IeHUnQWH8
qjAq9qQPCQSTsFGBzTDnMknQbV8WZj+QhMdfHHxpi9IwMrpIoZ+EYNTH3wwv
DkPbtzNJ0LReGMYxafP/SuK8Jozv9txQObJJMucsYezvIgBhMn9vGJJdWrVJ
xsOe/t7LAmF0HilIXjLaaIERRtvYAaYlT4Yeb0+Y+Ggy81AYf56UBjcZGhac
Ye77ZNi/JbYoyAuj+OTSJQn9k2GCwPGK3DAef+T+O/83OBnaXuSEMV8PWjLW
7XrrjylZYcaBZNQ4BTgIY7zA1uOSsUgLgzDr+WRcfuf08pgU874uEWQqGa89
d+KNuqQw42IypDu7MTEMHeMtSMYz9a+lz4gPo/+3z3zkXJIMTWenwozzyZwf
hKFl6cpktNgx+URCdBj7Jq2c6XsuGRs10YZxQ91M0/om43QbmeSE0fEZmdQl
4zEdMIXxkYwPtyaj4xpBzMPQ478tGVsPF1R8eDQMLad2JuM/Gb8cDrM+N++n
96E+fx8KE39Nxo0zDvguPhiGdPs/fJvMusOs/8YbTSlk3o8WWGFskXb0Z/N+
BI7+JoyWSVV/NYs270fK6q/CnKsk48sVAhyH8Yqk09RkXH3wi+9afh5GM4Gb
s837qZDCLIw3+skCmfejA8wwNh76ZdEmXzLPVRg6Fokko5eMCfeEOYdMxsey
nXaHWZcn81ya7yPjzdPm/Yy5xJQyYWzSgsq8nxeXxqzZbr6PlG//JuPbA0uW
bXzffJ+LpcJPIY4ZZn2dgg9uFCTPnCeBDa5I4ZwzDE3bnVKIO4Txwfs/Hf7m
uhTix2HOe1NYJ5r3431h3jV9UtBBgY0wcYQUvLnhlo3lr4Tx6fUykUshzhHG
jTpoToHCiJvCrJ9T0O16mfiY/XZrxlPbJqRw7mL2mxaWKWi9O+5g9PowzJc0
gTGFuEoYowSmmZeCfnpAw5gaGWS2XAoUhlpjzvsrnSQUKJozb1UYs3r9bxqe
ScE7P88wJWcY/nTbRL4UaNf4dJj1cQoOXyNPEsbTt790fNQrKcRLw2jwCICZ
Qnw0jKb6BVNYl4f5XlKIf5r4Jen34xQMGjrx4X2PhrlPUmCK3H9zHwmjjwaS
FFx75CqzpGEc7CQZPAWmSDGNYBix4X9M55SC5n2KIo/PC2P0K4WmEk3BMXn8
h8z5nrDvpV4J5v28f3f/L2aH4aqWgtS8n+zvcl0PhlHykwx+U9C+1RUrWswM
E09OwRv3PmeOfBg6bgykYMjKVafGPhBm3DPv56B3wbP3m/OiL9K8HxP1DkwO
Q8vROvN+pD2bFOb82LwfoQ1MDJMnkcI+KIxEgWmbpqKfvNZ7w8xTqfiiuXPA
C3ebeCZwbbtUdNbCJUzcIhXvbJIfEIZu+2tT0TSm2ZUdEIaOgW9MxeFSKXjD
2NPimk8e7p2Knt0lEpp8Yr51df9U7JFyeZjZLzvloKeinRIswsTxUrHZ+9GY
ssFh1k2p7PtMvK2KG9Z9YirxsjD+O7rh9OGpqdzXYeK6qcTDTPySccz8VOJf
YQzUAjkVP0u47BOG4/Rdv965LBW9572XcPbmMOvTVHxisv7NN4U5d0hFewWQ
zX4aLxk2FW/IOKh7GO3b3fzxqtdS8Y+0h93CEFRwxtup+H6dDF7DrEdToW32
dWE4pQz/KJW4rVnfKTIpSWWfbOLVsOf/F/46FZskXHQOY7uMCQ6mQqaye68K
s/5Mxed515mWMIwxOphLJU4cxnRtCFMZN8zzPyormoqLdAAbZh+dyjrO5Edp
U12p6FF75Mxnrc3zB/OXjg+mEpc251VgwKJUtNWEHMYjmthSoWOh5mb918kE
MhV/RIRQEWZ9mYqvW8lAMAyJ8i3+TYV02980CWOyAqFpnGOFoOP81mlopoPp
EHGtNMgq4O8QFLa9Og033yQdcojrmkb+TQg6pu2Vhiv3f73z4NkQyiff0+ft
W9PwerDNEPu3ELYMlUYsDcLCuPJ0iPVjGiTL3VMfwh2V3bqERqfheg1YIUg3
Gzs+jThKCHLq9t+fhpY6MArhiu8sc4LToOVJeYj1YhrnAiFMEfh7cRr5KSFI
1u21LA2dfDnnpheF8JbAYKvS8LaM8wpCEDSmYl0a80yI9WEa5w4hPCZj6y1p
0DI6GIK2te+k4SPZnv4QvqioXrxiRxr5ICGM1kYgDa8+LQOIEOzYtuZkpXGu
EWIeTcPysr8PNOSH8N3x5r9MPJyGwu6LTMtt1lPGRcfN+5kiDW6IeHEa82YI
7T9+b9nY5DTOTULEh9NQJ7Sp9BCmrjjyeXNnGhbL60kNEQ9Og0/TUAiCklxX
kEacLIQT04fP/q/MvJ8iKZxCrCPN+7mhh0kpIbx6nxAJ0lA6TzrBEOfdaZir
Y2+z3vK6L0lnHRDC89OFIZVOPkOI9V06fpNjfjzEviCdPI4Qiu6QDikdoWNS
SIXQThu7dEw7XXntxUdD0LKrXzqaaIIOEa9Nx1odrIfQ/D5BptNR+eHRNit/
CBGfTceC/M4mk4TYN6azrzT722S3PtPSMUHC7DchaLk2Jx2xrwsQGoJUZx8u
TGdfGsJLG6WDSieOGcL1SgBIx4M6kAhhktCY1qYjU7bHvhCekzZnYzpGCby7
1+yPD4ZfNHlzOo4JjWtPCLn7hQCQDk0Hu0PEU9M5ZwtxPp7OeXuIOE8641gI
m3QB0jHkH997Hd4357Hsy3Pv/JiOH4aNGjDuvRC8Mi79JZ19udmvApOeTOfv
DeHk4MMzX0lOh6D1x94MkeeTjhNXC+IWQsdpL06rcaZDw+GWEPl16fweIeKf
6XhAf5B53v1vmkozHVr+vGSe91B9v04N6cSZQ6y/0okrhDCsdkdb93/pUNhl
QwiCCrW+NAMKk68PkV+XAQ3rz5n1VWJXBkwR2+3dtWZ9teHOwKD3/hcftzpE
/DKDdXSI/LoM8pZC6BRT3nf8bRnQ9P90CGNlTD48A9rmPWX2g/z6MRnYcPJv
cwJC5NdloLcOGkIwTXlV8tQM4ioh7F0uC5ABbb+XhMivy4BUUw8/GsIrB6+8
pe3jGdDX84jZv+Yt7Ho6A8LGSVwQIr8ug3kxxLouA6YJNqElhMBUYRBloJUC
GiF8KGXU2xnQsDbbnLefv992ensGcaEQ+XUZeFIbjhB5Khk6/fnftBD5dRnE
lUL4Vo79kQzyQkJ45M1LTeeRAYWbJodwjbSLcRmoemvzL3snhVgvZWBhWuWD
uRNC7KsyoPD++BD5dRnEtUJoqgk0g/PIEPl1GZw/hrBWC64M4mJmP0qYP5vB
+WIIepz+yWAdEsKAT0aP/e+STM4PQ+zzMzkvNO+/kYjG+WAIVQ8KsJXJOBEi
vy4TCuPcZvKBwFR9M5H4yz0fXTYohK/bzTclcSaG/va9OUEh4jqZ5N2E8I3J
aveMycSNT617/qtbQlyHTJjm1nTOZj2v+3fPDw9k4l6nz1TKZj2l3ZyTieh2
kohDnMtnYoCMb3uGoG3NE5l8LhP/BZ5YkQkdg3QLkV+XCU0/15vzLXDTpkz2
wSHib5mQpxl7bYjnPhM3SbnZJQSFdXZlcm4W4rw+E1d0XW5K6BDrm0xskTFg
hxDxtUz8vXPY/Kvam3gfl/HZPb9kQsdaV4SQ0VEIjJmsQ0O4cllD7yYpmeQ1
haDjkexMtNCBQIj1TCY2Cu22ZYhzi0yclnKrRYh5OROP64DbxJ8GGXxnIvhE
k2deviSEWGnfz2biAaGrNQ2xLslEitBRm4RYv2RheNfbpl79XxA7ZFzaJgsV
Mgb8J4jAqaP5X3bIwsOv7fh0xt9BdO8oiG0WnPF/4fU/g1i61PfQgh5ZGC+0
hHNB8uuyuA+DrFeyMEjGl2eCyHlHGtUsfPPT9vgHTgfRUQcRWbi2/s9HNtcH
iW9lkVcShI6lZ2QBAttUBzk/z8LP8tcrg6xPstDbcdPpHhVBmCLviRufysIn
baRzD0KmBv+tziKObp7vc2kEsji3DZJfl4V/4iUhmOdbITsjC6v+7dXhRts8
nwLUWSgbLh1cENqW7M3Ch1ImBYPkuWWhlRKtg9DH+yELm2QM7Q1yfp1F3CgI
pT3GZLEvCuIPoeslZSG8/XXzREFkZ+k/mO6oMZEmiM8FBrOykNZmRsqp3CCe
i/20S/9QFkYoIBrEfUpUzSKPJ8h5cxYWakMZJL8ui3EniBE6YM3CRA3IQQja
5GiWjVMKgwVhgkq3pm2zcbvQwxOC0HB/VTYOyPGMD+L9RwQxyUZXobecCkJp
bb2yib8EWV9kE38Jkl+XTfwlyPlvNvpqog4SH8rG/iEdDwz4JYjrNNFmE38J
4nT+5EWXz84m/hJEqtAsFmYTfwlib5IQ4rKJvwSh23BFNvmRQWgYWZ+Nh3Xg
GsS303669KGXs+EM2623Hwiidd2qKyJvZmO8FvRB8uyyib8EMVba6z3ZWCa0
ly+D6KxAXzbr0CDnrdmY+feaux7bH+ScKxsZAqd8EsTRfjJwzAYEVtwbZJ2Y
jZ8Pf2MiXZD1QjZ6yxj9oyD5ddn4RNLfriDnpdnkDwaJ12SThxEk7z0b2l68
H+Q8NBvft5QNGST/Phs3KFE5iJfHygrkMA8GIV3+0Mtz0EoJQUHO/XOwSejM
bwTJS8jBGRk3vx7kPDMHT64RhpdZr1uFEJaD8OHlDzz2apD1QA6mKQAYhIad
sTnsA4Lk9eTALNagfzcGya/L4bkMkieVg16Rp1Y/+nwQWkYsyYFLjvW6IPn1
OZh4b07CJ88G8arQ4J7NIR/O7C9TXf35Yg55MWZ/KYCcQ75bEENvXZc3a1sO
+W1B4l455LOZ/bNEGGU55K8Fya/LgSkie160NIipCfeZkJgDidq3PRGEsFvv
js7BY/pPEF901U4Wgc+FwG/iQfQj5v/mECcKEnfNQfI1wuQKYo4O+nOwRok0
QUxQ4nYOyl/5y2SQIH5Y3Sbt4boc8oqD1G3kIP9vaSyD5AHkYpx+sSDq3jtn
OqNc4lZBaLl0ZS7jaJBzhVxIlf7ktCD5dbm4RgG3IPNyLrY9JgkliPa3SKec
i2ZasAZxsQ6mc6Hpf1IQmubH5ULHZxOC5IHlQumy44Kw+spkOBe+HX1jMu8J
cr6WC6UnjA3ipjeiTGbPReJlf/xvwBizX5bJm8/FSi0gTDyXv/ZCLkrXSIYM
4rWqB37t+lou5mqiCWKtFuy50HA5PEg+fC60jRoWZF+RCx0fDQlyTpwLqV6f
HBwkvy5X2SN7bwtCuu83onJxtQ4yzfNIuZGYi3dnizLAPE9bYazlkmcW5Hwr
F7KrHrvFrI/QvMK50OPcJ8g+OheLdAAcZJ+eC88WIcQEsUgB6Fzcl1h/xcCe
QazQjeaAsMcf7R4kb8QBhZ27BclLcRA3CJL34iAeE0RYyrH2DuIxQey74quT
8Z0cGKuE/CB5QQ7yaIOYIennBgfxmCBxIQfxmCDnWQ7iMUHiUA7iMUHqbRzE
Y8x5M1F56xAHntWCMEjemgMqd2gdRIrQ7kc5oLBxS/M+ZRxwjwOudUJMD+Lu
B2QC7KBOyKzn2AePPz/FgVMNIoQKIuH2NtdfMd2B2/tJRxIkn8FBXmKQ+KyD
cS+A/1pK5+XAdhnX/hMgTuogTyQAUwx36rvUgY3Szv8ZIC7roI4pgPjCFaWz
VjvwuA70AxinAdeB4BVTWj98JoDm2mg68IA2EgHyGxzULwUwKburScEO3Cnl
UG2AcdaBwxcLEhGAoHTz3nNQfxRgP+KgzioAUR0d3e1AO20oA9h+4JUHJuxz
MA8EiO868OdAIUgH4BWa/NcO9pUB5j0H56wB6Os+7MBsHZcEoPDIzw7qNgLQ
NvGEg31qAIc+ESGYA8eFPuoLsC5wUJ8ToO7EwTo1wDmQg31vAFLNt8tzYOu7
xaevzzfr/4kAxQ6IqmmaI8C6yQFNJzlmPb6SBsKB7hqYApCq4PJiB3aLTCkj
gI/lx5U7cJkegAC6aSPs4FwkwLrSQd1KAKIWueucg3qWAOeIDqhMLt7sDynH
muRBj+Up83wCNzTLY50egMLsrfKAaXdvmRkTwCwliuUxTgQ4Z81D78zLU6N+
DaB3s9DD+Z3zoOPCXwL4UeCI6/KgdL5jAQyW7XtjHt54SRJxgDzDPOpDApBp
0D9988iHCWCGwEkD8siHCbAPyyMfJoBe0yUy55EPE8BqgQWQxzgXYN+Yxz4l
wDl/Hs6tlRUI4IOdGYErpuQRnwmwz80jPhMgLyGPcTSAI0kXZ3w9L4/4TIB9
eR7xmQB5FHnEZwLYeYlMhvLIWwiQZ56HT2Wb7gyQ95GHDiIH2xEgbz4Pb+ZL
gRZA+hwhNOXh37by5AHO6/Kobwhg0eb6J4reyKOeway3VF/v5FG/ECDOk4f8
JuGmLbcG0E4Jx3kYp4SeAOZqY56HmPXfjX16SwDfivzyszwMNLtu/+YAeUR5
+Pq0DNwDaCG0oO/zqNMw72eaIDZ51G0FiMPloZkOxALcJ3nkiQeQduyzRXtP
5ZFHGIDCoUl57FPN+TNdzJ70PPhkXPBsAHdqIsrDZCUYBjjfy4PCFKvMeTBP
c9CbhyH3C/PdfH9hz4XyoLT7ZwI6VfihMA9Kj1geYBzJ43sJQOU71XlQ+OxJ
sz9V2JBHnC6ACTroysPZE/6t/ywx73PsW0+V/Z2Hpb+P6jtgcYBxNx9a3iwK
QOlzzfOJ+wXg+HXFDT1a5yP9eylkAqw389Hsr7s/6TE/gHPNZRCYDx1zzA2Q
l5oPLcvnBKDt9vX53IdmP4vMqkc++TEBtFaBZz75MQHoeKlfPvkxAeq78smP
CcAEg679huXjoNndJ6YEcIMKN/NxY5fQ6Or7AvhLYLex+dgl9IxJAYj6acf4
fLTRwBuAwsyT8/FyrhRSAfK98/G7wIT3BMjLz8ey8cFHK8YGWMflw94sg7oA
EqPnmZ2Zj5lKgA3AXTi9yduP5yND0sbIAOeA+YDQGO4KEF/Px88C+wwPQMdT
z+Wj90+je109zMRbkQ28kI8lCkAFWHfnM04EcGuvO673bMknXhPg3DWfeE0A
Bbv+Wj/9/XziNWa/O+Z98/7OfOI1AerJ8lkXmvct4Xh/PvEac943CJPerI82
dgEIm3Dr9/mMawH2afnkS5v41VMQ+nzyowOsn/PJhw5Qj5pP/nMA/RQwNOsj
bUXXAFrK+C3TrM/bl3ddfq3ZT7J8jnxs8Bf8mN7lfH7JR/1VgqQFyIsw66NA
agAKL9j58EvY6mie5yEhQOaTJx0grpCPpBZCDA5gphIF8zFMBb8Bzh/zcehl
ASbN/pb08Xc+uqvQLUC9ixO7ZVlbmfwvsHgzJy4bIoyKAHnGTrwi9JTm5vs+
L5NRJ/ky5vsKTbWjE7f9uzHltYsDrNed+FbkixcF8J3Qa25w4joFbv3Utznx
gYzN//UTj3PiUl0AP/nZTrwg4/G//Oi3OuqWXnc40fCEMAH9kG7s3TudWKKC
Mz9WtJhpjrYTupxn/TDJ6s2H73VC4czf/FivAwsn9dp+6mGdaKKCED8U7nzQ
SVzSDx1DznNCx1LVfuhY4xEnFjwsEcaPJdoQOMmT8RNHdrIP8lO35KSO0E8c
26zP1Kv/G1nk53zArM/bMsD1o7MC807qm/14SQsVsz7NZLDhJ//aiRzzU28L
+plnnBirAzw/GvrJC3biVym7vH58IOHsEyduVSKlnzpGJ3EZP2RK2+eAE52E
xuj0Q9hbMYec5A35ofKQn53UUfvRKNd34lkN2H7yrZ2cO/mp13fiJhWu+NFK
AXsn9b5+rNJBvpP8GT/rLif5M34ozS/gJH/GvE+VdTvJn/FD2EkrSp3kz/gx
6vU/TzetdmKOEmT95Fc7oe1AjB8egbnPOdEok/dDWP1F/3NCqsUNv/qxXIkE
FvWzftbxFnQs9rOfPHwLKtv+yY+nVLBgQbfVET8UFr3agmly/133ox9NVTBp
4RIVMvs5j7CoW/WT/2ERh/cj9d4bzBG3yAvzQ6YC2wdbrIP9eFjCzp0WJiuQ
6eec30KC0F6/MPtVZKL3WhgyQzppP4TtP+c+C6s/n//ajk/9uFrsCKZZKJfy
cp+ffbYFbRc+9kO303wL2v7t8eMrkYs/alEX4ycfxGJc9bO/sKCy2h3m++lB
sKj39GOh0AietxiX/Zg5+fK1179kQcdH7/mxOVoGABa03HzHj596zzIlt0Vd
sJ88HIv6TPP+BNbfZZFP46c+xyKfxo+/mwlAYXFO4ic/xMJUDcR+6DjlkMW+
xo8pSuSyqJ/0U3dtUS/px7BFonyw0EM3iB9POEwvm2zxe/kxX4EQi3iOnzin
RTzHz/mHRTzH7DdHqzZzQhbxHLN/dANaxHP8WNQImBHP8UNdJ2otzFHg2Y/J
IoM/Y0F++h/L/Bgzstz3w18W+z4/9TUuyDR1/hN+6LinuQsKEz3m53zEBW17
FvuJp7gg1eT1j5r9LjK6zi5MlzHoI37ioy7Osfx4vUAG0S6M0F/gh9I6+rhw
9MxnrSvn+pl3XbhJiRzn47MLj+pg0k+erAveaCnN/awjXJj8x1cvhmf4YQ5p
ed/xLvbFftbzLvJr/KyLXOTX+DkHc7GO8aPJ8KxdnRa6iLv7qY9xIW/Ns4OG
TvST7+zCvUqk8GNw3VCTCV08N37ySVxQe4S7/Tgk47oXXdByYawfS7/8ylTO
Lvpu+KHlyFYXHmy413TSfvLcXdAyeISffYGLujw/63MX9W1+4q8u6tn8nEO7
qF8z718Jwy7q1fzsu1yYKuXDbX44hK4T7aIu2E9+iQsXCS2lv8kvWlC68OzK
ay6zb/VD5dfZLlQdlITvx/1KFHZhocAWffzUibjgEnrYzX6Iyuoy2wU9tb1M
/rxavqmLukU/coQmVe2CsPqGdfcTN3Dp7nmqm596SxfrXvN9dJDpIr5jvo9Z
lQ7N3MR3/Nglr7u1m3wbk49V6OEm38ZP/MeNM2L/cJWfP8dNXYsfCoP1cJP3
bN6PDvTd/Dl+HPhUgHk33pM2pp0fKqMa4sYlSqQw+VcbTDdUFtnGz/rZDS1L
W/mpl3RD4fkWJl6LbG2qG6KeKGjup07VDaWHN/NDxwbz3NB25mI/+cpuJB0R
IN3kWwUu3Zx7+yBqge3PuMnL8ZGX56aPhI+4shsLjg0yIdUH88v27HjFzXX2
QWnDb7jZ5/iIx7ipd/IRd3fjL6FB/eZj3HczT/rov+JGscif6nzQNPutG3Nk
WWt9GK4NnJv8Gx+0XT3mJv/Gh0Y7DDf5Nz6o/UyCm7ihj7xZN7RNLvHRd8SN
L//3pf+bIh/1im6I+txf4MOlSqBycx/6IFPl5YVu4pI+xkvzvrRg8xFfdtOv
xce5nXlfQs/2+VhHmvd1TISoPurSPPBfLAnaR12ch+fCB1NUvZTbzoMksQvK
83F+5MGwE5HPbnb4kP2jEOk8xHt8CEsb1t3DOYiP/GMPtDzM8EHD9AAPlB6f
7qMOwMNz6oPKqEd4qH/yse/yUP/kwwvSLk30UP/k49zeg+/aSiPsY1/pwfUq
q/dhrYS9hz3YIeO4GB+2jKip9yz2kI/jY9/swT1Xysr7yJPwIGqKGI34sEkH
0R76h/iIC3jIc/NBslT9ax76g/iwTgUXHuIIPkzVDe1hHemjrsgDTWs/+DB0
c5/BG/Z7OHfykXfjgdKaD/igNKODHixWIq0Pgqqv+9mD/fYis9V9jH8edNQC
2UcczEPesg/CYlib5sF/H4ogzkfelIdzbx99dzw4fEP27Nv3+biPPOipRjw+
8sI8aPS1Mu9TaHiVHuqhfMRFPdRDmfVXAN9DPZSPukUPeTw+xjsv1I5pm484
shcqd33PhzcrJTB7yc8x+1FoJFd7sVPoS2/50OTQYlMiejnn8xF397Iv8DHO
e4n/+DBZiRde4j8+VAuN5k4v8R8f/SK8xH/Mefrjjd1XTvDiwUaiNZoowOVF
5gkRYvjIi/VC6WMbfKwDvMS5fJwTeZlHfXheDYS89H/wkUfshdqyrPHRR8JL
HwIf60Mv3hZ6yUof53ReXKSGRz7yrr3UR/lYd3rJm/eRL+zlHMZHvouXvAof
56ReaNh5zEffGi8EXb5oiY8+Ol7ydXxQ+V6sl7igj/o4L/k6Zr8IPTDLC7UB
me+DlgdOL3W7PvZhXuwOyUDcx77Oi8u00fSRH+zFhCdkhU081MbHi1iRK830
UffhxW1aQPs47/bSv8BH3a2PcyofeRY++hP4sHy1KH180PL9Ph/EjSTnah9U
1jfRB92lN/ioU/Zhn9AvbvJRL+VDuthX9PehvwphfaznzPe8QwoyH6T7GzjC
xzrOh1MbpXL1EQ/yUb/mIx5k4rcCxT7y8nzUR/iwQQnVPurQTN5J+qHT2GE+
jHsvEjjzuI/8HbM+++59qI/ZB426OrMfv5dC0Ef9vu/CPn3Af40pTX30r/BR
l+cjjurjXN/HftmH5yRs3+ojzusj7uAjbmzOoQp9fNQ//P86NfIOfbhSypJe
PtzSV06cj3WyjzpUH/VTvgtx/fy6N+pkTd76Nt5UvD76fPmoY/ch91VpkHz0
BTM/54t3ursL//89NsYjH3Ux5nlF/m3y+KsC013lu1AXnBLZUAfzvPqPH7er
0ZWP/jSmLpJff4WP8zc/+Tw++BYI88tPPo8PWaa732jqNm3DzT5rxC9NHe75
YsWIVr4LdeUmJcz7oHDHbef7EB/5vX7yts7HH9Nnmuw/8GIf6ys/9VQ+rFig
DljUU3kv9BGNeiovef9+5nUvdQR+4kNe9qd+4kMmLoodjunLGn0KvBf6vEad
qZc8AD8EPf3sNy99hPzQ8U+Dl/wZP3WqXuKJflws7VOtF2/2FiahH+vuqT/1
YbUXak9n+vpGnasXg1V47Ce/x4s62V4n/OT3eMlL8RPH87JeMn3PruSk0iIv
9bd+aFoo9GLfa5LQ/dRXmbitxoh+6qu8uLzi+I8Xl/lxWOC4kJd6LT96quDK
C1FVjPrdjz09L1q61OfFJWq44Id7tUzkvdTTBjBJ7BddXqgNwGUBvP6vDCK9
+OMOiYwBKL0i30veWYA+FF7qsQIQdnnnXC9+Erpa3wDU/iTbxDX9J8A+2nsB
F9Y2JN0LUdt/NCaAcQq4e3Hsn77mhAXwqspSzHoqoTpA3pGX8eT8XM/L+XyA
6+rF8dZCsA6Q7+O9MGdoxIu89K8KsI71UiccIF50Ps8GiBd5Iay05PcCxIu8
eFnS3q4ABuigxUvddYB+al7WNwEUSJg54qUvWoB+aV7ycwNQWsohL+NHgDws
L5RekhKg/5nJO9L25QQg7Mqqb73op41EgP5mXs5PAnhCAW8vfs8TwWMAMtU7
+IXJo0ooPj939bJPCFB/5YXSnf4JUH/lZV8TJP/HnA8tzIPk/5jzo4LsIAT9
eugjL3TbXBuEljO7zH4SulePIJQW/KGXuo/zvDQvOsyTSBiE2u184L3Ai0iZ
Ko2lF0uVMB7EnSpA8uKI0HTuC+I5JaZ56QMURHUnMUb0kn8TxE1agHgv8FhU
Vmvqiu4qjAhCWOBztniJXwWh8NNmL/1mgtRjefnvg9RjmedTwVwQwqKevMk8
nzZkQcYV7wWeVCN+5CVuFyR+ZP6+AjhB4kde4oxB+g6Y86YBKAilK64xdYrQ
45ODnON7eY6CUBhipRdaFriCWKWEWnOexVYsFETZAWkQvIwrQX5vL/0sg9gt
22ep9wLPsVFH6yUOH8R4TezeC7zMRh6TF3epEWqIflTeCzzSRv8pL3XBIags
Y6H3Au/1egXizf5/QwJmiL4NXs59QnAIDDXXi+EqNAmhjQKZ3gu84kaehBcK
g0wNkR/kvcCDbuQHmbpWDZJCUNvRaV4oLfMCb/t8nRmiv5MXN2sjFqKfk6n7
Xj8T8Lwcok+il3rKEHkdXvochKjX8kLD+p4Qdc7eCzqBRjzJy3lriDwyL/uo
EPEkL+fyIeJJXurTQ/RT8rJeCJGH4iVf5zxv3XtBl/KryEaGeonXhIhzeLFG
aJW1IehYfbCXeqAQ+UKmrlWCaYh8Ie8FXdFMHZB66VsTRsbX8wrm9/MS7w7z
HHuJ+4TpV+Ql3yaM45tkImPitdDbBoVxiwJzXtYDYTzeap/H29NLvCVMHbqX
OF4YnZUIe/58h6FyT9MH3Si2OfPDSBdaRFcvtO1dEsZIJRR4cShaGqEwnpd2
6Bovz1UYdaVyILzEfcPoq4nZy7gQhr7Oq7yMO2Hyhr3kNYbJH/LSD+q8DtTL
uBxGmsCA7bycE4Q5N/Be0PE2+n6aeKNGaWHUCn2tlen7RFafHSa+5OX8L0x8
yQu12wuHGYdNHyOy/7Iw8SUv51ZhqBzoIi/6CJz+R5h1nxdd9MEjF/rSRr+l
8z4DHvYLEfoxe1h3Rqjv8rCujVDf5WHdHIHSZ856qKeOQGldZzx4X2TCIyPU
3Xo4Z45Ql+bBykaCDPlEHvLjI3hOCTceTNOCLoJqoclVeTBGZOhLI9SVeKjz
iEDc2zqUe3CjElYjnAt5qP+LYLI2+h4oXfPdCP11POTDR+iv44FM2W/aH8Fw
oc1HPPhY5OoHIjxXHuqOItR7eajvi0DtEv2eCz41jTyG8zhQBFoeezycb0Wg
7Y/LQ95ShDwID/kMEeJNHuILEeJNHvK6IsSbPHyfNn+PB78LjaqZTf9dD/k+
Nv12PDgodKO2Nv12PNA2ub1N3r4Hi8WeopNNXq+H/HgbiQIjJnigY9xuNobq
wnugcqSeNn01PJxnnffd9dAfyIbCONEe6m1sLNSCywOlhwyx4fow9/Rdv3qg
5fxdNq4o3r/5o188nN/a9Kv1sA+1Ef+0OFZ4qDe1yTfykAdhk2/kwVPSFk+3
6TfrQV9NnDb1YB5UHt1tntimHswDtU17xOZ79zCe2LhcC1QPVAa81IbSdb7y
kJdi1kvGjl94oHTN1TbMJv6i6+cetFXAyr6AczXqnGysUcKrB0r/edm8P3lN
+zwQlkj/LTbxJw9+FjudrTbxJw/nZjbxJ7Pfpsig36aO30P+r40tq2Tg56HP
j03ekIc8b5v8Iw+WaGNqk3/kYX6yyTvyUH9o3p8SOzysa816KTHCw/mvWS+h
2b3hYb1q1svsouotHs5tbdynL8gDUYMXpp73FfOQT2wzz3qgsEWezbrbw3rW
pp+p54IPd6N/qYfn1KZezAOVgxbb1It5Lviau4dJoPdA7VxrzH5X41APbvc8
+eVXp837Sxqxc+QaD6KEFnTOJh/Jc8G3vpGH7yE/qIA4hIf+WwXQr7vcQ55E
AaqGVWwsWuYhj7SAfj0e+sYVkOfvIa+jgHiUB3OUcF1APMpD3KCAeJSHebOA
vAMP/UML6CthzqfY2w0suID7NsbjAvLcPOQVF6CXtHsPeVhfFTDueqB2JncX
QMuaWR7yoAug9tozPfSHLOAczgOFPaYXYOuzErA91DcUUPftYV1XgDsvEsWi
h7r9AurJPPSbL6CezIPRn6Zt/3JZATTdTPDQZ6AAj2oC8tBvoIA+qB7y6gvQ
QYk3HtbhBZgqtudjPfSjL0CyvN7RHihd8c0CCMvGAfN9VDhYQD8fD/GgAqxT
oZ8HJ4TutbsANYtX7IgZ7uG8uYB8JQ8GqzC7gHWrh7zEAvKVPNAxxfcFxKc8
0HL8cAHxKQ/UbvhYAfGp8/mkAE2V4OOB0h9OFWDkTz1GTb7VQz5FASQ7HOjr
YZ9ccGHO0KgfL6D/o8mPIjt2FlDXYs6DwhIFCFwlTBUP81oBOilxxcO8WIDp
Iivp5qH+twBpUqZe74HSimoKqDfzULddQP6Sh/VkAflLJn/oBizgPvdgiBLP
C3GLGqx5yIsupN+Ph3rzQsipurKDh/VmIXXCHmgY7VgIpTdcbs6b0H27FNIn
0kNdXCGaqZGsWS+xp+xRiNEqJPXQN7OQ+jMTv/9bvbt//0LIdPLeFma/iD36
7YX0O/RQR1gIbasuMflF7NpGFhKv8iD+oBSYhcSrPPRtLSRe5YbSSyYXso9y
87wUQtu//7mpFy2kr5mbPruFeFENw91YrkB8IeOSG4vVyKIQv0s6PuvGXH3A
QurR3JBueNCqQvKG3fRhLoTaCtW7WR8V0ofCzbhbSD8gN/35C5Hrl4Gzm/qx
QrRWIbybfIxCjBP7i3I31E5jZyHvg3BznlgIHdMVu8lDKSS/yU2/1EI8owWt
G0on+r6QPnFuHBDbySOFuEHtH9zUGxbSh90NtXWLLoTCYX439aiFvH/BzXsB
Csm7cOMnsUXLLGQd7SYuVYg4kfVZbuJahcSv3OQbFfK+BDdSbhOnsELiV27y
1AtR3l4MG91QWWtVIXqoIMLNuraQejU3++lC8p3c9E0oJN/JTd+FIvb1bvik
7G5WRF9rN/XyRbyfwI2hSiAvIi/FTXy2iPcPuOmLWkRdnps4cxHU1i7aTZ+v
IvLi3YwjRZDu67vj5nlUuFFEXqOb/h9F1K+56Y9URN2QG/8KHDe6qPH4H3Hj
U7HrvrcIGu5/dEPtwu4rgpYVB91QO9AHish/ckOPyYNFOCZ0lO/crMeKLsyd
G3GEItYpbuK7RfTnd2OH2Nc+VUQ8y835UhHxLDf9koqoZ3NTT12EbROEoOPm
HKyIcd1NXlERfRrcrIOKoDZHH7l5f0kR84Kb9VYRzsaKoMNN3/4izqXcrAuL
yIdy09+hiHwoN3V+RfQXclNfWYQ5Ciy4WScXUd/mJt+6CEpD2urmvRdFF+b+
jbqCIrw8Vw6Mm7qEIvqYuTnvLKJO1JwPGSsGijBYCfZu+j8UYYUO+N0810XU
obnJ9yjiOrrJry7C/OXJ/x7d4MbL1WLQX4SPpP193k38sIj4lps6l2L24W7O
CYqh8ue1bmT+IQ9WTHzLzftRivGPjH1XujkPLcYw/Ytuzk2K6fPmZl4rJu/Y
Tf5HMX0+3Fglbf2AYtysgiE350jF2HdGXqCb89Fi+MbI4M6shw5kitFRiVBu
TFBApZj6NzfnasXsG9zkaReTL+VmPVSMSxQwcVPXX0xdjxv3q0FJMf2I3HhR
iV/FUBhgthvbhNb7TDFu0YGqmzyyYjyhQJEbMs1/5/lifCljoelu3gtQDDtw
5nFMc9OnoZh6ODd5dcVQWGCKuxFuer8YotLoO9lN/LqYukY39TnFxLtM/hIZ
+RfFxLvcxJ2LyZ9yc85fDJly/3X3+f1cTJ8qN/KaCVBUjGc0ELnp21qM74WO
M+p8/C6mPs5NHXAxcWA377UpJm5k1lfacU8xnLLMw9zUkxfTr8iNvwTuKyrG
JCWeuSG3Dk2pKKaO200/k2L6qrvJEy5mHe0mH7qYvodu1v8lnLOf5/2UUCfu
pt685ALvqBFPKaFezg2ldXYuoX+RG3dqo1gCf6kYYLvJDy2hT5gbraR87VMC
tc290ayX2H4NKCH+dT4+lxD/cuNDgYnvKkEzJRq76atQgtExhxYcvsZN3lsJ
hO3cpouJV3rRRwn1c26offuMEvKr3NyXJeRXuXkfUAn5VW7qY0pQsEkGI27i
yiVQm/zL3dB2dlUJffNNvLxGMnUJ18nN+yNKqKtw0wetBG2U+ONmnCuhz6X5
/UIP2lZCfyNzHtXoooR6OjfjeAn+1sh7fr+WsO50k99cQpzTxTxVQr6Vi35h
JeRbuVhvlNBf2gUd/8aXUOfowj6h06WWEA9zUcdeQjzMBWHvdLJK0FGJFC76
7ZRc4MldqxcgmPcpMvd6F/0wSqA2EnUu3i9UwjmNC3LrSfHpEuh0tMrFOrEE
x4QmXGm+jw5WS+g37aL+qxS3qvDXRR+pUt5r4sI37wvBspT8Kxdx0FLev+XC
IaFZdi3lc7q4P0uJW7no01UK88u7dQm5WD+Ucm7twid1cpFK6QVeocrPR5Ri
nNCcvS7eR1RKPyQX8ZxS6sZdxAdL6cN9njdaiju0UXZB6a/zSskjd5GvXEof
bxd1QKXEx1yci5QSH3NRl1RKfMzF+riU79XFuU8p/ZFcvBemlDonF4bPv6r9
x++VQsvbBBfnWqXQ9jLeRX+FUuZtF/kopfTdMe9PCYmlxP1d5I2X0p/axf6w
FKLabnvChXkaYEvpl+Ti/QCl5GeZ5xMbjfRSqI3Fzy5cpwS2Uiwftqvwu6Mu
5v9S1tku+j6UosQlAImL/IJS8q5caDMnVDmsopT6PBf0x9SVQu0Ev3NRR1p6
gbfaeO9fKfEy8/MekAhdRrzMRT13GesiF/2Yy6CypM9d1O2Wka/loo9sGfla
LupsyqDwxj4X8cYy3n/kIr+zDGrDuMdFnXQZ9Xrnebll1FWb8ylp8u4yKIz9
oYv35ZRB7Y+2m/NuuvXlD5RBxyjvu9BWCZ5lvJ/IxTlWGd4/LRczuOj7UwaV
sbxjzpvYDy8ro7+Si/VpGflbZn31hZdRv2fe13tXf/v2pjLeJ+QiHlgGpX1v
dqG5AqBlUJnKqy76VpbhDpFTvuzi9y7DKhW0uOgfXnaBxxwl9nnflBE/cxEX
LSN+5qJ/ZxkekT9e78Lz2jCVsY520S+xjLwbF7RNSysjn+v8fisjn8tFX/ky
+l27qMstw3sin33GxbhTBoWJn3ZRR1NG3YwLQ4Z8fdMtDWXE/V28j6eMdZIL
anf+bxmi5Hqtx13Q66malVPfZ86LFojl+EPK3cUuzm3K6X/t4hyonPcquKhH
Kue9Vy4s0YFAOfldLtyggrty8rtc9G0uxwIdeLug18ndWY6PxcZ2jov8hXLe
6+Di/XvlxNNceLe5ICPl6CjjxRku1nnl5EmZ/Sp06IfLyfN0Qa8bW1wOpTXc
76KvQzk0nEw28UDk0KvKMUpkh/e5oOXd+nLyRl0okrL6pXLiFC72CeXke7k4
Hymn/s/Fc1FO3zQX9Pq5veWsK1zUnZQ30uBGmd8ncsoD5fRFcUG6gtOHy9FN
jVxcUDj2eDn7SPP+RNYUW05fJRcmqdDBrJ/Y2A110T+mHB6R0w1xEc8qp4+D
i3hwOfWALtwh9mUF5VDZ/iAX9dXlxNdcnI+Vk9fmok6sHM2S3xv43K0uaFr7
p5z+2S76CVX8v85B79mowK8/iuDdRV+kCt4r4sJCTYQV1Aea7y8/tlsFfSnM
/lWDoAo8rcC4C6v1gFdw37lYz1Vwbn4+X1bwPhTzPEpUqkAPvcDNPM8+SbAV
/L0u6jcr6O90XodRAZUNXuXiPq+A0uk6nteJVFAv6CL/vIL+2iYeayKvoK7P
BU0HGyugr6GtC5+brNbytQribS7iRRXE287HpwrOGV306a1g3+fi/LQCOgZo
fj4fVlA/aM7HKClcK6gfdJGXbNZPAXIXfQcrqFN0sX+owEGhaf5r0Rexgv5P
FgaqcWYF75+1oOODgFk/bXAt+mlW0H/bYjyq4P2xFnlgFewTLNaBFVCb/N8s
Pkcl/zsLi9WorJK6SwvaDrSrpB+UBYXrrqokrmoR/6+kH7eFJ5VwX0n8zcI8
sfW9pZL4m8V9X8k+3aKPayX1hRZ9YSvZB1n0ma2kP5SFgtbS4VVSR2rR36SS
/DGLvI1K8scs6qgriRtYnINUQq+L9Z3XPVWike5g0Z+6Eo/pxWYW72mopN7Q
wuF0IaRVkjdrcW5VSb9uizr8SvLeLFylg9xKzFZDF4v3LVVybm7RV6mSvucW
8ZNK4uQWurz19U/b4yvRVoECizz8SuJxFvHBSuJxFr9HJfE4C8VCt4pUEo+z
oGmqrBIyFZ0TZ3GOXQm9diPWIn+3kjweC2vVKKiSedXi/KiKflIWsm4W5+Yq
qA3+rxb5VFXkl1m8P7gK5yTtHLM4j6/CbdcIQ95CDxVQVUHlGkcs8jqqOMez
6JNXRZ9kCwlC/xlTRX8pi/eSVVH3bBHPqKJvkIW71XCqivpEi3OoKnx6WAZM
Fu5RI5oq6LjhKwtqW7eyivicRT/VKuJzZn8JvPBSFfE5C20VEKkiPmfOk7TZ
26qIQ1g4LWP6XVXkXVr0caji/ZYW65sqKBy222J/V8U+0eK9LlX0mbaYf6ro
P2VxH1RB7Ws+sDhnr4JU9y9vsxAjcnd3FflnFnUoVRipQIxFX/wq3vticd5Y
Rf2ixb7QvF+xWXvDQjc1yKgiz92iP041+utBsOgDXM37Ii3qvKvpq22xz6/m
Olr03ammP7hFfkY1ygUW2mjxvoZq8tEs+ihWc45mEbephsLL6yz6JFVTp29B
w9yMat7faHG+V01fOov1STXrXPP7ZSzxVDWuUUKGxfunqukjbnEeXk2/Kot1
bjV97yzeC1ONPIEfl5o/F5rzh9Xkp5k/39Vp4fX7qokLW9x31Zzbmz+vTU8c
c7Aary9/a9A1iy3299XYarqlzxaZPxd54Mlq+ldZ9D+tho5HF1i897ia+J1F
/kY18TuL87NqbFDD/fPvvxovakCwqJuq5j0WFu8LrSZfzaLffDVxF4s86Rre
c2Qxz9ZQ/2hBadOdauh7bOKv0PGvr+GcycL42yRC1pAXaVEHWMO+xoL7oBjg
1HCua+FdoW+PqoFeuzjO4py1Bo/rQMwiblhD3uX5/FBD/ppF3LOG/LXz578G
xR1EkGMRt62hL4UFla2tr6GPvUWf2JoLuuZGP6Ea+o+f1xHXQKqMFkMt4vI1
0GtK77AYV2qojzyvq64hz8Ti3KIGel3SQItzkRry2SzG+Rr6QFnUR9ZArw+5
1WK/XANtP/pa9E2soU+Hxbxbw7rOQlM18qih77VFPLyG59IiD6uW/uRmvfWL
1SJJ4JtuFgqlrLi8lvdEWsS7ay/oyBv/u1qee4s4Yy3xPYt+pbX0x7J431At
9ZMW9WS1vO/O4j2Vtbyn3qLPfS2E9eVsb1EPXkvfb4u4eC3nUBb9jmsb7T3a
mfiqhWIt/bIs+pPWku9m0f+/lnpKiz7FtdCxdAuLc5Za6hIs4gK1zJMWWiqQ
Uct7tC3mvdoLuv1GfKSWvmMW5+W1+EGuKfrPyfdbS7zPyf60lnifE3rNfbiW
eJ+T97fVkv/mZB1XS52Xk/hbLXEQJ3l3dbwH3MnvWQelyf7m5D2BddRpOKFf
49o66i2dnF/U0e/cSb/0OvraOLnv6/CwGok42WfV0ffdyXtC68iHc5LnWsf7
5pz02atDQMbJxU76t9RBy/oiJ34S2sayOuovnbwHoo74nxM7TBZrurGO+J+T
+v06aHsYcvJerzreP+fk/X919EN3QtP5/jreo+ekzq+O/Dgn7/utI6/Vyfuc
6+i/5eT93XXQcUS+k/e312GGEjrOv8866vycvN+yDo02lk68pA1fHRSeznIS
X6hDntgZZDihsPhfdfTjclKnW0+9pJP31dRTv+iE2sW0qiefy0k/rXrIbSlx
25xQuLl9PSIiO3vFSZ1OPf2PnKzn6vGqwEyPOdkv1vMeXyc+E3lAz3riok72
ofXQ43SXk31sPeb85Wh29lYn6716+s2Y76vE7Xr2c07OUerx+m1iQGC+v15A
VU8dSD6u1IF7PfuLfKi9zsR6+prlk8dTz748n/fF12NWy6vMj8znvKseXRTo
zCf/vp73veSjixJf6jkvzSdOU8/5ZT7zfD3vL8mnD0I9+ev5vBe6nj54+Zwr
1vM58jmXrCf/Op/8hnrOh/LJ86/nvCaf9znV897DfOo56hnv8hGUH7OjnnVZ
Pvm/9dBt/Ece7yurp+9IHh5QgLIeGnYjedRh1PP+xDzmp3riyXnUydaTR5dH
fl0965Y89gX1vD8+j/y6evq/59HPsZ73cubxPol63l+Xx/dUf8GnTMvfvHrO
HfN4XurpF55Hn7x6+ljn0XemnnViHpbqAKKeOuY86DV4FfXEZfN4L2Y98YY8
zivqqQ/Lg9KTztXTx9tB3ZY5L9Jm1Tug9m8XNVzwyWs8bw3kczh43hqwQYV9
DvKsGy74+nVQQLOB+hoH82cDOggs/aUDI/SFNNDPxMH7UBpYrzvgFjnxTQ3k
kTnoE9VAXM0B3R4DG7BfxmyPOThXbGBcdXAu2cB5qoN1UAPvQXNQB9BAHy8H
9W4NEJT665scyJghGaIBol4ZdI2D+7rhgi9mo/6tAVersbGD848G+i3m4i0J
64+Y5xUbw/xc8gobeM92LvHoBu6nXKyUY7migbqmXProN7Cvz0UrFQ41cH/k
UhfcgHK5VmBELn3/G5i3cjkfaSDumgu5TXPruw30W8ohHtTAeyJz+B4a2E/n
sM9rwD1q/JtDvmoDefg5PE8NEFeFpOdyeJ4aoLaCC3KINzZwHp1D/lAD1J6z
Xw714g2sd3KgZVJcA32AsvGkBoAG8kizoXKJ9AaMUsPXbPoVNJB/nE0eUcMF
X+XGe8oaeN9kNv1wG1gXZ1NPbr6P0JemZkPL4vIGjDOrPW5oNn00G8i3y4bS
Kv6vpysPq6pOwzWG4aOlkZhbI42TOVGi5aSW9lpqqc3Mg7g1qblvaLmUEmou
KKjlBgoiS6IiIEjs+3bhsoOStmhqapY22hh69nPuzeaen+/4p49s997vfOu7
SHfpx3uKOLC71IVp5fNzF8Im9btW1iuJviCteEIQFSXyv1rJ25QgaIG7WiHk
x7pJMOyx+eNW4vCkB7rk9lTt3Ufina4Vq4XwpQQBy/ZvpW69xL16K+uTBCFr
bLXwbi4h1aaLXGvh3V3i+9qCsUI4RKJubQv5AhLEevNQC3V1JUwRh4UWxNuy
WuMl+l22kOcskf/cwudFIq68hc+LhIeFwE0L8RcS9cpaqHsjcR/XDH9BNJEg
YHPfNUM8Xh9IzC/NzAMSfVibYXdLcSES9YuaOc9KxKk2c06XqJvXDGEXul3i
nN1MvQSJ/JlmvCIKpkSccDP5CRJ1Cv/vGyLhJT/bkaKJ+s4S47OJ+o4Sdbub
+HxIeN9O3/FNfJ8liPQb1sS9kkR/iybqe0vE8zbRr02i73UThI1UvURf7Sb6
zEgotM+bnZqIm5O4/2xkfZEwVwDRGrk3lKjf1Ug9L4l730YMEoRIiXf+RvI+
pAc+PPfrhESf+Ub23RJxDY3c60qc7xrplyxD0Kl6NrKeyJzDGok3lcm7aODz
IPOO1YCJ4oGWuXdugGAj95HJ62xgvyYTN9mArfYaZoDM/NnAO4KMMJv+O62B
uBKZcd6AF8WgJuNFAVBqoD6STF5dA9LsdPqGzD1iPRbZ59q3ZM6h9cQfydx7
19M/UyZ/tJ5+WzLv0vXsx2TqldfDbcsmzZO5L6nnHU2m73I99zcydcjqGf8y
58966nzKvLvVQ8i/fSozj9VRd0sm36WO+z2Z/kB1xF/L1G/9vw+fzDtnHfst
Gd0F4LIOYg32hUw8ex11P2TqDtRR30HmnryO+z8ZQn6pex2q7HKSLzNv1tIv
XGa/Uct6IFO/rpZ6D/IDH877eo0yca619+mhX8lYJgaaWsa7zLtcLf5qj4EX
ZealWgh7gB89P9+mBb5WS362TH3sWvpCyIzLWuKrZSyPnrNquOxk/yQTp+rE
e6KBliHOL04nRHh0UCDg2xlOiLWot/LAd/e+L6oC0e6vcxJnrRBn7KSugEJ9
CCfzpoKeoiFxkr+rwO5CD/d2UhdcoU+dkz5vCu8mNeyPFHwojO5reB9VyKeu
YXwr3AfX4NxQW5BL4b60hvtH5YEv9/29mII5AmhZw/yuEE9WQ98/hfuZGgh7
3fkKxBrMpwbtdlu9VKF+UjXnC4W492riEBXihquxXjSUCv2nqrlnVR742N+f
JxTuLaupR6qwblQznytIsmmS06rJ21HoZ1PN+UGhr1U1XhYFXKE+ZzXxSgr3
DA7yxRXeOR2cFxT6kzowWwg3K9yLOKg/qhCH4mD+VrhfdmCmKIgK8ZMO6lor
3Fc6IML3nEKdQQf7GYW8Tgd9RxTiwRycBxQIWTWzCuLltSvUma8iv1whnqOK
+Vqhr18V+3+VPJQq1mkVAibds4p8c5X3sUqIscBHZX2uJM9AxQohUFiJfkJg
X2V+q2T8qtTNraR/twpb/SexSyX1RVUIGvbVCuZnlbiICs7PKnWaK2B3Mc43
VfbhFexPVOKgKtjPq7xnVtCHSeW9rJy6MCpa7PVUZjnrmgohOxNWzv5d5edR
znyscn4tZz5WiUsspy+5yjtFGXG7KvNBGf0GVPpxlZFfplJvpoz+9CrO2OXj
+TL2Hyp91svYn6vwEUChUsaryntRKfOvCrFW2VxKHp5KnHcp8Uwq96ul7DdU
4oRKqd+k4o4tE/F9CfliKv5ce7r7q1kl8BMJyvP7NsfXfR5ewv5bxZVLs0f9
NqME9+VCVPJrSthfqAjo1TBe8y5hvvX8PmPppfgrxaxTKqp7uX+fV1jMOUWl
nkAx41hF7OV7M4cuKMZe++34wxNfYSviXn+tmHtJDbmL2xYG+xSzv9aQcXuA
kXKzCOK/fTR0Lfigp1d1EfewGvFIRYxPDdaz1zLlFUWMTw3DVj5668DbRYxP
DVdcffKn9yvi/Klh1MCB4/z1QuJcNTwa03+BX1shhGrTKA3bk3tMHJBayP5Z
Q8Xkh/WRmwq5z9Ewe+zFIWumF5KnpWH52mTrdEAh9Z00DJ6w8LMR3oX0T/R8
/SzftLqrBdwbaNQLKyCvTUOM95Q//KIK8FCkZ/xdqWHy6At/PLSsgDghDfU9
3224O6aA/bGG9shTU+W+BewPNPoI5mOuWIho2DY+ou+MtnzuYzS8dv3M7uy0
fPIcNcxydtn9XFg+cuz2O0GDKNsz8olH0eiHkc949Lx/yUsDh3bNZzxq5AXm
cT7UWD/z0F8AmTRMDZyk+ifmUUdEg7C7D8mDkDtr0ujrlQf7OpTepuGjRWVv
9nshj/Vf4x0nDx1FwGus+7mw1VF+vabh1V9Shz9enst8qfE+mUtdGQ3rfkoe
3L4ql32fhvSzPc4Z/8gljkHD78dWnB06MJf1XodXD8eBLR1y6QuqI7Tpj5/b
L+cg3W7vuun4d+Ug56bSHO79dbRPnrrELyaHej467j6/LP7aqhzy7nXMHrNy
Zv0/c1jfdYxIXJDR8rcc9q86Gg8GVv/olcP406lHk807jw7/SVrM6sps7jt0
3OuaPe12XDbE+PWOju0r5v7wSUg2+1Wdeg3ZrOc6ovbvnOE1JJs+Mp6/p8h7
l/pYNv0udNTo9zre/jaLd0IdnceVHp68L4v5UEfV1wvqL07Mor6YTt3qLPr2
6MgKnbq4wPEl67dO3+Ivqbvm+Xufd4TED/sSy2w4+X4dn3b8Jn6SnIkNYuDT
MTqlYOnyrEzuUXR8uD2iLm1ZJkS5S9Xx8a9/9zyimdSb1RF01vnVrZ9Psl7r
8B45ePOdIyfpR6wjeuD6d0bMPkmetY690wqSj/U9SXyCjpbxFamrL2Qw3jw/
f0P+8PmxGcRV6JjzcehHxdMy6KelozjzxZEBvhn00dDxn6UOv5tfp1On0fP5
pw155kZUOgRc666OtuAtowYEpdOPR0dEVtaaE0+k03dER/eQ8qYVZ04w3xlY
X506IjTyBHJsuEUXAyV7VtXVTTrB+4aBeYnPX3nZ5wTvUAZ9R9Poz2JQ7yWN
+zYDb81a5gnJNPLFDcZpGnUqDDx6cM+ItvOpnI8MVBVutNriUll/PV8fN3Lh
32elcp9moL/j5qzyfqnMbwZOn1jwUNq1FOqGGJjUo7Lyu+Mp7BcNoLZj5+eW
phC/aWD1K08/fOmFFMaXgW63/hKee+c4cY0GpLla7u384+S5GMiYmeZeFnqc
/aGBr2InfNP59eMQ4bPdwIhDxVO7dTjOfZiBdX07ytMbkyFk96IN6tolM58Z
CMsYuSV7cjLrq4GJRc+uru6VTJ6UgZvjbm/0vXqM87yBOdP3p55MOUbciEE+
8jHqcRt4Y2zwhbqhx9j/GeQ1H+X9xPP7RpZt+NV5lPXUQMClksFnPz/KfbCB
Z0ZH7Hl6ylE+5wbvFkeZRw18tq808dPrR5i/DPrCH+G+ysDk/y7peyvkCHUn
PK//8m6v8DeOUF/KxI0Dm2O3dT5C3VWTOqBJjCcT58f7bPNPSuLcYaJ5e1Kw
EpxEHyET0RMe++ChV5KIyzOJ90+in7VJ3cnD7OdMXKyRg3KGHGa9NOF19XDQ
s81fwGaDDB9nci/0BflrJhb7B5iH3Ynkb5rU9U1k/2bi/W6RcWuHJPK+YUKd
8Fv2ztYE4hRMPNnll96LliQQ92qieNr68529EiDKeYhJHnE8OoiFkEledjxE
+ISbuP1tw5grP8RxX2QicFjg1cQNccxPJuZ9EZ1/rU8cbtsfX5wJ9+61l+6U
HeL+1MS4rd1Hhs88xHpoUkcwlvcHE9dtu83DscRnmuju/Vpd+huxjB8TUkxG
v/ifDzJ+TLz7ZdGpKTsOEh9hkod+kLguE/9eNrDgqTMxxJebOG63I2tjOC+Y
aBw7MS+0bwzzkYnVruv7fZ3RnHdNHHv16cZ1wdHsv0xkul/q2d8nmvscC77N
NefOlR6gPruFKb2H5LXNP8B7gIU+8qvX9j12gHnEQuSZhyecL9pPPoOFvcMX
dLg5bz/vaxYW/OX49yMf38++1EKsDSspjeK+0sJ6n/MJWxdHcX618PiTjwXd
6R5FXWgLAxN+eG+AM5L9lcV6Gsn6ZiG4quDJZ5+JxDhRcDz/9nSfg8/sY79v
odd9gBH3jxb1nfdxPvW8nvKs5vDmvYwXC+qgy3svBuylLoKFQYKYvId6rBZx
ZrtZzzzff67q15cX7yZ+xkJbWODlhjO7mG8sXBsxY/SSUbt4p7PwyJ8SJ8Sn
f46DNhw1w8LQi77WnF6fw2XDKnMt1FR5935552fcn1jItsuFtZP4cIu85J3s
lywU1CgVEVd3cD9o4dT1jmOenraDOikWxnbfP8zRup06vxZ6/+tQ/Iqx2yHO
wL9YuBf7XUpORQT5Whb1siOoc2wxH4czv1js/8O573Oh6/tl+T9mb6POswur
us3fETRkG/1aXPhH4cquRu5W8g1c6B3eZD76ylb24y5c3PDB22GlYZy7XNiX
ONNYNDqMvH4Xhv8S06WwYQvjw4Uhqb53NgRuYXy44HjzRnPShc30m3bh3hHl
6oRFm7nPcOFoyYlLh29sYj5x4b995Oj4Dpt4z3Hh++C62xH9N3J/4cLSFL+f
5771KXH1LiScfiT0heUb2O+4UDB+0zctB9ZT19WFgIlrUtY41tEH0fN6hys9
uraHUq/chcbM337P9QvlPcYF/zWbMvynfkI9HBcy3t+Y2rQrhP2NC6eGdnxz
esNa9tMuBEZ1mtz+yFrqp7rwUsiOC5Hj1jB/uLDmp7Dzr+/8GGK92uDCU55u
Vmv7iHoFLvQKujWsuNdH7GdcWD9l+qFti1aj2X65l10wP3lpwtrCVcQxuHCg
av3buzutou6iC3tt2uHsldwHe16f68a9W6tWUCfSRZ7Sh4wHN05XvBDV59Zy
xoMbacHPte/IWsb7hxtlM+79Z/T6YPbHbmypjwkI/edS5gs3jPQ7NUMGLCFu
3I3+nbocC/ZaTN0HNyIyOvj9dmshxHltlBu+vx859Ny5BawvblyO6pud0TSf
OhhunD03ynm9Zh5E2E51Q2rx+vrbmrmcv9yoHbE34K2mOexP3AjP3PjE9ydn
c8/kxo0Lc2cN+GYW91duRJ2Z+ad3Os3kPdyNGBuO8c57rCdu/DTWK3ZMwrvM
D27srM7d8ZQ1jf2I5+9PyFw9feFU7qfccGR85nvh8mTekdwI6lWQ07gwiLxu
NwYF6il7rED8D8vplTI=
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{0, 1.7924}, {0, 0.53084}}, 
            "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {400, 
              Rational[800, 3]}, "Axes" -> {True, True}, 
            "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3],
             "DefaultStyle" -> {
              Directive[
               PointSize[0.003666666666666667], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2], FontSize -> 22]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 1.7924}, {0, 0.53084}}, 
           "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {400, 
             Rational[800, 3]}, "Axes" -> {True, True}, 
           "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3], 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.003666666666666667], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2], FontSize -> 22]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{
       Annotation[{
         Directive[
          PointSize[0.003666666666666667], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2], FontSize -> 22], 
         Point[CompressedData["
1:eJxEXXmAjmX7lSJbVIhUSpZC2UqW4lgqWyRLCJFoIWUtkrRIpU0REqU9FaEk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          "]]}, "Charting`Private`Tag#1"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, "PlotRange" -> {{0, 1.7924}, {0, 0.53084}}, 
        "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {400, 
          Rational[800, 3]}, "Axes" -> {True, True}, 
        "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3], 
        "DefaultStyle" -> {
          Directive[
           PointSize[0.003666666666666667], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], FontSize -> 22]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListPlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[
    Rational[2, 3], 0.6666666666666666],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 22},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->Directive[
    GrayLevel[0]],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->400,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1.7924}, {0, 0.53084}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.86012313341177*^9, 3.867241272805624*^9, 3.867241359463307*^9, 
   3.867302955701556*^9, 3.867905619750823*^9, 3.867912988660727*^9, 
   3.867913855066607*^9, 3.8679154458492403`*^9, 3.867924133142885*^9, 
   3.868526671444504*^9, 3.868530557478599*^9, 3.868535812753212*^9, 
   3.8685415749689693`*^9, 3.86854170152273*^9, 3.8685470194948683`*^9, 
   3.868590069460012*^9, 3.868597147658668*^9, 3.8686088349309998`*^9, 
   3.868609887837132*^9, 3.868613401295781*^9, 3.870171606532385*^9, 
   3.8702461899991627`*^9, 3.870250803629345*^9, 3.870753083268463*^9, 
   3.870834592829814*^9, 3.8708510316867943`*^9, 3.870931155623887*^9, 
   3.871456181677154*^9, 3.871459116904351*^9, 3.8750673345871477`*^9, 
   3.878273175139202*^9, 3.878279845392695*^9, 3.8782868470414*^9, 
   3.878620250619273*^9, {3.8786303039330387`*^9, 3.878630319139537*^9}, 
   3.878630374633892*^9, 3.878631650593275*^9, 3.8786404033395767`*^9, 
   3.878720108289081*^9, 3.8787929297896423`*^9, 3.8787942527743797`*^9, 
   3.878876278974614*^9, 3.878881149257967*^9, 3.878889712136331*^9, 
   3.878959336497176*^9, 3.879079565266673*^9, 3.879401082398044*^9, 
   3.879485193079192*^9, 3.879564752294816*^9, 3.8795708807031612`*^9, 
   3.87958007740974*^9, 3.879580204096898*^9, 3.8805205987906218`*^9, 
   3.880529013681837*^9, 3.883048451200495*^9, 3.883473272833294*^9, 
   3.883552731741972*^9, 3.883553628151833*^9, 3.883814114181058*^9, 
   3.8860516616844463`*^9, 3.886133522099864*^9, 3.8861527926433773`*^9, 
   3.886160137354138*^9, 3.8878766783331957`*^9, 3.88805666630307*^9, 
   3.888157773671855*^9, 3.8881669681127167`*^9, 3.8881694388904657`*^9, 
   3.8881705709054737`*^9, 3.888171219863565*^9, 3.8881920961037683`*^9, 
   3.891325824336001*^9, 3.891928781429582*^9, 3.892180616076469*^9, 
   3.8924406196478243`*^9, 3.8924644228607273`*^9, 3.9045434519551*^9, 
   3.904635299124403*^9, 3.905841856678566*^9, 3.905847331972295*^9, 
   3.905860659238223*^9, 3.905873443163354*^9, 3.905907507499881*^9, 
   3.9064444043164682`*^9, 3.9064519387029963`*^9, 3.906515254352611*^9, 
   3.906516690169271*^9, 3.906523575881411*^9, 3.907047887201008*^9, 
   3.907055086130196*^9, 3.9070573685617533`*^9, 3.907821891156842*^9, 
   3.908334826895688*^9, 3.9083352523678093`*^9, 3.9379000941849365`*^9, 
   3.9379011469405003`*^9, 3.9416809041075516`*^9, 3.941701655282696*^9, 
   3.941701961843111*^9, 3.9417026512838535`*^9, 3.943165689083618*^9, 
   3.94321199996673*^9, 3.9432151628774185`*^9, 3.9432152935529823`*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"e1b8c0b5-ace3-d04f-9548-2147bde3b4e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"t", ",", "pt"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.860216458038883*^9, {3.867241291279339*^9, 3.867241300774431*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"f0c386e8-7866-471f-a716-77ca91414f38"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.003666666666666667], AbsoluteThickness[2], 
        StyleBox[PointBox[CompressedData["
1:eJxMvXm8j1X3Pn6/x5MhQiIqpMkQEsmQtaIQhVQiCUkZI1MooSSJyuxBg1lk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          "]],
         FontSize->22]},
       Annotation[#, "Charting`Private`Tag#1"]& ],
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.003666666666666667], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2], FontSize -> 22], 
             Point[CompressedData["
1:eJxMvXm8j1X3Pn6/x5MhQiIqpMkQEsmQtaIQhVQiCUkZI1MooSSJyuxBg1lk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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{0, 1.7924}, {0, 2.9307}}, 
            "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {400, 
              Rational[800, 3]}, "Axes" -> {True, True}, 
            "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3],
             "DefaultStyle" -> {
              Directive[
               PointSize[0.003666666666666667], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2], FontSize -> 22]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 1.7924}, {0, 2.9307}}, 
           "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {400, 
             Rational[800, 3]}, "Axes" -> {True, True}, 
           "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3], 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.003666666666666667], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2], FontSize -> 22]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{
       Annotation[{
         Directive[
          PointSize[0.003666666666666667], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2], FontSize -> 22], 
         Point[CompressedData["
1:eJxMvXm8j1X3Pn6/x5MhQiIqpMkQEsmQtaIQhVQiCUkZI1MooSSJyuxBg1lk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          "]]}, "Charting`Private`Tag#1"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, "PlotRange" -> {{0, 1.7924}, {0, 2.9307}}, 
        "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {400, 
          Rational[800, 3]}, "Axes" -> {True, True}, 
        "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3], 
        "DefaultStyle" -> {
          Directive[
           PointSize[0.003666666666666667], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], FontSize -> 22]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListPlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[
    Rational[2, 3], 0.6666666666666666],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 22},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->Directive[
    GrayLevel[0]],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->400,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1.7924}, {0, 2.9307}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8602164587232018`*^9, 3.867241302089179*^9, 3.8672413608245773`*^9, 
   3.867302956700068*^9, 3.8679056229260597`*^9, 3.86791299073403*^9, 
   3.8679138564045486`*^9, 3.867915446760285*^9, 3.867924134017997*^9, 
   3.868526672283307*^9, 3.868530562792001*^9, 3.868535812815714*^9, 
   3.868541575022064*^9, 3.8685417021494617`*^9, 3.868547020422813*^9, 
   3.868590070280116*^9, 3.868597148524159*^9, 3.868608836163136*^9, 
   3.868609888797385*^9, 3.868613402037221*^9, 3.870171607192601*^9, 
   3.8702461906939573`*^9, 3.870250804391465*^9, 3.870753084265813*^9, 
   3.870834593605967*^9, 3.870851032444232*^9, 3.870931156481093*^9, 
   3.8714561831955957`*^9, 3.871459117551071*^9, 3.8750673355059958`*^9, 
   3.8782731763849163`*^9, 3.878279845802417*^9, 3.878286847817546*^9, 
   3.878620251634626*^9, {3.878630304619341*^9, 3.8786303197370787`*^9}, 
   3.8786303750610437`*^9, 3.878631651335309*^9, 3.878640403932474*^9, 
   3.878720108770218*^9, 3.878792930750041*^9, 3.878794253589819*^9, 
   3.8788762798745003`*^9, 3.8788811501048927`*^9, 3.8788897131569757`*^9, 
   3.878959337329303*^9, 3.8790795662430677`*^9, 3.8794010824515753`*^9, 
   3.879485193672617*^9, 3.8795647523857*^9, 3.8795708813799677`*^9, 
   3.879580078005632*^9, 3.8795802048640823`*^9, 3.880520599769178*^9, 
   3.880529013740185*^9, 3.883048452383349*^9, 3.883473272882409*^9, 
   3.883552731791*^9, 3.883553628202785*^9, 3.883814114234475*^9, 
   3.886051662180276*^9, 3.886133522638336*^9, 3.886152792701069*^9, 
   3.8861601374038267`*^9, 3.887876678428187*^9, 3.8880566663714733`*^9, 
   3.8881577752898808`*^9, 3.888166969471356*^9, 3.888169438996036*^9, 
   3.88817057103409*^9, 3.888171220784177*^9, 3.888192097068325*^9, 
   3.8913258247197847`*^9, 3.891928782265191*^9, 3.892180616522542*^9, 
   3.892440620490847*^9, 3.892464422914439*^9, 3.904543452792918*^9, 
   3.9046352991736803`*^9, 3.905841856734077*^9, 3.9058473320188093`*^9, 
   3.905860659300282*^9, 3.905873443225058*^9, 3.9059075075532217`*^9, 
   3.9064444043648777`*^9, 3.906451938757559*^9, 3.906515254933125*^9, 
   3.906516690231586*^9, 3.9065235759291887`*^9, 3.907047887248908*^9, 
   3.9070550861778717`*^9, 3.907057369381983*^9, 3.907821891211484*^9, 
   3.908334826944645*^9, 3.9083352524134007`*^9, 3.9379000959658146`*^9, 
   3.937901150273924*^9, 3.9416809041599483`*^9, 3.9417016553458176`*^9, 
   3.941701961903244*^9, 3.9417026513291206`*^9, 3.9431656902651253`*^9, 
   3.9432120013230457`*^9, 3.9432151662367096`*^9, 3.943215294596712*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"272cab84-be86-1545-93ac-5b7a7df25d14"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Loading data", "Section",
 CellChangeTimes->{{3.8787936333657713`*^9, 3.8787936401094513`*^9}, {
  3.878793967083466*^9, 3.878793969475052*^9}, {3.878794049994149*^9, 
  3.878794083949638*^9}, {3.886162677228191*^9, 
  3.886162684075622*^9}},ExpressionUUID->"171327ac-a4f8-47c7-a3bc-\
3debd3a692c1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pf58e6", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-58-Lr-0.\
5-Wmin1-1.1267e-06\\\\simulation__2022-10-30__17_27_40\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf65e6", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-65-Lr-0.\
5-Wmin1-1.1267e-06\\\\simulation__2022-10-30__17_46_45\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf75e6", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-75-Lr-0.\
5-Wmin1-1.1267e-06\\\\simulation__2022-10-30__20_19_53\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf87e6", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-87-Lr-0.\
5-Wmin1-1.1267e-06\\\\simulation__2022-10-30__18_11_50\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf104e6", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-104-Lr-\
0.5-Wmin1-1.1267e-06\\\\simulation__2022-10-28__19_56_04\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf130e6", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-130-Lr-\
0.5-Wmin1-1.1267e-06\\\\simulation__2022-10-28__19_59_46\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf174e6", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-174-Lr-\
0.5-Wmin1-1.1267e-06\\\\simulation__2022-10-19__20_13_55\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.860129537136554*^9, 3.860129574939909*^9}, 
   3.865577107325162*^9, 3.865578238119577*^9, {3.8672326746529903`*^9, 
   3.867232692770069*^9}, {3.8672335374315577`*^9, 3.867233563187471*^9}, {
   3.8673380887076263`*^9, 3.867338188480274*^9}, 3.867338234472362*^9, {
   3.8679056415663013`*^9, 3.86790568729235*^9}, 3.8679253440699043`*^9, {
   3.874046436982432*^9, 3.874046445040164*^9}, 3.875067374859962*^9, {
   3.8750674299393673`*^9, 3.8750674649581127`*^9}, {3.875067500108643*^9, 
   3.8750675294263487`*^9}, {3.875067575923634*^9, 3.875067576979113*^9}, {
   3.875067633000821*^9, 3.875067663179824*^9}, {3.875067758095087*^9, 
   3.875067782765314*^9}, {3.8750678283563137`*^9, 3.875067828506658*^9}, {
   3.875067885312623*^9, 3.875067947596095*^9}, {3.8782732154767647`*^9, 
   3.8782732361483603`*^9}, {3.878273494190213*^9, 3.878273827802792*^9}, {
   3.8786304165874557`*^9, 3.8786305145737553`*^9}, 3.878868702333946*^9, {
   3.883048472764543*^9, 3.883048512784402*^9}, 3.883552879113146*^9, 
   3.883553008775543*^9, 3.8835530460041733`*^9, 3.883553096335672*^9, 
   3.8835531281567497`*^9, {3.883553231548967*^9, 3.883553381409316*^9}, {
   3.883553429720069*^9, 3.883553471845708*^9}, 3.883553553471539*^9, 
   3.883553641105945*^9, {3.883553692370737*^9, 3.883553692553404*^9}, 
   3.886160193538054*^9, {3.8861602573179617`*^9, 3.886160273917553*^9}, {
   3.886160305866125*^9, 3.886160344319333*^9}, 3.886160457375475*^9, {
   3.88616050685421*^9, 3.886160529831586*^9}, {3.8861605909377832`*^9, 
   3.886160703759142*^9}, {3.8861607662307*^9, 3.886160856913509*^9}, {
   3.886162773616695*^9, 3.886162773759651*^9}, 3.886162875442349*^9, {
   3.887876725780774*^9, 3.88787678156878*^9}, {3.891325838592125*^9, 
   3.8913258935420933`*^9}, {3.905873068495727*^9, 3.9058730984728127`*^9}, {
   3.905873183053144*^9, 3.9058731830618773`*^9}, {3.905873218158474*^9, 
   3.9058732518644753`*^9}, {3.905873313401537*^9, 3.9058733547752743`*^9}, 
   3.905873395396195*^9, 3.905873586979381*^9, 3.9059074728276033`*^9, {
   3.937900170922924*^9, 3.937900194334799*^9}, {3.937900234120899*^9, 
   3.9379002953725624`*^9}, {3.937900346332659*^9, 3.9379004040606728`*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"fe1c3f07-70b1-4d0e-afeb-26b400c1a477"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pf104e2", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-104-Lr-\
0.5-Wmin1-1.1267e-02\\\\simulation__2022-11-25__18_57_52\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf104e3", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-104-Lr-\
0.5-Wmin1-1.1267e-03\\\\simulation__2022-11-25__14_30_53\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf104e4", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-104-Lr-\
0.5-Wmin1-1.1267e-04\\\\simulation__2022-11-28__11_30_41\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf104e5", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-104-Lr-\
0.5-Wmin1-1.1267e-05\\\\simulation__2022-11-28__17_40_17\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf104e7", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-104-Lr-\
0.5-Wmin1-1.1267e-07\\\\simulation__2022-11-28__09_08_52\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf104e8", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<C:\\\\Users\\\\mtale\\\\OneDrive\\\\Desktop\\\\Sunset \
Paper\\\\Simulation_Code\\\\SUNSET_2\\\\MtoK_closure_w_1_phi_01-Nelts-104-Lr-\
0.5-Wmin1-1.1267e-08\\\\simulation__2022-11-28__15_54_36\\\\Exported-results.\
json\>\"", ",", "\"\<RawJSON\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.860129537136554*^9, 3.860129574939909*^9}, 
   3.865577107325162*^9, 3.865578238119577*^9, {3.8672326746529903`*^9, 
   3.867232692770069*^9}, {3.8672335374315577`*^9, 3.867233563187471*^9}, {
   3.8673380887076263`*^9, 3.867338188480274*^9}, 3.867338234472362*^9, {
   3.8679056415663013`*^9, 3.86790568729235*^9}, 3.8679253440699043`*^9, {
   3.874046436982432*^9, 3.874046445040164*^9}, 3.875067374859962*^9, {
   3.8750674299393673`*^9, 3.8750674649581127`*^9}, {3.875067500108643*^9, 
   3.8750675294263487`*^9}, {3.875067575923634*^9, 3.875067576979113*^9}, {
   3.875067633000821*^9, 3.875067663179824*^9}, {3.875067758095087*^9, 
   3.875067782765314*^9}, {3.8750678283563137`*^9, 3.875067828506658*^9}, {
   3.875067885312623*^9, 3.875067947596095*^9}, {3.8782732154767647`*^9, 
   3.8782732361483603`*^9}, {3.878273494190213*^9, 3.878273827802792*^9}, {
   3.8786304165874557`*^9, 3.8786305145737553`*^9}, {3.87886783186827*^9, 
   3.878867989888258*^9}, 3.87886804331763*^9, 3.8788681058982763`*^9, 
   3.878868139032516*^9, 3.878868170246801*^9, {3.886070705600586*^9, 
   3.886070944393313*^9}, {3.886071020484405*^9, 3.886071020643955*^9}, 
   3.886074333450633*^9, {3.886162631681119*^9, 3.886162632511614*^9}, {
   3.886162704483333*^9, 3.886162769733407*^9}, {3.88616288992892*^9, 
   3.886162967893437*^9}, {3.887876799963346*^9, 3.887876827443328*^9}, {
   3.891325911852232*^9, 3.8913259528835583`*^9}, {3.90587325885422*^9, 
   3.905873294418788*^9}, 3.905907489667822*^9, {3.937900446922718*^9, 
   3.937900539308058*^9}, {3.9379005724043865`*^9, 3.93790057506052*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"82685294-99ba-40a8-873e-52ea707da743"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Keys", "[", "pf58e6", "]"}]], "Input",
 CellChangeTimes->{{3.8750679707488823`*^9, 3.875067978809643*^9}, 
   3.878273851406582*^9, {3.8830485261999083`*^9, 3.883048526318922*^9}, 
   3.883552880863254*^9, 3.886160193751004*^9, 3.8861605509423323`*^9},
 CellLabel->"In[95]:=",ExpressionUUID->"62fe1e3d-504a-495c-b260-c56e700689ab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Time\"\>", ",", "\<\"Efficiency\"\>", ",", "\<\"Radius\"\>", 
   ",", "\<\"p inlet\"\>", ",", "\<\"w inlet\"\>", 
   ",", "\<\"Closure Radius min\"\>", ",", "\<\"Closure Radius mean\"\>", 
   ",", "\<\"wc\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"intersectionHslice width\"\>", 
   ",", "\<\"intersectionVslice width\"\>", 
   ",", "\<\"intersectionHslice p\"\>", ",", "\<\"intersectionVslice p\"\>"}],
   "}"}]], "Output",
 CellChangeTimes->{
  3.875067979749269*^9, 3.878273852291492*^9, 3.8782798511055813`*^9, 
   3.87828687587533*^9, 3.878620258320243*^9, {3.878630307575151*^9, 
   3.878630324531979*^9}, 3.878630386554676*^9, 3.878631654592255*^9, 
   3.878640407710252*^9, 3.878720112836091*^9, 3.8787929383114634`*^9, 
   3.8787942617545137`*^9, 3.8788763115144053`*^9, 3.878889723155037*^9, 
   3.878959342062142*^9, 3.8790795710330048`*^9, 3.879401090259177*^9, 
   3.8794851977934103`*^9, 3.879564687814447*^9, 3.87956476456875*^9, 
   3.87957088690434*^9, 3.8795800807313137`*^9, 3.879580208855562*^9, 
   3.880520611835928*^9, 3.8805290157311687`*^9, 3.883553651692288*^9, 
   3.883553702609428*^9, 3.8860519758107347`*^9, 3.886133527133806*^9, 
   3.8861527950534*^9, 3.886160867472664*^9, 3.8861629777293663`*^9, 
   3.887876843855712*^9, 3.888056670318961*^9, 3.888157837985465*^9, 
   3.8881671777277327`*^9, 3.888169452870875*^9, 3.88817060488805*^9, 
   3.8881712534010077`*^9, 3.888192106750537*^9, 3.891325965391739*^9, 
   3.891928856890792*^9, 3.892180622814233*^9, 3.892440645923805*^9, 
   3.8924644526936197`*^9, 3.904543519854817*^9, 3.9046353024868927`*^9, 
   3.905841860077024*^9, 3.905847335266029*^9, 3.90586067140954*^9, 
   3.905873680988185*^9, 3.905907510855266*^9, 3.906444407635107*^9, 
   3.906453027317245*^9, 3.906515267334691*^9, 3.90651670030287*^9, 
   3.906523579545052*^9, 3.90704789769659*^9, 3.9070550921335382`*^9, 
   3.907057383076198*^9, 3.9078218944942617`*^9, 3.90833483024177*^9, 
   3.908335254789308*^9, 3.937900586070833*^9, 3.939474992002407*^9, 
   3.941680914367466*^9, 3.9417016673788624`*^9, 3.9417019718491764`*^9, 
   3.941702660750448*^9, 3.9431657211478386`*^9, 3.943212032071989*^9, 
   3.943215312597124*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"7aaf0078-c815-544e-9b84-4f4dcc187de1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["N", "cells"], "=", 
   RowBox[{"{", 
    RowBox[{
    "58", ",", "65", ",", "75", ",", "87", ",", "104", ",", "130", ",", 
     "174"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["Rt", 
    RowBox[{"r", "-", "Anthony"}]], "=", "0.38326"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["L", "r"], "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["h", "cells"], "=", 
  RowBox[{"2", " ", 
   RowBox[{
    SubscriptBox["L", "r"], "/", 
    SubscriptBox["N", "cells"]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["N", "elementR"], "=", 
  RowBox[{"Round", "[", 
   RowBox[{
    SubscriptBox["Rt", 
     RowBox[{"r", "-", "Anthony"}]], "/", 
    SubscriptBox["h", "cells"]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.907054398885861*^9, 3.907054537681481*^9}, {
   3.907054570111835*^9, 3.90705462051094*^9}, {3.9070546894115334`*^9, 
   3.907054807331127*^9}, 3.9070550034180202`*^9, 3.907055488719799*^9},
 CellLabel->"In[96]:=",ExpressionUUID->"51f225b1-614f-4e9f-92ed-6bd50f39ab38"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.017241379310344827`", ",", "0.015384615384615385`", ",", 
   "0.013333333333333334`", ",", "0.011494252873563218`", ",", 
   "0.009615384615384616`", ",", "0.007692307692307693`", ",", 
   "0.005747126436781609`"}], "}"}]], "Output",
 CellChangeTimes->{{3.907054616213736*^9, 3.907054621038581*^9}, 
   3.907054692944577*^9, 3.907054777035323*^9, 3.907054807729991*^9, 
   3.907055005811885*^9, 3.9070550921535463`*^9, 3.907055489248948*^9, 
   3.9070573842960043`*^9, 3.907821894504241*^9, 3.908334830264338*^9, 
   3.908335254806525*^9, 3.9379005900298157`*^9, 3.9394749884467335`*^9, 
   3.941680914399147*^9, 3.9417016674302807`*^9, 3.9417019718805065`*^9, 
   3.9417026607660675`*^9, 3.943165725974737*^9, 3.9432120321211834`*^9, 
   3.943215312642132*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"de32d022-0887-3d4e-8d5b-121fb2c001ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "22", ",", "25", ",", "29", ",", "33", ",", "40", ",", "50", ",", "67"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.907054616213736*^9, 3.907054621038581*^9}, 
   3.907054692944577*^9, 3.907054777035323*^9, 3.907054807729991*^9, 
   3.907055005811885*^9, 3.9070550921535463`*^9, 3.907055489248948*^9, 
   3.9070573842960043`*^9, 3.907821894504241*^9, 3.908334830264338*^9, 
   3.908335254806525*^9, 3.9379005900298157`*^9, 3.9394749884467335`*^9, 
   3.941680914399147*^9, 3.9417016674302807`*^9, 3.9417019718805065`*^9, 
   3.9417026607660675`*^9, 3.943165725974737*^9, 3.9432120321211834`*^9, 
   3.94321531264616*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"76fb115f-56ae-f64e-881f-e2623315fde0"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\[Alpha] parameter", "Section",
 CellChangeTimes->{{3.892461264177154*^9, 
  3.8924612922286673`*^9}},ExpressionUUID->"705205c9-70b3-4544-90ce-\
ccb43404bf16"],

Cell[CellGroupData[{

Cell["Categorizing data", "Subsection",
 CellChangeTimes->{{3.886163011260984*^9, 
  3.8861630418222647`*^9}},ExpressionUUID->"2c1f729b-ba22-4768-81a9-\
e8f985f05d0f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"pf58e6", "[", "\"\<Radius\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
   RowBox[{"[", 
    RowBox[{"1", ";;", "355"}], "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"pf58e6", "[", "\"\<Closure Radius min\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
   RowBox[{"[", 
    RowBox[{"580", ";;", 
     RowBox[{"-", "31"}]}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.886162521412547*^9, 3.8861635981406612`*^9, 3.8861637331169043`*^9, {
   3.891943040387249*^9, 3.8919430644246387`*^9}, {3.891943135990904*^9, 
   3.8919431461481323`*^9}, {3.891943401520541*^9, 3.8919434018543043`*^9}, {
   3.89194345968443*^9, 3.891943464730999*^9}, {3.9058736888264093`*^9, 
   3.905873691056026*^9}},
 CellLabel->
  "In[101]:=",ExpressionUUID->"d99c11f9-034c-4c06-9f69-7e7cb96276bb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["pf58e6", "propagation"], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf58e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "355"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf58e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "355"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf58e6", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf58e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "580"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf58e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "580"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf58e6w", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf58e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "580"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf58e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "580"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf58e6", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf58e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"581", ";;", 
         RowBox[{"-", "31"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf58e6", "[", "\"\<Closure Radius min\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"581", ";;", 
         RowBox[{"-", "31"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf58e6w", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf58e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"581", ";;", 
         RowBox[{"-", "31"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf58e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"581", ";;", 
         RowBox[{"-", "31"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf58e6", "total"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["pf58e6", 
      RowBox[{"pre", "-", "rec"}]], ",", 
     SubscriptBox["pf58e6", 
      RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["pf58e6w", "total"], "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["pf58e6w", 
       RowBox[{"pre", "-", "rec"}]], ",", 
      SubscriptBox["pf58e6w", 
       RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf65e6", "propagation"], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf65e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "343"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf65e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "343"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf65e6", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf65e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "595"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf65e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "595"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf65e6w", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf65e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "595"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf65e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "595"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf65e6", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf65e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"596", ";;", 
         RowBox[{"-", "36"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf65e6", "[", "\"\<Closure Radius min\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"596", ";;", 
         RowBox[{"-", "36"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf65e6w", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf65e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"596", ";;", 
         RowBox[{"-", "36"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf65e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"596", ";;", 
         RowBox[{"-", "36"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf65e6", "total"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["pf65e6", 
      RowBox[{"pre", "-", "rec"}]], ",", 
     SubscriptBox["pf65e6", 
      RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["pf65e6w", "total"], "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["pf65e6w", 
       RowBox[{"pre", "-", "rec"}]], ",", 
      SubscriptBox["pf65e6w", 
       RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf75e6", "propagation"], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf75e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "470"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf75e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "470"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf75e6", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf75e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "889"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf75e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "889"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf75e6w", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf75e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "889"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf75e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "889"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf75e6", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf75e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"890", ";;", 
         RowBox[{"-", "23"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf75e6", "[", "\"\<Closure Radius min\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"890", ";;", 
         RowBox[{"-", "23"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf75e6w", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf75e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"890", ";;", 
         RowBox[{"-", "23"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf75e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"890", ";;", 
         RowBox[{"-", "23"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf75e6", "total"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["pf75e6", 
      RowBox[{"pre", "-", "rec"}]], ",", 
     SubscriptBox["pf75e6", 
      RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["pf75e6w", "total"], "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["pf75e6w", 
       RowBox[{"pre", "-", "rec"}]], ",", 
      SubscriptBox["pf75e6w", 
       RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf87e6", "propagation"], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf87e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "379"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf87e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "379"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf87e6", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf87e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "599"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf87e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "599"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf87e6w", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf87e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "599"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf87e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "599"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf87e6", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf87e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"600", ";;", 
         RowBox[{"-", "19"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf87e6", "[", "\"\<Closure Radius min\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"600", ";;", 
         RowBox[{"-", "19"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf87e6w", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf87e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"600", ";;", 
         RowBox[{"-", "19"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf87e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"600", ";;", 
         RowBox[{"-", "19"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf87e6", "total"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["pf87e6", 
      RowBox[{"pre", "-", "rec"}]], ",", 
     SubscriptBox["pf87e6", 
      RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["pf87e6w", "total"], "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["pf87e6w", 
       RowBox[{"pre", "-", "rec"}]], ",", 
      SubscriptBox["pf87e6w", 
       RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf104e6", "propagation"], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf104e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "398"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf104e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "398"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf104e6", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf104e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "559"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf104e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "559"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf104e6w", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf104e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "559"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf104e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "559"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf104e6", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf104e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"560", ";;", 
         RowBox[{"-", "23"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf104e6", "[", "\"\<Closure Radius min\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"560", ";;", 
         RowBox[{"-", "23"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf104e6w", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf104e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"560", ";;", 
         RowBox[{"-", "23"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf104e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"560", ";;", 
         RowBox[{"-", "23"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf104e6", "total"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["pf104e6", 
      RowBox[{"pre", "-", "rec"}]], ",", 
     SubscriptBox["pf104e6", 
      RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["pf104e6w", "total"], "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["pf104e6w", 
       RowBox[{"pre", "-", "rec"}]], ",", 
      SubscriptBox["pf104e6w", 
       RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf130e6", "propagation"], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf130e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "379"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf130e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "379"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf130e6", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf130e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "558"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf130e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "558"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf130e6w", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf130e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "558"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf130e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "558"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf130e6", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf130e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"559", ";;", 
         RowBox[{"-", "16"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf130e6", "[", "\"\<Closure Radius min\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"559", ";;", 
         RowBox[{"-", "16"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf130e6w", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf130e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"559", ";;", 
         RowBox[{"-", "16"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf130e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"559", ";;", 
         RowBox[{"-", "16"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf130e6", "total"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["pf130e6", 
      RowBox[{"pre", "-", "rec"}]], ",", 
     SubscriptBox["pf130e6", 
      RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["pf130e6w", "total"], "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["pf130e6w", 
       RowBox[{"pre", "-", "rec"}]], ",", 
      SubscriptBox["pf130e6w", 
       RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf174e6", "propagation"], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf174e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "420"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf174e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "420"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf174e6", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf174e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "582"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf174e6", "[", "\"\<Radius\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "582"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf174e6w", 
    RowBox[{"pre", "-", "rec"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf174e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "582"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf174e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "582"}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf174e6", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf174e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"583", ";;", 
         RowBox[{"-", "26"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf174e6", "[", "\"\<Closure Radius min\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"583", ";;", 
         RowBox[{"-", "26"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf174e6w", 
    RowBox[{"rec", "-", "end"}]], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"pf174e6", "[", "\"\<Time\>\"", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"583", ";;", 
         RowBox[{"-", "26"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"pf174e6", "[", "\"\<w inlet\>\"", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "[", 
       RowBox[{"[", 
        RowBox[{"583", ";;", 
         RowBox[{"-", "26"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf174e6", "total"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["pf174e6", 
      RowBox[{"pre", "-", "rec"}]], ",", 
     SubscriptBox["pf174e6", 
      RowBox[{"rec", "-", "end"}]]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["pf174e6w", "total"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["pf174e6w", 
      RowBox[{"pre", "-", "rec"}]], ",", 
     SubscriptBox["pf174e6w", 
      RowBox[{"rec", "-", "end"}]]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.883559079218058*^9, 3.8835590829138308`*^9}, {
   3.886160317788706*^9, 3.88616031778953*^9}, {3.886160658584836*^9, 
   3.886160658585721*^9}, {3.886160922648109*^9, 3.886160931234226*^9}, {
   3.8861609690446987`*^9, 3.886161105001107*^9}, {3.886161191406516*^9, 
   3.8861612948475237`*^9}, {3.886161410657834*^9, 3.886161502303738*^9}, {
   3.88616158473877*^9, 3.88616161794221*^9}, {3.886161671092443*^9, 
   3.886161800828906*^9}, {3.8861618689460793`*^9, 3.886161950117033*^9}, {
   3.886162104543556*^9, 3.8861621342592707`*^9}, {3.8861622242394037`*^9, 
   3.886162293259264*^9}, {3.886162358664493*^9, 3.886162457083165*^9}, {
   3.88616250001031*^9, 3.8861625157374477`*^9}, {3.886163765375228*^9, 
   3.8861637775578547`*^9}, 3.888170989811778*^9, {3.888171323670068*^9, 
   3.8881713296772623`*^9}, {3.9432140693709793`*^9, 3.943214080175812*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"b66b0e54-6e1e-4c42-b4fd-902e8574fc6f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xlabel", "=", 
    RowBox[{"MaTeX", "[", 
     RowBox[{"\"\<time \\\\; (s)\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "Myfontsize"}]}], "]"}]}], ";"}], 
  "  "}], "\n", 
 RowBox[{
  RowBox[{"ylabel", "=", 
   RowBox[{"MaTeX", "[", 
    RowBox[{"\"\<fracture \\\\; front \\\\; radius \\\\; (m)\>\"", ",", 
     RowBox[{"FontSize", "\[Rule]", "Myfontsize"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"opt", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", " ", "0.65"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", "texStyle"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"xlabel", ",", "ylabel"}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"t", ",", "Rt"}], "}"}], "]"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       SubscriptBox["pf58e6", "total"], ",", 
       SubscriptBox["pf65e6", "total"], ",", 
       SubscriptBox["pf75e6", "total"], ","}], "*)"}], 
     SubscriptBox["pf174e6", "total"]}], 
    RowBox[{"(*", 
     RowBox[{",", 
      SubscriptBox["pf104e6", "total"], ",", 
      SubscriptBox["pf130e6", "total"], ",", 
      SubscriptBox["pf174e6", "total"]}], "*)"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<time\>\"", ",", "Bold", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<closure radius\>\"", ",", "Bold", ",", "14"}], "]"}]}], 
     "}"}]}], ",", "opt", ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Anthony's results\>\"", ",", 
      "\"\<58 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=4.5\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<65 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=4\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<75 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=3.5\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<87 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=3\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<104 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=2.5\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<130 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=2\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<174 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=1.5\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.875069520629857*^9, 3.875069521005477*^9}, {
   3.875069582772043*^9, 3.875069634335623*^9}, {3.8750697225641623`*^9, 
   3.875069728994524*^9}, {3.8750697828299103`*^9, 3.875069842460795*^9}, {
   3.875069883147547*^9, 3.875070282032522*^9}, {3.8750703198532*^9, 
   3.8750703473429327`*^9}, {3.875070390034153*^9, 3.875070400319558*^9}, {
   3.875070535626419*^9, 3.8750706000092363`*^9}, {3.875070649058566*^9, 
   3.8750709274509983`*^9}, {3.8750709589123697`*^9, 3.875070960510127*^9}, 
   3.875070999547874*^9, {3.8750710536933823`*^9, 3.875071070312463*^9}, {
   3.875083602072206*^9, 3.87508379280766*^9}, {3.87827474097661*^9, 
   3.878274827907084*^9}, {3.8782748616272697`*^9, 3.87827488950413*^9}, {
   3.8782751033417063`*^9, 3.878275128858859*^9}, 3.878275167970545*^9, {
   3.878275214029951*^9, 3.8782752237287083`*^9}, {3.878275314272624*^9, 
   3.878275373192937*^9}, {3.878275436319326*^9, 3.8782754430415297`*^9}, {
   3.87827553497789*^9, 3.878275566880742*^9}, {3.878275744925362*^9, 
   3.878275751664321*^9}, {3.878275852200067*^9, 3.878275877415042*^9}, {
   3.878275908171173*^9, 3.8782759148461437`*^9}, {3.878275978691115*^9, 
   3.878276010186236*^9}, {3.878276183906871*^9, 3.878276189233787*^9}, {
   3.8782762372472143`*^9, 3.878276272754187*^9}, {3.878276311869276*^9, 
   3.878276317968033*^9}, {3.87827636348989*^9, 3.878276390660694*^9}, {
   3.878276640587113*^9, 3.878276641419059*^9}, {3.878276912615781*^9, 
   3.8782770336818542`*^9}, {3.878277078903997*^9, 3.878277153901661*^9}, {
   3.878876520890106*^9, 3.8788765282842703`*^9}, {3.879159084690365*^9, 
   3.879159087060967*^9}, {3.879159125819654*^9, 3.879159181013218*^9}, {
   3.8791592111130733`*^9, 3.879159232433074*^9}, {3.879159267257741*^9, 
   3.87915927873517*^9}, {3.879159328035495*^9, 3.879159353982354*^9}, {
   3.879159446496798*^9, 3.8791594585147247`*^9}, 3.879159557996456*^9, {
   3.879159594715703*^9, 3.879159605138678*^9}, {3.879159692113433*^9, 
   3.879159693875244*^9}, {3.879159772215129*^9, 3.8791597998346786`*^9}, {
   3.879159992234779*^9, 3.879160077009997*^9}, {3.8791601258734283`*^9, 
   3.879160127740384*^9}, {3.879162012095924*^9, 3.879162031153586*^9}, {
   3.883552906621821*^9, 3.8835529080520077`*^9}, {3.883553014001112*^9, 
   3.883553014204439*^9}, {3.883553051034876*^9, 3.883553051233468*^9}, {
   3.8835531008229647`*^9, 3.883553133074808*^9}, {3.883553193537558*^9, 
   3.883553214759931*^9}, {3.883559097092977*^9, 3.883559098935239*^9}, 
   3.8835591710974283`*^9, {3.8835592110507393`*^9, 3.88355923571332*^9}, {
   3.886160198614847*^9, 3.886160198807115*^9}, {3.886160244243005*^9, 
   3.886160273970522*^9}, {3.886160305913042*^9, 3.886160317826474*^9}, {
   3.886160358517962*^9, 3.8861603590205517`*^9}, {3.88616055101536*^9, 
   3.8861606586230507`*^9}, {3.886163505749021*^9, 3.886163508052052*^9}, 
   3.886163552683443*^9, {3.891929018471554*^9, 3.891929024179528*^9}, 
   3.8919290631041822`*^9, {3.8919291408653727`*^9, 3.891929145985957*^9}, {
   3.891929204624161*^9, 3.891929210769806*^9}, {3.891929276547789*^9, 
   3.891929282786059*^9}, {3.89192938818589*^9, 3.891929388235077*^9}, {
   3.891943827316353*^9, 3.891943827530027*^9}, {3.8919438934717216`*^9, 
   3.891943893686173*^9}, {3.891943925934754*^9, 3.891943926128469*^9}, {
   3.891943966708569*^9, 3.891943966986404*^9}, {3.891943999538752*^9, 
   3.891944000648571*^9}, {3.891944047119421*^9, 3.8919440487738943`*^9}, {
   3.892461310706586*^9, 3.8924613110077543`*^9}, 3.906453295551536*^9},
 CellLabel->
  "In[152]:=",ExpressionUUID->"cfd8b0be-ffed-4564-ad61-30b3584c5a4f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, 
     InterpretationBox[{
       TagBox[{
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           PointSize[0.003666666666666667], 
           AbsoluteThickness[2], 
           StyleBox[
            PointBox[CompressedData["
1:eJxcfXf81tP/fqJoKKE0VZQoDRQNujSVhoZRWpTsREtKpWGVURr6RNFCIUmk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             "]], FontSize -> 22]}, 
          Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           RGBColor[0.880722, 0.611041, 0.142051], 
           PointSize[0.003666666666666667], 
           AbsoluteThickness[2], 
           StyleBox[
            PointBox[CompressedData["
1:eJxd2nlcTO3/P/DsFVFJRJJkJ2RPeVmjSCGihEiiVLaQLJEsEVGI0Ia0UGlP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             "]], FontSize -> 22]}, 
          Annotation[#, "Charting`Private`Tag#2"]& ]}, {
        "WolframDynamicHighlight", <|
         "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
       StyleBox[
        DynamicBox[
         (Charting`HighlightActionBox["DynamicHighlight", {}, 
          Slot["HighlightElements"], 
          Slot["LayoutOptions"], 
          Slot["Meta"], 
          Charting`HighlightActionFunction["DynamicHighlight", {{
             Annotation[{
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2], FontSize -> 22], 
               Point[CompressedData["
1:eJxcfXf81tP/fqJoKKE0VZQoDRQNujSVhoZRWpTsREtKpWGVURr6RNFCIUmk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                "]]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.880722, 0.611041, 0.142051], 
                AbsoluteThickness[2], FontSize -> 22], 
               Point[CompressedData["
1:eJxd2nlcTO3/P/DsFVFJRJJkJ2RPeVmjSCGihEiiVLaQLJEsEVGI0Ia0UGlP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                "]]}, "Charting`Private`Tag#2"]}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{0, 1.83249406159968}, {0, 0.3860241405548744}},
               "Frame" -> {{True, True}, {True, True}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {400, 260.}, 
              "Axes" -> {True, True}, "LabelStyle" -> {FontSize -> 22}, 
              "AspectRatio" -> 0.65, "DefaultStyle" -> {
                Directive[
                 PointSize[0.003666666666666667], 
                 RGBColor[0.880722, 0.611041, 0.142051], 
                 AbsoluteThickness[2], FontSize -> 22], 
                Directive[
                 PointSize[0.003666666666666667], 
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 AbsoluteThickness[2], FontSize -> 22]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> ({
                  Identity[
                   Part[#, 1]], 
                  Identity[
                   Part[#, 2]]}& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, 
             "PlotRange" -> {{0, 1.83249406159968}, {0, 0.3860241405548744}}, 
             "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
             "ImageSize" -> {400, 260.}, "Axes" -> {True, True}, 
             "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> 0.65, 
             "DefaultStyle" -> {
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.880722, 0.611041, 0.142051], 
                AbsoluteThickness[2], FontSize -> 22], 
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2], FontSize -> 22]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 Identity[
                  Part[#, 1]], 
                 Identity[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ListPlot, "GroupHighlight" -> False|>|>], 
         ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
          4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
        False]}, 
      Annotation[{{
         Annotation[{
           Directive[
            PointSize[0.003666666666666667], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2], FontSize -> 22], 
           Point[CompressedData["
1:eJxcfXf81tP/fqJoKKE0VZQoDRQNujSVhoZRWpTsREtKpWGVURr6RNFCIUmk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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            PointSize[0.003666666666666667], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2], FontSize -> 22], 
           Point[CompressedData["
1:eJxd2nlcTO3/P/DsFVFJRJJkJ2RPeVmjSCGihEiiVLaQLJEsEVGI0Ia0UGlP
ad9LyzQzhBZCQjNpm02/c67f3N/Dp3/ux/Nx57jOeV3X+3VmHsbuct6wp7eM
jAy/j4wM/d/6rhPOAXJm2HFnTMD3BUFgFVjb9zZfD4cFFVZnzgZhloJkBDt8
A8xC1xu2FAfBPUdizFc0x9GeXh4uWsEwDn/W6OOzCUVKpth4NhjukRuOHxtn
gaxEH/dPn4OhoS9ad6NyC2SaR3+bvzEEH2vedT68Z4kpidUaBXkhUD4wfkr9
2W34xZn6bNGSUMxqTkm/dGE7+v3oO+jcq1BYh4+847JpJyqOeY53WR4G9TGs
gztP2MDqdMTB20WUd55qf/piF+rvaHbv3/wYFzu3+9sJdqPKceY81d+Pccsn
NCrbYg9UqnbEGF9+glfLW4e1ldjhE/v4gKtaTxH06FToXAt7yCvvGrT99VM8
dDwyvUG4D8LNFmquu8Kx93qKzNpkBwwwDN9mMugZWgp/i1puHEDNvF1bX8c8
g3+ucM46L2dEB3fNPb89AqGudcqiUhdYjOu4/GNIJE5unrrn9ZeD0JGP9Hhe
FAkJ64vTJqXDyJuiGFflEYU++b3OBJkcQc7UcxOvIBqdBqXPvAKPouK55iZ3
cTQmqG871LfHFbEjXvdzK36O906H5ym5HseOhMAzr71fYKtAsDO3txsqN2rd
4k+OQV2vb+d1npzExtXX9udcj4H/i9M/XGxOYe2Kb+OfCmJQGTQvI3XuGXwx
40St2RMLBfUrFpo3z6LowbH5RRWxaDTbPUPzjgf6V+Rt3rk0DvULe0+/EHEO
4lnTtnBexOHQ4Y6uP6Xnoet3L6dN8yV8s2foGvR4wnujnnCY/0uMKrN/3b7U
CxcyK9bIDorHsY0Pjqq4e+Fk2rjVdmPjMWNn/8aNPC/sqO46420Sj0cnuKlV
3It4WPauv9WjeNiW3/BftOwylrwfOblSJQEVSw/l3824Ao1FUcolPgk4FTSs
KmfdVeh4bi3ulk/E4fYK2du/r6FIS+nO2wuJiH/w7VVH9HWcrOiWW9IvCe90
Uq9mb7sBdpVzZNSGJJiO3VXWvMYX6/aw1J9WJ+GSnYyC7KqbUB9wtXqIRTJa
j8oFBa67hevs1+9G1ybDqLfO98m7/dD3tzBH0SYF3S8ff3Q76Q9rp6qhCl9S
oDwjsEYh8jbiw82t7h1IhZpi4oIZzXfg6zPF1aI7Fa9YP1sd5gXgrn/VmJwL
aRi+0Hfm7Hv3kBL2QaVG9RU2iWYMfzkgENWTrl9Oe/oKA/buqlPyeoDenn/G
yC9Ix9crk2f/GvYIJjOchFaF6ZiX4X6uJfkRJP31S9P6ZmD/TV/Fw2eCsDij
/aHW8QycGDPb3NYqGAbb9CrzBr1GWEBvK7WlIfg0ZO3kitDXiBg753ulQwhU
zioruWS9RuKsO7LLs0IwMndQcoXoNcrXW68c7xiKsaMUPktmZ0Jeu7b0s30Y
nFf8bph/NhMLP08eqiMKg+peVYl3ZCaWvFxxtK/cE7TNvf3ua1cmau91OxpT
52rmm/FTnA2zUPRkjP6VK0+RMHqNw0DbLDzOOPBOziocxZWzNlwKzIL+ApGz
4rVnuLqiwC/zexa27Bu254taBPjbtAfMU8zGjRIj05uzI/Hg5fDFupuzsVa+
ibfxfBSmves2v/wkGzrjHzhFBUeBv9/puOHzbHTcsBqb8TQKs5zTvxe8yEbS
2/iP7eFReKZet2N4TDaV4/SBoyOi4JMZltBJWZxY9fHd8yhYvGhfaxyXjR+L
1b02J0dh5s9ZNcXx2Shd94JlUhKFpz+VLUJTsnHVqeagPj8KO648HzQhJxuD
no+NUjOIRmXT4xFBNZSnp2qyWNH4MWGx2XlBNi4KbfQLOp8jda/tonV6OXD9
JZP0cMELnLDV36BtlANz9uIok1cvoOZSfFPDLgeyG61Lamxi8N7mYcqaRzk4
v0XkLPkUg8eqduprODmYG8Ftuu0ZiyhTR5lXI3JRvNDVM3JqHPIDn/8Zvi0X
4xYcHGXIjsOebsemK49yoTyKf3fr4ZfY1KA80/x9LgbY6zm9mRiPVyE7FoeP
yYOl2CF6QFo8ynfX3Jm+OQ9bx27LmnciAW96rxCtv5eH4A9fshJ6J8I20n6U
XWkeyky8ek4UJ6IoNOjGcqV8NGfYsHcbJ2HIkvU/4gzy4ZF0a/j9UckIKD23
ufp8PmYFvf+udDMZH84Vub+MzMf8wPo59xxTIPDw2e3Jz8dxD4ue129TcD9w
rXWFSgGEa1b6DYxPhfGTfdGhWwqQuatqqNPYNFg2NaPFrQBrb/xQni1OQ/17
h1dr0gowYIXJJPV9rzDnYOTD97UFOBU5eOOvZek4tXe+WEGtEKbjC/WLY9LR
OlfpxO+Fhfg9YpHiuasZUBu8nX3mWCHu9F++/nh3BqIDvj/K8i9EXcOGatuK
1zDWLbCZXlmI1t8fdYdqZmKH3gC2Ga8QvwRGeazrmbj/4+u09zpFuGWrbvA9
JxNhg1rTTY2L8GFh1rRh07KwePDi1IwzRZhfs3VV1t4seG9Rc7ULLkLLQG93
tbosuPTs/51eW4R3K++svzswG8o+60Z28ouQnPJC5G9L7fM8X/b50cU4nciy
cqb2sWKAVq35smLIx2ioa63MgfHy31YGF4uhNVHZznBjDgyM5yRt9CnGhmEC
gY9zDhJ8012tA4sRx88fqxmeA55wyt0JScXIv2PqMrorB9vm756UUFuMfbLX
3Nrv5YK3U7TMWbsECieKPUsW50F/Zk2BnUMJYpsHXA9pzIN8+aKgwNgSbLJc
GXDCKx++Odt1vLpKICg+F2o2pQAh3QkXCxeVInBRZvTE8gLEyn7KKjxdiiVR
kqQ/BwvR6PhniWVmKT6rL8quGVaErfuvxtb3lOLSteOlUSlFuDdk1euAxWWY
9ieBfd66GAdeRGjGnirDG6ff9Za9SvDz1trFotQyHK6b2TLrcQmist7b3ukq
w3Azpw5Zo1KcOzJn6azZ5UjLjOyp+1GKj7NKZpsfKMeOWc1ySTfKcHO3/ELl
p+XoEzJBxWdOOUpmui6KqivHE2VbjT3cchzlrXa4OfwNjM8HT9J3f4MhZgom
iuvegLweKVYgYr4565PnGxjp+mh02FTA6eqDoT6pb3D/e1Ro/csKTNeTfer0
6w1+hpRMKu1XCbGcjdxGpQrA6nt0kkUlLA21i7SnVsB3qNzs0GeVWKTsv3zV
igp8KpmY7COqhP6PtR+VrCsw19PQwM2kCiEb5jedP1qBi/p7svc8qoJP6CzP
9msVeNt+ftV6fhX6jtYxb31cganRIaX6y6vxyCOY/yy9Au57stZP8q+GYIen
+q6aCpSPrmcP/VoN/rk1Tmt/VECT/ceqZwELG/0DRsv0qcQhn9EN36+wMIV/
60mMWiVyDfXt2O9ZUKntO/T7jEqo9li2ZOnU4EBP4nO/lZWwTzrhEn22BubX
2PVWVpVIdb7bcbeqBjflxVbuLpUYNCnJzVObDe6hkKe7LlRie31Nj7MrG1Pm
iiI+36tEzN12T6tCNq7vmnDk04tK9Fo/VH7VSA7m8l0yJ+VWYqOc7nVdRw6s
rhk9KeZW4nGWmYpGBgfnPbc9Gv+zUpoHF72/XDBQ71UlzYOL+QsPppepVEnz
4OJ2/9N/TkyqkubxFsmlawZCv0qax1toCI23yZlVSfN4i2+vhE59d1dJ83gL
uWkflHlHqzCH5PEOmgWqyW6XquBF8ngH7iZMMLhfBS7J4x2Ca+Uvl0ZXYQrJ
oxa299LKTmdXSfOohYLMJMkkVpU0j1pUPbKbpt9UJc3jPeS+jVZX6KqS5vEe
R4K6LBXlqqV5vEeSEi/k2chqaR4fUKd7dvmTqdXSPD7AlHPST0m/Gikkjw+Y
V82f0LW2GgNJHh+xZ+Y1z1jraliTPD5iw71w+2qnarwgeXyEYa8o81Me1dI8
6iCoU81d4lstzaMOIpnFAp3gamkedSiweDtAGFMN0auk0r6y9dB+dmyKYVY1
tNVWXRfOrMeSw5mFqpXVMDnKXs/bWo9+eWG33tZXw7Vyj8qXc/WYLjlgcZ1H
7dvpHezayHqk6U57sbA3C4WXPQMqWfX4kMExhhIL/Kah2wok9Xi9fcP9bE0W
Ri4L1Uif0IClB+ZfNZ3JwvKHug1xpg2Iut68ZQJYcBRmhYYfb8DCP6Wai81Z
8N+83u5hcAMMJha8crZhISOufpJfcQOUb6D/QWcWvg52abn8uwEl12d1Pj/F
gqJDT/QZ9UakZCtXl3uzsLDAx+XoykacG3l0emMAC7vGacx2cGrEEysP09nh
LHifie7YeacRP8+dLahLYCG+Vj95c2Yj5pzWjeiby8KH+aVua5sbodY4ak//
Khb6+1kZLFP+BNMz2k/q6ljQ4X3vmb/oE/a8vznuz08WLNa6ZU+3/QRvfqNN
jIiFs+FyF8Zd+4RNo3lF9fI1eNY3YJVa4ifkxrx60zW8BlU7J8kPqfuEsQWx
B1zH10jz+AwjRcPitDk10jw+Y4Cdb9u8ZTXSPD5j3D3tk0KzGmken+FkFOf0
0rpGmsdnnK+2Hpm5v0aax2ecs9bRbThVI83jMzY7DIs4eLlGmkcTBFtVFJ74
10jzaMKmKHHfouAaaR5N8FaYmpT+okaaRxNUF/udiEyrkebRBIXm91uiCmqk
eTThqOYRp2tva6R5fIHFm8XFbp9rpHl8gYNYdd2v1hppHl9wY9V8rUxRDa6Q
PL5Ay9RLO0qWjZckjy+w9B9xSEGFjfckjy9Y52gxzmwMG/1IHl/x7OvrXdOn
saV5fEXr+ojj5+azpXl8RafK/XUKy9nSPL5iX61p75x1bGkeX6Fz8sNwN0u2
NI+vCBh+1NrJji3N4xte+mVo+B1kS/P4hl0juufx3NnSPL4halht06lLbGke
3wDx4+1Nt9jSPL5BvHHLlSWP2NI8vkEryD5gUxRbmsc37E7YdaYiiS3NoxlX
N7Rc3pTDlubRDNdy3Ykm5WxpHs2QL5VpPPuWLc2jGW19161e95ktzaMZC3QN
N2q3svGF5NGMt6muDZuEbAwheXzHeqXURzf7cbCA5PEdxyN1zjYpcmBD8viO
2MVNCdbqHGke32Eacr1HZiJHmsd3WPg5+E7Q5UjzoNyg/UHGgCPNowVeJ1KU
763iSPNogeWana2aGzjSPFqwZVN/ds02jjSPFlxyOBfG3cuR5tGCAj3l6rxD
HGkeLVA7cIRtfIojzeMHrKa0pfa7xJHm8QPG7jMCgm9ypHn8QMa+W2rsQI40
jx9Q45gcHvaUI83jB8a9Uol1iOVI86B+f3Lg07g0jjSPHxDys8wc8jnSPH5i
1o8zU35XcKR5/MQAmz1njtVy4EDy+ImWIsslrU0c+JE8fkLL2/tZeSsH6SSP
nzjS3VN8RsCR5vETrl2Lbz/vw5Xm8Quef+5zihW40jx+QSKKdz0znCvN4xf0
1ZS1qsdypXn8Qk7+G+7QaVxpHr/QzgmZ2WceV5rHLxjEBd+hWlyaRyvGDTWJ
O2TElebRiqH5dWOxkSvNoxUVoX7yi6y50jxa4Rb+/XKqHVeaRyv6rZZ7p+3C
lebRiuFysluLT3AhQ354WOSiM6/dg4v9r47cGtGXB1f5iweWe3LBOt48YZYs
9f9Hzlc76cXF4rnbU40G8dAUnMt6dYmLcH6VyS5FHhRmNBh1X+FC+fmqBjcV
HlrWnPFXu8aFO7kgD3eSdimMu87FF+pqUeo8BL3tHbDGlwuzT4/v52rywE6L
Fey9xUXqo5EzPmjzYPmRPdPDnwvtbdezOybx0GqXmeh+hwufEX03D57Og8yt
rn6OAVx0kwXykOD6MGnmfS52+f50x1xqPRd+9/oYyEUptbotC3mIKYo66PiQ
i3nynFAXAx52XNpi3vmIi6D8NfMvL+VBfuu9B7uCuZA/n1kcvJIH+8y7VUUh
XBwBfcM8SELqxwwJ4+Kj6Bl1xzzUV8zgLnvMxepkjQst63nwOc7qvf8JF3H0
49vMwwG3Rt1jT7lQp2/XkgdhgaHwdjgXXvTytvOQlifJC3jGBY++3C4ehv/q
CTgTwYWlHf3Dw8LnPatMIrnI1aoVnN7Pw3lD5c/Doqj860yv3XHiwVE+LbGI
8l3q6cUc4qF//2SBVzT1XrZlYXyhKw/Ft5Rypj/nwlGFDoSHndOSJBmU2RX0
BXkocDfesPgFF0uoqymf5+HT1bEnnlOOMBrUe+pFKm+PJcZKMVyo9PfwX+5N
Pd95L8faUz5NpbHtOg/vfvadGk/522k6YB4ijov3dFLesIheIA9t3XdzZsRy
8aprI5UwD0bLijVsKE+gVpfxiIehFR/lvSnfcDGgEuHh1pg2veeUhdPiHrQ+
5eGrskRYSdmW3n5RPLw+ODBaQLmc3i4xPEwrn2syMo46b3S88TyYdDZOmUU5
hI4jmQeNO9Y+yygPoh/fKx66DMX2lpRd6dvNpPLYt8NuD+V6enm5PGT1L316
hLIxfblCHnT8bPKuUI4vpX94+DklS+8mZY3LS3c2VfCw4d1D0T3Kl1Ym/paw
qN9fLxyUS7mt19SLqm+pv69ht0w95W0Z9IbmwVPmgWkz5Xw3OhBq/y+tFIoo
z5xPX5CHEf4L4+Sp9+Z71NWON/MQ5aPXNoZy35hD9r4/qf0e0vlEl7KT41dq
B/JQEvqpCZS5k+gDwkPn2no3c8rLmuiAKb9O89hOOSqYXiC1n664fthDWZU+
vr350Erd4nSA8ln6uPXno0FW/8NRyt/Z1PGQ54N/4dgYD8rm9HYezMcaVvn4
y5Qz6O2nzMec5b2qwylPoreLKh/D55xTjqV8k453JB/Ni+8fSKEs9qTi0ODD
1eTg9SLKdvTj0+JjvJmP/xvKFfTtTuAj6vHJQ7WU9ejlTeWjZUOL0WfKYfTl
ZvBh9u5KewvlwbPpHz78Z/950Er5eOtT6gTzUTJ9f2UH5cZIdUvbRXxcz7s7
UUJ5rT09EKi/74X16D7xXCRq0xuaj1FvJjcpUtZsoANhfOUBfUE+8raV5Y6h
3L7VltrR1P3KtvhMprxd9W1510Y+Qhq8pk+nXEiPvy18THrHvadLWZceV9v4
qKgK6JlNOZAeLzv5iLj9IFCPcn96HNjyIatQFE3bhT6+9nzIv9StM6T87ix1
3Bz5eDDXIXgt5RX08XDhI2Biq6UZ5ef0dj7Cx9o/v0o2UR5Bb7/jfLwZItC3
onyO3i7ufHhq2XjT/qFDxevBhzBv6WxbypvpOC7woWp4/cQBypn047vMeAp9
u9f4uHNi04CDlP3o5fnycetmW7Ar5T/v6QfIh3vE6wra9gH0Dx9e4QMEbpSr
Ng2eHveAD4cbWhEnKesr0wOVj5xM2yenKD8ppwcCH+dOHyZW9CYbmvo8GaN5
kbIbXR/Pqf15/R3rEuXPfahxH8fHj+3jNl6mvI4ez4mMk+lxmsqHwU2d79co
a9HjL4MPt/otxFfpcZXNh2kc57gv5c5YOmDqftYPEdLeSY+DYj7ODn4RfZNy
8RTq+JbzMcGobrIf5Tn06qoYP6SPB4exLL2da/nop3y7z23Kh+jtV0ddT03n
zh3K77n0DTM2pOP9ykfx3C1FtGPoOFr4yN+88w3tkfTja+XjWlnlpADKnvTt
/uZDnJmVfp/yLy96A/JxuClbJ5DyFvpyIsbZPfQPtT88Z66nPY30eRuO7rp+
iPZt0udtuFIg1npAWYb0eRtci4/dor2f9DljVjQdSBtWJev3e0h5MelzxuGk
zxkrkz5n7E76nPEXK/qAMDYjfc44lfQ5Y23S54x9SJ+3ISrgkzvtbjm6z9uw
zrzwLu1dpM8Zl56jNwzjeaTPGQeRPmcsT/qc8RHS523w9Ssi/jiTPsCMV5M+
ZxxH+pyxOulzxl6kzxnzPtIDlbEl6XPGuRb0hmasQ/qc8V3S54x7kz5n7Ej6
nDG7H93njJeQPmccQfqcsQrpc8anSZ8z/vaSHviMN5A+Z/yK9DnjCaTPGd8g
fc5YaEMXMGNb0ueMy9/RA5DxAtLnjENInzMeRPqcsSvpc8b1l+hCYmxM+pxx
POlzxhqkzxlfIn3OuG0e3eeMt5E+Z5z/gh7QjGeS8cf4Hulzxn1JnzN2In3O
mGtNF+bv//My0ueMo0ifM1Ylfc74LOlzxt8H0n3O2Jz0OeMM0ueMJ5E+Z3yT
9DljcQq9ARnbkT5nXKFL9zljPdLnjMNInzMeTPqc8XHS54wb6+lAGK8lfc44
kfQ5Y03S54yvkD5n3O5DHxDG20mfMy4cQPc5Y13S54wDSZ8z7k/6nLEL6XPG
7xLoDcN4Belzxs9JnzMeQfqc8TnS54x/7KYPMOPNpM8ZZ5I+ZzyF9DljP9Ln
jP8o0X3O2J70OeOqK/SGZqxP+pzxE9LnjBVJnzN2I33O+PMCus8ZryN9zjiZ
9DljLdLnjK+SPmfc+YUe+Ix3kj5nXLyDPnCM55A+Z/yQ9DljWdLnjA+RPmf8
XoHuc8aG5HYZx5A+ZzyS9DljT9LnjH+l0YXU/n/eQvqccfYcus8ZTyN9zvg2
6XPGMqTPGe8nfc6Y1UgPaMaLSZ8zDid9zliZ9Dljd9LnjL/coAuTsRnpc8ap
pM8Za5M+Z+xD+pxxN/lCgvEu0ueMS5PoAmE8j/Q54yDS54zlSZ8zPkL6nPHH
PXSfM15N+pxxHOlzxuqkzxl7kT5nzBtK9zljS9LnjHOv0gXHWIf0OeO7pM8Z
9yZ9ztiR9Hk7zq69MrwwjOp/PbrPGS8hfc44gvQ5YxXS54xPkz5n/O0bvWHa
cdR8rMAikOp/0ueMX5E+ZzyB9DnjG6TP2zHI71HR1WtU/9+mDzBjW9Ln7Rhi
/mTE+stU/w+h+5zxAtLn7RDszBoQe4iLsv9xV9m/XlPxr3+z/vXyj//6E+9f
j1Mt+8ehO//HHf/jMW/+9eHKfz2K/a8d6v71wLZ/vWZ42T8usfkfd/6PNd/8
6yOV/1qd/a8d6/71oLZ/vZZawN8utfkfd/6PqQX8Y2oB/5hawD+mFvCPqQX8
Y2oB/5hawL/u/B9rvvnXRyr/tTr7XzvWtaPdWV/fzJEL8vVAA2Prt6Euks+M
N93O7rD/wZjUU0c7fnqdPo+dXMxddz37qGwHfu3zbHpoyAUZb/KMY79R8Sow
7jVozIUWlQ7ETng6NGgpF6Pp46LRgcq2DcnHZnIxi3z/0YFBdopu96ZzsZIs
sAOsojUrw1S52Eq+f+jAN7uTbleEHBwg7xsdqNbfstCqhQMP8r7QAZcZe6Yp
cDjwJ33fgVP22U138jh4Rvq6A0cHtLFNIzlI//83BKFn5u5ngRxUkr7swCVt
jcmNFzhoIn3XgeGsiMMRRzkQkL7qQEbn8qX5VhwokO+DOyFWuSCQWcHBWPJ9
bieMLL3qxk/mYC75PrYTx8s1NA6ocmBEPn91ol3vYPveARxYk89PnXi+p3PL
7E9sHCSffzphLco886qcjQtk3nViu1585OaXbASQedWJlEJjK5lgNqLJvOlE
/LjGQr3LbGSR+dCJBz/2R7Y7sFFD8u3EZMGLvhwLNprJ7XaCe4ndkrmADQl5
f+6CAm9bLncUG0okjy7EPjgRYS3DxniSRxcsXjqLzb/UYCHJowsrfDi1gfk1
MCF5dMFApS/na3QNbEge1J+vV3L+ElCDoySPLnQ3jtzqdqgGl0keXbDZPzUi
YWMNHpA8uvBUzWbQet0axJI8ujCQrRpoO6oGeSSPLhTtVr/Z08XCW5JHFy4M
dvTw+MDCT5JHF1rmH/81M4mFXiSPbkyc5z7hXQALw0ge3dDln1q3/BwLk0ke
3XhZdsMmyJYFA5JHNzzG/PkQv4iF9SSPbvR+kv181xgW9pA8urHE7GRYTWs1
TpA8uqFiPLttQUk1rMO/rckL6UaHgs2lOenVuEbyYfxT5quX8HE3HMIVNpyL
qkb0WL2zSyMYT99df+hNXDcmOBoIN9+pRjDJsxt+QW+ijtyuxmX/8vebc7px
9Nt8q4unq5FA8u2GEgRstkM1pi3exTKu64blhodL+aurUUTyZtyn/bjN0qZu
bBh1SHUwqnHsy9LCOT+7oTmmSKdGpxofyH7oRluQbtCT0dV4Fn1j9Mf+Anz+
eL/hp7gKfLI/GHtMLlYVKwrAuZjYoNdahX5kvwgwwLCXQO9tFV7GHu7bPEOA
fkPK157PqIIa2T8CBBd83ZTwogpNc+NuFCwUYN+57RvGPajCqUUxa3iGAlT8
SU/V86nCdLK/GF+bpvhkspEAzrvOPqq6UAWTHL0izbUC6PaXDL14sgplvOtD
hmwQIOKb3mHVw1VYSvajAOaCd76Td1XhS4Dx7b2OAujZf5wnWFaFTWR/CuAb
nqMbPK8Ksz0vb1E/IcDAU4KfJ8dXYR/ZrwLMUB8Fr8FViB46JiHVT4DTAqX3
QW2VOEX2rwB1g7c7K32pxOjHPrssQgV4POjFoCfVlfAl+1mAm+aDfCZmVWL+
5uv75dIFmBI0Zce7oEo8JvtbgPx7dTGjfCvhMWcb7pcJ8Ci0WWn3iUqkkP1O
PZ/kQyMv76rEeM/bk22aqOtpcu/cMK5EGdn/Aozd3JPmZUD9/T9FsmVdAjQF
q7tbjq9EAzkP1PMfzTsySqkSixXGPHqsIESo5Gi3448KdJD3YyGOOIzwbOZU
4FTuheimsUIEq58abJdfATlyXoRoOdZmmx5XgQuLJwp+zxUiSsfovqNvBUaT
8yNE2BXTDc0XKrDwiHm4trEQtXEfT9jvrcAscp6EeMYSOJlsrMCmtzonV20X
4kvFZPcJMyuwkpwvIVK03ycra1Yg/NSRKYcOCbH96dHf8/tXYCs5b0Kk+due
Wsh+g+q0IZP9vIRwHC0sYwe/wQFy/oR4I1hdqn7gDbSzTFwz7wnhFF2fLrfg
DTzI+RMixGhd4+WBb5Bu76he91yIub0KF8g2lMOfnC8h/vDrJ5WnluOov3qt
TI4QDx/DxflkOZ6R8yVEo0rvLWyDcuSK0xbO4ghxP9AsaFvfcqST8yUENVL7
Hykug0Zdn2/mLULUhX29N/5hGeIGTLWZ3SGEgFptnWMZKsn5YjzEIaOlvlOI
bqm9W8+FjRYIcfgau8nNqAznuweq3pEIIfJX/zh5ThkOy2sILvcX4XK2nvKt
vmVoIudRhKx9nEDu71IUOb/YEaYkgm2bRtvs1FIkHdx2um2kCPzl4l8jfEsh
IN9nMD4VKSdYPkGEWxryuY1rS9H70NaahTNE2BS50pitWgoFcl5FiFr++q1e
ewnGJXz5NX6RCFNctpR1lpcgPtdpd/ZyEcbKpfU5HVaCseS8ivA4wyVit3cJ
RGq3XC+YijCtPdJLZVkJsoq0v5dYiMDxSJwSrFSCueR8imB96mW0pqQYCuzz
i5fbitBf70Ni34Ji1FfKBs1xFKGguUs11r8YRuS8iuD32mSbvFcxZA0O7LE7
LgL75KYdHzcX41gynvY9K4Kb7aM9R4YXw5qcXxFyR28v8OwpwshHO2SvXRXB
/+ul45msIuRlyrpV3xJhyELbIUW3i3CQnGcRpmZcKLtnXwTXkPdGsUEi9MxU
fNfPrAihT/vnPX1K2V8mvnJUES6Q8y3Cq/gXP951FSL8fsoTdrwIEXOqq1OS
CrGf+3Kya5pI+n5fiNoiy1+iLBHay52G9N9QiABy/hkPM8mbn5jDWEEs+dUn
XwTzgzErcpcXQrLV2fpRsQhf7GeuLh1RiKGz2gd/qxBhx8F+981+FyCazAsR
UstNrJxiChBWapU15oMI59SF9w2uFSBpZb+YUZ9EyOyZObNzZwFOLTEok22m
nvf5iw3r9QqQReYJY6Mjz7NO8ag/bxWXtU2Uj9g/D7JndYoQVEefwHzo8mpM
80TU823fmL3vWT5qyLwRwXhB4f1vN/Jh551rsK+fGHK1KtrGm/NR7/eoPEte
DPHvebEbx+Zjffhc796KYpQl6VfuGJiPZjKPxBgXUN01ty4PjnVl5f5qYvwe
sud4T2EevpoM/XFTQwzuxoixiSF5EBwdV3p8nBjmm+ifPFSURAZbTBKjn2Xy
Lz2dPEjI53XGFu6b++pOYTww/fPFiGnUekb0le2lkoewuNpm61liKLGcvB1/
5MLhmtPSP3PFGDHP79ml1Fy4Lno2y0dPjLz14yYfepILJTL/xEiOcHhU4pmL
Hzq5n+uXivHx3DivlC25+K3DH7/CUIxXVz/Jas/ORdUpiw3XjcWws6/f/613
LtpSZsjlrBNDuLJhwPT6HIwn81IsfV/IgXJtg93AzYwvtRquGWopxgQn9vW9
zjkwqNTdp7BdjHdWy3YKttL/XjvsZpuNGPX9dCdv18yh3mtvxVbtEeOk/dCX
p4blYCGZt4yzxilUXNsrhoVOnEl6czYqH1qGvt/HeK7MElffA2L4FJyf9Tkl
G4Hji/ssPCiGqfMxrbmB2Xh+P/Jb5RExUpdMyBtom40VDqMDtx0XQ6MifXnl
ymyYkPlNPV9zz9nVutnwCxw60eK0GK5dW6pGjsiGU4TCrFceYiwu6fOqtTkL
O+d/qle8IEZUUOQrmYIsvN+pdXjrJTH8To60SXmaheIJhtPueYuhKTD5ZuWe
hSURf0pKfMTU5442lq9ZFmxIHzAObfvU6H6D8cSNmZszbooRkrvS94J+Fo4+
UL1b6C/GLdEi1aXqWahdNOt+6V0xgvdNNXktyoTfqZQlOffFeET6MBOR7vyj
iQ/FKDp2ctK16Ez0kd8/PyBYjJ758UW9LmXiKOkbMTrrzdR7Hc6EvbZSStAT
MZwW+ts6bsrERf3hldufibGa3ztAZUYmVie23BoaJca68kv7F2hlolFTdVXW
czH6bNZg9VbKxNyTpp+2xYqRwcm5/zD7NUwvnL39/SWVf5iwIfnwawhup0w+
lChG0Id9aa3TXuMy6TMxtg/M4br9ykDc6LDCslQx+l5XGXAtOQP6DquLFqeL
UXUi8PShBxmoXPvu/qPXYngP0t7nuyYDZYFXP4qyxChOUJYdNjMDap/M7qzO
pfYz6bd0/Igz8ruWL0YC2y/l4M10nEnYN66kkLpf0l/p6Lz75EVPMbUfN2ip
TBmbjgekP8UIy7Msqvv6Co8V3dU6yhk/2Pe2dGClGL9IH73CtQ+mSSOqxZil
NS1NdfkrfPzjfWlcjRg3Kka5a/1JQ4TT7reTONR+C1oUeSY7DeEDfw6c+FYM
ddI/abicbpAwolaMl59vzRNap8HHUbm+1wdqvz/3tO7STMNBsweljR/F2Dj4
6LJlvdNw+9iJu+n1YpipKkwc+TYVsaTPGX89a/zWqlGMnSlPlW6fTIXLl149
Ez5T693rsfP++lRYf+rx+9UkRmvJ/nvayqmISGWPePGVml9nvHM8BqQitHZQ
nz3NYpwvLvQpjU3B0DLvdSotjCu7Pp1O+SFG7mT8VJuRgqmSirnbfolx/Zdt
Ru/BKQgy7urobhVL+yUZ2Q2Gebf4jAOfJLqN/S3Giu+i6rhnydRc+DnuSTu1
ftIXycgj7xtipPm62+0fmwydOQttl3SJYU36IgmKh+Y7pnSLEdqstVs3JQln
Y6LeTxdS6wk77rH2ShLiJ7zsHSgSQ2vNMIdly5Mw2fhEez8J46LzgmH2f8TS
fkiEeqf7zvwe6rw6vx88jJOIoVkt6mN6Sf7PHT9s3jr2lqB5zhKLKx6JuLF2
k/fLPhJoyS2788E+ESt2fpPt6iuBG33clRKRVtpsvKi/BMel5j7MUDw2gPp9
0g8JsJp7aWaMrAQuy4MKhqYkICes16BPchL0KTyV18cxAW/J+xHjfou+LWyj
fKSUYyS7IAFzzsh1qQ2SYPeHw2eSFBNQ/f3PYyhIcF/VIM+7PB6bzYoc9wyW
YNoNI+rExuPE9P4PLw5hHPYoxTtIUYJzE1nrzrrEI/J7wvBkJcZto1oT85Ul
2EPmfTzcO63tKoYy7rGpNqpRkaCdzPeXqJ251bNmmATs9+ujFYJfYmeIo4il
yriuUMu4dLgEo8nntZdQ+7xXOWeERDrvX2KOhq5PihrjiaomQyNGSqTzOw4b
lTKC746SSOd3HGR8Ru07ry5B/9Tlv8yd45Co63Zp/2jGZ5pGGxprSKTzOw4/
yfsjY68BDWN8x0jwkXz+iYXercGu+zUl0nkdi7hfEY8MxzI+vCWpcIwW4+Hu
ol5tf5lnreGZPk6CqaaN9TaTYjH7dM7SK9qMp8WIjpiNZxyes2ij4gSJdD7H
oPvGpLBKyieOFz/QfxwDI8sjCT4TJdJ5HIOv9/reMZkkweoXzyymLImB6cXX
DvKTJdJ5HAP/wDGLc/5yoUf2JNcpEmwz/aM7MfYF3ny9uGPqVMaLXCUl7ygP
c/FpvbbqBSz76odcmiaRztvniHF6LpkznfGZRB1OLeXLZN4+h2beIGsPHQkW
8iOKFHpTv7+vKWL8DMbLLfyTcynzyHyNRghvSYvdTAlYZL5GY3GajYHsLAmK
2u21+omiYOU8vDz8L9++P8NghS5jO7MH8e/+ci/yfs+4YH/+gGzKCWS+RkK0
O+SS+RzG9/KzLRv/sn26a5jDXAmOkvkaCa8m9bZuyv9/XkYgqkV08dI8CVrI
vIzAx1Y1oxHzGR8b3n0w9C+Lb0+eNGUB42cT5G5EUe4nqpYbrv0MFp+mDZ6z
UIJEMv/CcW/K2IiUv7zkQo7MIj0J1pL5F46jej8V0v9y/ShOm94iCYLIvHtK
9ZtFcspfNs6ad2uhvgSZZP49RffDM+IkyqfIfHsC9/0T38w3YBxvne/98i97
cIo2Tl0sgQaZZ09Q6xsZHfaX37c6ThgJxgPXlHzw/svrtU+2CSgfJPPpMTZP
VtzvvITxmK1LNBsoTyLzJwyqJ+LirZYyvvmGZ131l0sLlfVXLqP2D5kvoZh6
t1A97S9nX81eMH054zGenOf3KReqFrrbckJg+s3eWWGFBGvIvAihPq82yZ3/
yzJunxraKb8j5z8Yb79njHJYKcENcp6DscDdsK7hLw9yZLPNDSWYSM5vMOKu
uswsM/zvvAahfZJvkOEqxsPI50kJNpHz9ggf4nJZU1YzblumcDeU8ixyXh7i
iEurhbbRf+flAYaZLZmV9JfdrvC3rDRmPOiue0e58X/77R6m1w4fYrfmv/10
F+yxg2t6r/1vP9zB5x7tLzl/uehqc8lpk//y8Yez92pvq3X/3a8vlJ6u+nnX
9L/rX4Fqh/yapvUS6b9DlpH5f8YF9mg=
            "]]}, "Charting`Private`Tag#2"]}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{0, 1.83249406159968}, {0, 0.3860241405548744}}, 
          "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
          "ImageSize" -> {400, 260.}, "Axes" -> {True, True}, 
          "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> 0.65, 
          "DefaultStyle" -> {
            Directive[
             PointSize[0.003666666666666667], 
             RGBColor[0.880722, 0.611041, 0.142051], 
             AbsoluteThickness[2], FontSize -> 22], 
            Directive[
             PointSize[0.003666666666666667], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2], FontSize -> 22]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ListPlot, "GroupHighlight" -> False|>|>, 
       "DynamicHighlight"]], {{}, {}}}, AspectRatio -> 0.65, 
    Axes -> {True, True}, AxesLabel -> {
      FormBox[
       TagBox[
        StyleBox["\"time\"", Bold, 14, StripOnInput -> False], HoldForm], 
       TraditionalForm], 
      FormBox[
       TagBox[
        StyleBox["\"closure radius\"", Bold, 14, StripOnInput -> False], 
        HoldForm], TraditionalForm]}, AxesOrigin -> {0, 0}, 
    BaseStyle -> {FontSize -> 22}, DisplayFunction -> Identity, 
    Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
       FormBox[
        TagBox[
         GraphicsBox[{
           Thickness[0.003924492759310859], 
           StyleBox[{
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
              0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJHIGYC4viQIPUFLzUdDtTKWqQ/MXOA8RlA4IK5Q8At
6ZpEIQ0H6XlxmqcDLBxaeP3XT1FVg/N/vX19wNJZBc5XvvYomCFHyeFFlva3
6XPNIfweRYeDbcvDTx0yc+i28dyVdkjBoWSr6O/T/0wdOkH8IAUHA62VwhdM
TB3+g8B8OYf0NCAIM3IIenv544yDEnC+x5qjyxkkxFH5FmIY/L/fSh/M+WgI
5/tfnBjzb7OhwxohHb70fQj+WhC/TgLOnzETCCTl4Pya+z9uGb8Wg7hrv4KD
wq4F+1LzRCH8+5IO60D65UQc3rTldhtVCzts8dpgMaeSH843MQaCz3xwvn2J
Y+3pO5xw/g3e22Kp29gcQM5PUxOF+GMZPyT8GxD8vohuf8YCSZz8B67xjrMM
pR1axGtZM9l4If60k3HoB6nbwAnng/UZsKHKf2BwCAGHsxScf/YMEOSIw/k7
gq0i/i8XdjjYva/JZDEHxP27BVH9C+RXgcJrtQScPx0UnpEyEPc9VHDoBZkX
IAvhCyo7hHOKtRufV4SH95xFyjv/tKvC+Q2/rQrOZajB+RJTr3BmHMLknz7s
tDZTzgjOh6UHmH4Y/xRI3TxVOB+c/oSU4Hxwerin7KDxlnefwU0zB1ObvUHT
FFUg8ZFg7gAKljM8qg4yoPT+wBxCG6jB+Zv08hYzyqjD+R77gRmLXcPhJMje
deYODSxH+w3LNRw2gtTVmMPd63OC3XZ2qrnDBpC4jRo8v8D4S+7v45uTjMb/
bOrgBwqHx2oQ920wddjh0PTo+A51OH87iD9DA86H5e++4BKV6fyI/A7L/wCm
hqNM
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxFk21IFEEYx886ij6cViL1Qas7FTv1dmf2bs8QO56rD0lIhkWZHUmaqQnm
h4vQMivthcw00+zlssxIIy2joozUskzL8gV71eCCjjqiPmhkgprt7OzNDgzL
j5155v//zzP6tN1JGbM1Go2fNFdLc5Y078VMdO6IjYEtix4MamwYfDw9vueL
axTDazJOWuHls1XN2acEeFIYsiLTKTJeN3ja8e+MhfHi6rfzsirNcJ4MowAf
Fo7Z+68LUO9u93cNISjf4AyrKRJo3SkMX7fXvbdcxmy/h3AHYlw0GZvX18Mz
LiTs5SBzpzS+YXpeGgc1FQEF1hwMCURPvQlK1/7QWuoQ9L/b9JOfjAYxri3p
bB3HOHVjUsSVbJWrjh1JGYrjwHU1tHUqwgR85I3AAS0HJdqucrxX5eDabcbe
AZVbuNx6v88m6Hr0sGzOfOl/gzeeW8rBFMlvAQ/xHVJg3Rws/6VrR58QXe/i
oZf4WSJQX7cQY7muBTO+Q9Y7sJILZrx1mX00PVhln99E4j8UQ3O4p7i2jFdy
RlQP5mCGjFQEB2VfRgghet288g2n/ip4qvNxGCT0zF15MUjSS+o0GRgH5lc6
3zhVXtPU1aD5qGf75XMdekUnYiz3V4rKiPh9jmCfe2LYfFOv3KvCpQY4RHT+
RfQ8j4H20wvl3g8bQZd4uyrDi6nv4kggcWdqBdg/1rI+pyAK/rQOn5gOF6BE
XhgNxOaMXaD37TCxfuwmedt4yGsqHcmqEJQ+4uG3VOZChJnW9Sj53jUrOWJF
nxm+74oar7mE4QDpz+MWdn/O+0GTvbkiY38io0flRqJHb6X7dQKck/vYSvt5
BIMtP7lRbBPpe2rFcI28o3SRvVcfPz3asPlVJ2Is5x6HIJms6xOpzwAEDvk+
rIxpXZV971/OrVpl33n/AcLo4Ak=
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
               3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
               3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
               3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
               1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGAQB2IQvcX8x6GUU3YOv96+PmDJrO5w4rDT2sx1dg6+FyfG
/HNWg/M3qD5pnqer5vAfBOLtHHY4ND06HqHqoKu1UvjCE1sH2eUvPPTkVRzC
xbdfZHhn43AGBGyUHNLTgOCZNZwvMS9O8zQDgg82r97KQeXao2CGO8pw/t9v
pQ/mFKrB+TNB4KaGw/Ms7W/Tda0dTG32Bk07qOuQEHvHjXmGtcN2kHtm6Dtc
FfrkeD7MxkEf5K4QQ4cIkHvibB1Og/whZ+RQ+9uq4JyFHZwP8tbZVfZw/pL7
+/jmfLZ3ONi2PPxUkAGc/3Xnra6/qgj+Fyj/CEjdI3uHp4kLr5ms13ewrYxY
YXrXHu4e9PAFAGfcupY=
               "], CompressedData["
1:eJxTTMoPSmViYGDQB2IQHVyiMv1/hqPD8V07etkENBxg/DmLlHf+cddwkHf8
mHwm1tEhM/9D68kSDQeWxZOsGH0R/MqIFaZnjRF8sH4DR4fJ7a1Rl22g+lWh
8lPUHRyaHh2f8dvBQW75Cw+9/yoO6WlAcMzB4QwI2Cg52IPkgxH8+/v45hgz
Ifjqb3n3Gfy0d1j57WXFmQRlOP9RhPj2iw4qcL7E1CucGU6qEPeyOji8yNL+
Nn2vqoP+hAU/DOUcHEyMgaBYHWJ/mIODx/5aWYvjWg6RQGMY9jk4RCsAHb7G
wOFJ4sJrJtcdIOrKDOH85Ng7bswzDFHlnxk68Pivn5K6w8HB/+LEmH/KRhDx
PgR/yje2+BkmCD7MPf9BIN7QwVW1lGmWBNR+GUOHJaAA+GzvcPKw09rMdYYO
MSDxGCi/z8ih9rdVwTkLOzgf7J791nD+YpB+YUuHFJB7d+jB+bD4gfEFYgPu
Gz1Xhrg/wgoS3jGKDj4n2G1nX7WG8zncgA7ksoXz/3wrfTBH0M5hrZAOX7qd
ssMJsDvtHGTmxWme3qDikAoOFzuH6vs/bhlLKzmEg8L3nT1cPygajL0d4PzH
IPfPR/DFQfH4CBq+akoOrKD4FHV0cJnQLJS2S9nhcn48+zlHR4cGlqP9huaq
8PT76+3rA5aP1R3Q0zcAaFpLZA==
               "]}], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGI9IGYC4pKtor9Pu7k5GBkDwWQ1BxhfR1H+S841NYcI
8e0XGczcHFg4u+ST+dQd1J40zzurheBLTL3CmaGE4H/aEJA9S97N4dfb1wcs
mdUd0kCAzc3h1GGntZnz1Bx+xeQe/Rfk6iBcOank7BMlBzfVUqZZHi4OZ0DA
RslBf8KCH4b3nOF8MC2D4D9OXHjN5L6Tw4ss7W/T76rA+TD7YXxdkPunaTgU
g/zD5wzhX9NxcGh6dHxGsbODzLw4zdMX9B2mfGOLn7HH2aE/uERl+nsDh8qI
FaZng10cToPcK2fkcKBW1iKdxRXODwEq+6+B4IP9c8jVARR8xsJGDiYg+rer
w/IXHnr/FQ0dFBw/Jp85iuCD7VuD4At9cjyf1uoKcec9A4h8iavDwbbl4acO
GUD0h7pC4iUPwb8tXZNoJIrgJ4QEqS/w1Hc4oWk16XS9q8MPUPgf1nNgXTzJ
inErgs/jv35K6g8Ef6Ne3mJGFzcHn4sTY/4t1ofzwe7baADnPwGF635DuH9P
gvzfZ+QwEwQYEXxwepjkDOdnc/5ckK7s5DADpO6mHpxvarM3aNpCDTg/4BbQ
Q5dUHN7w7jOYucsJEt8xig6uoPRxwxnOh/kXxoel10fghIpIv7D0DABIaUP+

              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
              0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
              0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJLIGYCYp8T7Laz13o6HN+1o5dNQMMBxjcyBoJgDQeJ
qVc4MxZ5OmTmf2g9WaLhMBMEJiL4M6D8DCi/7rdVwbkGhDzIGONqT4c5i5R3
/nHXgJgL5M+G8r1B9pV6Ovz9VvpgjqGGw/IXHnr/Ez0dTh12WptZp+7wJHHh
NRN1T4cNqk+a5/mqOuhOWPDDcJmHwxkQsFFysG96dHwGM4L/aUNA9qz17nD+
MpB5K90d9uTXvJ0ZqgznvyneKvrbW8VhKRofJv8KxNdWhfh/k7tD4C3pmsRN
qg4siydZMfZ6OPhfnBjzb7OhA0jZ6T5POL99efgpoyMIvvm1o7kmDzD59aBw
kjCC89PTgCDMyGHPra6/qecRfLD/pyP4bqqlTLMWeMD5vP7rp6RyeELCvcMU
Eh7Cng5fQOFwHcE/1AZ02CMEnwdkEJcZnL/k/j6+OclmDmu6b2cwvPdw+LoT
6JCpZg5vePcZzDyF4IOMMdqC4FdGrDA9W+zhcBMYPEatZg5CnxzPp8V6QMLx
oqkDAwh8cEd1/ws3OJ8H5P4Nbmj+xeRv0MtbzPjGEM6HhacaMFmcXYXgW4DD
E8EHp9eb7nA+2H4Fd4eU2DtuzDfUHR4AvW3M5e7wFGSuv5rDpfx49nOM7g6y
oIR4XxXOh6U/GH+tkA5fup2ygx4oPcZB01uMooMJKH3/RvBB3kgT84TzYfnL
zGZv0LSD6g7o+Q8A4v2bNw==
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}}}, CompressedData["
1:eJxllG1IU1EYx6cObdCLUJYUZHObm2k377aQxOLRD2nb3b1lYhbmNJ0vkK1A
PxRSZIjYi4atzNTSJCSwjDLUiF6Ui5m2DIdEKopZWGJWH8RwaPfcs52L9sDh
8uOc87z9n3uUx+1JNj+ZTOYjLE5YvsIyGgRb4KDnecdV/0AdeLnunqrTnaCD
JWSzHOTbf5X2Fuqg5fJwnmxM4pC431n9vMTutAJ+sYuD62WlRwdjdcCHx1T1
tXv2HVoI/BP3IaeUg6+ZjUPGSjU+n8RBP7LYUNBMXrzzfoIlXPgsaKGv4n9O
VWwsM7SqCE+kbmr/CGrCwTdcirx4DUyiONUsHPy8pTjziQbX95SFjOQkbUO5
FvM0C+Po/rYIiLzWME+nc9A8lUgtKWkYsFsDnKc56O2Of5j/SOIaZJ0St0XP
d2W/k7gPnd+qh+ghvsB4gIPcHMFS9LAD+Q+TWKzLxRK+YvohN75hib81XKvD
9piFI0J6sr00ZHQPRti+WyAIHXRpwOrhDR4W75+xkH455vytt1oYwmK/NzPL
+7loBuZtwJ7aXWrCXv9e1qM+HdJh/SyMJ14ErucmA/Mz0693d1MevRkYFtqt
D4ryzAcDqL2y9BXslFjU6RWN58vO4H5X6GE1qn/KTPhubKTr9jcTYTG/cyYS
38tWpG++xA5xHimsa7kJdm5/sH5ATuH49RKL8dslFvXsNIF7rmi8jqZA3lQV
48ObQK64FJLlpLC+q8x4HvbTuI9FZqK/+P+MSdxGnWzycUucXKiuXtIxcH4h
5pQzWGIz8mOjCTeNvVxbNxiF81cwWGc6ivjPPjayz6+Dwrpmm/H8l4Tj+lM8
+5+0hMX/uyyMsOhnXSjUo/5SnvlIU+J5a5RY/CZbCON+WaBWrF+FedYCF+R8
JX1YDScUfxty17OAxsfwRQn3Uf41LLk/guZklF3uL5ojPCqUbTjLQUIL3yxL
DMX7zRy8sBfP1PAqnO8QBx1QMtGTqiHvly/S56cWVr5v/wAG6EVJ
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdk2tIk1EYx+cl0w9modBNzYlW87LtnRfCVjwWYZeF57xFWQ6GhbfE7IMW
XiJpmpTYVDRTVCYjtFQUJcwuStkIU1PRwjSyi6lpfdDQLNTa2dneQz1wPvzg
fd7zf57//4jPpPCxdiKRyMZ09puOrek8Gr2xEpvJw6mNbYOivRxYeWUx7UPl
HAd/SEXy0N21rzHxpgJ2BwxXTDox9gqfO9s7iAV2nQ/vjyvCUE5KogAtPlSV
fQKDYbxjXeWQHJo/fi1tUWHoJbXMQYRvmm2FG+s/QPgd+ve+O//xdQTxcaaa
5CBFs/bV5nQEZYUuGaFJHPx00NxWxSDIPzxjH1wjh7zaky8VKgQhyif8rRqp
wJrj/A59IuOSvNzTQ0opnQcjkPnddR2wl4I62bjaEs24UL/ETcYxNhSH2RxN
QGB8+KDAYb2UzncBwTLZ3wYZ3M/JGmjNRbDzu3OH/K2cfq9H0EPm8VRA52WP
XfEjjKOID78Zp0fVhfTZYZiIqXkT3MkJHE2EujO2zruN6F9A0Og7oa0ukFH/
Zi16OCnd+3ME2fZGHXdJAk1Ebx0Cj9rpg9JxX9CR+aoRNEvPG2we+8BrY3Jw
ts6kh/Q1eAvsml6c2pfKOKLBWCsaEQv95nvUYvjs5tH9pZVxO8lXF2Nz7t4j
yBxfGg2qF1t8tXC+N3wzra18xnLfhDfNkyeGTaXDTglXJdSP7RgiB4vUq1o/
UJJ8BGLImm9GSRn+cCRTK1OFYshxjmwqiQ2g+diDqd/qQCGPL8i+98pguq3J
bgphUJH/GWTg+Esf33oRU58mLPstx3SvGo7qu4dh6pz/YlkVB/X5Ywmifiz4
Jwkr7rniyAts3o8nY7OeEJ72Oyvgh0l2RQRP8zzGwdbZT6Fb3Hn6nto5mqc1
7L1a+ek1U5CfyQU250NpyZsXD7pjqT5lLnLqRxDjIFLRjK3vf4EYVcrYet9f
C9ftrg==
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
               3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
               1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
               3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQBmIQvfNW199U5lAHI2MgmKzmAOPrKMp/ybmm5rCm+3YG
w+8QBxbOLvlkPnUHoU+O59O+Ivg9Xq9YTD4i+BURK0zPvg9x+PX29QFLZnUH
E5C5j0McTh12Wps5T82hdt22pPrOEAfhykklZ58oOSyZZMXoyxLicAYEbJQc
xD0C/kicD4bzwfrrEXywfaHBDj4n2G1nm6rA+WB1xepw/vFdO3rZBDTg/DmL
lHf+Udd0eLCPb45xFlT/V20HbatJp+u3IPje1c36PrcQ/JkgYBni8KJ4q+hv
bh2HF9vXMz+vCXHQBYePDiS8noc4nL8a9kZfWg8eHgfbloefCjKA8z9vCMie
tR3BPwkKj3WGDk9EZE8+3Q3l9xlBzItH8BeDwudMMJy//uHLqZt+BDlwu6mW
MlUZwPkw/8H4TxMXXjPpV4GEmw80/GIU4ebB+BMW/DB81hUC58Pi/1GE+PaL
DIj0AEsfAOyS+8Q=
               "], {{83.11090000000002, 16.717200000000002`}, {
               83.11090000000002, 14.4188}, {79.6078, 14.4188}, {78.6875, 
               14.4188}, {77.7688, 14.4188}, {78.7109, 17.790599999999998`}, {
               80.79059999999998, 18.118800000000004`}, {81.49059999999999, 
               18.118800000000004`}, {82.4547, 18.118800000000004`}, {
               83.11090000000002, 17.549999999999997`}, {83.11090000000002, 
               16.717200000000002`}}}], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
              0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJHIGYC4vJ986X090Y6HKiVtUh/YuYA4zOAwAVzh98r
P17ybYp0kJ4Xp3k6wMLhpZohxxoXBB8kncSB4Neu25ZUfzbC4UWW9rfpc80h
/I0RDgfbloefOmTmsHiSFaPvjAiHkq2iv0//M3Xwqm7W9+mKcDDQWil8wcTU
IUJ8+0WGrAiH9DQgCDNykH79yEyKB8EHm/cxHM6/ejTXpOExJv/vt9IHcz4a
wvn+FyfG/Nts6PBERPbk09cI/mMQnz0Czp8JAokIPufPBemb34U7/AeB/QoO
Exb8MHx2Dcq/L+lgo3Nl1rOD4Q5v2nK7jaqFHSoiVpierUbwv2wIyJ5VjuCD
9fsh+Ftbai5sNg13ADk/TU3UocfrFYtJbTgk/BsQ/L6Ibn/GAkmc/Aeu8Y6z
DKUdOoDBbJQR7rBGSIcv3U4GEl6+aHxDBP8aKHzYwx1C3l7+OOOgFJx/9gwQ
5IjD+TuCrSL+Lxd2KIhnPyfpCnX/bkFU/wL54PDiioDzweHpGgFx30MFh+AS
len/Q6B8QWUHa1D47USEt5T+XRU2w0g4v+V14A45XwR/u1zr68AITP7pw05r
M+WM4HxYeoDph/E3zX2//Jgxgu8JSn+HEOkL7J/fEQ4ab3n3Gdw0c/BNEoiw
ZIHmhwRziH8UIx1kQOn9gbnDWveHVSJuCD7IutZkBN+80zHhaUOkw0mQ+9aZ
O3z+e6XiZV+kw0a9vMWMNeZw9/qcYLednWruUJwx8W2NeyQ8v8D4S+7v45uT
jMb/bOogvA7ogBio+zaYOpwoA2bgcgTfv3d6ntBkBB+Wv/tAEcGPyO+w/A8A
FZK/tA==
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJnIGYCYpv7/r3T/WIcIsW3X2SwM3SA8f9+K30w56Oh
g4kxECjHOJw87LQ2s8/IoeV14A65u9Fw/gLXbZ//LkHwvwc/Xjo7JdphJgho
GjnU2JvG7dKMdlh8fx/fnMsGDjJRKdb35aMdzoDAH0MHnXaxm+eeR8H1g/nr
EXweJu12scooVPtjoxzS04DgmaEDyHhPnyiH6RP4q8yyDR1E1rk/rDKJcuj2
esVistDAoWGqc3eOfJSDqc3eoGkL9eD8+JAg9QWZCP6U9taoyzZ6EP+oRDno
a60UvsCi5/Dl75WKl3oIvrohxxoZKwT/DdA5rdZRDkd37ehlE9BzmAI07rlz
lMMfUPgJ6juYdzomPI2IctB4y7vP4KYBRH1xlMNpkH/kjBzuqLA1Tl2N4Jfv
my+lfxbBf3JB6fbPa1EOTxIXXjPZbwjnRys4fkyWQfBh/pXRv6vCdjLKYa3q
k+Z5vfoOa0ABvh/qHkM9h/8gMD3KoYHlaL9huSbEvdVRDrLLX3jo3VeF+K8o
ymGDXt5ixj0qDstnH1HYkAR0Dyi+1ijB+cKVk0rOliD47muOLme4oQjXD47f
GEWH42VAD7Uj+OD0NQ3Bf7/8mLf5xiiH6vs/bhmvVnSYAUo3O6H8biWH579X
fry0F2rfEyVIevoY5SAx9QpnRpMmxL5fUQ7+FyfG/GvWgqQXxmiHmk8bArKr
tB22fwZGIGe0Qwuv//opqToOPdPzhJoFoiHxHaMLT4/HQeFtp++QsadksoRK
tIMPyLzF+g4BwOh67RntsL9W1iL9iQEkfeREQ8Ix3hDivtpoh+dZ2t+mzzV0
EGcJ49NdFA2Pv/2nFrpuu43gg937CcEHu4cjBqKf18ihHZhcLkjFQNLzbUOH
OaAAeg/NTzsNIenpRjQ8v8L4B9uWh586ZADng9OHDTS9fY526A8uUZnObwCJ
D/YYOD8VlI/0EHxY/v+681bX36kIPsw+AMKX4o8=
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{
               1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
               3}}}, {{{124.08599999999997`, 14.921899999999994`}, {
               124.08599999999997`, 17.001599999999996`}, {
               122.72800000000001`, 18.556299999999997`}, {
               120.73399999999998`, 18.556299999999997`}, {117.844, 
               18.556299999999997`}, {114.99799999999999`, 
               15.403100000000002`}, {114.99799999999999`, 
               12.315599999999998`}, {114.99799999999999`, 10.2359}, {
               116.35499999999998`, 8.681249999999999}, {118.34800000000001`, 
               8.681249999999999}, {121.26099999999997`, 8.681249999999999}, {
               124.08599999999997`, 11.834400000000002`}, {
               124.08599999999997`, 14.921899999999994`}}, CompressedData["
1:eJxTTMoPSmViYGAQBmIQHcKnu2nu8jiHqRP4q8yy9R1Q+Kt1HVQNOdbIdMU5
nL8a9kb/t4bD+qKMiW9D4hyeJi68ZuKv5sC+RiYqRTrOYeW3lxVnEpQdWg6c
Wuh6LtbhDAjYKDm4P6wSWTcdwZ8xEwgCEfynv1d+vCQb61B+eJvrzL/KcD4L
Z5d8Mp86nP/3W+mDOYKaDg1Tnbtz7GMdEkKC1Bd06jrY3PfvnZ4W61DzaUNA
9i59B5YwoAeWQs3vMXTwSRKIsPwS63D6sNPaTDkjB4FmoAN14+D8P0DjfYsQ
fJj/I8W3X2SwM3RADx8AlEKMFA==
               "]}], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdlHtMVEcUxlckII01VK0kipZ9wC7qXvaCRG2h/SgloEhUrHRB2plV0WKI
mhZBG22xhFCglJaCStbXSgySLmoIIr6NQAHxhRpLrQrxEWyroRZt08DWztzL
3kl6kvnjd++dO+d85zujX7khNWusTqcbw1YaWz5szS2Jo48mO9BxsqXcL9AC
L+8+YDwxkmiBWR7nDp7oQPaGP4q6ci3ovfL3sgevCl4+wdq4x1/wkOfm5l/9
HIiMYrHMAn93cMbqsaPvq8ww+W2vjh+iyG9tTqjxGLEx9pWfanspLvGIMSB9
9Vt9i88IHq5/dj2lWXBn3tl9U3+gSHS31+mSBNsDphRHHTFqnHRu2/R5HSZ8
xcq51kix3be9Qg4Kw4cnF4z3OU7VfJrC4EpoHvK0UXxfXJRxIzgcH8xv6sy7
TxExs37SNV9J47rHSdLLOJvGQdU3Az6ulFU9uii6Wt9tyP4mUq2nSrCSf5rg
GykrA+3RFLFb7IeirTJ++efzdactFGULf/Od47JhduOewbowiml7Pwrv7pfR
zRMMEPu/fbr1nehbROP+zyYfTqwXfNXA/lhKsLjnu8x/jZE46GwLOfoJQXKn
f6wzS8Yx3qB0Anx5v2OX04YBnmACgVX/xvOcHZLG5P1U8/5swVVcnxhJ7Wcy
0fSx834tF/z1zvUTC6ngJS0zin53ELQr/pIwwvVYRzDy16b+3a9FgAba5zcV
EHx67PXh7ns29fsagm5ez4xIvFeWMzDcIzjIN22C9U/Bi7hhPQQ2fl6brPGK
kLhnq4IFe/UtqI4vyxkkaAh9WLi3PAKBhecvuh6N5iNLyFrD4ixBAfdLfria
7wGC6dwAfaFqfbsIjkrra8ecNmG8z6ziKSUsH+5Pt0HjSVsqcy/nClb82qvX
9it+ztTDepdNRINg7/le9tb/ksc+PTYxe0fcJZr/led9o++/MIC58aDzCcG2
4Tc3Xhlnwh0+cEOsHs6PTRis+zF5LvNTDY+fLbCx8c4IoYiOOZO6wyXhhSWz
4oJ+1P8PJXVeoyjMTK7LpTZ1fwpFetDxHt3bsuoHQjX9le/zqdafVv7DSsHM
LeU7Dws28gFooVjL686TNX5x4napp9qmsaKHW8K5i2wgnBQDDtetOUfCweWp
L6fw8P4tNaPiAjuwmCKF+z8+DLV8IAsplt6ettXRGKqxVw8vK/oNGsDLK6mh
mv78Gos6JVjJZ0Sw975U+JIZ/79P/wMQ032k
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
              0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
              0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJLIGYCYuv7/r3T/yU6HN+1o5dNQMMBxjcyBoJgDQft
drGb534nOmTmf2g9WaLhEMqnu2nudwQ/BMrPgPLZ18hEpXxGyO8umSzB8inR
Yc4i5Z1/3BH82VD+9+DHS2d/SHT4+630wRxDDYf9pxa6bnud6HDqsNPazDp1
ByDv8987iQ4bVJ80z/NVdbj9sy5rz55EhzMgYKPkkL0HaOAUBP9E2b75UvUI
PnMY0IG1iQ578mvezgxVhvPfFG8V/e2tgpP/CsTXVoX4H2he4C3pmsRNqg7h
lltOlG1LdPC/ODHm32ZDh89/r1S8/IbgH/c273RkSYLzVdgapzpzY/Lrf1sV
nJMwgvPT04AgzMjh+uICWy52BB/s/x+JcH7/oa8aMbsR/MgUYIxdTXSoA5nX
YQoJjxuJDl82BGTPuo7gH2pbHn7qEYLP46ZaysRlBucvub+Pb04ykP/898qP
5xIdvu681fV3qplD/NMLSrePIvhg/x1A8KNBDtqQ6HATGDxGrWYOh4HO61+V
6LDshYfe/4umDqBkZNyPcO9l3ySBCF8Ef+775ce87RNR/WuByd+gl7eY8Y0h
nA8LzxvngCnINhE1fL0R/Jkg0Ingg8MvOtEhJfaOG/MNdQeQcw+FJjo8TVx4
zcRfzeE8KEEGJzrILgd64L4qnA9LfzD+WiEdvnQ7ZYfpeULNB7Kg6S1GEZK+
JyH4YPoGgg/LX2Y2e4OmHVR3QM9/ACy3rSc=
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdk3tIU3EUx6cOs3BqGekfWm7M3Hxs985VSsuOiT3MsDQsdbXy59uwqGWm
FZWV1DC1NAtmNEYMSUlE8oEpWWJliY9RPqAJzUxBYplm5Kp7d7f7gw6cPz7w
+53n9/DTTyZmunA4HCfKYyh3ppyb7BHWzMuAFJ/WIU4UCQ62Lp6d1FpI4NC2
hODNyx2NubdlIFJW9CwYMUfcjD421YYZeR2ObLmP4AFtYhkIXa/UxJQg0Ju6
PLQjBKjv+nKTCxG8o22ZhOV6y/C+VPzfxlGYT0z/rrcI/su/FkF2FmVfSFhB
hde4I6it9CzenE/CqW2rPuo5CDRxs1y5joAg0q3BbzEdNimeJ97TSVhWHUwM
epSLubrseuqIQgJb6H6W0kEaXO89yJWAampQMGHF/OtSXqfaBbGcRpUj4iLo
7Wgrd/WSAEGFS3VDsEzPb7UUnELK1o2tQSCa43URYwTzPgBBP93PehkYi2Y2
kgrMuthn89Z4zKMDP5M+H0BgPq77IO8mWU4LiLYgP8yOfn9YqYhxCBoDzaUP
y6XQSQ98p70eUsLMTYbgMre3gjwnZuoVIvA3fN0tMQUy/W1A0CQp0Dt1CiGy
5XVhlw9VD72vBgHL3ufvqN+rMe9q6DVwRvnsf9t+lXzopxsSY3ah9UViPtKx
x915O4IS09J4+BM+yMMpi7GzRgApGVtNCbH2fGYBoycVAt8a48qcq2ImH0KQ
MFSl/FMazOglC8GF703784tDgNrmoCAfwTVewtPqzFAIba77ZihAzL6VYawe
++h5R0lB+yqg6XQRgng6nl4KldS6lBoE3Rf9I7LNBKN3LYK/tKlIpr7HCKbz
QhZr60g4k1M1d6EV769vL6UoI2ZbvSbMtnpm7f95MqDlMjBv1/MECfKj1IA+
2e+pnWT0NIzYe3XwixuGQ297CJZt+lAQQJ+LaBJBRZJaWOtJMPuYwWyLa8Xs
uP+F9vFb1hrMjnz/ANsM2lc=
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
               3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
               3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
               3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
               1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGAQB2IQfeDUQtdt/1Mcfr19fcCSWd3hSsVLNcM/KQ6+FyfG
/HNWg/M3qD5pnqer5pAGAp9SHHY4ND06HqHqELfLk4fpcYqD7PIXHnryKg4x
/Ye+ahxJcTgDAjZKDibGQLAYwb+gdPtnXRuCDzavLMVB5dqjYIY7ynD+32+l
D+YUqsH5M0HgpoZD1p6SyRI9KQ6mNnuDph3UdTiisKEoY2aKw3aQe2boO2RM
fFtjvzHFQV9rpfCFEEOHBVL6d1UupTicPuy0NlPOyMHgrgpb41sE32LLibJ9
0qlw/r75IA2pDgfbloefCjKA87/uvNX1V9XAYS+U/wXKn5En1HxAKdXhaeLC
aybr9R1MQAEC5MPcgx6+AH5lrUg=
               "], CompressedData["
1:eJxTTMoPSmViYGDQB2IQXWDLdX1xQ6rD8V07etkENBxg/DmLlHf+cddwSHh6
Qel2bapDZv6H1pMlGg49Oc9/r6xE8Ccc+qoRU4zg62ya+355UarD5PbWqMs2
Gg5LQAbmQ+WnqDtEpljf909NdZBb/sJD77+KAwMIRKQ6nAEBGyUHoO5j3tYI
Psi6j2oI/opj3uadqqkOK7+9rDiToAznP4oQ337RQQXOl5h6hTPDSdXh3Pfg
x0vVUx1eZGl/m75X1eHUQtdtn3VTHUyMgaBYHWK/TaqDx/5aWYvjWg43QBpC
Ux2iFRw/Jq8xcLhS8VLNMCbVIT0NCMoM4fzk2DtuzDMMUeWfGTr0Ts8Tag5J
dfC/ODHmn7KRw56SyRIsXgg+yPu9xgg+zD3/QSDe0IGtcapztw7UfhlDh33z
pfTvqqQ6nDzstDZznSFEvSCU32fkYHBXha3xbQqc/2flx0u+8xB8sH6PFIcU
kHt36MH5sPiB8QViA+4bPVd2AEV/QWEKJLxjFB14mLTbxRYi+ODwPI7g/wBy
Z79IcVgrpMOXbqcMCY8/KQ4y8+I0T29QgYQzc6pD9f0ft4yllRxi+oEJRiUV
rv8DMLrNLRH8iW9r7E39EPzYXZ48TPHQ8FVTgtifnergMqFZKG2XsgMj0Hk3
y1IdGliO9huaq8LT76+3rw9YPlZ3QE/fANeWVOk=
               "]}], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
               3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
               1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
               3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
               3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
               3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGCwB2IQfWNxgS3X8zSH47t29LIJaDjA+HMWKe/8467hcMzb
vNPxSZpDZv6H1pMlGg4fL/kmCTxA8L9qxPQfuongT5FgCeMD8ie3t0ZdttFw
4LoONPAaVH6KusOBUwtdt51Oc5Bb/sJD77+KQxoI7EtzOAMCNkoOQN26mxYi
+CDrInoRfKDs3PfdaQ4rv72sOJOgDOc/ihDfftFBBc7foPqkeV4ugr/DoenR
8QhVh33zpfTvTkhzMDIGgslqDue+Bz9e+hlqfo+5gwHHGpmoL2kOJiD5xeYQ
/31NczDQWil84QiCLzMvTvP0AwS/7rdVwTkJC4h73+LmX4Tya6H8PyuBIXoq
zUF86hXODCYLhw7HhKcXjkHd88fc4cvfKxUvd6U5NLIc7Tf8bu6gdPtnXdYG
oP/08hYzvjF30GoXu3lucRokHJ+ZQ8J7UprDtAn8VWa3zeHh53OC3Xb2VQQf
7P4CBJ/Hf/2UVAtzh5znv1d+nITg3wFat2cOgn+iDBiC+xF8HZD9QP6Xnbe6
/rIi+KDoYDhnBufHKDh+TF5jBo/vCcElKtPrzSDxvTfNoWSr6O/TeWZw+6NB
6mUMHVTYGqc6A+Pv5GGntZnrDCHxUwHl9xk5ACVzngcj+EDfWG5hQfDB+ten
OqTE3nFj3qEH58PSJ4wvEBtw3+i5ssMSYPK/fj0VEv4xig5FGRPf1rCnwfkm
cbs8efQQ/Fggl8k/zWGtkA5fup2yg819/97pSdDw3aDiMBMEMtMcqu//uGUs
reRwCJRguhD6Q0EJdD6C/wOYHGdvQfCPKGwoyjia5pAOCjc1JYj9l9IcXCY0
C6XtUnYAOc/+bppDAyh9mKvC8++vt68PWD5Wd0DP3wDFSsw5
               "], CompressedData["
1:eJxTTMoPSmViYGAQB2IQrWHIsUYmLc3h19vXByyZ1R1s7vv3Tk9Kc/C9ODHm
n7ManL9B9UnzPF01hzMgEJHmsMOh6dHxCFWHIwobijI80xxkl7/w0JNXcTj0
VSOmXysNos5GyWEmCHAi+BadjglP36TC+WD6TqqDyrVHwQx3lOH8v99KH8wp
VIPzwebc1HC4oHT7Z92nVAdTm71B0w7qOui0i9089z/VYTvIPTP0Hc59D368
VDzNQV9rpfCFEEMH1sapzt0WaQ6nDzutzZQzcgDycp4HI/gLpPTvqjQh+Cps
IA1pDgfbloefCjKA87/uvNX1VxXB/wLl/71S8VKtM83haeLCaybr9R3mgAKk
Iw3uHvTwBQDLJrKa
               "]}], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
               3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
               1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
               3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {
               1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGAwBWIQPdW5O+f5/nSH47t29LIJaDjA+HMWKe/8467hwMOk
3S62N90hM/9D68kSDQeLTseEpzsQfJv7/r3TNyH4N859D368Md3ByBgIgjUc
0kBgHVR+irpDTP+hrxpz0h0+LFqvcHaGssPPuqw9JfXpDmdAwEbJwcE0bpdn
BoIPdk88gq9hyLFGJizdYa2QDl96HIIfwSnWbrxeGc5/kaX9bfpdFYcLSrd/
1sWlO2xQfdI8T1fNYeLbGnvTtHSHU4ed1mbWqTuosDVOdZ6e7uBzcWLMv8X6
Dld8kwQiZqY7PAfp/6vvwHV9cYHtvHSHJff38c1JNoDzI8S3X2Q4h+DPBIGd
hg4ZIAs60x1OgszvM3L48vdKxcs0BD/CcsuJMjUEv3d6nlAzT7rDj7evD1ge
1oPz40OC1BdkIvhT2lujLtvoOcx9v/yYN3+6g77WSuELLHoOx7zNOx1FEHxg
6Mb0SyH4YP9Jpzv8+Vb6YI6hnoMJMHh55NIdWDi75JPP6TkwAqP3pl66QyTI
P3aGDgZ3gTo80x1Og9wnZwQJ9xQE/0TZvvlS2Qj+DaD3ucrTHep/WxWck0Dw
vU+w285ONYTzF4PC77IBJH3kpjuAouOslAE8vo+DzLPTh5jvn+7wpnir6G9t
bTjfB2SeqDbEP+bQ8JZUh5hvnA5JZ2lqcP8E3pKuSdykCuc3gNz3QgXO/w8C
75UcfgQ/XjrbBZq+YhTh6QPGXzr7iMKGZQg+LH+Y2ewNmnZQ3QE9/wAASeB1
8A==
               "], {{189.822, 22.564099999999996`}, {189.822, 
               22.892200000000003`}, {189.55899999999997`, 
               23.285899999999998`}, {189.077, 23.285899999999998`}, {
               188.57299999999998`, 23.285899999999998`}, {188.005, 
               22.804699999999997`}, {188.005, 22.2359}, {188.005, 21.6875}, {
               188.46399999999997`, 21.512500000000003`}, {
               188.72699999999998`, 21.512500000000003`}, {
               189.31899999999996`, 21.512500000000003`}, {189.822, 
               22.082800000000006`}, {189.822, 22.564099999999996`}}}], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}}}, CompressedData["
1:eJxllGlIVFEUx0dn0GzRadHEIp3NmTTHeeOEGRonW9Q0K02dTE1N814/pIhF
kBhaMhjWfFAJ0TATkcgWREpFTFxyKQZTaXGKRBNaMIvQrBR7d97Mu2QH7off
u/edd87//O+TpOfEZAoFAoEdu46wy55ds41PIwPjMPS3t15zEKvAxjW3ZW2L
YSo4QyIGA875VjKYr4JaD/938mjK9bkhq1+FUd6bOj0sZbncUJI4GqwCzaqm
rYn7rfsVSghqGTjfGYhhOq3upc4o5877YnhOIlgK7G6thwtlb4ZN8Bv9x3on
N0PAAxnPk/rNj1+AnGf3yjEnFKqAsQufvJlFBMfGtxSkNSsggIQQQ+rxGOWt
UiXX73oME+R9L18Yqjvw6IcfhsaP4eplCQN2vga3N1oMgz2h9/B9ylUk2ii3
BC50ZwxRfkbOb9NCAmnYB0MW0TFeC85+zTdnPSnHkQdrKDdU93o9dKD5hqXm
X4X2GE6w5Qn2MMBSdscwAteyQ59FYwoYt/ImK6eL9UEtLVQv0l5pEeUlIkgy
ZSXRKx5B1IBjSPVOOc+2/DbWEt1iVTCnSjJ2Y9v3fLl+LiJYmPnSFdSj5uZ9
BYGZlVvrquH8YWDnRepPWcEmyh+IH54wnL/yEKf3dS2U3Ti74fJRyt9HDqeL
xZRVpL75LP77Nj5F5ospV1j8qIZdpazjFrLA3+fOxmGRGoj9zEuUTxq751Qi
xHMnKYjlxflzEzWMGkw/Y6caHBGInK56njapgYwrzx1xfohgwIcdvykA8fO3
3J9oyj3scRRHmbRfn4rg0p/duSZ3ypFkHpkMz/XvO51rRjUQSOrXIyDy6xgN
nz8j+e1BYaua85O/1f/F2yG7I7/cfYd1/7WSZ8v9NnjzvEzCRQq6lPaItelW
fyRJgMjfVUjZkv8uZYtevQiqLf3LuPmNICgS9RmZBDnIHYoq95kRd++mJFz9
i/R9YTybcB3+N5+cMrHbnA5DWFNfoyBcyu0Dho6cgpmqPhnnhygMrVA82a9X
8P8vezKfr0pY+X/7C6d3HKs=
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJbIGYCYv27KmyNlVkO0yfwV5l1azjA+MZgoAnnr1d9
0jwvV8vh+uICW67kLAeRHq9XLFe0HZYf8zbvDMxyMLXZGzTtoY5DgkCE5RaH
LIcZM4FAUtfhy98rFS+lshwy8j+0npyi68Cvu2nue/Ysh4TYO27MN3Qd4p9e
ULr9MtNhSntr1GUbPTgfZN1ZKQM4Xx3E7zJwCLfccqLsW6bD6cNOazPljByW
uG77/NciC84Hy4ch+A4JQAOKsxwMtFYKXzhi6DDhbY29aVUWxPxfBg79h75q
xEQj+GcWAg2MzHIoWNN9O0MBNx/snxB9B2DoTHVOz3L48630wRxBfUh45CL4
HGtkolLKEfz4XZ48TN1ZDmtBFvYi+MtfeOj932gA5z/P0v42fa6hgwHIgIIs
h5Mg//QZObCE8eluskTwb5z7Hvz4biacf0RhQ1HG0UwH28qIFaa+BnA+C2eX
fPI5PTi/5tOGgOwqbYeMicAA+Znp4LG/VtbiuJbDFd8kgQjOLIcniQuvmfRr
OUSkWN/3F0XEPzA21Qw1shy2m/84lKKl5aBy+2ddlk6WgwzIA/JakPRimuXg
f0u6JvGTpsMUCaCLQ7McToHcZ4fgg+NDRR3Or/ttVXDuhCrEfY5ZDmdAwEbJ
IQYUQR8y4Xyw/EMEf/98Kf27azId1grp8KXHKTkwaLeL3ZwH848KJP3tynR4
CvaPioN5p2PC0xOZDltA7n+lCuebgdOvGpwPNv+MusPxsn3zpfZnOsxZpLzz
j7sGxL0bEfyenOe/Vy5E8C+Bwq830yEhJEh9Qac6nC81L07z9ARVOL/6/o9b
xr+VIOljO9S+GEWHP3VZe0reI/iw9Abjw/Kj78WJMf+c1RzQ8y8ALUW3Hw==

              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJ5IGYC4tQ0IHDLcTAxBoJiHocUND5MPkY1QubcHx4H
e9O4XZ4uOQ5Lbi1/bNjM65Cxp2SyhEqOw1ohHb70e0ION859D358NtuhVYFd
9YyIHJyfkf+h9eQWHTj/SeLCayb6pg5LZx9R2KCU49DIcrTf8Lu5wwLXbZ//
As3vCy5Rmc5v6TAfyu+F8mHuKVjTfTtDAcHv8XrFYmKI4C9/4aH339ES7l7b
yogVpr6WDvp3VdgaHRH8XKHmA6csEXye64sLbP9lO5w87LQ2c525wxTn7pzn
t7MdvE6w2852NXUw73RMeLoj2+HzhoDsWdeNHEDKudZnO3C7qZYyVRnA+f9B
YL8OnL/doenR8RmaDvy6m+a+35zt8ChCfPtFBxUHUPCx3IOGl4msw3lg8Cz9
n+3gsebocgYJEQceJu12MaD70kH+SuOGux/Gh4UXjA/zP8R+BB8WnwC49dEt

              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
              3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdlXtQVFUcx1fYTBqGSBMbxZBlYReBy16MwoL4EeMrh0RIh3QDAhKhcy5U
m6mDr8gQEFECiXiJiIQDE+NQArM+BiFEkHg4I5oMjo/BahjE0mSA7Jx7957T
eGbuH5+593d+r+/vd90T0qI+ttdoNLPI8zl57MjjaOeT5dIgQWdrc95sZyOo
XHbco2V6lRGm6yYGIk5JkJL2YH+XxQgGcU6960nOvlku13srOXduO1e5kHDA
MnKijbDBye90eantfaEBnuxOtVpyJZh/8N0/tC/rofaXtW9kfypBDz3BOvAb
1s/et4Fzn+63yd3vcS4fJxbhEqyq76jVrOYc4+CStexHD8aRNxZlfDSgh/OX
q1b8vFaCZvjqdmeQF7tPjqfJCy7ReDdLYO+Q45bYawQS7XjtTgm+KyFn0o9x
7f3VwtMwE+MFRVcdthaI4EnrkSBB18V3GlIOBcDZyoX+w76ch3r/ib4zgxkj
q+XbV4Yw0OtLWkR4MBCR4GzFYPlp/lS3ZIIeEu5fLRhGU30eF5eLcCAs/l7f
cW7veK06PUTiXBSei0b9/3f/6FTdhBOGkB0xPwT6iUC8aTfaYcgl5X6tygQd
pNxhGgyLKmK9u2+JkPTWyLq8O4jZJznHLG9q52wi6W1q5CzbH0PwlJ5Qm78C
BMWHX9z5+ic2f98g5i+vWJqbmYHAz93tb3RUYBz3fpThWArnwqz9mwaDBSij
/duDwH9p3bw+rQCd1N/XnOPukQ5mc25/ZDTn5yDokPUrAL3uwiEE04+/uFX2
kj9sPTKWEVqCoHrknFPZoEn5/iSCbprPqwEQTNIvbuNcU9q+pHGAc2hgbOua
IQQm6q9dZLx5SdhEoitnNV8zLWg/ggbPu5kVef6gJ3JL7bHFIwqKjpsR7NV2
5ItfeivxnkKwmApsxBPiaX41CBoFqXqWVQ9UTvoKEg+1q9cxnrejwHLFwlme
hyF3Zi/7Mbuz/qms+ldZzV/uZ6U7XN3+u5d4CbH5kuegy/Z+j07R268Idk29
md47Rw/Pk+uTBkk+lO/rFb3eRoq+rxsVPU8iCAw+G3W0SoD8NtKAKVv/7grK
vDhiMJByXckxKfZeGD5YcKZf87YIJ4j5TBBm9Ze/j8SsP2Z6IeIsx3+AMx03
bQGG5C3kbBMZP2q5kTNTZGJ8ftfioGTLM6w1KflnY7YPDtKG7cXKfjntw9iV
ztNhH2W+t2PW36AmsmESMTRSPWA9GGnA8RisaRljJR0ecJPIw2rGMLIiLuz7
Kh1jtb8qq/0tI/L8LAmz/snzJ3GW+5TJ2UIHIAtDw1xfp+RYHaQRuV3OI/sg
eE3rlocecCI95IVrZzCbR3leyP55MvbnheUXBdBuJAt8mNdT1utSibHcr5Wc
ybarKY2UWL1VVuutctKHN1faNwuQTP0FSrCO1vOht6JfTwlm6LysNyj7yU2C
iP4j5n/DvZR96SrBern+noxV/aks12FcB3Tc20SJ1UPWazTn5/YRRRdyVv9/
MvcY4Nn/438aYVmO
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJ5IGYC4pKMiW9rqvMdMvI/tJ7couMA42/Qy1vMeEff
wea+f+/0snyHmWBg5MDaONW52yff4QwI5Jg6fPl7peKlVr6D38WJMf82mzvY
cl1fXPAxz8G2MmKFqa+lwxQJljC+lwh+zvPfKz8+Q/Bj+g991XiS5/BpQ0D2
LHcE377p0fEZ2gi+HZS/d76U/l0gX/VJ87yzUpYOy495m3c+zXPoCy5Rmc5v
6eCQ8PSCEnu+QyPL0X7D7+YOBSAHxeQ7PElceM1E3xTO/w8C+3Xg/Jr7P24Z
a8s5LAEJAPVXg/jcwnDzv+z7uDU9jBduf4xqhMy5Pzxw95kYA0Exbr7/E89L
ppO54f5PTwMBbnj4wPh3ftZl7fmA4Nubxu3y1Ml3UNi1YF+qnoiDzqa575f7
5Ts8cI13nHVR1gGoW3dTYb7DnvyatzOPKsPjD+y/eg0H9PgFAPeD5/o=
              "]]}, {
             Thickness[0.003924492759310859]}, StripOnInput -> False]}, {
          ImageSize -> {254.81244333748444`, 28.29386799501868}, 
           BaselinePosition -> Scaled[0.31408730361334886`], 
           ImageSize -> {255., 29.}, PlotRange -> {{0., 254.81}, {0., 28.29}},
            AspectRatio -> Automatic}], HoldForm], TraditionalForm], None}, {
       FormBox[
        TagBox[
         GraphicsBox[{
           Thickness[0.012903225806451613`], 
           StyleBox[{
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
              0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
              0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJLIGYC4v8gMF/O4fiuHb1sAhoOML6RMRAEazikpgGB
m5xDZv6H1pMlGg5/QfL7ZeH8P1B+BpQ/YyYQWCLkz4AAj6zDnEXKO/+4I/iz
oXywffdlHP5+K30wx1DDYX/3viYTZxmHU4ed1mbWqUPU50g5bFB90jzPV9VB
pHJSydkUMYi4jZJDf0S3P2OAIJwvs1FsPlMCL5zfIl7LmsnG67Anv+btzFBl
OP9N8VbR394qOPmvQHxtVYg5PbwOgbekaxI3qTq8acvtNpot6uB/cWLMv82G
DqqfVF7OWikL57cosKueCZGH850nNAulSSlg8Ot/WxWckzCC89NB4Rxm5CC/
a8G+1HXycD7Y/jeycL7HmqPLGSzE4Pwv+z5uTS+TdKgDmddhCgmPC5IOXzYE
ZM+6juAfalsefuoRgs/jplrKxGUG5y+5v49vTrKZQ9X9H7eMV0s4fN15q+vv
VDOHncFWEf/bxeH8NpD/rojB+Q9c4x1nXRRxuAkMHqNWM4d1Qjp86XIiDste
eOj9v2jqAEpGxpsF4O4F2/eBAc6/8PvY9Xk3f9nD+CZg9d8x+Bv08hYzvjGE
82HhOf/E5CXZar/gfG5HPq8ZmQzw8Aanr//8cH4fyP4CFoeU2DtuzDfUHdRB
8cfJ7PA0ceE1E381hyW3lj82bGZykF0O9MB9VTgflv5g/LUgf9opQ/R7ckDi
KUbR4Sw4fQvC+WB/PJOE82H5y8xmb9C0g+oO6PkPAORqpC4=
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
               3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
               1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
               3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {
               1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGAwBWIQPXUCf5XZaV2H47t29LIJaDjA+HMWKe/8467hcOKw
09rMeboOmfkfWk+WaDicvxr2Rj8awddRlP+S800Hzgfrf63jYGQMBMEaDiYg
ejNUfoq6w5PEhddM+rUdPixar3B2hrKD/8WJMf8OazqcAQEbJYe/30ofzAnU
gPNngN2jDuezcHbJJ+upO6wV0uFLj0PwIzjF2o3XK8P5L7K0v02/qwKxd4u6
wwbVJ83zdNUg/jTQcDgF8ledusODCPHtFx20HXxA7lis7yAx9QpnRpK2w3OQ
/r/6DjLz4jRPb9B2WHJ/H9+cZAM4H6SN4RyCPxMEdho6PAFJJGg5nASZ32cE
CS9rDThftMfrFYuJCpwvXDmp5OwUJYcfb18fsDysB+fHhwSpL8hE8Ke0t0Zd
ttFzeOAa7zjroJKDvtZK4Qsseg4rvr2sOCOgDOfvza95O7MUwV8Jkm9QdvgD
CldDPYfyw9tcZ66FhtM5PYeaTxsCsnepOESC/GNn6GAA0pei5nAa5D45I4i/
JDXgfEi4IfjgcLLVdKj/bVVwTgLB9z7Bbjs71RDOXwwKv8sGDtNB8blawwEU
HWelDODxfRxknp0+xPx9ag5vireK/tbWhvN9QOaJajs8AseXKtRd0Hj+q+KQ
BgZqcP8E3pKuSdykCuc3gNz3QgXO/w8C75UcdEHpV0wNkr5iFOHpA8ZPib3j
xmyhA+fD8oeZzd6gaQfVHdDzDwABuXfm
               "], {{14.721899999999998`, 22.564099999999996`}, {
               14.721899999999998`, 22.892200000000003`}, {
               14.459399999999997`, 23.285899999999998`}, {
               13.976599999999998`, 23.285899999999998`}, {
               13.473399999999996`, 23.285899999999998`}, {
               12.904699999999998`, 22.804699999999997`}, {
               12.904699999999998`, 22.2359}, {12.904699999999998`, 
               21.6875}, {13.3641, 21.512500000000003`}, {13.626599999999996`,
                21.512500000000003`}, {14.2188, 21.512500000000003`}, {
               14.721899999999998`, 22.082800000000006`}, {
               14.721899999999998`, 22.564099999999996`}}}], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
              3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdlXtQVFUcxxdhLP4ISzMtNNtlYReRy30s7IN9fNc0rWxEaEYyklFJIEtq
XC0bTasxZiDEFHlFFllDzcBEDk3AGJnIEKGkyfSwGsxoNIuyrRgbVNpzzr2/
HT0zd3Y/c3/n/F7f37nmtWW5j8eaTKaYyLMp8kyJPMmjLx84cVcQ/d2dVVNv
tcPgpreTuq4ssePv9pwNjdOCKC27tGsgZMemj2ZODF4D8YOf3+R7/Zco8/3n
AFWLrDw7jrM1rL+vsaG8ZeUXag0w89UHLsbdbsW+8amF9Qsg7LwWbJ/wPD30
XIB49oHVqYOI8o64vmrlvB9LWvtaTEujnB9/R7n2QRJxzpnEbWu+sqLDeflo
0fwAOvHSuX5XCp3H4+lIwTIW/7sBxMZXzFs3ZEdeyFo3mQPUN0TWf+nELReW
SpNBmXjW/uH4kr0Kzj+RNl73YwADvQvbSnereGekJ6FJ8xN3SBsPxhz2EnP7
qmyw4xu6FHi35r+X2eZBiNV1o4yCe4J/rWvyCLs3FDhYHX92035ef7+L+EN2
/rIs4iPb57qKF2XCx85NV7CbBTziQGWk3I5mWfgZciCR1eGsAvvYLT3yrxrt
53mFVeJqtn+5er3/IQWTbAVUfMr8FSmo2zPt+awNirCflMkf99MuI908758n
ayXiwodzbW+VRrmmfNeq014JL7L+9cvImP/+jJNxkoj3jyizNtYnKsTcj1lB
H9evhM9eiQhsoYIr45vPNt2WgW+mh4Nf1io4yPpyWo8rRsUgy+duVdj9FOXZ
LP+1GvHomuavHdUaZObvmEL8KOvTnCgb+fL4V2poY4NQlSHqlKEJP4oE1k5t
n4qdzO7ZVPSyeC0q5jKBjSQjyPKbUNDOdWPFI7M+PmXqUTDI9N9qIZ6xdW/o
RCjKfB6+NdN+Pi8FZuqfwYZ/g438eZxvmkWfEzSaL67TOzXxfodF15sm5vRm
K4oe++G+2BINOxlfsOp61cS+7+y6nh3I9H6SW9ssIczukxaH6N+opM9LJmzs
3qiQxf7YLJGXXxF1r8mi+nP7PCf1J5/ZSS5iEb+bWOTpRvH6yNqiEP/bdabi
6n6ZmOs4dAPHyXr+broPuF5PusT9ciiNeA773ZOmz7eL+svvw4tOtLM/T1nF
fA47cbhs21hDXxKOsv4fcmJkcWGwsdlCbPTXYKO/z7RWfl9yyUn943EuchHz
39+j/ALvkxtt0xckFK+2oJbNabYbld77u9eHkxBgeqn00DyKefHg8thvR9y9
krg/u7Opnse4Xv3Eol+B6+dpRYDqbbBRb4O5bjp1f1v8WM7qGU4V8Uz4cJXb
2cT9NODDQ6deK7h2b4p+X/qwgtc/mdjQn8Fcr39aRP1X+akeQq8B4sXJm6c0
doLY+P5xPm7Djd/H/wHX8EL1
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
               3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
               1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
               3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQBmIQveyFh97/n64ORsZAMFnNAcbXUZT/knNNzaHH6xWL
yUtXBxbOLvlkPnWHSPHtFxnuIfg+J9htZ19F8FWfNM87e8nV4dfb1wcsmdUd
ZoLATleHU4ed1mbOU3PQnbDghyGbq4Nw5aSSs0+UHCojVpie/e3scAYEbJQc
Eg9f1k6diOCD9X90gvO9QfbNdYLYa6oC55uA3F+sDucf37Wjl01AA86fs0h5
5x91TYfPGwKyZx2H6v+q7dC+PPyUUYwznH9C02rS6eUIfhoYuDi8KN4q+ptb
x4Fl8SQrxrcuDrrg8NFxWAEKr4OuDuevhr3Rl9aDh8fBNqDBQQZwPtje7Qj+
SVB4rDN0+BOTe/RfFpTfZwQJ/40ucH4FKHy6neH8Kd/Y4mc8cXTgdlMtZaoy
gPNh/oPxnyYuvGbSrwIJtx5o+MUows2D8UNKVKb/53CF82Hx/ygCFNGI9ABL
HwDTBvvb
               "], {{43.0109, 16.717200000000002`}, {43.0109, 14.4188}, {
               39.5078, 14.4188}, {38.587500000000006`, 14.4188}, {37.6688, 
               14.4188}, {38.61090000000001, 17.790599999999998`}, {
               40.69059999999999, 18.118800000000004`}, {41.39059999999999, 
               18.118800000000004`}, {42.35470000000001, 
               18.118800000000004`}, {43.0109, 17.549999999999997`}, {43.0109,
                16.717200000000002`}}}], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJ5IGYC4jNg4ONgYgwExTwOuPgxqhEy5/7wOOytlbVI
P+LjsOTW8seGzbwODk2Pjs9w9nFYK6TDl35PyEHlSfO8s6+8HFoV2FXPiMjB
+Rn5H1pPbtGB858kLrxmom/qEC6+/SKDnY9DI8vRfsPv5hDx4z4OfcElKtP5
LeH8Xigf5p6CNd23MxQQ/B6vVywmhgj+8hceev8dLeHuta2MWGHqawlRtxPB
F596hTNjFoLfvjz8lNEab4eTh53WZq4zd1AHuVfJ28HrBLvtbFdTh5Ktor9P
T/Ny+LwhIHvWdSOHPbe6/qbmezlwu6mWMlUZwPn/QWC/Dpy/HRxQmg5/YnKP
/mvycngUAfS4gwoknLW9IeFlIutwIT+e/dxGbwePNUeXM0iIOHwA2TPdxyE9
DQS44e6H8WHhA+PD/A+xnxsjPgFmYuUg
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
              1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJbIGYC4vv7+OYYHwtwmD6Bv8qsW8MBxjcGA004f73q
k+Z5uVoO39niZ/jMDHAQ6fF6xXJF28G7ulnfpyzAwdRmb9C0hzoO7qqlTLNC
AhxmzAQCSV2H4BKV6f85Ahwy8j+0npyi66A7YcEPw2P+Dgmxd9yYb+g6KDh+
TD7j6+8wpb016rKNHpwPsu6slAGcrw7idxk4mF87mmvS4O9w+rDT2kw5I4du
oDNMXAPgfOnXj8ykGhD82nXbkup3BjgYaK0UvnDE0OHzhoDsWccDIOb/MnCw
1rky61kngi/uEfBHoj3AoWBN9+0MBdx8sH9C9B22ttRc2LwwwOHPt9IHcwT1
IeGxDsGPEN9+keEQgg9278sAh7UgC3sR/OUvPPT+bzSA859naX+bPtfQ4bGI
7MmnmwMcToL802fk8IZ3n8FMNwQ/HGS+nD+cv0UvbzHjHj8H28qIFaa+BnA+
C2eXfPI5PTi/5hMwIKq0HXI4fy5I7/Z38NhfK2txXMuhHKjt7Gl/hyeJC6+Z
9Gs52Dc9Oj7jtz88/sHhpxzgsN38x6EULS2H/yCgHeAgA/KAvBYkvdgFOPjf
kq5J/KQJSS+1AQ6nQO6zQ/DB8aGiDufX/bYqOHdCFRJeYQEOZ0DARskBFOwM
6f5w/gaQ+3UQ/Av58eznIv0c1grp8KXHQfmKflD/qDgsBYXrRD+Hp2D/qEDC
+aSfwxaQ+1+pwvlm4PSrBueDzT+jDkkXi/wc5ixS3vnHXQMS/lkIPsviSVaM
ugh+BSj8bvs6JIQEqS/oVIfzpebFaZ6eoArnV9//ccv4N9Q/LVD7YhQdWpeH
nzJK8YfzYekNxoflR9+LE2P+Oas5oOdfAMBzt00=
              "]], 
             
             FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
              3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJ5IGYCYuFPjufT5gY5ZOR/aD25RccBxt+gl7eY8Y6+
w+cNAdmzJgc5zAQDI4erR3NNGuyDHM6AQI6pQ/vy8FNGfwId/C5OjPm32dzh
O1v8DJ/OQAfbyogVpr6WDppWk07XVyD4iydZMfqWIPicPxekb84LdPgEsscd
wbdvenR8hralAweUbwflS79+ZCZVEOig+qR53lkpS4fadduS6gsDHfqCS1Sm
81s6bHj4cuqmLYEOjSxH+w2/mzvE5B79tyk+yOFJ4sJrJvqmcP5/ENivA+fX
3P9xy1hbzuHwZe1UyW2BDtUgPrcw3Pwv+z5uTQ/jhdsfoxohc+4PD9y9JsZA
UIyb7//E85LpZG64/9PTQIAbHj4w/mMR2ZNP2xH81d23Mxj+Bzoo7FqwL1VP
xCEW5F7nIIcHrvGOsy7KOsg7fkw+0xnksCe/5u3Mo8rw+AP7r17DAT1+AbbG
4q4=
              "]]}, {
             Thickness[0.012903225806451613`]}, StripOnInput -> False]}, {
          ImageSize -> {77.50331257783311, 28.29386799501868}, 
           BaselinePosition -> Scaled[0.31408730361334886`], 
           ImageSize -> {78., 29.}, PlotRange -> {{0., 77.5}, {0., 28.29}}, 
           AspectRatio -> Automatic}], HoldForm], TraditionalForm], None}}, 
    FrameStyle -> Directive[
      GrayLevel[0]], 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImageSize -> 400, 
    Method -> {
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
        Directive[
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.571589, 0.586483, 0.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.915, 0.3325, 0.2125], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
         AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
      "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05],
       "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint",
       "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& )}}, 
    PlotRange -> {{0, 1.83249406159968}, {0, 0.3860241405548744}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Anthony's results\"", 
       "\"58 - 5.21\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-9\\)]\\) - \
\[Alpha]=4.5\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-2\\)]\\) - \
\[Beta]=1\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-8\\)]\\)\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2], FontSize -> 22], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2], FontSize -> 22], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2], FontSize -> 22], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2], FontSize -> 22], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8750709618728113`*^9, 3.87507100099376*^9, 3.875071071587775*^9, 
   3.875083794891965*^9, 3.8782770376117487`*^9, 3.878277156586391*^9, 
   3.878279854151279*^9, 3.878288652162231*^9, 3.8786260417936687`*^9, 
   3.878630310100937*^9, 3.878631659428925*^9, 3.8786404173164797`*^9, 
   3.878720115968473*^9, 3.878793066876075*^9, 3.878794265062416*^9, 
   3.8788765294574842`*^9, 3.878881166725089*^9, 3.878889740538148*^9, 
   3.878959345743647*^9, 3.8790795748375683`*^9, 3.879159237427155*^9, 
   3.8791592807635403`*^9, {3.879159329864006*^9, 3.879159356192116*^9}, 
   3.879159461733225*^9, 3.879159560484602*^9, 3.879159605975484*^9, 
   3.8791596960281982`*^9, {3.879159774739792*^9, 3.879159820282527*^9}, 
   3.8791598512868967`*^9, 3.8791599959711514`*^9, 3.879160039666127*^9, 
   3.879160077926634*^9, 3.879160135744686*^9, {3.879160261314302*^9, 
   3.8791602799267197`*^9}, 3.879162034622614*^9, 3.879401094838057*^9, 
   3.8794852035051317`*^9, 3.879564689170027*^9, 3.879564765982061*^9, 
   3.879570904980022*^9, 3.879580083012225*^9, 3.879580214143722*^9, 
   3.880520617494835*^9, 3.88052901717925*^9, 3.883559242398624*^9, 
   3.8860520488373327`*^9, 3.886133532164484*^9, 3.886163073026189*^9, 
   3.886163736698723*^9, 3.886163781088215*^9, 3.887876866417375*^9, 
   3.888056671496607*^9, 3.888158009304943*^9, 3.888167200116268*^9, 
   3.888169462518485*^9, 3.888170613616448*^9, 3.888171341818405*^9, 
   3.888192225722249*^9, 3.891325978108078*^9, 3.8919289695860033`*^9, 
   3.891929028022073*^9, 3.891929287272073*^9, 3.891929389756858*^9, 
   3.891942480119123*^9, 3.8919438534086647`*^9, 3.8919438945710917`*^9, 
   3.891943937136779*^9, 3.891943968428322*^9, 3.891944002865571*^9, 
   3.891944049265493*^9, 3.891944217522986*^9, 3.8921806283070717`*^9, 
   3.892440707541575*^9, 3.8924613119096746`*^9, 3.892464524499486*^9, 
   3.904543547038039*^9, 3.904635303723282*^9, 3.905841861328347*^9, 
   3.90584733646832*^9, 3.90586068964042*^9, 3.90587373982493*^9, 
   3.905907512037463*^9, 3.90644440882311*^9, 3.906453322193027*^9, 
   3.906515284396771*^9, 3.9065167073028603`*^9, 3.906523580657422*^9, 
   3.907047901281926*^9, 3.907055022348453*^9, 3.907055104493512*^9, 
   3.907057403886251*^9, 3.9078218957161617`*^9, 3.9083348314522552`*^9, 
   3.908335255233493*^9, 3.9379006428780155`*^9, 3.9394750170997257`*^9, 
   3.9416809315992775`*^9, 3.9417016732839165`*^9, 3.941701974647505*^9, 
   3.94170266361154*^9, 3.943165760515871*^9, 3.943212045929617*^9, 
   3.9432153378031807`*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"9d376a8a-2b21-6b46-9688-ad5651d7625d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"t", ",", "Rt"}], "}"}], "]"}], ",", 
     SubscriptBox["pf58e6", 
      RowBox[{"rec", "-", "end"}]], ",", 
     SubscriptBox["pf65e6", 
      RowBox[{"rec", "-", "end"}]], ",", 
     SubscriptBox["pf75e6", 
      RowBox[{"rec", "-", "end"}]], ",", 
     SubscriptBox["pf87e6", 
      RowBox[{"rec", "-", "end"}]], ",", 
     SubscriptBox["pf104e6", 
      RowBox[{"rec", "-", "end"}]], ",", 
     SubscriptBox["pf130e6", 
      RowBox[{"rec", "-", "end"}]], ",", 
     SubscriptBox["pf174e6", 
      RowBox[{"rec", "-", "end"}]]}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<time\>\"", ",", "Bold", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<closure radius\>\"", ",", "Bold", ",", "14"}], "]"}]}], 
     "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Anthony's results\>\"", ",", 
      "\"\<58 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=4.5\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<65 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=4\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<75 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=3.5\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<87 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=3\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<104 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=2.5\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<130 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=2\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\"", ",", 
      "\"\<174 - 5.21\[Times]\!\(\*SuperscriptBox[\(10\), \(-9\)]\) - \
\[Alpha]=1.5\[Times]\!\(\*SuperscriptBox[\(10\), \(-2\)]\) - \
\[Beta]=1\[Times]\!\(\*SuperscriptBox[\(10\), \(-8\)]\)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.891930225956444*^9, 3.891930232144857*^9}, {
  3.891930423577156*^9, 3.891930424022718*^9}, {3.891942530778219*^9, 
  3.89194253091158*^9}, {3.891943836403675*^9, 3.891943836737043*^9}, {
  3.891943883608431*^9, 3.8919438851584883`*^9}, {3.891943931725307*^9, 
  3.8919439333718348`*^9}, {3.891943984603074*^9, 3.8919440356863422`*^9}, {
  3.9064536274292183`*^9, 3.906453631738903*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"09c6ba0e-2460-4f20-a3b7-74ee8975e610"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, 
     InterpretationBox[{
       TagBox[{
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           PointSize[0.003666666666666667], 
           AbsoluteThickness[2], 
           StyleBox[
            PointBox[CompressedData["
1:eJxcfXf81tP/fqJoKKE0VZQoDRQNujSVhoZRWpTsREtKpWGVURr6RNFCIUmk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             "]], FontSize -> 22]}, 
          Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           RGBColor[0.880722, 0.611041, 0.142051], 
           PointSize[0.003666666666666667], 
           AbsoluteThickness[2], 
           StyleBox[
            PointBox[CompressedData["
1:eJxN1nlYjXkbB/DQWJosoUxMM1PEIGOSzNulfGekyAgRWapXqJElS2+WEtKi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             "]], FontSize -> 22]}, 
          Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[{
           RGBColor[0.560181, 0.691569, 0.194885], 
           PointSize[0.003666666666666667], 
           AbsoluteThickness[2], 
           StyleBox[
            PointBox[CompressedData["
1:eJxN1ns41GkbB/BRIXJKzuuYTWxbtrCl0i1t61BppcJK61CyW8IrpLfQlrdo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             "]], FontSize -> 22]}, 
          Annotation[#, "Charting`Private`Tag#3"]& ], 
         TagBox[{
           RGBColor[0.922526, 0.385626, 0.209179], 
           PointSize[0.003666666666666667], 
           AbsoluteThickness[2], 
           StyleBox[
            PointBox[CompressedData["
1:eJxN13s0lPkfB/Aubm2sFO1WJMTSlmqRbYt3N8kmFalFF+lio6LddKUbUyiV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             "]], FontSize -> 22]}, 
          Annotation[#, "Charting`Private`Tag#4"]& ], 
         TagBox[{
           RGBColor[0.528488, 0.470624, 0.701351], 
           PointSize[0.003666666666666667], 
           AbsoluteThickness[2], 
           StyleBox[
            PointBox[CompressedData["
1:eJxF1nlcTHsfB/BsEULduBVdspVUkrJEPpIrkWUoNeKqyLVFXTdLlkQJ6dpy
XaonFUlUkhCijKkmg5lqZmR5LBWRbpZmPWf0NL9n+J1/5vV+zev1m3PO57uM
dcjGhaGdDQwMenUyMNB9Zj4QCgdJ2zD83/2T3/z1BDqvf0n9Ososz+s19bK6
zHBtA7Xf3/fkqz9Sy22XHr4np3add/heZA/5DxvJMsPde1IXNAmFQmM5unqK
BrYnPEGn3oPjms2oreKaOTd+oR47TnfJ8aHr6AnxQU/wK7nBju/d1J5lLk/A
7fh126XUYe49O36ROkZ3XJwcoWtOlojaZThxSnfJUdKWuHXGcxkueOkOlKOt
206P5SIZSv7/QD8s1t2+TI6EycsHHcyXoVF3XLMcnlMD6xOzZFC36y45kmJq
EjdHy2CcpztQ8cPWutNsFVDcF38eGSiDq+723BVofV8WXD1dBm/dcRwF7ltF
eD03kWHZKt1FHaGLI0qBcblys5cfpYjTPe5h6lO628tUINFT6WNyQ4pc3XE3
FBh2IYo7JkOKMqHuUuD8ncBZ6dFSSEi+ClyaZlP6dKMU78njKjDbuOXKNx8p
tFLdAyuRMU9gsWecFCYkDyX6vrs4qMlCihEkDyV6pYy//8RIikkkDyUeyX6P
tKqXYC7JQwm/hhvtwwUSBJM8lNjh31InT5cgkuShxMq53EXSJAkOkDyUcPX2
2+cVJkEqyUOJAKetU9bPl6CA5KHEsPJLGYE2EvBJHkokuXc7sL23BHUkDyW0
nSvsn7XVooXkoUSdpaTuZVktOpE8VFggPXy6d2Yt+pM8VHjhvmxedHwtRpE8
VLC/kOP868ZauJM8VHjKSzrVNr8WHJKHCpYW88ybRtQilOShQvTeFfzhhrXY
RvJQYdPKinSFsgaJJA8V8rv6hfFENUgneajgeFs+IOl4DYpIHiqkJ97d1vp7
DQQkDxXuS+XOKk4NXpA8VPA/kr023qUGn0keaozZP3lXVN8adCN5qJH24Xpw
xudqWJA81HjadNTeNasaDiQPNRSDXP513VEND5JHx/cO+TNmB1fDj+Shxo7i
/mM3Ta3G9JjNtd1j1WgaEmLGHViNNSQf6ut3e+z2iadetHpz3+wENbq8O9DU
zIiRUMxxXJ6khoP//uwhH8XYSfJUY4SHySPXBjGCuaPC+5xVYzMpaDGOknzV
KJs1ccaaUjFSeS27Zpeq8bz6ZvCUI2KcI3lTF3HTBlhUqBGv/im2dqMYEutD
CfYiNbKCFs/hrROjmNSDGu13C5kx88WIOT8pnd+gxiVJ0G9vpovxkNSHGusz
H2+Y6yhGaFaRRVe1Gh3NteW+lRivSb1Q111JEiqNNcg5udZNIBVBnqu7YQ2e
749bMaxKBIezuT1jrDUw7fJixYRiEYxIPWkQtGv7WFWmCGUPFjq/nKCB+brw
kzbbRLAi9aXBzpSxPx8MF0Gy7+W+47M0OMs9YoiFIowl9aaBK2Su0mki8A7v
GTUwWIOkzkEJoRYi/ErqT4O3s7sVJPUTwfsnx1dsuAYhZmmKaU8fg0vqUQOh
x/agnLOPUZ/dL830gAbGHF9eQehjhJH61ED0s26iPUaM/O6U1mQNdmdnVbb/
1GFSr9Rrhu0ZPbhAg3zJL399PvAIJ0j9Uh/gpvRdwNegzXR1y3WLR7hA6pk6
3bywF+o0CCcv9CFKSH1Tr3h/ZH9IiwapUbxsb85DiEm9a9AFWZxm94c4UjC/
IbYTgxm7A2yGvhWikdQ/gzjfb61D0oUweDFvzb7+DLx8uCUTTgqhjtUVLINb
BosiVrsLsWCvYdStUQzC3CobrfsLYUz6g0HSlqGmlo8eoKEgdvJ5dwaR41u+
GS57AGvSLwyMqma6Zy98gPORbl0rOAzOcOXHvtVWwZX0D4MrWZdGrauqgvdz
h+1vQxksmfNAfHd5FRIn7jy5biMDC34xR+vb8T3pL+qymcMXm22iLuAG+Mq3
MDCMr1wwxqgKklCRb+cYBjujk5lZ3wRYRvqPwc8Rk522FwgQpvCN9k9kwJEm
uYbOFeBDz/JDFn8ziKlPkzlMFyCC9Bt19LVphafOMGhZGJe1k18Je/WOf5uz
GVg6zz7TJ7MScaT/GP1+rcS7VWd8B15j0D5niCLZrRJvio/2UZcw+n1ZgVOk
Hxn9PqzA7COtt2ZXUQ9LeTJKKGYwczS/MGZ/BXJJPzIIUm7sVo4KONXwAr3+
y8D7TvQi04EVGNTH7lBYI3UZ6U8Gh8j+Ksfk26UxPl8YpJkkmxsFlcPbbn2q
QtWRX8fTcxeV46VPgtHhdgb43BDCGVIOCelf6rLQ9x9fG7A/fGrs7fJznVmk
mNnml6j58BYERzkYUr/1//Pgjt4sTl8QeFVe5OOKXQ/PNFMWlnl2fZ238PGe
9D+r30d8+F8tt3I2Z+Gvd6rjNhvzX1gcJ/uIj+Zr1ke/DmMx8viJcT1v3Yc2
UFdALEb3+2VIQO59pBgzpdmO1LHxGZ+sXail7nnpKyaxiCT7hAcTMj9YeLSV
qrc/46FWNOps0XTq0VNaB/O9WP1+4eFZ8crNV31YkHLh8mCVeHpeBod6BJk3
1K59bL7sXEjtd3OCMGNRx3lk3/BwwpS7+6MfdX9eclP0EhY1fhMUp2vugamI
wcjlrH7/3EP3wOT2yyuoJ5H5xWKG83Pf9tX3cLRPi9fNtSxsR17zYuzuYcrK
MAP5BhZjyP4og+Trg97YxGIr2RdlOHfJqX77Fuq5ZN5Rn+Y1JYh2sViSH/fq
z8AyNPxzjHNnD3V9r1VDY/exOE/meSlMbbg9fQ9Sj+6da6dNZPXzuxTBZF5S
P3SMH2F5jIU5KfhStM6u9S4+Qf11TMihcadYuKfs1d7pXophe6cZ/ieF2vBh
/AZ1GgsBmc93sSZ0XOTMTBbRZN7eRSSZv9SJ+zguqrPUJVe27Xc7T93JxTOd
k8MizKOLT3DgHWR8SF8Unks9f3UPbLzMYiOZtyUYGzFr95ZCaluXXv3XXWOx
+oDbyFdbSnCAzHcWyWQel8Bv3aoFzreoG17vWC4vob6Z7OOdUkqtNJo72pbH
Yg2Zt7dxSCCT3eVTB9Z4DnCvZFH4j7T0RsQtpCkHWlZWUaeS/cHib6fle76m
3YT9n3mzlj2mHns+KqVGTN1lQYTEqZbaX771S6SUxabSVxOXJxdjx7ru9def
sChOLktv2VCMMyuY35RPWf18LManBx5L7F5QGxttfjvzJXUB2VcsDMh8vIFn
6uTSufUsQsg8vI6iyWtDFzWy+ETm33VMm7r+9Mp31HXG468HvWf18+86rAdv
SvytmXoXm9pvVkvH/NDm8I9dvIbuBQMcXVqpp4TdvNT7M/XM6ljf6i/UK1/a
Nsa1fZ9XReCT/fl9XhVh/dK9sXuU1AP2jDvtpP4+n4pgnnzf+pOGhYtunEqv
okfpzeE5LDXnjXTfwm+s/v9sITbnC4s7G2h/eKXZ6fz0TtR//DXM3KkL9eVl
yuS8rlr9vChEnsBuv6uhVj8vrmDUZMPM8u7UyR6LS7yMqOvIvqdOsL0WfK6X
Vt/vBSic+nrTSGPqqfZnbf/pQ+1eaWLF9NUigPR/AQIs+c3rTLT6fr+MQzmV
ti9MqUc/7J4DM+piG1m3pP5aff9exhyHF1PVA6jDPi4bv8CcesZFw12nLLTY
QPovD+afBBq5pRZrSb/lYm5iuWD3IOpe317IGCvqFvL/hbqmcWvJoCHUAjtp
yx/WWn2956DPQkPDpqHUTYf5bvOGUwcvDhqeNUKLzqR+sxHSyBd52mj19Xke
PQNW/S63pU52OXrlhB31pvfNISPstTAj9XMOMZWXDmkctBCSPDLwzLNH7BQn
LcLJ+06HzdJZ/vecv7+/M+hE/m9RF73q0WzmQm015eqSJ67UJ1QBiakTtbhC
fARxERlfbKZqYaC//gehdJAE
             "]], FontSize -> 22]}, 
          Annotation[#, "Charting`Private`Tag#5"]& ], 
         TagBox[{
           RGBColor[0.772079, 0.431554, 0.102387], 
           PointSize[0.003666666666666667], 
           AbsoluteThickness[2], 
           StyleBox[
            PointBox[CompressedData["
1:eJxd2AlUjfkbB/BSqMRUiCSm0SaJCDVpvnajbClbZCRZMkyRnSxlaUyyVLRJ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             "]], FontSize -> 22]}, 
          Annotation[#, "Charting`Private`Tag#6"]& ], 
         TagBox[{
           RGBColor[0.363898, 0.618501, 0.782349], 
           PointSize[0.003666666666666667], 
           AbsoluteThickness[2], 
           StyleBox[
            PointBox[CompressedData["
1:eJxd1wk4Vfn/B3BLxpKKKNkKFTXatCHx1rSoUTOKVmmSMo0kTRsq28SPmvZk
JDNUklAMQiS7S7ZruSiKxBiSFtztnPzv/Y7+x+0853nu83ru83zP99z35/M5
5+rvObRpn4yUlNQuaSkp8afvnL+j+uMG0BQaJT7R3W1oopDIeFNsZJFeMuMc
Z5Vt5mmMDacG9W7MZHzpOd/XLYex4LrHxN/yGO+17xCtyLhqgmg5FmOzCvEx
gMYRV35lbqWkbWsk/ale0itfSrrjvaSnT66U8O3dX3nwK0+rlvQRtqS1OZI+
8ErSYz9K2lajUsLPnL/y0FfWq5b0UbakdTiSdn8laeWPkl4v2sBoVzh/5aGv
LNqAhEUbkLBoAxIWbUDCog1IWLQBCYs2IOmhr6xXLemj7AGcuvmb55jI/6zD
kbT7qwG49O19UR3chHYf9Qc27QN4tdj3k9vJJjg13/ak3zDefL1gcP/bAby4
5eyxeFcTBmftvFgwyHjJDxcLjikMYu9PZf45m5qg2Hjb01KJcUq3KN5xjKWV
pwX1qjPWFbfL1EEkaaV1x2xogski8TEI028GF080bsJqssFB8AKmic4mbBdd
fdbOQXRcMs3JlmvCQUsl0RUHEZb052lNQSMCxMsFDeL00R+8T7Q3IixCfAxi
T7qX4YWaRsTbiBcchDV/vNavjxrx5L8bgoZPjOhsBFu8/cZBKNUsLFG92IhO
8XK9gyiLUF91x6sR/GHxMYifCgebjro0YtwD8YJDqGUvuHfGvhH64tVmDeH3
pABj//mNWCLenuUQ3OZcjlef2oh14uU2DkG2Z+L+HD4HTq7iYwjOmr/Mv9LH
wWFxHD5DMLTymhzM4SBIfLsXh7DDXMoyO4WDCPH2bg/Br6C9fUMMB0lk3gwh
4qX6NIdzHOST+SBaf9nQvI4jHDSQfIewPKFqipwDB/+S2x3CBVseP9eSA5oj
vmEu/mwL7tmtx4EqyYOLkIpPLxWlOJhJ8uCiLz/ZU6O/AeYkDy4mnH4+fmxl
AzaQPLiIjZuxS/1hA5xJHlxsW5zrVH+1AcdIHlzETfdoGD7egFCSBxeGvU02
Xo4NiCJ5cLGux8LxypIGpJA8uGCxfo+hpzegmOTBhbNa4blUuh7NJA8ucupv
7lLoqEcfyYOLhwkNa0of10Oa5MGD7zEjk8Kb9ZhE8uBBdaWSloJPPWaTPHg4
88RGI8e5HpYkDx48WRY1LxfVYyPJg4dHb+0GWDr12Efy4CEioDyxka6DN8mD
B6PwvceON9XhPMmDhywPwyj/xDrEkDx4sOpakfxbcB3SSR48LE/6UHjLtQ5l
JA/R+oHtCffM69BK8uBhsMhvT5tRHT6QPPjQM8txei5VBzmSBx9e5hHSMdW1
0CR58JEw8GlsyINazCV58LG5Pk91fkgtVpA8+JBOd9UIdq7FZpIHH/fV3Jwa
zWrxC8mDj59WX3VfLF8L9UvvNgf8wcfPBV1N13vZOE3yYfxjYr9eeSQfz8sX
3SzisPGJHTnfOJqPYdY5e/kGNix0B9b33eMjrNsiWiuPjcskTz56rN0vcBLZ
sLyZzdmTycfkZzEt1bFsxJJ8+VC8wR/3OJyNX8PWK0TW8xH6tqBfzZWNLJI3
H4Gvf9xVvpUNm7zMuO4XfFx5s9HO2pYNF/7aU7GdfCSrWaSoWbBRSeqBD+W4
gWKVhWzEyIS7rOKK7vdMkZeXKhvtpD5E3qf3Rl2ajWudA7EvVAQITDBz6eHU
YDBJvGEBzmva56dU1iDDqm9rlrYAjUan53Xl1kCR1I8AJveTbaPTa6D/naeM
srkA/6orrtwUUANdUk+MJ92402W+RgBVs6aho041MCH1JUDD4tl7dq4XXS/6
XZuOswBBe+t8o01qsJrUmwDT5HuPt0ysQef7zYf5ngLMdmiw4XRUYzupPwEK
VOZS0unVUGC537ALFWAqGYjVOEjqUYAFCsrrd7hWwzRDfs2RSNH9dalF906u
RgCpTwFaFiWw27qqcO91xtOjKQIkvi48a3erCmGkXgW44uv+khdahUdOFp3/
KxYgLT/8DdehCvGkfgVIOJ4UZLy4CiEp8iv+1yxAtsGcMUYfK/GE1LMATgY/
p158WIm6ZIvWyD4BHCa9+JjxUyXYpL4F8GUL6yLMK3FIqzi0UlqI8vUT5u4Y
rEAnqXchugVReXRtBbzN9iTmTBKihXVedFaAf0ZcsEI0n2pa2u9WgcmNIV71
s4XIPG/52mB2BcaRfhDi9xUn5g4/ewbsTPXpshSi1DJMzvz6M+iT/hDCY7qi
W/uGZyh9Wz9TZpMQdXWtjgdnP8MS0i9CdExM73n/qhzK4S5HlFzF32v+Y3+j
HB9fuik9PSTEnZW6a9f6lmMd6SfGXP5az4O/CuETreYQdKAc9kdKbkkdZzzW
NV/e6LQQC/wUeh+olsOJ9J8Q/p/136sXl8HcvnTstxeEsP4YmaZ0rgyaw29U
jMKFkLf6/PNJuzIcJv3IWL9KJsH3TyG0jm903qxVhp3Tp3w3LU6IZWtW70vv
ZiGI9J8Qpq/s23KbWbgXHHkOj4TYZOhlpH6MBRkTNQeXXCH+9PMeOLaRhQjS
j0JMsf/59RtTFqp8kr1dyoUwCdwi+3agFCz3N7/L1Ip+vzXLDvASSpFE+lOI
X01/4WTdLcW2C7sVT78UYsbzK1kBW0ths7B7WUWnEN8MraEjlUuRT/pTiL9n
NF07RJXAYd/i/FMfhSPPtxJ0q6jZ2/GF2OIWKzpL0ED6VQhp8vwqgWf8futr
31Ajz6cSbOo3mzxmHIUqO4O7iS3FaNcfEDqpUehPHjjxOqoY/5J+phCdbqc3
449i8IvfJaRNpvA68IGbdkAxNIeWr5ilzVjByd/aUp+CLXn+FMPpUm/ZTCMK
5TucWrveFYF2FBcIhQWtcuGTW4tg+YmTGjaHcVLGlh9XLqRg+Re1+fvUInjL
LjJ8bUphh9PTqxNOF0GVzAfGm78NSU79jkLy5Tgt1UlFuD7n7JlPNhS2Z44f
vl1TCLNrTiv0NlBQF4+3lELMJPODgqOph6XHgUJcabk6r38LhdLbskvNtxVi
/wF7M7Yj4+xx/skBuyl4ZBn26Y4pRMcp+VXa+yjEk+dFAczJvGHcaTYjgdrP
+N7c4Ga/gxRUyhrcq/wKYDSkOa7rMAWLqqQbUXYFcHM//eOC4xQUXYY3TtEq
wA/GpvL7fSjcbveXSeHmYwOZV4xtuyJZdScZ25w9UZ55msIl7azL2ln5QO28
qsAACpTbnvOyUfno4lTQoUEUfC06/d0P5GNP7tymgFAKW/8IebjGPB9ub9fX
bz9Pjcz7fDiT+Uch6sC+ozHv8xC6oIzWvEphxqWtyyKe50FmjpzS4+sUasY+
EZ158DDYPdbxBjUyz/NgmpS5/UUUhR4yv/NQWdNtbR1DIaa5SKBlmYdjZH5S
COw48nilfB5O6KbNnRVHwf1Vc4hjzVMoa94x3n+fAudDdMiTvKeYkKeQFp5E
oST8eu5rg6c42HooOTuZ8U45+TGsVAoG7P3ecQW56HJYUF78iIJfxVJMuZKL
UDKPGSd9f6JubjaFHOOuviufn2Dawo//jsmlcJP8QXyCaO3l+1vyRPm1JSs7
rHmCsn72wb8KKYwxds9Zp/YE0q4GJltLGE9esnTFJxaFs89/krrsmoNdLtPG
Bz2j4Dwj/P4HkxxEkXnP+ObOX0NtqinwPA19dzdnY1vmIZssNoUp4vguZ+PO
7EsRBvUU1u4M/MXfMRtTJnKVz3BEeddeeFDDeoyrQbywhibG98YnZ2u8oOBF
5uNjrFrR5mLfSkE3OHlZ4+rHWGcTecn/FYXpD/TnpXVlIYU8XyiQMRiRBdmF
uxft66Dwx4jVk6488e6ksGY45LCnShaUEoyfBv3D2Mwjr/XUvxSKg/e03UnM
hOBk7yHPXsZzcUrDro+Cofwhi0jFTCxXce6Y0y/qbzL/MmDVY9b5+T2FFeT/
QgbMUxdwqz6K7p/8X8jAuyPSP0QMMC4mzztqZP5lYFdu7vBxruh6x8b2KHAf
QZATtNmAz5jufv1XjoAamXeP0JaytHwLRSH8fO9ef5tH+L3KNuUNTSFDLttz
1ZhHKDyete7IMIVrO+LDdsSnQ8fuTt1nKfr/fem3ljAfGRo2ZJ6lY3tIhSVP
lvGSp/sSXOXokfmWho/s1I6qb2jcuxU2ftHFNBQbnFtoosD4+zNspyBFGg7K
TiUr16ShmTyvaSSQ+ZWGXR/O6Z0fy/gvqX/2VyvTUCHzKxW1Kg2U5nga7do/
bLvkm4re7S1FjhNoLF8nu01xXyoiawv8I1QYd6ztOV+uyvix/tOD/RNp9F07
Zd5x9W88z1Q5p6nOePzJ6HzTSTR8SiNolpHo+/qICfaTaXiP+FF6Vu4BDRqf
yftqCpKqT2oFTqFH5k0KrMqum0ZqMk5dukc7Xotx0vNAs0Rtxt1yfdQdHXpk
3iSjSqfU6aYuDWMyT5KhmJ29IXwq4z7y/sI4fYrtDsEor7ZWOuA7jfGmRQna
rno0osn8SYb1A5bVBn3Gi8PvGhob0CPz5iH83uuaTZxOQ4+8Dz7EBJ1JzQOj
XPPquXvVDBo6ZN48wJDhw8x7Mxnv3OS43seQHpkvSfAbyOOvN2Ic31K2XGMW
47iQEweaR/lw7Iamq7NpNMhaXZiRmAhet07sj9/S+I3Ml0QEc7xXjzOmwSXz
IwHe/8RdrxX5v/mRgNVj2cfD5jCW0R1zwW4ujcNkPtxHw3ezNSbMY+wecku2
ZJTVVFfGHJvPOMP+72VTF9DweyXf9dY0Hs7vtpwtF3kBeT+6h8Cqk9tPmjCe
aDRnysyFjI/GxI5niaxC+jkO0uT9knGrhodt6yhfiPcK919Mj/TzXRTLsdZ+
u4Qe6d+7uFB5Zn79KG8ud11/Yinjyzfq36iZ0lhF+jMWaQvXrssc5bt903S2
mDHuUr0Y3TfKLR++0fAz/9J/d2CiLz1Jc9mX/ruNNKu22NJRdorQtTxkwfis
lqGBynLGBbf2RtwfZfWAs2+sLGnwSf3HYIyr7v22UT7MruOdtPpSn9HIt1KU
MsWX+vsLrvlS+sJRrhrWd8+wFvUrqY+bODwhOe/aCsZneS2Wv3z3JY8/YEfv
unZo5ZffOxxLed/PC1tFw5/8ftfx6ZZSVNdqGj1kP5cxibzv05Ai1/PDdidH
WUtbGpUWfq5/Rgcv/z8BFIaZ
             "]], FontSize -> 22]}, 
          Annotation[#, "Charting`Private`Tag#7"]& ], 
         TagBox[{
           RGBColor[1, 0.75, 0], 
           PointSize[0.003666666666666667], 
           AbsoluteThickness[2], 
           StyleBox[
            PointBox[CompressedData["
1:eJxd13k8Fe37B3C0URSRFrJEop1SUfoobZRoVUml1GN70kIrlUopqVTaEKKN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             "]], FontSize -> 22]}, 
          Annotation[#, "Charting`Private`Tag#8"]& ]}, {
        "WolframDynamicHighlight", <|
         "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
       StyleBox[
        DynamicBox[
         (Charting`HighlightActionBox["DynamicHighlight", {}, 
          Slot["HighlightElements"], 
          Slot["LayoutOptions"], 
          Slot["Meta"], 
          Charting`HighlightActionFunction["DynamicHighlight", {{
             Annotation[{
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2], FontSize -> 22], 
               Point[CompressedData["
1:eJxcfXf81tP/fqJoKKE0VZQoDRQNujSVhoZRWpTsREtKpWGVURr6RNFCIUmk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                "]]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.880722, 0.611041, 0.142051], 
                AbsoluteThickness[2], FontSize -> 22], 
               Point[CompressedData["
1:eJxN1nlYjXkbB/DQWJosoUxMM1PEIGOSzNulfGekyAgRWapXqJElS2+WEtKi
TCHVsVYUlRRTSElaSNRpOed0WpBlaCwly6uzPc+p6fyuM+55rqur6/PPr/Oc
7/373pmu3rzIu7eOjs7znh/N75xXQqFwYCfe+oa1Jjk2oZf+t+Ftw8km4W0u
+d+QLa00D9nhWeDwS7PJyw+XdX7vTt5kp9eYuoUcojkunJxwQvOQL8zWHEgu
6jmt50jstK5OdrVqgih1S8+J5FbNcW2d6BcyaUaYcROU3ZqHPPCS5kAZ6p6J
P8lEjTDVnPa9DCZc0IVKQSOsNR/PTgaPeFeZyrERTprjXGSYWrZtwWiLRnj4
aB7y1uGaA8nhmtc9TD6h+XipMszasKDcV68R2Zrj8smlQs0jw4z13jqRxQ2Q
ar6+ZzKsG/BwUHZ+A16z15WhferPbgdDGqBu0LywHD689D+PFjbAgOUhR/+z
k3+VTmqAOctDjqCRXgXpBg2wYXmQnVkecgRq7cXykCN4S4LPty+lCGB5yDH2
lvHhJ01SRLE85LAdrtv4MluKRJaHHJ+m2F0Rb5Qih+VBLmd5yNEh6Dcs00aK
ZpaHHBsfDW850VWPtywPOaZ73L1b+K4evVgeChzK31jyRFQPQ5aHAs2Owv2e
hfUYz/JQQBYUmjotsR52LA8Foto6MoIi6uHC8lDgQdn8p15O9fBmeShws84p
UWJWj10sDwWepn+tUHESxLA8FOhfZRfzxyMJzrI8FOgc6BU5tUiCaywPBVxb
HddtPy/BfZaHAu7JGYvOhkvQwvIgf2B5KNF6zGjDcgcJvmB5KFE8JnqNLi+G
MctDiZ5hkE8tE2MSy0OJQxWhli8KxPiF5aFE3jv+G8e9YixheSgRFgkbfw8x
mqxXP3sVqkSXa5iVZIoYviwf8u9LLX0OHiDXWrwv9YomuzVv2jVEQA5meSrh
vKlFONhYjPvGH5ovnlGiv+Gs/+2WiRDL8lXivP5l/TSJCEM9HA+PK1HCbvKK
ytZKEc6zvMlVYzs6PSuUSGADJsKIqJ3ju+rIBWwelFipWFC3dZsI6qZV3mbP
ydVsPpRIveMQG24rwib732Ln8krYC/P3+0wQ4RmbFyVyFptXLTAV4f5Oy5b1
/VSf3Zmt+cA9HreldNyzOvTVd28IH6PCw4itlmk1dRjA5kmFth0f1xbl1mEw
33lSaqnC1ILW1POCOpiw+VLhkUQzEXUw/cPtq/fzVBBMyZfWzK2DJZs3ssu9
LM8/V5Id2PypoLv0m/reBnVwf2AzyCiAvJzNowpXcm/76dfXYnGk4MaOCPIm
Np8qjBBOwrATtWioNhzRdVqF9rMP00XWtQhh86qCw7KOngasQekFk0LfHHIC
m18VHKfP2F6SUYNEK4P07eXkC2yeVTh9euEZd90aDNJdb7S4WYVTWhex+Vbh
Q3yssOZUNZ6u3TAz+q0Ks6pUofFbqyFi807eU9AnyLcXh4qoNUNkfavRyuaf
g5hdKCHGZQkGvzIkK8M0A8vBysyi0MheiI+NBsF3xnNwvegwt8FIiIHsfnBQ
jr1yZcGbKux7cfVMnh0H/WPe3t1pVTBl94VD8F7Hatt5VZjmFbH4lgt5/JAV
/r4rOSw0GjhuZHMlrNl9IjvHxKnSPcjBUda6aas4/Fkx5INhXCVaQnaNSPHh
sKqnDQVBlXBi94/Mf+XeNTiQQ/zLyJ0l9fchnv31rl9DOZRtXyw6evM+PNh9
JPtPKZpWHklOLomzGnqELPx9tnPScQ5FVy+3P5Dfw1Z2H8mFV+2mHDlFXtAW
viY4mbxjmdFdt3QO/i67MkOy7iGc3VcObyP2hGLVPQSvTzzgm8dp9+U9TMxv
KAm5RT7B7i/ZPjXDeVIlhwOFM3xa7lTAx3jtD40icja7vxyM6jP9MwMq0GRs
6+75mNPurwok7U37IqGVXMruM6fdX3fxOMjvp9UfObSx/XUXFvoRpeZKckd6
99Nz3RzM2b4ph5Tdd3LqZZ0ZeTr8Z2Nw7xtmvck7anRzOV3yy3l6Kdl6PI5d
r2m2v1kOsVNi3I8G5NesL8ge3p43T44k72y+67P7O167j+5g5NLd+wLHktUr
NQNGvv3bNcf2STxa9o+OKFh2B0uiAypirMjxhn2bzGx4PGH75zYMWN+QlbWR
E2tn8tr9cxsVknlLbeeQj496v32bM9mc9RE5bKTe+uKlPGLYPinD6ScjR0lW
kvv2yZh5ZRU5Teja7uVNtmH9xWv3Qxn+eyJqxeZ15IvdtTNDNpKNQmvjn2/h
tf1eihDp3I2HAsijkz81DQgkO7P+I5/t+s78yG4eKazvS+Ek6fv07V5y/Lw7
UZPDyJsczV86RPLaPi9B5r64maujyV6sP8nxssA9P8aRZ7YEN7UIeG0fl8Dk
/7EHjp7kkcP6txiuFn2aFybx2r4txl8ptgm9Uni0aR3A+pfHLNa3txD3JT6F
pJP9LYwFZhfJh0r2z0+6xKOD9WkRPiWvrJiQS/ZdVWAad40cxfqbfG7qz+lB
hby2L2/CpGJGwPVbPOSsHwvxQ+kZ0wFl5F7Rs3rblJPnFr73m3OPx3zWdzcQ
anHJeksVD0/WZzeQyPYBWaSvx4XXktcc9M8NEfPavirA5gTR0VNS8tykyY8S
mnjcZH2Uj9vGxfaxD8lZp5qd/B6Tc9h+4bV9ch2DbH5KGf+CfG149rSOv8i6
ufYCwWte2w95ENkZvvZp57GT/b+aB2VSZuCxd+SJmWti0j+S1UV9/I53ksvZ
/iIv6dIXG8nIARf83Ir/5WvdlquHKMjWWfk7clX/3LcruD+hODFLTTYzSdsY
qaP+bM+8YaNm91GDZ/clF/FOi6cl9FUjns1/DvrN6zqgr0duZvuTHNze8Uvy
v1w+IvzF6i/JS/xyxr/RJweM0ruqGKzGZTbPlxGl57qudBg5dmiNYM0INT6x
+bgIt0VPMp6MUsOd5Z2Jt2w/q7V5ZcD4TZ9zvmPIc5ZbGehN+OfvnUUvtq/V
qJ6+1yfpjMD2by9Oerw=
                "]]}, "Charting`Private`Tag#2"], 
             Annotation[{
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.560181, 0.691569, 0.194885], 
                AbsoluteThickness[2], FontSize -> 22], 
               Point[CompressedData["
1:eJxN1ns41GkbB/BRIXJKzuuYTWxbtrCl0i1t61BppcJK61CyW8IrpLfQlrdo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                "]]}, "Charting`Private`Tag#3"], 
             Annotation[{
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.922526, 0.385626, 0.209179], 
                AbsoluteThickness[2], FontSize -> 22], 
               Point[CompressedData["
1:eJxN13s0lPkfB/Aubm2sFO1WJMTSlmqRbYt3N8kmFalFF+lio6LddKUbUyiV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                "]]}, "Charting`Private`Tag#4"], 
             Annotation[{
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.528488, 0.470624, 0.701351], 
                AbsoluteThickness[2], FontSize -> 22], 
               Point[CompressedData["
1:eJxF1nlcTHsfB/BsEULduBVdspVUkrJEPpIrkWUoNeKqyLVFXTdLlkQJ6dpy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                "]]}, "Charting`Private`Tag#5"], 
             Annotation[{
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.772079, 0.431554, 0.102387], 
                AbsoluteThickness[2], FontSize -> 22], 
               Point[CompressedData["
1:eJxd2AlUjfkbB/BSqMRUiCSm0SaJCDVpvnajbClbZCRZMkyRnSxlaUyyVLRJ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                "]]}, "Charting`Private`Tag#6"], 
             Annotation[{
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.363898, 0.618501, 0.782349], 
                AbsoluteThickness[2], FontSize -> 22], 
               Point[CompressedData["
1:eJxd1wk4Vfn/B3BLxpKKKNkKFTXatCHx1rSoUTOKVmmSMo0kTRsq28SPmvZk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                "]]}, "Charting`Private`Tag#7"], 
             Annotation[{
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[1, 0.75, 0], 
                AbsoluteThickness[2], FontSize -> 22], 
               Point[CompressedData["
1:eJxd13k8Fe37B3C0URSRFrJEop1SUfoobZRoVUml1GN70kIrlUopqVTaEKKN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                "]]}, "Charting`Private`Tag#8"]}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{0, 1.83249406159968}, {
                0, 0.38505747126436773`}}, 
              "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0},
               "ImageSize" -> {400, 
                Rational[800, 3]}, "Axes" -> {True, True}, 
              "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> 
              Rational[2, 3], "DefaultStyle" -> {
                Directive[
                 PointSize[0.003666666666666667], 
                 RGBColor[1, 0.75, 0], 
                 AbsoluteThickness[2], FontSize -> 22], 
                Directive[
                 PointSize[0.003666666666666667], 
                 RGBColor[0.363898, 0.618501, 0.782349], 
                 AbsoluteThickness[2], FontSize -> 22], 
                Directive[
                 PointSize[0.003666666666666667], 
                 RGBColor[0.772079, 0.431554, 0.102387], 
                 AbsoluteThickness[2], FontSize -> 22], 
                Directive[
                 PointSize[0.003666666666666667], 
                 RGBColor[0.528488, 0.470624, 0.701351], 
                 AbsoluteThickness[2], FontSize -> 22], 
                Directive[
                 PointSize[0.003666666666666667], 
                 RGBColor[0.922526, 0.385626, 0.209179], 
                 AbsoluteThickness[2], FontSize -> 22], 
                Directive[
                 PointSize[0.003666666666666667], 
                 RGBColor[0.560181, 0.691569, 0.194885], 
                 AbsoluteThickness[2], FontSize -> 22], 
                Directive[
                 PointSize[0.003666666666666667], 
                 RGBColor[0.880722, 0.611041, 0.142051], 
                 AbsoluteThickness[2], FontSize -> 22], 
                Directive[
                 PointSize[0.003666666666666667], 
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 AbsoluteThickness[2], FontSize -> 22]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> ({
                  Identity[
                   Part[#, 1]], 
                  Identity[
                   Part[#, 2]]}& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, 
             "PlotRange" -> {{0, 1.83249406159968}, {
               0, 0.38505747126436773`}}, 
             "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
             "ImageSize" -> {400, 
               Rational[800, 3]}, "Axes" -> {True, True}, 
             "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> 
             Rational[2, 3], "DefaultStyle" -> {
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[1, 0.75, 0], 
                AbsoluteThickness[2], FontSize -> 22], 
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.363898, 0.618501, 0.782349], 
                AbsoluteThickness[2], FontSize -> 22], 
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.772079, 0.431554, 0.102387], 
                AbsoluteThickness[2], FontSize -> 22], 
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.528488, 0.470624, 0.701351], 
                AbsoluteThickness[2], FontSize -> 22], 
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.922526, 0.385626, 0.209179], 
                AbsoluteThickness[2], FontSize -> 22], 
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.560181, 0.691569, 0.194885], 
                AbsoluteThickness[2], FontSize -> 22], 
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.880722, 0.611041, 0.142051], 
                AbsoluteThickness[2], FontSize -> 22], 
               Directive[
                PointSize[0.003666666666666667], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2], FontSize -> 22]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 Identity[
                  Part[#, 1]], 
                 Identity[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ListPlot, "GroupHighlight" -> False|>|>], 
         ImageSizeCache -> {{139.49162525593087`, 
          217.80690055287675`}, {-45.54899206513818, -20.083016103587823`}}], 
        Selectable -> False]}, 
      Annotation[{{
         Annotation[{
           Directive[
            PointSize[0.003666666666666667], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2], FontSize -> 22], 
           Point[CompressedData["
1:eJxcfXf81tP/fqJoKKE0VZQoDRQNujSVhoZRWpTsREtKpWGVURr6RNFCIUmk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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            PointSize[0.003666666666666667], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2], FontSize -> 22], 
           Point[CompressedData["
1:eJxN1nlYjXkbB/DQWJosoUxMM1PEIGOSzNulfGekyAgRWapXqJElS2+WEtKi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            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            PointSize[0.003666666666666667], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2], FontSize -> 22], 
           Point[CompressedData["
1:eJxN1ns41GkbB/BRIXJKzuuYTWxbtrCl0i1t61BppcJK61CyW8IrpLfQlrdo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            "]]}, "Charting`Private`Tag#3"], 
         Annotation[{
           Directive[
            PointSize[0.003666666666666667], 
            RGBColor[0.922526, 0.385626, 0.209179], 
            AbsoluteThickness[2], FontSize -> 22], 
           Point[CompressedData["
1:eJxN13s0lPkfB/Aubm2sFO1WJMTSlmqRbYt3N8kmFalFF+lio6LddKUbUyiV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            "]]}, "Charting`Private`Tag#4"], 
         Annotation[{
           Directive[
            PointSize[0.003666666666666667], 
            RGBColor[0.528488, 0.470624, 0.701351], 
            AbsoluteThickness[2], FontSize -> 22], 
           Point[CompressedData["
1:eJxF1nlcTHsfB/BsEULduBVdspVUkrJEPpIrkWUoNeKqyLVFXTdLlkQJ6dpy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            "]]}, "Charting`Private`Tag#5"], 
         Annotation[{
           Directive[
            PointSize[0.003666666666666667], 
            RGBColor[0.772079, 0.431554, 0.102387], 
            AbsoluteThickness[2], FontSize -> 22], 
           Point[CompressedData["
1:eJxd2AlUjfkbB/BSqMRUiCSm0SaJCDVpvnajbClbZCRZMkyRnSxlaUyyVLRJ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            "]]}, "Charting`Private`Tag#6"], 
         Annotation[{
           Directive[
            PointSize[0.003666666666666667], 
            RGBColor[0.363898, 0.618501, 0.782349], 
            AbsoluteThickness[2], FontSize -> 22], 
           Point[CompressedData["
1:eJxd1wk4Vfn/B3BLxpKKKNkKFTXatCHx1rSoUTOKVmmSMo0kTRsq28SPmvZk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            "]]}, "Charting`Private`Tag#7"], 
         Annotation[{
           Directive[
            PointSize[0.003666666666666667], 
            RGBColor[1, 0.75, 0], 
            AbsoluteThickness[2], FontSize -> 22], 
           Point[CompressedData["
1:eJxd13k8Fe37B3C0URSRFrJEop1SUfoobZRoVUml1GN70kIrlUopqVTaEKKN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            "]]}, "Charting`Private`Tag#8"]}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{0, 1.83249406159968}, {0, 0.38505747126436773`}}, 
          "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
          "ImageSize" -> {400, 
            Rational[800, 3]}, "Axes" -> {True, True}, 
          "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> Rational[2, 3], 
          "DefaultStyle" -> {
            Directive[
             PointSize[0.003666666666666667], 
             RGBColor[1, 0.75, 0], 
             AbsoluteThickness[2], FontSize -> 22], 
            Directive[
             PointSize[0.003666666666666667], 
             RGBColor[0.363898, 0.618501, 0.782349], 
             AbsoluteThickness[2], FontSize -> 22], 
            Directive[
             PointSize[0.003666666666666667], 
             RGBColor[0.772079, 0.431554, 0.102387], 
             AbsoluteThickness[2], FontSize -> 22], 
            Directive[
             PointSize[0.003666666666666667], 
             RGBColor[0.528488, 0.470624, 0.701351], 
             AbsoluteThickness[2], FontSize -> 22], 
            Directive[
             PointSize[0.003666666666666667], 
             RGBColor[0.922526, 0.385626, 0.209179], 
             AbsoluteThickness[2], FontSize -> 22], 
            Directive[
             PointSize[0.003666666666666667], 
             RGBColor[0.560181, 0.691569, 0.194885], 
             AbsoluteThickness[2], FontSize -> 22], 
            Directive[
             PointSize[0.003666666666666667], 
             RGBColor[0.880722, 0.611041, 0.142051], 
             AbsoluteThickness[2], FontSize -> 22], 
            Directive[
             PointSize[0.003666666666666667], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2], FontSize -> 22]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ListPlot, "GroupHighlight" -> False|>|>, 
       "DynamicHighlight"]], {{}, {}}}, AspectRatio -> NCache[
      Rational[2, 3], 0.6666666666666666], Axes -> {True, True}, AxesLabel -> {
      FormBox[
       TagBox[
        StyleBox["\"time\"", Bold, 14, StripOnInput -> False], HoldForm], 
       TraditionalForm], 
      FormBox[
       TagBox[
        StyleBox["\"closure radius\"", Bold, 14, StripOnInput -> False], 
        HoldForm], TraditionalForm]}, AxesOrigin -> {0, 0}, 
    BaseStyle -> {FontSize -> 22}, DisplayFunction -> Identity, 
    Frame -> {{True, True}, {True, True}}, 
    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> Directive[
      GrayLevel[0]], 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImageSize -> 400, 
    Method -> {
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
        Directive[
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.571589, 0.586483, 0.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.915, 0.3325, 0.2125], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
         AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
      "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05],
       "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint",
       "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& )}}, 
    PlotRange -> {{0, 1.83249406159968}, {0, 0.38505747126436773`}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Anthony's results\"", 
       "\"58 - 5.21\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-9\\)]\\) - \
\[Alpha]=4.5\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-2\\)]\\) - \
\[Beta]=1\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-8\\)]\\)\"", 
       "\"65 - 5.21\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-9\\)]\\) - \
\[Alpha]=4\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-2\\)]\\) - \[Beta]=1\
\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-8\\)]\\)\"", 
       "\"75 - 5.21\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-9\\)]\\) - \
\[Alpha]=3.5\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-2\\)]\\) - \
\[Beta]=1\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-8\\)]\\)\"", 
       "\"87 - 5.21\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-9\\)]\\) - \
\[Alpha]=3\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-2\\)]\\) - \[Beta]=1\
\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-8\\)]\\)\"", 
       "\"104 - 5.21\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-9\\)]\\) - \
\[Alpha]=2.5\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-2\\)]\\) - \
\[Beta]=1\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-8\\)]\\)\"", 
       "\"130 - 5.21\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-9\\)]\\) - \
\[Alpha]=2\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-2\\)]\\) - \[Beta]=1\
\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-8\\)]\\)\"", 
       "\"174 - 5.21\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-9\\)]\\) - \
\[Alpha]=1.5\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-2\\)]\\) - \
\[Beta]=1\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(-8\\)]\\)\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2], FontSize -> 22], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2], FontSize -> 22], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2], FontSize -> 22], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2], FontSize -> 22], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2], FontSize -> 22], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2], FontSize -> 22], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[2], FontSize -> 22], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[2], FontSize -> 22], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[2], FontSize -> 22], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[2], FontSize -> 22], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #5}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[2], FontSize -> 22], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[2], FontSize -> 22], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #6}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[2], FontSize -> 22], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[2], FontSize -> 22], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #7}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.75, 0], 
                    AbsoluteThickness[2], FontSize -> 22], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.75, 0], 
                    AbsoluteThickness[2], FontSize -> 22], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #8}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.772079, 0.431554, 0.102387]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.363898, 0.618501, 0.782349]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[1, 0.75, 0]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7, 
               ",", #8}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "False", ",", "False", ",", "False", ",", "False", ",", 
                 "False", ",", "False", ",", "False", ",", "False"}], "}"}]}],
            ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.891929034729986*^9, 3.8919302328751*^9, 3.891930425346836*^9, 
   3.891942532112961*^9, 3.891943854283836*^9, 3.891943898025736*^9, 
   3.891943934288389*^9, {3.891943986266135*^9, 3.891944008952325*^9}, 
   3.8919440530462027`*^9, 3.892180628443761*^9, 3.8924408944953012`*^9, 
   3.892464526059415*^9, 3.904543547474395*^9, 3.904635303830737*^9, 
   3.905841861443686*^9, 3.905847336576329*^9, 3.905860689759468*^9, 
   3.905873745839244*^9, 3.905907512160915*^9, 3.906444408928987*^9, 
   3.906453632435384*^9, 3.9065152851062613`*^9, 3.906516707491469*^9, 
   3.906523580810717*^9, 3.907047901443534*^9, 3.907055023495989*^9, 
   3.907055104750222*^9, 3.907057405431388*^9, 3.907821895874324*^9, 
   3.908334831609828*^9, 3.908335255364689*^9, 3.937900733273674*^9, 
   3.9394750174136543`*^9, 3.941680931866287*^9, 3.941701673571121*^9, 
   3.9417019749168777`*^9, 3.9417026638470554`*^9, 3.9431657608251743`*^9, 
   3.9432120462429676`*^9, 3.943215338159767*^9},
 CellLabel->
  "Out[156]=",ExpressionUUID->"f14abe7b-89d7-694b-9f80-0b1396969d9a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xlabel", "=", 
    RowBox[{"MaTeX", "[", 
     RowBox[{"\"\<t/t_{s}\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "Myfontsize"}]}], "]"}]}], ";"}], 
  "  "}], "\n", 
 RowBox[{
  RowBox[{"ylabel", "=", 
   RowBox[{"MaTeX", "[", 
    RowBox[{"\"\<R(t)\>\"", ",", 
     RowBox[{"FontSize", "\[Rule]", "Myfontsize"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"opt", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", " ", "0.65"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", "texStyle"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"xlabel", ",", "ylabel"}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   SubscriptBox["pf174e6", "total"], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<time\>\"", ",", "Bold", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<closure radius\>\"", ",", "Bold", ",", "14"}], "]"}]}], 
     "}"}]}], ",", "opt", ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9058478123724747`*^9, 3.905847850244452*^9}, {
  3.905908701759594*^9, 3.905908791388652*^9}, {3.9059088624226522`*^9, 
  3.90590888378094*^9}, {3.906453531249517*^9, 3.906453569470615*^9}, {
  3.906453601700938*^9, 3.9064536018909597`*^9}, {3.906455594035111*^9, 
  3.906455599866955*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"40763f9b-d5f7-4a59-baac-ad5699a8c33c"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[
      TagBox[
       {GrayLevel[0], PointSize[0.004583333333333334], AbsoluteThickness[2], 
        StyleBox[PointBox[CompressedData["
1:eJxd2nlcTO3/P/DsFVFJRJJkJ2RPeVmjSCGihEiiVLaQLJEsEVGI0Ia0UGlP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          "]],
         FontSize->22]},
       Annotation[#, "Charting`Private`Tag#1"]& ],
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.004583333333333334], 
              AbsoluteThickness[2], FontSize -> 22, 
              GrayLevel[0]], 
             Point[CompressedData["
1:eJxd2nlcTO3/P/DsFVFJRJJkJ2RPeVmjSCGihEiiVLaQLJEsEVGI0Ia0UGlP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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{0, 1.83249406159968}, {0, 0.3860241405548744}}, 
            "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {400, 260.}, "Axes" -> {True, True}, 
            "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> 0.65, 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.004583333333333334], 
               AbsoluteThickness[2], FontSize -> 22, 
               GrayLevel[0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 1.83249406159968}, {0, 0.3860241405548744}}, 
           "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {400, 260.}, "Axes" -> {True, True}, 
           "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> 0.65, 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.004583333333333334], 
              AbsoluteThickness[2], FontSize -> 22, 
              GrayLevel[0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{
       Annotation[{
         Directive[
          PointSize[0.004583333333333334], 
          AbsoluteThickness[2], FontSize -> 22, 
          GrayLevel[0]], 
         Point[CompressedData["
1:eJxd2nlcTO3/P/DsFVFJRJJkJ2RPeVmjSCGihEiiVLaQLJEsEVGI0Ia0UGlP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          "]]}, "Charting`Private`Tag#1"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{0, 1.83249406159968}, {0, 0.3860241405548744}}, 
        "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {400, 260.}, "Axes" -> {True, True}, 
        "LabelStyle" -> {FontSize -> 22}, "AspectRatio" -> 0.65, 
        "DefaultStyle" -> {
          Directive[
           PointSize[0.004583333333333334], 
           AbsoluteThickness[2], FontSize -> 22, 
           GrayLevel[0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListPlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->0.65,
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      StyleBox["\"time\"", Bold, 14, StripOnInput -> False], HoldForm], 
     TraditionalForm], 
    FormBox[
     TagBox[
      StyleBox["\"closure radius\"", Bold, 14, StripOnInput -> False], 
      HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 22},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       GraphicsBox[{
         Thickness[0.023934897079942556`], 
         StyleBox[{
           
           FilledCurveBox[{{{1, 4, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {0, 1,
              0}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
              3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
             1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
             3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3,
              3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0