---
title: "Mapping Biolink Model to a Neo4j property graph"
parent: "Mapping to a graph store"
layout: default
---

# Mapping Biolink Model to a Neo4j property graph

This section describes how a Neo4j database is mapped to the Biolink Model.
Although specific to Neo4j, these recommendations should hold for any Labeled Property Graph (LPG) model, 
e.g a Python networkx graph (specifically a [MultiDiGraph](https://networkx.github.io/documentation/stable/reference/classes/multidigraph.html)).
For mapping to RDF graphs refer to [Mapping to RDF](mapping-rdf.md).


## Nodes

All nodes in the Neo4j database should be typed according to the Biolink Model, by specifying the 'category'
property on the node to be a class in the Biolink Model. For example, a node representing a gene should have 
category `biolink:Gene`.  

Biolink Model defines a typology of categories (aka: classes, aka: node types), 
all of which descend from [NamedThing](NamedThing).

The [NamedThing](NamedThing) class in Biolink defines the properties expected on a node of that type in neo4J. 

Core properties for all nodes include:
 - [id](id)
 - [name](name)
 - [category](category)

All descendents of [NamedThing](NamedThing) inherit these properties, but also expand and refine the properties
applicable to each class (aka: node category).  Additional properties may be added to
a node, but these three properties are required.  The [id](id) property is a CURIE that uniquely identifies 
the node. The [name](name) property is a human-readable name for the node (E.g. *asthma* or *Wnt signaling
pathway*. If the node is an ontology class then name will correspond to the `rdfs:label` of that class.
The [category](category) property is the type of the node, and should be a Biolink Model class name.

When mapping nodes to RDF, the node ID MUST correspond to the IRI using the [link](biolink-model-prefix-map.json) json-ld context.

> **Note:** The `biolink:id` property (aka: attribute, aka: field) is distinct from the internal autogenerated `id` field in Neo4j.

Any Neo4j instance MAY provide as many additional properties as required.
These SHOULD come from a registered list of properties for that class (aka: category, aka: node type).

For example, the [Genotype](Genotype.md) class provides a property [has_zygosity](has_zygosity.md), which is specific to that class 
(and its sub-classes).


> **Note:** While the CURIE for a property is `biolink:name` that does not necessarily mean the property
> name has to be `biolink:name` in Neo4j. Instead, the prefix part of the property can be omitted such that
> the property name is just `name`.


### Use of Neo4j labels

Nodes in Neo4j can be tagged with label(s) indicating a grouping to which the node belongs.
The `biolink:category` field in the model MUST map to a Neo4j label.
The Biolink Model class name in CamelCase MUST be used for the `biolink:category` field.

Additionally, the Neo4j implementation MAY have additional categories which are super-classes of a 
specific category.
 
For example, if a node representing a particular type of neuron has category [Cell](Cell.md),
then the Neo4j graph may also tag the node with [AnatomicalEntity](AnatomicalEntity.md) as label, 
in addition to [Cell](Cell.md).

Consequently, any number of additional local labels MAY also be used.

In addition to Neo4j labels, additional [subclass of](subclass_of.md) edges may be used to connect a node
to an ontology class node.

> **Implementation Note:** Cypher queries that use labels are optimized for speed, under the assumption that
an index has already been generated in Neo4j for said label(s).

> **Terminology note:** The term `label` is overloaded. In RDF it usually denotes the name of an entity (`rdfs:label`).
For this reason we use [category](category.md) as the property name in Biolink Model.


## Edges

Each edge in the Neo4j graph should have a predicate that is a sub-property of [related_to](related_to.md).
For example, two protein nodes may be related via [physically_interacts_with](physically_interacts_with.md) predicate.

The set of edge labels is deliberately kept minimal. This is partly for practical reasons.
Neo4j has no easy way to automatically use sub-property relationship types in Cypher queries.

### Edge properties

Neo4j uses a property graph model, where any number of properties can be attached to an edge. 
Some properties may be generic, while some may only pertain to particular kinds of predicates.

Edges can also have generic properties that changes the meaning of the edge itself. 
For example, the generic property [negated](negated.md) which logically negates the assertion defined by the edge.

### Associations

Biolink Model includes a hierarchy of [Association](Association.md).

> **Note:** This is distinct from the predicate hierarchy, although in some cases they parallel one another.

An association in Biolink model is a convenience class that helps constrain the set of possible properties
on an edge between two Biolink nodes.  Different association types may have different properties associated with them.

Every association must have:
 - [subject](subject.md)*
 - [predicate](predicate.md)*
 - [object](object.md)*

Many associations also have qualifying properties that apply to the subject, object, or entirety of the statement
expressed in the association.  

For many examples of associations and how they constrain properties on an edge, please see: 
[Association Examples with Qualifiers](association-examples-with-qualifiers.md)
