-- # Class: "mapping collection" Description: "A collection of deprecated mappings."
--     * Slot: id Description: 
-- # Class: "predicate mapping" Description: "A deprecated predicate mapping object contains the deprecated predicate and an example of the rewiring that should be done to use a qualified statement in its place."
--     * Slot: id Description: 
--     * Slot: mapped_predicate Description: The predicate that is being replaced by the fully qualified representation of predicate + subject and object qualifiers.  Only to be used in test data and mapping data to help with the transition to the fully qualified predicate model. Not to be used in knowledge graphs.
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: subject_form_or_variant_qualifier Description: A qualifier that composes with a core subject/object concept to define a specific type, variant, alternative version of this concept. The composed concept remains a subtype or instance of the core concept. For example, the qualifier ‘mutation’ combines with the core concept ‘Gene X’ to express the compose concept ‘a mutation of Gene X’.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_part_qualifier Description: defines a specific part/component of the core concept (used in cases there this specific part has no IRI we can use to directly represent it, e.g. 'ESR1 transcript' q: polyA tail).  This qualifier is for the  subject of an association (or statement).
--     * Slot: subject_derivative_qualifier Description: A qualifier that composes with a core subject/object  concept to describe something that is derived from the core concept.  For example, the qualifier ‘metabolite’ combines with a ‘Chemical X’ core concept to express the composed concept ‘a metabolite of Chemical X’.  This qualifier is for the subject of an association  (or statement).
--     * Slot: subject_context_qualifier Description: 
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: object_form_or_variant_qualifier Description: A qualifier that composes with a core subject/object concept to define a specific type, variant, alternative version of this concept. The composed concept remains a subtype or instance of the core concept. For example, the qualifier ‘mutation’ combines with the core concept ‘Gene X’ to express the compose concept ‘a mutation of Gene X’.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_part_qualifier Description: defines a specific part/component of the core concept (used in cases there this specific part has no IRI we can use to directly represent it, e.g. 'ESR1 transcript' q: polyA tail).  This qualifier is for the  object of an association (or statement).
--     * Slot: object_derivative_qualifier Description: A qualifier that composes with a core subject/object  concept to describe something that is derived from the core concept.  For example, the qualifier ‘metabolite’ combines with a ‘Chemical X’ core concept to express the composed concept ‘a metabolite of Chemical X’.  This qualifier is for the object of an association  (or statement).
--     * Slot: object_context_qualifier Description: 
--     * Slot: causal_mechanism_qualifier Description: A statement qualifier representing a type of molecular control mechanism through which an effect of a chemical on a gene or gene product is mediated (e.g. 'agonism', 'inhibition', 'allosteric modulation', 'channel blocker')
--     * Slot: anatomical_context_qualifier Description: A statement qualifier representing an anatomical location where an relationship expressed in an association took place (can be a tissue, cell type, or sub-cellular location).
--     * Slot: species_context_qualifier Description: A statement qualifier representing a taxonomic category of species in which a relationship expressed in an association took place.
--     * Slot: mapping collection_id Description: Autocreated FK slot
-- # Class: "ontology class" Description: "a concept or class in an ontology, vocabulary or thesaurus. Note that nodes in a biolink compatible KG can be considered both instances of biolink classes, and OWL classes in their own right. In general you should not need to use this class directly. Instead, use the appropriate biolink class. For example, for the GO concept of endocytosis (GO:0006897), use bl:BiologicalProcess as the type."
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
-- # Class: "annotation" Description: "Biolink Model root class for entity annotations."
--     * Slot: id Description: 
-- # Class: "quantity value" Description: "A value of an attribute that is quantitative and measurable, expressed as a combination of a unit and a numeric value"
--     * Slot: id Description: 
--     * Slot: has_unit Description: connects a quantity value to a unit
--     * Slot: has_numeric_value Description: connects a quantity value to a number
-- # Class: "attribute" Description: "A property or characteristic of an entity. For example, an apple may have properties such as color, shape, age, crispiness. An environmental sample may have attributes such as depth, lat, long, material."
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical role" Description: "A role played by the molecular entity or part thereof within a chemical context."
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "biological sex" Description: ""
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "phenotypic sex" Description: "An attribute corresponding to the phenotypic sex of the individual, based upon the reproductive organs present."
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "genotypic sex" Description: "An attribute corresponding to the genotypic sex of the individual, based upon genotypic composition of sex chromosomes."
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "severity value" Description: "describes the severity of a phenotypic feature or disease"
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "relationship quantifier" Description: ""
--     * Slot: id Description: 
-- # Class: "sensitivity quantifier" Description: ""
--     * Slot: id Description: 
-- # Class: "specificity quantifier" Description: ""
--     * Slot: id Description: 
-- # Class: "pathognomonicity quantifier" Description: "A relationship quantifier between a variant or symptom and a disease, which is high when the presence of the feature implies the existence of the disease"
--     * Slot: id Description: 
-- # Class: "frequency quantifier" Description: ""
--     * Slot: id Description: 
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
-- # Class: "chemical or drug or treatment" Description: ""
--     * Slot: id Description: 
-- # Class: "entity" Description: "Root Biolink Model class for all things and informational relationships, real or imagined."
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "named thing" Description: "a databased entity or concept/class"
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "relationship type" Description: "An OWL property used as an edge label"
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
-- # Class: "taxonomic rank" Description: "A descriptor for the rank within a taxonomic classification. Example instance: TAXRANK:0000017 (kingdom)"
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
-- # Class: "organism taxon" Description: "A classification of a set of organisms. Example instances: NCBITaxon:9606 (Homo sapiens), NCBITaxon:2 (Bacteria). Can also be used to represent strains or subspecies."
--     * Slot: has_taxonomic_rank Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "event" Description: "Something that happens at a given place and time."
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "administrative entity" Description: ""
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "study result" Description: "A collection of data items from a study that are about a particular study subject or experimental unit (the 'focus' of the Result) - optionally with context/provenance metadata that may be relevant to the interpretation of this data as evidence."
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "study" Description: "a detailed investigation and/or analysis"
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "study variable" Description: "a variable that is used as a measure in the investigation of a study"
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "common data element" Description: "A Common Data Element (CDE) is a standardized, precisely defined question, paired with a set of allowable responses, used systematically across different sites, studies, or clinical trials to ensure consistent data collection. Multiple CDEs (from one or more Collections) can be curated into Forms. (https://cde.nlm.nih.gov/home)"
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "concept count analysis result" Description: "A result of a concept count analysis."
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "observed expected frequency analysis result" Description: "A result of a observed expected frequency analysis."
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "relative frequency analysis result" Description: "A result of a relative frequency analysis."
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "text mining result" Description: "A result of text mining."
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chi squared analysis result" Description: "A result of a chi squared analysis."
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "log odds analysis result" Description: "A result of a log odds ratio analysis."
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "agent" Description: "person, group, organization or project that provides a piece of information (i.e. a knowledge association)"
--     * Slot: address Description: the particulars of the place where someone or an organization is situated.  For now, this slot is a simple text "blob" containing all relevant details of the given location for fitness of purpose. For the moment, this "address" can include other contact details such as email and phone number(?).
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Different classes of agents have distinct preferred identifiers. For publishers, use the ISBN publisher code. See https://grp.isbn-international.org/ for publisher code lookups. For editors, authors and  individual providers, use the individual's ORCID if available; Otherwise, a ScopusID, ResearchID or Google Scholar ID ('GSID') may be used if the author ORCID is unknown. Institutional agents could be identified by an International Standard Name Identifier ('ISNI') code.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: it is recommended that an author's 'name' property be formatted as "surname, firstname initial."
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "information content entity" Description: "a piece of information that typically describes some topic of discourse or is used as support."
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "dataset" Description: "an item that refers to a collection of data from a data source."
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "dataset distribution" Description: "an item that holds distribution level information about a dataset."
--     * Slot: distribution_download_url Description: 
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "dataset version" Description: "an item that holds version level information about a dataset."
--     * Slot: has_dataset Description: 
--     * Slot: ingest_date Description: 
--     * Slot: has_distribution Description: 
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "dataset summary" Description: "an item that holds summary level information about a dataset."
--     * Slot: source_web_page Description: 
--     * Slot: source_logo Description: 
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "confidence level" Description: "Level of confidence in a statement"
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "evidence type" Description: "Class of evidence that supports an association"
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "publication" Description: "Any ‘published’ piece of information. Publications are considered broadly to include any document or document part made available in print or on the web - which may include scientific journal issues, individual articles, and books - as well as things like pre-prints, white papers, patents, drug labels, web pages, protocol documents,  and even a part of a publication if of significant knowledge scope (e.g. a figure, figure legend, or section highlighted by NLP)."
--     * Slot: summary Description: executive  summary of a publication
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Different kinds of publication subtypes will have different preferred identifiers (curies when feasible). Precedence of identifiers for scientific articles is as follows: PMID if available; DOI if not; actual alternate CURIE otherwise. Enclosing publications (i.e. referenced by 'published in' node property) such as books and journals, should have industry-standard identifier such as from ISBN and ISSN.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: the 'title' of the publication is generally recorded in the 'name' property (inherited from NamedThing). The field name 'title' is now also tagged as an acceptable alias for the node property 'name' (just in case).
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "book" Description: "This class may rarely be instantiated except if use cases of a given knowledge graph support its utility."
--     * Slot: summary Description: executive  summary of a publication
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Books should have industry-standard identifier such as from ISBN.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: the 'title' of the publication is generally recorded in the 'name' property (inherited from NamedThing). The field name 'title' is now also tagged as an acceptable alias for the node property 'name' (just in case).
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "book chapter" Description: ""
--     * Slot: published_in Description: The enclosing parent book containing the chapter should have industry-standard identifier from ISBN.
--     * Slot: volume Description: volume of a book or music release in a collection/series or a published collection of journal issues in a serial publication
--     * Slot: chapter Description: chapter of a book
--     * Slot: summary Description: executive  summary of a publication
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Different kinds of publication subtypes will have different preferred identifiers (curies when feasible). Precedence of identifiers for scientific articles is as follows: PMID if available; DOI if not; actual alternate CURIE otherwise. Enclosing publications (i.e. referenced by 'published in' node property) such as books and journals, should have industry-standard identifier such as from ISBN and ISSN.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: the 'title' of the publication is generally recorded in the 'name' property (inherited from NamedThing). The field name 'title' is now also tagged as an acceptable alias for the node property 'name' (just in case).
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "serial" Description: "This class may rarely be instantiated except if use cases of a given knowledge graph support its utility."
--     * Slot: iso_abbreviation Description: Standard abbreviation for periodicals in the International Organization for Standardization (ISO) 4 system See https://www.issn.org/services/online-services/access-to-the-ltwa/. If the 'published in' property is set, then the iso abbreviation pertains to the broader publication context (the journal) within which the given publication node is embedded, not the publication itself.
--     * Slot: volume Description: volume of a book or music release in a collection/series or a published collection of journal issues in a serial publication
--     * Slot: issue Description: issue of a newspaper, a scientific journal or magazine for reference purpose
--     * Slot: summary Description: executive  summary of a publication
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Serials (journals) should have industry-standard identifier such as from ISSN.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: the 'title' of the publication is generally recorded in the 'name' property (inherited from NamedThing). The field name 'title' is now also tagged as an acceptable alias for the node property 'name' (just in case).
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "article" Description: "a piece of writing on a particular topic presented as a stand-alone section of a larger publication"
--     * Slot: published_in Description: The enclosing parent serial containing the article should have industry-standard identifier from ISSN.
--     * Slot: iso_abbreviation Description: Optional value, if used locally as a convenience, is set to the iso abbreviation of the 'published in' parent.
--     * Slot: volume Description: volume of a book or music release in a collection/series or a published collection of journal issues in a serial publication
--     * Slot: issue Description: issue of a newspaper, a scientific journal or magazine for reference purpose
--     * Slot: summary Description: executive  summary of a publication
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Different kinds of publication subtypes will have different preferred identifiers (curies when feasible). Precedence of identifiers for scientific articles is as follows: PMID if available; DOI if not; actual alternate CURIE otherwise. Enclosing publications (i.e. referenced by 'published in' node property) such as books and journals, should have industry-standard identifier such as from ISBN and ISSN.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: the 'title' of the publication is generally recorded in the 'name' property (inherited from NamedThing). The field name 'title' is now also tagged as an acceptable alias for the node property 'name' (just in case).
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "journal article" Description: "an article, typically presenting results of research, that is published in an issue of a scientific journal."
--     * Slot: published_in Description: The enclosing parent serial containing the article should have industry-standard identifier from ISSN.
--     * Slot: iso_abbreviation Description: Optional value, if used locally as a convenience, is set to the iso abbreviation of the 'published in' parent.
--     * Slot: volume Description: volume of a book or music release in a collection/series or a published collection of journal issues in a serial publication
--     * Slot: issue Description: issue of a newspaper, a scientific journal or magazine for reference purpose
--     * Slot: summary Description: executive  summary of a publication
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Different kinds of publication subtypes will have different preferred identifiers (curies when feasible). Precedence of identifiers for scientific articles is as follows: PMID if available; DOI if not; actual alternate CURIE otherwise. Enclosing publications (i.e. referenced by 'published in' node property) such as books and journals, should have industry-standard identifier such as from ISBN and ISSN.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: the 'title' of the publication is generally recorded in the 'name' property (inherited from NamedThing). The field name 'title' is now also tagged as an acceptable alias for the node property 'name' (just in case).
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "patent" Description: "a legal document granted by a patent issuing authority which confers upon the patenter the sole right to make, use and sell an invention for a set period of time."
--     * Slot: summary Description: executive  summary of a publication
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Different kinds of publication subtypes will have different preferred identifiers (curies when feasible). Precedence of identifiers for scientific articles is as follows: PMID if available; DOI if not; actual alternate CURIE otherwise. Enclosing publications (i.e. referenced by 'published in' node property) such as books and journals, should have industry-standard identifier such as from ISBN and ISSN.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: the 'title' of the publication is generally recorded in the 'name' property (inherited from NamedThing). The field name 'title' is now also tagged as an acceptable alias for the node property 'name' (just in case).
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "web page" Description: "a document that is published according to World Wide Web standards, which may incorporate text, graphics, sound, and/or other features."
--     * Slot: summary Description: executive  summary of a publication
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Different kinds of publication subtypes will have different preferred identifiers (curies when feasible). Precedence of identifiers for scientific articles is as follows: PMID if available; DOI if not; actual alternate CURIE otherwise. Enclosing publications (i.e. referenced by 'published in' node property) such as books and journals, should have industry-standard identifier such as from ISBN and ISSN.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: the 'title' of the publication is generally recorded in the 'name' property (inherited from NamedThing). The field name 'title' is now also tagged as an acceptable alias for the node property 'name' (just in case).
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "preprint publication" Description: "a document reresenting an early version of an author's original scholarly work, such as a research paper or a review, prior to formal peer review and publication in a peer-reviewed scholarly or scientific journal."
--     * Slot: summary Description: executive  summary of a publication
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Different kinds of publication subtypes will have different preferred identifiers (curies when feasible). Precedence of identifiers for scientific articles is as follows: PMID if available; DOI if not; actual alternate CURIE otherwise. Enclosing publications (i.e. referenced by 'published in' node property) such as books and journals, should have industry-standard identifier such as from ISBN and ISSN.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: the 'title' of the publication is generally recorded in the 'name' property (inherited from NamedThing). The field name 'title' is now also tagged as an acceptable alias for the node property 'name' (just in case).
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "drug label" Description: "a document accompanying a drug or its container that provides written, printed or graphic information about the drug, including drug contents, specific instructions or warnings for administration, storage and disposal instructions, etc."
--     * Slot: summary Description: executive  summary of a publication
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: Different kinds of publication subtypes will have different preferred identifiers (curies when feasible). Precedence of identifiers for scientific articles is as follows: PMID if available; DOI if not; actual alternate CURIE otherwise. Enclosing publications (i.e. referenced by 'published in' node property) such as books and journals, should have industry-standard identifier such as from ISBN and ISSN.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: the 'title' of the publication is generally recorded in the 'name' property (inherited from NamedThing). The field name 'title' is now also tagged as an acceptable alias for the node property 'name' (just in case).
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "retrieval source" Description: "Provides information about how a particular InformationResource served as a source from which knowledge expressed in an Edge, or data used to generate this knowledge, was retrieved."
--     * Slot: resource_id Description: The InformationResource that served as a source for the knowledge expressed in an Edge, or data used to generate this knowledge.
--     * Slot: resource_role Description: The role of the InformationResource in the retrieval of the knowledge expressed in an Edge, or data used to generate this knowledge.
--     * Slot: upstream_resource_ids Description: The InformationResources that served as a source for the InformationResource that served as a source for the knowledge expressed in an Edge, or data used to generate this knowledge.
--     * Slot: license Description: 
--     * Slot: rights Description: 
--     * Slot: format Description: 
--     * Slot: creation_date Description: date on which an entity was created. This can be applied to nodes or edges
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "physical essence or occurrent" Description: "Either a physical or processual entity."
--     * Slot: id Description: 
-- # Class: "physical essence" Description: "Semantic mixin concept.  Pertains to entities that have physical properties such as mass, volume, or charge."
--     * Slot: id Description: 
-- # Class: "physical entity" Description: "An entity that has material reality (a.k.a. physical essence)."
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "occurrent" Description: "A processual entity."
--     * Slot: id Description: 
-- # Class: "activity and behavior" Description: "Activity or behavior of any independent integral living, organization or mechanical actor in the world"
--     * Slot: id Description: 
-- # Class: "activity" Description: "An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities."
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "procedure" Description: "A series of actions conducted in a certain order or manner"
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "phenomenon" Description: "a fact or situation that is observed to exist or happen, especially one whose cause or explanation is in question"
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "device" Description: "A thing made or adapted for a particular purpose, especially a piece of mechanical or electronic equipment"
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "diagnostic aid" Description: "A device or substance used to help diagnose disease or injury"
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "study population" Description: "A group of people banded together or treated as a group as participants in a research study."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "subject of investigation" Description: "An entity that has the role of being studied in an investigation, study, or experiment"
--     * Slot: id Description: 
-- # Class: "material sample" Description: "A sample is a limited quantity of something (e.g. an individual or set of individuals from a population, or a portion of a substance) to be used for testing, analysis, inspection, investigation, demonstration, or trial use. [SIO]"
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "planetary entity" Description: "Any entity or process that exists at the level of the whole planet"
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "environmental process" Description: ""
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "environmental feature" Description: ""
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "geographic location" Description: "a location that can be described in lat/long coordinates"
--     * Slot: latitude Description: latitude
--     * Slot: longitude Description: longitude
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "geographic location at time" Description: "a location that can be described in lat/long coordinates, for a particular time"
--     * Slot: timepoint Description: a point in time
--     * Slot: latitude Description: latitude
--     * Slot: longitude Description: longitude
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "thing with taxon" Description: "A mixin that can be used on any entity that can be taxonomically classified. This includes individual organisms; genes, their products and other molecular entities; body parts; biological processes"
--     * Slot: id Description: 
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
-- # Class: "biological entity" Description: ""
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "genomic entity" Description: ""
--     * Slot: id Description: 
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
-- # Class: "epigenomic entity" Description: ""
--     * Slot: id Description: 
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
-- # Class: "molecular entity" Description: "A molecular entity is a chemical entity composed of individual or covalently bonded atoms."
--     * Slot: is_metabolite Description: indicates whether a molecular entity is a metabolite
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical entity" Description: "A chemical entity is a physical entity that pertains to chemistry or biochemistry."
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "small molecule" Description: "A small molecule entity is a molecular entity characterized by availability in small-molecule databases of SMILES, InChI, IUPAC, or other unambiguous representation of its precise chemical structure; for convenience of representation, any valid chemical representation is included, even if it is not strictly molecular (e.g., sodium ion)."
--     * Slot: is_metabolite Description: indicates whether a molecular entity is a metabolite
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical mixture" Description: "A chemical mixture is a chemical entity composed of two or more molecular entities."
--     * Slot: is_supplement Description: 
--     * Slot: highest_FDA_approval_status Description: Should be the highest level of FDA approval this chemical entity or device has, regardless of which disease, condition or phenotype it is currently being reviewed to treat.  For specific levels of FDA approval for a specific condition, disease, phenotype, etc., see the association slot, 'clinical approval status.'
--     * Slot: drug_regulatory_status_world_wide Description: An agglomeration of drug regulatory status worldwide. Not specific to FDA.
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "nucleic acid entity" Description: "A nucleic acid entity is a molecular entity characterized by availability in gene databases of nucleotide-based sequence representations of its precise sequence; for convenience of representation, partial sequences of various kinds are included."
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: is_metabolite Description: indicates whether a molecular entity is a metabolite
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "regulatory region" Description: "A region (or regions) of the genome that contains known or putative regulatory elements that act in cis- or trans- to affect the transcription of gene"
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "accessible dna region" Description: "A region (or regions) of a chromatinized genome that has been measured to be more accessible to an enzyme such as DNase-I or Tn5 Transpose"
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "transcription factor binding site" Description: "A region (or regions) of the genome that contains a region of DNA known or predicted to bind a protein that modulates gene transcription"
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "molecular mixture" Description: "A molecular mixture is a chemical mixture composed of two or more molecular entities with known concentration and stoichiometry."
--     * Slot: is_supplement Description: 
--     * Slot: highest_FDA_approval_status Description: Should be the highest level of FDA approval this chemical entity or device has, regardless of which disease, condition or phenotype it is currently being reviewed to treat.  For specific levels of FDA approval for a specific condition, disease, phenotype, etc., see the association slot, 'clinical approval status.'
--     * Slot: drug_regulatory_status_world_wide Description: An agglomeration of drug regulatory status worldwide. Not specific to FDA.
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "complex molecular mixture" Description: "A complex molecular mixture is a chemical mixture composed of two or more molecular entities with unknown concentration and stoichiometry."
--     * Slot: is_supplement Description: 
--     * Slot: highest_FDA_approval_status Description: Should be the highest level of FDA approval this chemical entity or device has, regardless of which disease, condition or phenotype it is currently being reviewed to treat.  For specific levels of FDA approval for a specific condition, disease, phenotype, etc., see the association slot, 'clinical approval status.'
--     * Slot: drug_regulatory_status_world_wide Description: An agglomeration of drug regulatory status worldwide. Not specific to FDA.
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "biological process or activity" Description: "Either an individual molecular activity, or a collection of causally connected molecular activities in a biological system."
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "molecular activity" Description: "An execution of a molecular function carried out by a gene product or macromolecular complex."
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "biological process" Description: "One or more causally connected executions of molecular functions"
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "pathway" Description: ""
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "physiological process" Description: ""
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "behavior" Description: ""
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "processed material" Description: "A chemical entity (often a mixture) processed for consumption for nutritional, medical or technical use. Is a material entity that is created or changed during material processing."
--     * Slot: is_supplement Description: 
--     * Slot: highest_FDA_approval_status Description: Should be the highest level of FDA approval this chemical entity or device has, regardless of which disease, condition or phenotype it is currently being reviewed to treat.  For specific levels of FDA approval for a specific condition, disease, phenotype, etc., see the association slot, 'clinical approval status.'
--     * Slot: drug_regulatory_status_world_wide Description: An agglomeration of drug regulatory status worldwide. Not specific to FDA.
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "drug" Description: "A substance intended for use in the diagnosis, cure, mitigation, treatment, or prevention of disease"
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: is_supplement Description: 
--     * Slot: highest_FDA_approval_status Description: Should be the highest level of FDA approval this chemical entity or device has, regardless of which disease, condition or phenotype it is currently being reviewed to treat.  For specific levels of FDA approval for a specific condition, disease, phenotype, etc., see the association slot, 'clinical approval status.'
--     * Slot: drug_regulatory_status_world_wide Description: An agglomeration of drug regulatory status worldwide. Not specific to FDA.
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "environmental food contaminant" Description: ""
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "food additive" Description: ""
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "food" Description: "A substance consumed by a living organism as a source of nutrition"
--     * Slot: is_supplement Description: 
--     * Slot: highest_FDA_approval_status Description: Should be the highest level of FDA approval this chemical entity or device has, regardless of which disease, condition or phenotype it is currently being reviewed to treat.  For specific levels of FDA approval for a specific condition, disease, phenotype, etc., see the association slot, 'clinical approval status.'
--     * Slot: drug_regulatory_status_world_wide Description: An agglomeration of drug regulatory status worldwide. Not specific to FDA.
--     * Slot: trade_name Description: 
--     * Slot: max_tolerated_dose Description: The highest dose of a drug or treatment that does not cause unacceptable side effects. The maximum tolerated dose is determined in clinical trials by testing increasing doses on different groups of people until the highest dose with acceptable side effects is found. Also called MTD.
--     * Slot: is_toxic Description: 
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "organism attribute" Description: "describes a characteristic of an organismal entity."
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "phenotypic quality" Description: "A property of a phenotype"
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "genetic inheritance" Description: "The pattern or 'mode' in which a particular genetic trait or disorder is passed from one generation to the next, e.g. autosomal dominant, autosomal recessive, etc."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "organismal entity" Description: "A named entity that is either a part of an organism, a whole organism, population or clade of organisms, excluding chemical entities"
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "bacterium" Description: "A member of a group of unicellular microorganisms lacking a nuclear membrane, that reproduce by binary fission and are often motile."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "virus" Description: "A virus is a microorganism that replicates itself as a microRNA and infects the host cell."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "cellular organism" Description: ""
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "mammal" Description: "A member of the class Mammalia, a clade of endothermic amniotes distinguished from reptiles and birds by the possession of hair, three middle ear bones, mammary glands, and a neocortex"
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "human" Description: "A member of the the species Homo sapiens."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "plant" Description: ""
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "invertebrate" Description: "An animal lacking a vertebral column. This group consists of 98% of all animal species."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "vertebrate" Description: "A sub-phylum of animals consisting of those having a bony or cartilaginous vertebral column."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "fungus" Description: "A kingdom of eukaryotic, heterotrophic organisms that live as saprobes or parasites, including mushrooms, yeasts, smuts, molds, etc. They reproduce either sexually or asexually, and have life cycles that range from simple to complex. Filamentous fungi refer to those that grow as multicellular colonies (mushrooms and molds)."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "life stage" Description: "A stage of development or growth of an organism, including post-natal adult stages"
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "individual organism" Description: "An instance of an organism. For example, Richard Nixon, Charles Darwin, my pet cat. Example ID: ORCID:0000-0002-5355-2576"
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "population of individual organisms" Description: "A collection of individuals from the same taxonomic class distinguished by one or more characteristics.  Characteristics can include, but are not limited to, shared geographic location, genetics, phenotypes."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "disease or phenotypic feature" Description: "Either one of a disease or an individual phenotypic feature. Some knowledge resources such as Monarch treat these as distinct, others such as MESH conflate.  Please see definitions of phenotypic feature and disease in this model for their independent descriptions.  This class is helpful to enforce domains and ranges that may involve either a disease or a phenotypic feature."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "disease" Description: "A disorder of structure or function, especially one that produces specific signs, phenotypes or symptoms or that affects a specific location and is not simply a direct result of physical injury.  A disposition to undergo pathological processes that exists in an organism because of one or more disorders in that organism."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "phenotypic feature" Description: "A combination of entity and quality that makes up a phenotyping statement. An observable characteristic of an individual resulting from the interaction of its genotype with its molecular and physical environment."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "behavioral feature" Description: "A phenotypic feature which is behavioral in nature."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "anatomical entity" Description: "A subcellular location, cell type or gross anatomical part"
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "cellular component" Description: "A location in or around a cell"
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "cell" Description: ""
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "cell line" Description: ""
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "gross anatomical structure" Description: ""
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical entity or gene or gene product" Description: "A union of chemical entities and children, and gene or gene product. This mixin is helpful to use when searching across chemical entities that must include genes and their children as chemical entities."
--     * Slot: id Description: 
-- # Class: "chemical entity or protein or polypeptide" Description: "A union of chemical entities and children, and protein and polypeptide. This mixin is helpful to use when searching across chemical entities that must include genes and their children as chemical entities."
--     * Slot: id Description: 
-- # Class: "macromolecular machine mixin" Description: "A union of gene locus, gene product, and macromolecular complex. These are the basic units of function in a cell. They either carry out individual biological activities, or they encode molecules which do this."
--     * Slot: id Description: 
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
-- # Class: "gene or gene product" Description: "A union of gene loci or gene products. Frequently an identifier for one will be used as proxy for another"
--     * Slot: id Description: 
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
-- # Class: "gene" Description: "A region (or regions) that includes all of the sequence elements necessary to encode a functional transcript. A gene locus may include regulatory regions, transcribed regions and/or other functional sequence regions."
--     * Slot: symbol Description: Symbol for a particular thing
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "gene product mixin" Description: "The functional molecular product of a single gene locus. Gene products are either proteins or functional RNA molecules."
--     * Slot: id Description: 
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
-- # Class: "gene product isoform mixin" Description: "This is an abstract class that can be mixed in with different kinds of gene products to indicate that the gene product is intended to represent a specific isoform rather than a canonical or reference or generic product. The designation of canonical or reference may be arbitrary, or it may represent the superclass of all isoforms."
--     * Slot: id Description: 
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
-- # Class: "macromolecular complex" Description: "A stable assembly of two or more macromolecules, i.e. proteins, nucleic acids, carbohydrates or lipids, in which at least one component is a protein and the constituent parts function together."
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "nucleosome modification" Description: "A chemical modification of a histone protein within a nucleosome octomer or a substitution of a histone with a variant histone isoform. e.g. Histone 4 Lysine 20 methylation (H4K20me), histone variant H2AZ substituting H2A."
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "genome" Description: "A genome is the sum of genetic material within a cell or virion."
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "exon" Description: "A region of the transcript sequence within a gene which is not removed from the primary RNA transcript by RNA splicing."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "transcript" Description: "An RNA synthesized on a DNA or RNA template by an RNA polymerase."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "coding sequence" Description: ""
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "polypeptide" Description: "A polypeptide is a molecular entity characterized by availability in protein databases of amino-acid-based sequence representations of its precise primary structure; for convenience of representation, partial sequences of various kinds are included, even if they do not represent a physical molecule."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "protein" Description: "A gene product that is composed of a chain of amino acid sequences and is produced by ribosome-mediated translation of mRNA"
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "protein isoform" Description: "Represents a protein that is a specific isoform of the canonical or reference protein. See https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4114032/"
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "protein domain" Description: "A conserved part of protein sequence and (tertiary) structure that can evolve, function, and exist independently of the rest of the protein chain. Protein domains maintain their structure and function independently of the proteins in which they are found. e.g. an SH3 domain."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "posttranslational modification" Description: "A chemical modification of a polypeptide or protein that occurs after translation. e.g. polypeptide cleavage to form separate proteins, methylation or acetylation of histone tail amino acids, protein ubiquitination."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "protein family" Description: ""
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "nucleic acid sequence motif" Description: "A linear nucleotide sequence pattern that is widespread and has, or is conjectured to have, a biological significance. e.g. the TATA box promoter motif, transcription factor binding consensus sequences."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "RNA product" Description: ""
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "RNA product isoform" Description: "Represents a protein that is a specific isoform of the canonical or reference RNA"
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "noncoding RNA product" Description: ""
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "microRNA" Description: ""
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "siRNA" Description: "A small RNA molecule that is the product of a longer exogenous or endogenous dsRNA, which is either a bimolecular duplex or very long hairpin, processed (via the Dicer pathway) such that numerous siRNAs accumulate from both strands of the dsRNA. SRNAs trigger the cleavage of their target molecules."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "gene grouping mixin" Description: "any grouping of multiple genes or gene products"
--     * Slot: id Description: 
-- # Class: "gene family" Description: "any grouping of multiple genes or gene products related by common descent"
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "zygosity" Description: ""
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "genotype" Description: "An information content entity that describes a genome by specifying the total variation in genomic sequence and/or gene expression, relative to some established background"
--     * Slot: has_zygosity Description: 
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "haplotype" Description: "A set of zero or more Alleles on a single instance of a Sequence[VMC]"
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "sequence variant" Description: "A sequence_variant is a non exact copy of a sequence_feature or genome exhibiting one or more sequence_alteration."
--     * Slot: has_biological_sequence Description: The state of the sequence w.r.t a reference sequence
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "snv" Description: "SNVs are single nucleotide positions in genomic DNA at which different sequence alternatives exist"
--     * Slot: has_biological_sequence Description: The state of the sequence w.r.t a reference sequence
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "reagent targeted gene" Description: "A gene altered in its expression level in the context of some experiment as a result of being targeted by gene-knockdown reagent(s) such as a morpholino or RNAi."
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "clinical attribute" Description: "Attributes relating to a clinical manifestation"
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "clinical measurement" Description: "A clinical measurement is a special kind of attribute which results from a laboratory observation from a subject individual or sample. Measurements can be connected to their subject by the 'has attribute' slot."
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "clinical modifier" Description: "Used to characterize and specify the phenotypic abnormalities defined in the phenotypic abnormality sub-ontology, with respect to severity, laterality, and other aspects"
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "clinical course" Description: "The course a disease typically takes from its onset, progression in time, and eventual resolution or death of the affected individual"
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "onset" Description: "The age group in which (disease) symptom manifestations appear"
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "clinical entity" Description: "Any entity or process that exists in the clinical domain and outside the biological realm. Diseases are placed under biological entities"
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "clinical trial" Description: ""
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "clinical intervention" Description: ""
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "clinical finding" Description: "this category is currently considered broad enough to tag clinical lab measurements and other biological attributes taken as 'clinical traits' with some statistical score, for example, a p value in genetic associations."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "hospitalization" Description: ""
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "socioeconomic attribute" Description: "Attributes relating to a socioeconomic manifestation"
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "case" Description: "An individual (human) organism that has a patient role in some clinical context."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "cohort" Description: "A group of people banded together or treated as a group who share common characteristics. A cohort 'study' is a particular form of longitudinal study that samples a cohort, performing a cross-section at intervals through time."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "exposure event" Description: "A (possibly time bounded) incidence of a feature of the environment of an organism that influences one or more phenotypic features of that organism, potentially mediated by genes"
--     * Slot: timepoint Description: a point in time
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
-- # Class: "genomic background exposure" Description: "A genomic background exposure is where an individual's specific genomic background of genes, sequence variants or other pre-existing genomic conditions constitute a kind of 'exposure' to the organism, leading to or influencing an outcome."
--     * Slot: timepoint Description: a point in time
--     * Slot: has_biological_sequence Description: connects a genomic feature to its sequence
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "pathological entity mixin" Description: "A pathological (abnormal) structure or process."
--     * Slot: id Description: 
-- # Class: "pathological process" Description: "A biologic function or a process having an abnormal or deleterious effect at the subcellular, cellular, multicellular, or organismal level."
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "pathological process exposure" Description: "A pathological process, when viewed as an exposure, representing a precondition, leading to or influencing an outcome, e.g. autoimmunity leading to disease."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "pathological anatomical structure" Description: "An anatomical structure with the potential of have an abnormal or deleterious effect at the subcellular, cellular, multicellular, or organismal level."
--     * Slot: in_taxon_label Description: The human readable scientific name for the taxon of the entity.
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "pathological anatomical exposure" Description: "An abnormal anatomical structure, when viewed as an exposure, representing an precondition, leading to or influencing an outcome, e.g. thrombosis leading to an ischemic disease outcome."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "disease or phenotypic feature exposure" Description: "A disease or phenotypic feature state, when viewed as an exposure, represents an precondition, leading to or influencing an outcome, e.g. HIV predisposing an individual to infections; a relative deficiency of skin pigmentation predisposing an individual to skin cancer."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical exposure" Description: "A chemical exposure is an intake of a particular chemical entity."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "complex chemical exposure" Description: "A complex chemical exposure is an intake of a chemical mixture (e.g. gasoline), other than a drug."
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "drug exposure" Description: "A drug exposure is an intake of a particular drug."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "drug to gene interaction exposure" Description: "drug to gene interaction exposure is a drug exposure is where the interactions of the drug with specific genes are known to constitute an 'exposure' to the organism, leading to or influencing an outcome."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "treatment" Description: "A treatment is targeted at a disease or phenotype and may involve multiple drug 'exposures', medical devices and/or procedures"
--     * Slot: timepoint Description: a point in time
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "biotic exposure" Description: "An external biotic exposure is an intake of (sometimes pathological) biological organisms (including viruses)."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "geographic exposure" Description: "A geographic exposure is a factor relating to geographic proximity to some impactful entity."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "environmental exposure" Description: "A environmental exposure is a factor relating to abiotic processes in the environment including sunlight (UV-B), atmospheric (heat, cold, general pollution) and water-born contaminants."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "behavioral exposure" Description: "A behavioral exposure is a factor relating to behavior impacting an individual."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "socioeconomic exposure" Description: "A socioeconomic exposure is a factor relating to social and financial status of an affected individual (e.g. poverty)."
--     * Slot: timepoint Description: a point in time
--     * Slot: name Description: The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.
--     * Slot: has_attribute_type Description: connects an attribute to a class that describes it
--     * Slot: has_qualitative_value Description: connects an attribute to a value
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: full_name Description: a long-form human readable name for a thing
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "outcome" Description: "An entity that has the role of being the consequence of an exposure event. This is an abstract mixin grouping of various categories of possible biological or non-biological (e.g. clinical) outcomes."
--     * Slot: id Description: 
-- # Class: "pathological process outcome" Description: "An outcome resulting from an exposure event which is the manifestation of a pathological process."
--     * Slot: id Description: 
-- # Class: "pathological anatomical outcome" Description: "An outcome resulting from an exposure event which is the manifestation of an abnormal anatomical structure."
--     * Slot: id Description: 
-- # Class: "disease or phenotypic feature outcome" Description: "Physiological outcomes resulting from an exposure event which is the manifestation of a disease or other characteristic phenotype."
--     * Slot: id Description: 
-- # Class: "behavioral outcome" Description: "An outcome resulting from an exposure event which is the manifestation of human behavior."
--     * Slot: id Description: 
-- # Class: "hospitalization outcome" Description: "An outcome resulting from an exposure event which is the increased manifestation of acute (e.g. emergency room visit) or chronic (inpatient) hospitalization."
--     * Slot: id Description: 
-- # Class: "mortality outcome" Description: "An outcome of death from resulting from an exposure event."
--     * Slot: id Description: 
-- # Class: "epidemiological outcome" Description: "An epidemiological outcome, such as societal disease burden, resulting from an exposure event."
--     * Slot: id Description: 
-- # Class: "socioeconomic outcome" Description: "An general social or economic outcome, such as healthcare costs, utilization, etc., resulting from an exposure event"
--     * Slot: id Description: 
-- # Class: "association" Description: "A typed association between two entities, supported by evidence"
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical entity assesses named thing association" Description: ""
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "contributor association" Description: "Any association between an entity (such as a publication) and various agents that contribute to its realisation"
--     * Slot: subject Description: information content entity which an agent has helped realise
--     * Slot: predicate Description: generally one of the predicate values 'provider', 'publisher', 'editor' or 'author'
--     * Slot: object Description: agent helping to realise the given entity (e.g. such as a publication)
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "genotype to genotype part association" Description: "Any association between one genotype and a genotypic entity that is a sub-component of it"
--     * Slot: subject Description: parent genotype
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: child genotype
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "genotype to gene association" Description: "Any association between a genotype and a gene. The genotype have have multiple variants in that gene or a single one. There is no assumption of cardinality"
--     * Slot: subject Description: parent genotype
--     * Slot: predicate Description: the relationship type used to connect genotype to gene
--     * Slot: object Description: gene implicated in genotype
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "genotype to variant association" Description: "Any association between a genotype and a sequence variant."
--     * Slot: subject Description: parent genotype
--     * Slot: predicate Description: the relationship type used to connect genotype to gene
--     * Slot: object Description: gene implicated in genotype
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "gene to gene association" Description: "abstract parent class for different kinds of gene-gene or gene product to gene product relationships. Includes homology and interaction."
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: the subject gene in the association. If the relation is symmetric, subject vs object is arbitrary. We allow a gene product to stand as a proxy for the gene or vice versa.
--     * Slot: object_id Description: the object gene in the association. If the relation is symmetric, subject vs object is arbitrary. We allow a gene product to stand as a proxy for the gene or vice versa.
-- # Class: "gene to gene homology association" Description: "A homology association between two genes. May be orthology (in which case the species of subject and object should differ) or paralogy (in which case the species may be the same)"
--     * Slot: predicate Description: homology relationship type
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: the subject gene in the association. If the relation is symmetric, subject vs object is arbitrary. We allow a gene product to stand as a proxy for the gene or vice versa.
--     * Slot: object_id Description: the object gene in the association. If the relation is symmetric, subject vs object is arbitrary. We allow a gene product to stand as a proxy for the gene or vice versa.
-- # Class: "gene to gene family association" Description: "Set membership of a gene in a family of genes related by common evolutionary ancestry usually inferred by sequence comparisons. The genes in a given family generally share common sequence motifs which generally map onto shared gene product structure-function relationships."
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: membership of the gene in the given gene family.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "gene expression mixin" Description: "Observed gene expression intensity, context (site, stage) and associated phenotypic status within which the expression occurs."
--     * Slot: id Description: 
--     * Slot: quantifier_qualifier Description: Optional quantitative value indicating degree of expression.
--     * Slot: expression_site Description: location in which gene or protein expression takes place. May be cell, tissue, or organ.
--     * Slot: stage_qualifier Description: stage during which gene or protein expression of takes place.
--     * Slot: phenotypic_state Description: in experiments (e.g. gene expression) assaying diseased or unhealthy tissue, the phenotypic state can be put here, e.g. MONDO ID. For healthy tissues, use XXX.
-- # Class: "gene to gene coexpression association" Description: "Indicates that two genes are co-expressed, generally under the same conditions."
--     * Slot: quantifier_qualifier Description: Optional quantitative value indicating degree of expression.
--     * Slot: expression_site Description: location in which gene or protein expression takes place. May be cell, tissue, or organ.
--     * Slot: stage_qualifier Description: stage during which gene or protein expression of takes place.
--     * Slot: phenotypic_state Description: in experiments (e.g. gene expression) assaying diseased or unhealthy tissue, the phenotypic state can be put here, e.g. MONDO ID. For healthy tissues, use XXX.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: the subject gene in the association. If the relation is symmetric, subject vs object is arbitrary. We allow a gene product to stand as a proxy for the gene or vice versa.
--     * Slot: object_id Description: the object gene in the association. If the relation is symmetric, subject vs object is arbitrary. We allow a gene product to stand as a proxy for the gene or vice versa.
-- # Class: "pairwise gene to gene interaction" Description: "An interaction between two genes or two gene products. May be physical (e.g. protein binding) or genetic (between genes). May be symmetric (e.g. protein interaction) or directed (e.g. phosphorylation)"
--     * Slot: predicate Description: interaction relationship type
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: the subject gene in the association. If the relation is symmetric, subject vs object is arbitrary. We allow a gene product to stand as a proxy for the gene or vice versa.
--     * Slot: object_id Description: the object gene in the association. If the relation is symmetric, subject vs object is arbitrary. We allow a gene product to stand as a proxy for the gene or vice versa.
-- # Class: "pairwise molecular interaction" Description: "An interaction at the molecular level between two physical entities"
--     * Slot: interacting_molecules_category Description: 
--     * Slot: subject Description: the subject gene in the association. If the relation is symmetric, subject vs object is arbitrary. We allow a gene product to stand as a proxy for the gene or vice versa.
--     * Slot: predicate Description: interaction relationship type
--     * Slot: object Description: the object gene in the association. If the relation is symmetric, subject vs object is arbitrary. We allow a gene product to stand as a proxy for the gene or vice versa.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: identifier for the interaction. This may come from an interaction database such as IMEX.
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "cell line to entity association mixin" Description: "An relationship between a cell line and another entity"
--     * Slot: id Description: 
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "cell line to disease or phenotypic feature association" Description: "An relationship between a cell line and a disease or a phenotype, where the cell line is derived from an individual with that disease or phenotype."
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease or phenotype
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical entity to entity association mixin" Description: "An interaction between a chemical entity and another entity"
--     * Slot: id Description: 
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: subject_id Description: the chemical entity that is an interactor
-- # Class: "drug to entity association mixin" Description: "An interaction between a drug and another entity"
--     * Slot: id Description: 
--     * Slot: subject Description: the drug that is an interactor
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "chemical to entity association mixin" Description: "An interaction between a chemical entity and another entity"
--     * Slot: id Description: 
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: subject_id Description: the chemical entity or entity that is an interactor
-- # Class: "case to entity association mixin" Description: "An abstract association for use where the case is the subject"
--     * Slot: id Description: 
--     * Slot: subject Description: the case (e.g. patient) that has the property
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "chemical to chemical association" Description: "A relationship between two chemical entities. This can encompass actual interactions as well as temporal causal edges, e.g. one chemical converted to another."
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the chemical element that is the target of the statement
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: the chemical entity or entity that is an interactor
-- # Class: "reaction to participant association" Description: ""
--     * Slot: stoichiometry Description: the relationship between the relative quantities of substances taking part in a reaction or forming a compound, typically a ratio of whole integers.
--     * Slot: reaction_direction Description: the direction of a reaction as constrained by the direction enum (ie: left_to_right, neutral, etc.)
--     * Slot: reaction_side Description: the side of a reaction being modeled (ie: left or right)
--     * Slot: subject Description: the chemical entity or entity that is an interactor
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the chemical element that is the target of the statement
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "reaction to catalyst association" Description: ""
--     * Slot: stoichiometry Description: the relationship between the relative quantities of substances taking part in a reaction or forming a compound, typically a ratio of whole integers.
--     * Slot: reaction_direction Description: the direction of a reaction as constrained by the direction enum (ie: left_to_right, neutral, etc.)
--     * Slot: reaction_side Description: the side of a reaction being modeled (ie: left or right)
--     * Slot: subject Description: the chemical entity or entity that is an interactor
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: object_id Description: the chemical element that is the target of the statement
-- # Class: "chemical to chemical derivation association" Description: "A causal relationship between two chemical entities, where the subject represents the upstream entity and the object represents the downstream. For any such association there is an implicit reaction: IF R has-input C1 AND R has-output C2 AND R enabled-by P AND R type Reaction THEN C1 derives-into C2 catalyst qualifier P"
--     * Slot: subject Description: the upstream chemical entity
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the downstream chemical entity
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical to disease or phenotypic feature association" Description: "An interaction between a chemical entity and a phenotype or disease, where the presence of the chemical gives rise to or exacerbates the phenotype."
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the disease or phenotype that is affected by the chemical
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: the chemical entity or entity that is an interactor
-- # Class: "chemical or drug or treatment to disease or phenotypic feature association" Description: "This association defines a relationship between a chemical or treatment (or procedure) and a disease or phenotypic feature where the disesae or phenotypic feature is a secondary undesirable effect."
--     * Slot: FDA_adverse_event_level Description: 
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease or phenotype
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: the chemical entity or entity that is an interactor
-- # Class: "chemical or drug or treatment side effect disease or phenotypic feature association" Description: "This association defines a relationship between a chemical or treatment (or procedure) and a disease or phenotypic feature where the disesae or phenotypic feature is a secondary, typically (but not always) undesirable effect."
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease or phenotype
--     * Slot: FDA_adverse_event_level Description: 
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: the chemical entity or entity that is an interactor
-- # Class: "gene to pathway association" Description: "An interaction between a gene or gene product and a biological process or pathway."
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the pathway that includes or is affected by the gene or gene product
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: the gene or gene product entity that participates or influences the pathway
-- # Class: "molecular activity to pathway association" Description: "Association that holds the relationship between a reaction and the pathway it participates in."
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical to pathway association" Description: "An interaction between a chemical entity and a biological process or pathway."
--     * Slot: subject Description: the chemical entity that is affecting the pathway
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the pathway that is affected by the chemical
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "named thing associated with likelihood of named thing association" Description: ""
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_context_qualifier Description: 
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_context_qualifier Description: 
--     * Slot: population_context_qualifier Description: a biological population (general, study, cohort, etc.) with a specific set of characteristics to constrain an association.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical gene interaction association" Description: "describes a physical interaction between a chemical entity and a gene or gene product. Any biological or chemical effect resulting from such an interaction are out of scope, and covered by the ChemicalAffectsGeneAssociation type (e.g. impact of a chemical on the abundance, activity, structure, etc, of either participant in the interaction)"
--     * Slot: subject_form_or_variant_qualifier Description: A qualifier that composes with a core subject/object concept to define a specific type, variant, alternative version of this concept. The composed concept remains a subtype or instance of the core concept. For example, the qualifier ‘mutation’ combines with the core concept ‘Gene X’ to express the compose concept ‘a mutation of Gene X’.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_part_qualifier Description: defines a specific part/component of the core concept (used in cases there this specific part has no IRI we can use to directly represent it, e.g. 'ESR1 transcript' q: polyA tail).  This qualifier is for the  subject of an association (or statement).
--     * Slot: subject_derivative_qualifier Description: A qualifier that composes with a core subject/object  concept to describe something that is derived from the core concept.  For example, the qualifier ‘metabolite’ combines with a ‘Chemical X’ core concept to express the composed concept ‘a metabolite of Chemical X’.  This qualifier is for the subject of an association  (or statement).
--     * Slot: subject_context_qualifier Description: 
--     * Slot: object_form_or_variant_qualifier Description: A qualifier that composes with a core subject/object concept to define a specific type, variant, alternative version of this concept. The composed concept remains a subtype or instance of the core concept. For example, the qualifier ‘mutation’ combines with the core concept ‘Gene X’ to express the compose concept ‘a mutation of Gene X’.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_part_qualifier Description: defines a specific part/component of the core concept (used in cases there this specific part has no IRI we can use to directly represent it, e.g. 'ESR1 transcript' q: polyA tail).  This qualifier is for the  object of an association (or statement).
--     * Slot: object_context_qualifier Description: 
--     * Slot: anatomical_context_qualifier Description: A statement qualifier representing an anatomical location where an relationship expressed in an association took place (can be a tissue, cell type, or sub-cellular location).
--     * Slot: subject Description: the chemical entity or entity that is an interactor
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: object_id Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "chemical affects gene association" Description: "Describes an effect that a chemical has on a gene or gene product (e.g. an impact of on its abundance, activity,localization, processing, expression, etc.)"
--     * Slot: subject_form_or_variant_qualifier Description: A qualifier that composes with a core subject/object concept to define a specific type, variant, alternative version of this concept. The composed concept remains a subtype or instance of the core concept. For example, the qualifier ‘mutation’ combines with the core concept ‘Gene X’ to express the compose concept ‘a mutation of Gene X’.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_part_qualifier Description: defines a specific part/component of the core concept (used in cases there this specific part has no IRI we can use to directly represent it, e.g. 'ESR1 transcript' q: polyA tail).  This qualifier is for the  subject of an association (or statement).
--     * Slot: subject_derivative_qualifier Description: A qualifier that composes with a core subject/object  concept to describe something that is derived from the core concept.  For example, the qualifier ‘metabolite’ combines with a ‘Chemical X’ core concept to express the composed concept ‘a metabolite of Chemical X’.  This qualifier is for the subject of an association  (or statement).
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_context_qualifier Description: 
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_form_or_variant_qualifier Description: A qualifier that composes with a core subject/object concept to define a specific type, variant, alternative version of this concept. The composed concept remains a subtype or instance of the core concept. For example, the qualifier ‘mutation’ combines with the core concept ‘Gene X’ to express the compose concept ‘a mutation of Gene X’.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_part_qualifier Description: defines a specific part/component of the core concept (used in cases there this specific part has no IRI we can use to directly represent it, e.g. 'ESR1 transcript' q: polyA tail).  This qualifier is for the  object of an association (or statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_context_qualifier Description: 
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: causal_mechanism_qualifier Description: A statement qualifier representing a type of molecular control mechanism through which an effect of a chemical on a gene or gene product is mediated (e.g. 'agonism', 'inhibition', 'allosteric modulation', 'channel blocker')
--     * Slot: anatomical_context_qualifier Description: A statement qualifier representing an anatomical location where an relationship expressed in an association took place (can be a tissue, cell type, or sub-cellular location).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: species_context_qualifier Description: A statement qualifier representing a taxonomic category of species in which a relationship expressed in an association took place.
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: object_id Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "gene affects chemical association" Description: "Describes an effect that a gene or gene product has on a chemical entity (e.g. an impact of on its abundance, activity, localization, processing, transport, etc.)"
--     * Slot: subject_form_or_variant_qualifier Description: A qualifier that composes with a core subject/object concept to define a specific type, variant, alternative version of this concept. The composed concept remains a subtype or instance of the core concept. For example, the qualifier ‘mutation’ combines with the core concept ‘Gene X’ to express the compose concept ‘a mutation of Gene X’.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_part_qualifier Description: defines a specific part/component of the core concept (used in cases there this specific part has no IRI we can use to directly represent it, e.g. 'ESR1 transcript' q: polyA tail).  This qualifier is for the  subject of an association (or statement).
--     * Slot: subject_derivative_qualifier Description: A qualifier that composes with a core subject/object  concept to describe something that is derived from the core concept.  For example, the qualifier ‘metabolite’ combines with a ‘Chemical X’ core concept to express the composed concept ‘a metabolite of Chemical X’.  This qualifier is for the subject of an association  (or statement).
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_context_qualifier Description: 
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_form_or_variant_qualifier Description: A qualifier that composes with a core subject/object concept to define a specific type, variant, alternative version of this concept. The composed concept remains a subtype or instance of the core concept. For example, the qualifier ‘mutation’ combines with the core concept ‘Gene X’ to express the compose concept ‘a mutation of Gene X’.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_part_qualifier Description: defines a specific part/component of the core concept (used in cases there this specific part has no IRI we can use to directly represent it, e.g. 'ESR1 transcript' q: polyA tail).  This qualifier is for the  object of an association (or statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_context_qualifier Description: 
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: object_derivative_qualifier Description: A qualifier that composes with a core subject/object  concept to describe something that is derived from the core concept.  For example, the qualifier ‘metabolite’ combines with a ‘Chemical X’ core concept to express the composed concept ‘a metabolite of Chemical X’.  This qualifier is for the object of an association  (or statement).
--     * Slot: causal_mechanism_qualifier Description: A statement qualifier representing a type of molecular control mechanism through which an effect of a chemical on a gene or gene product is mediated (e.g. 'agonism', 'inhibition', 'allosteric modulation', 'channel blocker')
--     * Slot: anatomical_context_qualifier Description: A statement qualifier representing an anatomical location where an relationship expressed in an association took place (can be a tissue, cell type, or sub-cellular location).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: species_context_qualifier Description: A statement qualifier representing a taxonomic category of species in which a relationship expressed in an association took place.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "drug to gene association" Description: "An interaction between a drug and a gene or gene product."
--     * Slot: subject Description: the drug that is an interactor
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: object_id Description: the gene or gene product that is affected by the drug
-- # Class: "material sample to entity association mixin" Description: "An association between a material sample and something."
--     * Slot: id Description: 
--     * Slot: subject Description: the material sample being described
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "material sample derivation association" Description: "An association between a material sample and the material entity from which it is derived."
--     * Slot: subject Description: the material sample being described
--     * Slot: predicate Description: derivation relationship
--     * Slot: object Description: the material entity the sample was derived from. This may be another material sample, or any other material entity, including for example an organism, a geographic feature, or some environmental material.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "material sample to disease or phenotypic feature association" Description: "An association between a material sample and a disease or phenotype."
--     * Slot: subject Description: the material sample being described
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease or phenotype
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "disease to entity association mixin" Description: ""
--     * Slot: id Description: 
--     * Slot: subject Description: disease class
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "entity to exposure event association mixin" Description: "An association between some entity and an exposure event."
--     * Slot: id Description: 
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "disease to exposure event association" Description: "An association between an exposure event and a disease."
--     * Slot: subject Description: disease class
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "entity to outcome association mixin" Description: "An association between some entity and an outcome"
--     * Slot: id Description: 
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object_id Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "exposure event to outcome association" Description: "An association between an exposure event and an outcome."
--     * Slot: population_context_qualifier Description: a biological population (general, study, cohort, etc.) with a specific set of characteristics to constrain an association.
--     * Slot: temporal_context_qualifier Description: a constraint of time placed upon the truth value of an association. for time intervales, use temporal interval qualifier.
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: object_id Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "frequency qualifier mixin" Description: "Qualifier for frequency type associations"
--     * Slot: id Description: 
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "entity to feature or disease qualifiers mixin" Description: "Qualifiers for entity to disease or phenotype associations."
--     * Slot: id Description: 
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "feature or disease qualifiers to entity mixin" Description: "Qualifiers for disease or phenotype to entity associations."
--     * Slot: id Description: 
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "entity to phenotypic feature association mixin" Description: ""
--     * Slot: id Description: 
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "phenotypic feature to entity association mixin" Description: ""
--     * Slot: id Description: 
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "information content entity to named thing association" Description: "association between a named thing and a information content entity where the specific context of the relationship between that named thing and the publication is unknown. For example, model organisms databases often capture the knowledge that a gene is found in a journal article, but not specifically the context in which that gene was documented in the article. In these cases, this association with the accompanying predicate 'mentions' could be used. Conversely, for more specific associations (like 'gene to disease association', the publication should be captured as an edge property)."
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "entity to disease association mixin" Description: "mixin class for any association whose object (target node) is a disease"
--     * Slot: id Description: 
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease
-- # Class: "disease or phenotypic feature to entity association mixin" Description: ""
--     * Slot: id Description: 
--     * Slot: subject Description: disease or phenotype
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "disease or phenotypic feature to location association" Description: "An association between either a disease or a phenotypic feature and an anatomical entity, where the disease/feature manifests in that site."
--     * Slot: subject Description: disease or phenotype
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: anatomical entity in which the disease or feature is found.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "disease or phenotypic feature to genetic inheritance association" Description: "An association between either a disease or a phenotypic feature and its mode of (genetic) inheritance."
--     * Slot: subject Description: disease or phenotype
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: genetic inheritance associated with the specified disease or phenotypic feature.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "entity to disease or phenotypic feature association mixin" Description: ""
--     * Slot: id Description: 
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease or phenotype
-- # Class: "genotype to entity association mixin" Description: ""
--     * Slot: id Description: 
--     * Slot: subject Description: genotype that is the subject of the association
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "genotype to phenotypic feature association" Description: "Any association between one genotype and a phenotypic feature, where having the genotype confers the phenotype, either in isolation or through environment"
--     * Slot: subject Description: genotype that is associated with the phenotypic feature
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "exposure event to phenotypic feature association" Description: "Any association between an environment and a phenotypic feature, where being in the environment influences the phenotype."
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "disease to phenotypic feature association" Description: "An association between a disease and a phenotypic feature in which the phenotypic feature is associated with the disease in some way."
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject Description: disease class
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "case to phenotypic feature association" Description: "An association between a case (e.g. individual patient) and a phenotypic feature in which the individual has or has had the phenotype."
--     * Slot: subject Description: the case (e.g. patient) that has the property
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "behavior to behavioral feature association" Description: "An association between an mixture behavior and a behavioral feature manifested by the individual exhibited or has exhibited the behavior."
--     * Slot: subject Description: behavior that is the subject of the association
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: behavioral feature that is the object of the association
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "gene to entity association mixin" Description: ""
--     * Slot: id Description: 
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: subject_id Description: gene that is the subject of the association
-- # Class: "variant to entity association mixin" Description: ""
--     * Slot: id Description: 
--     * Slot: subject Description: a sequence variant in which the allele state is associated with some other entity
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "gene to disease or phenotypic feature association" Description: ""
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject_id Description: gene in which variation is correlated with the phenotypic feature
-- # Class: "gene to phenotypic feature association" Description: ""
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject_id Description: gene in which variation is correlated with the phenotypic feature
-- # Class: "gene to disease association" Description: ""
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject_id Description: gene in which variation is correlated with the disease, may be protective or causative or associative, or as a model
-- # Class: "causal gene to disease association" Description: ""
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject_id Description: gene in which variation is shown to cause the disease.
-- # Class: "correlated gene to disease association" Description: ""
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject_id Description: gene in which variation is shown to correlate with the disease.
-- # Class: "druggable gene to disease association" Description: ""
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject_id Description: gene in which variation is correlated with the disease in a protective manner, or if the product produced by the gene can be targeted by a small molecule and this leads to a protective or improving disease state.
-- # Class: "phenotypic feature to disease association" Description: ""
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "variant to gene association" Description: "An association between a variant and a gene, where the variant has a genetic association with the gene (i.e. is in linkage disequilibrium)"
--     * Slot: subject Description: a sequence variant in which the allele state is associated with some other entity
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "variant to gene expression association" Description: "An association between a variant and expression of a gene (i.e. e-QTL)"
--     * Slot: quantifier_qualifier Description: Optional quantitative value indicating degree of expression.
--     * Slot: expression_site Description: location in which gene or protein expression takes place. May be cell, tissue, or organ.
--     * Slot: stage_qualifier Description: stage during which gene or protein expression of takes place.
--     * Slot: phenotypic_state Description: in experiments (e.g. gene expression) assaying diseased or unhealthy tissue, the phenotypic state can be put here, e.g. MONDO ID. For healthy tissues, use XXX.
--     * Slot: subject Description: a sequence variant in which the allele state is associated with some other entity
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "variant to population association" Description: "An association between a variant and a population, where the variant has particular frequency in the population"
--     * Slot: subject Description: an allele that has a certain frequency in a given population
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the population that is observed to have the frequency
--     * Slot: has_count Description: number in object population that carry a particular allele, aka allele count
--     * Slot: has_total Description: number all populations that carry a particular allele, aka allele number
--     * Slot: has_quotient Description: frequency of allele in population, expressed as a number with allele divided by number in reference population, aka allele frequency
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "population to population association" Description: "An association between a two populations"
--     * Slot: subject Description: the population that form the subject of the association
--     * Slot: predicate Description: A relationship type that holds between the subject and object populations. Standard mereological relations can be used. E.g. subject part-of object, subject overlaps object. Derivation relationships can also be used
--     * Slot: object Description: the population that form the object of the association
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "variant to phenotypic feature association" Description: ""
--     * Slot: subject Description: a sequence variant in which the allele state is associated in some way with the phenotype state
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "variant to disease association" Description: ""
--     * Slot: subject Description: a sequence variant in which the allele state is associated in some way with the disease state
--     * Slot: predicate Description: E.g. is pathogenic for
--     * Slot: object Description: a disease that is associated with that variant
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "genotype to disease association" Description: ""
--     * Slot: subject Description: a genotype that is associated in some way with a disease state
--     * Slot: predicate Description: E.g. is pathogenic for
--     * Slot: object Description: a disease that is associated with that genotype
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "model to disease association mixin" Description: "This mixin is used for any association class for which the subject (source node) plays the role of a 'model', in that it recapitulates some features of the disease in a way that is useful for studying the disease outside a patient carrying the disease"
--     * Slot: id Description: 
--     * Slot: subject Description: The entity that serves as the model of the disease. This may be an organism, a strain of organism, a genotype or variant that exhibits similar features, or a gene that when mutated exhibits features of the disease
--     * Slot: predicate Description: The relationship to the disease
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "gene as a model of disease association" Description: ""
--     * Slot: predicate Description: The relationship to the disease
--     * Slot: object Description: disease
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject_id Description: A gene that has a role in modeling the disease. This may be a model organism ortholog of a known disease gene, or it may be a gene whose mutants recapitulate core features of the disease.
-- # Class: "variant as a model of disease association" Description: ""
--     * Slot: subject Description: A variant that has a role in modeling the disease.
--     * Slot: predicate Description: The relationship to the disease
--     * Slot: object Description: disease
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "genotype as a model of disease association" Description: ""
--     * Slot: subject Description: A genotype that has a role in modeling the disease.
--     * Slot: predicate Description: The relationship to the disease
--     * Slot: object Description: disease
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "cell line as a model of disease association" Description: ""
--     * Slot: subject Description: A cell line derived from an organismal entity with a disease state that is used as a model of that disease.
--     * Slot: predicate Description: The relationship to the disease
--     * Slot: object Description: disease
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "organismal entity as a model of disease association" Description: ""
--     * Slot: subject Description: A organismal entity (strain, breed) with a predisposition to a disease, or bred/created specifically to model a disease.
--     * Slot: predicate Description: The relationship to the disease
--     * Slot: object Description: disease
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
-- # Class: "organism to organism association" Description: ""
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: An association between two individual organisms.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "taxon to taxon association" Description: ""
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: An association between individuals of different taxa.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "gene has variant that contributes to disease association" Description: ""
--     * Slot: subject_form_or_variant_qualifier Description: A qualifier that composes with a core subject/object concept to define a specific type, variant, alternative version of this concept. The composed concept remains a subtype or instance of the core concept. For example, the qualifier ‘mutation’ combines with the core concept ‘Gene X’ to express the compose concept ‘a mutation of Gene X’.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: disease
--     * Slot: subject_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the subject of an association (aka: statement).
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: sex_qualifier Description: a qualifier used in a phenotypic association to state whether the association is specific to a particular sex.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: has_count Description: number of things with a particular property
--     * Slot: has_total Description: total number of things in a particular reference set
--     * Slot: has_quotient Description: 
--     * Slot: has_percentage Description: equivalent to has quotient multiplied by 100
--     * Slot: subject_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the subject of an association (aka: statement).
--     * Slot: object_aspect_qualifier Description: Composes with the core concept to describe new concepts of a different ontological type. e.g. a process in which the core concept participates, a function/activity/role held by the core concept, or a characteristic/quality that inheres in the core concept.  The purpose of the aspect slot is to indicate what aspect is being affected in an 'affects' association.  This qualifier specifies a change in the object of an association (aka: statement).
--     * Slot: qualified_predicate Description: Predicate to be used in an association when subject and object qualifiers are present and the full reading of the statement requires a qualification to the predicate in use in order to refine or increase the specificity of the full statement reading.  This qualifier holds a relationship to be used instead of that expressed by the primary predicate, in a ‘full statement’ reading of the association, where qualifier-based semantics are included.  This is necessary only in cases where the primary predicate does not work in a full statement reading.
--     * Slot: frequency_qualifier Description: a qualifier used in a phenotypic association to state how frequent the phenotype is observed in the subject
--     * Slot: subject_id Description: A gene that has a role in modeling the disease. This may be a model organism ortholog of a known disease gene, or it may be a gene whose mutants recapitulate core features of the disease.
-- # Class: "gene to expression site association" Description: "An association between a gene and a gene expression site, possibly qualified by stage/timing info."
--     * Slot: stage_qualifier Description: stage at which the gene is expressed in the site
--     * Slot: quantifier_qualifier Description: can be used to indicate magnitude, or also ranking
--     * Slot: predicate Description: expression relationship
--     * Slot: object Description: location in which the gene is expressed
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: Gene or gene product positively within the specified anatomical entity (or subclass, i.e. cellular component) location.
-- # Class: "sequence variant modulates treatment association" Description: "An association between a sequence variant and a treatment or health intervention. The treatment object itself encompasses both the disease and the drug used."
--     * Slot: subject Description: variant that modulates the treatment of some disease
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: treatment whose efficacy is modulated by the subject variant
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "functional association" Description: "An association between a macromolecular machine mixin (gene, gene product or complex of gene products) and either a molecular activity, a biological process or a cellular location in which a function is executed."
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: class describing the activity, process or localization of the gene product
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: gene, product or macromolecular complex that has the function associated with the GO term
-- # Class: "macromolecular machine to entity association mixin" Description: "an association which has a macromolecular machine mixin as a subject"
--     * Slot: id Description: 
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "macromolecular machine to molecular activity association" Description: "A functional association between a macromolecular machine (gene, gene product or complex) and a molecular activity (as represented in the GO molecular function branch), where the entity carries out the activity, or contributes to its execution."
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: class describing the activity, process or localization of the gene product
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: gene, product or macromolecular complex that has the function associated with the GO term
-- # Class: "macromolecular machine to biological process association" Description: "A functional association between a macromolecular machine (gene, gene product or complex) and a biological process or pathway (as represented in the GO biological process branch), where the entity carries out some part of the process, regulates it, or acts upstream of it."
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: class describing the activity, process or localization of the gene product
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: gene, product or macromolecular complex that has the function associated with the GO term
-- # Class: "macromolecular machine to cellular component association" Description: "A functional association between a macromolecular machine (gene, gene product or complex) and a cellular component (as represented in the GO cellular component branch), where the entity carries out its function in the cellular component."
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: class describing the activity, process or localization of the gene product
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: gene, product or macromolecular complex that has the function associated with the GO term
-- # Class: "molecular activity to chemical entity association" Description: "Added in response to capturing relationship between microbiome activities as measured via measurements of blood analytes as collected via blood and stool samples"
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "molecular activity to molecular activity association" Description: "Added in response to capturing relationship between microbiome activities as measured via measurements of blood analytes as collected via blood and stool samples"
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "gene to go term association" Description: ""
--     * Slot: subject Description: gene, product or macromolecular complex that has the function associated with the GO term
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: class describing the activity, process or localization of the gene product
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "entity to disease association" Description: ""
--     * Slot: clinical_approval_status Description: 
--     * Slot: max_research_phase Description: 
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "entity to phenotypic feature association" Description: ""
--     * Slot: clinical_approval_status Description: 
--     * Slot: max_research_phase Description: 
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "sequence association" Description: "An association between a sequence feature and a nucleic acid entity it is localized to."
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "genomic sequence localization" Description: "A relationship between a sequence feature and a nucleic acid entity it is localized to. The reference entity may be a chromosome, chromosome region or information entity such as a contig."
--     * Slot: start_interbase_coordinate Description: The position at which the subject nucleic acid entity starts on the chromosome or other entity to which it is located on. (ie: the start of the sequence being referenced is 0).
--     * Slot: end_interbase_coordinate Description: The position at which the subject nucleic acid entity ends on the chromosome or other entity to which it is located on.
--     * Slot: genome_build Description: The version of the genome on which a feature is located. For example, GRCh38 for Homo sapiens.
--     * Slot: strand Description: The strand on which a feature is located. Has a value of '+' (sense strand or forward strand) or '-' (anti-sense strand or reverse strand).
--     * Slot: phase Description: The phase for a coding sequence entity. For example, phase of a CDS as represented in a GFF3 with a value of 0, 1 or 2.
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "sequence feature relationship" Description: "For example, a particular exon is part of a particular transcript or gene"
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "transcript to gene relationship" Description: "A gene is a collection of transcripts"
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "gene to gene product relationship" Description: "A gene is transcribed and potentially translated to a gene product"
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: object_id Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "exon to transcript relationship" Description: "A transcript is formed from multiple exons"
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "chemical entity or gene or gene product regulates gene association" Description: "A regulatory relationship between two genes"
--     * Slot: object_direction_qualifier Description: Composes with the core concept (+ aspect if provided) to describe a change in its direction or degree. This qualifier qualifies the object of an association (aka: statement).
--     * Slot: predicate Description: the direction is always from regulator to regulated
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
--     * Slot: subject_id Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: object_id Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "anatomical entity to anatomical entity association" Description: ""
--     * Slot: subject Description: connects an association to the subject of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "anatomical entity to anatomical entity part of association" Description: "A relationship between two anatomical entities where the relationship is mereological, i.e the two entities are related by parthood. This includes relationships between cellular components and cells, between cells and tissues, tissues and whole organisms"
--     * Slot: subject Description: the part
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the whole
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "anatomical entity to anatomical entity ontogenic association" Description: "A relationship between two anatomical entities where the relationship is ontogenic, i.e. the two entities are related by development. A number of different relationship types can be used to specify the precise nature of the relationship."
--     * Slot: subject Description: the structure at a later time
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the structure at an earlier time
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "organism taxon to entity association" Description: "An association between an organism taxon and another entity"
--     * Slot: id Description: 
--     * Slot: subject Description: organism taxon that is the subject of the association
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
-- # Class: "organism taxon to organism taxon association" Description: "A relationship between two organism taxon nodes"
--     * Slot: subject Description: organism taxon that is the subject of the association
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: connects an association to the object of the association. For example, in a gene-to-phenotype association, the gene is subject and phenotype is object.
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "organism taxon to organism taxon specialization" Description: "A child-parent relationship between two taxa. For example: Homo sapiens subclass_of Homo"
--     * Slot: subject Description: the more specific taxon
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the more general taxon
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "organism taxon to organism taxon interaction" Description: "An interaction relationship between two taxa. This may be a symbiotic relationship (encompassing mutualism and parasitism), or it may be non-symbiotic. Example: plague transmitted_by flea; cattle domesticated_by Homo sapiens; plague infects Homo sapiens"
--     * Slot: associated_environmental_context Description: the environment in which the two taxa interact
--     * Slot: subject Description: the taxon that is the subject of the association
--     * Slot: predicate Description: A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.
--     * Slot: object Description: the taxon that is the subject of the association
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "organism taxon to environment association" Description: ""
--     * Slot: subject Description: the taxon that is the subject of the association
--     * Slot: predicate Description: predicate describing the relationship between the taxon and the environment
--     * Slot: object Description: the environment in which the organism occurs
--     * Slot: negated Description: if set to true, then the association is negated i.e. is not true
--     * Slot: qualifier Description: grouping slot for all qualifiers on an edge.  useful for testing compliance with association classes
--     * Slot: knowledge_source Description: An Information Resource from which the knowledge expressed in an Association was retrieved, directly or indirectly. This can be any resource through which the knowledge passed on its way to its currently serialized form. In practice, implementers should use one of the more specific subtypes of this generic property.
--     * Slot: primary_knowledge_source Description: The most upstream source of the knowledge expressed in an Association that an implementer can identify.  Performing a rigorous analysis of upstream data providers is expected; every effort is made to catalog the most upstream source of data in this property.  Only one data source should be declared primary in any association.  "aggregator knowledge source" can be used to capture non-primary sources.
--     * Slot: timepoint Description: a point in time
--     * Slot: original_subject Description: used to hold the original subject of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_predicate Description: used to hold the original relation/predicate that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: original_object Description: used to hold the original object of a relation (or predicate) that an external knowledge source uses before transformation to match the biolink-model specification.
--     * Slot: subject_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_category Description: Used to hold the biolink class/category of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: subject_namespace Description: Used to hold the subject namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: object_namespace Description: Used to hold the object namespace of an association. This is a denormalized field used primarily in the SQL serialization of a knowledge graph via KGX.
--     * Slot: id Description: A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI
--     * Slot: iri Description: An IRI for an entity. This is determined by the id using expansion rules.
--     * Slot: name Description: A human-readable name for an attribute or entity.
--     * Slot: description Description: a human-readable description of an entity
--     * Slot: deprecated Description: A boolean flag indicating that an entity is no longer considered current or valid.
-- # Class: "predicate mapping_exact_match" Description: ""
--     * Slot: predicate mapping_id Description: Autocreated FK slot
--     * Slot: exact_match_id Description: holds between two entities that have strictly equivalent meanings, with a high degree of confidence
-- # Class: "predicate mapping_narrow_match" Description: ""
--     * Slot: predicate mapping_id Description: Autocreated FK slot
--     * Slot: narrow_match_id Description: a list of terms from different schemas or terminology systems that have a narrower, more specific meaning. Narrower terms are typically shown as children in a hierarchy or tree.
-- # Class: "predicate mapping_broad_match" Description: ""
--     * Slot: predicate mapping_id Description: Autocreated FK slot
--     * Slot: broad_match_id Description: a list of terms from different schemas or terminology systems that have a broader, more general meaning. Broader terms are typically shown as parents in a hierarchy or tree.
-- # Class: "attribute_has_quantitative_value" Description: ""
--     * Slot: attribute_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "attribute_provided_by" Description: ""
--     * Slot: attribute_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "attribute_xref" Description: ""
--     * Slot: attribute_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "attribute_synonym" Description: ""
--     * Slot: attribute_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "attribute_category" Description: ""
--     * Slot: attribute_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "attribute_type" Description: ""
--     * Slot: attribute_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "attribute_has_attribute" Description: ""
--     * Slot: attribute_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "chemical role_has_quantitative_value" Description: ""
--     * Slot: chemical role_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "chemical role_provided_by" Description: ""
--     * Slot: chemical role_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "chemical role_xref" Description: ""
--     * Slot: chemical role_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "chemical role_synonym" Description: ""
--     * Slot: chemical role_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "chemical role_category" Description: ""
--     * Slot: chemical role_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "chemical role_type" Description: ""
--     * Slot: chemical role_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "chemical role_has_attribute" Description: ""
--     * Slot: chemical role_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "biological sex_has_quantitative_value" Description: ""
--     * Slot: biological sex_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "biological sex_provided_by" Description: ""
--     * Slot: biological sex_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "biological sex_xref" Description: ""
--     * Slot: biological sex_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "biological sex_synonym" Description: ""
--     * Slot: biological sex_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "biological sex_category" Description: ""
--     * Slot: biological sex_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "biological sex_type" Description: ""
--     * Slot: biological sex_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "biological sex_has_attribute" Description: ""
--     * Slot: biological sex_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "phenotypic sex_has_quantitative_value" Description: ""
--     * Slot: phenotypic sex_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "phenotypic sex_provided_by" Description: ""
--     * Slot: phenotypic sex_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "phenotypic sex_xref" Description: ""
--     * Slot: phenotypic sex_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "phenotypic sex_synonym" Description: ""
--     * Slot: phenotypic sex_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "phenotypic sex_category" Description: ""
--     * Slot: phenotypic sex_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "phenotypic sex_type" Description: ""
--     * Slot: phenotypic sex_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "phenotypic sex_has_attribute" Description: ""
--     * Slot: phenotypic sex_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "genotypic sex_has_quantitative_value" Description: ""
--     * Slot: genotypic sex_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "genotypic sex_provided_by" Description: ""
--     * Slot: genotypic sex_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "genotypic sex_xref" Description: ""
--     * Slot: genotypic sex_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "genotypic sex_synonym" Description: ""
--     * Slot: genotypic sex_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "genotypic sex_category" Description: ""
--     * Slot: genotypic sex_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "genotypic sex_type" Description: ""
--     * Slot: genotypic sex_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "genotypic sex_has_attribute" Description: ""
--     * Slot: genotypic sex_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "severity value_has_quantitative_value" Description: ""
--     * Slot: severity value_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "severity value_provided_by" Description: ""
--     * Slot: severity value_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "severity value_xref" Description: ""
--     * Slot: severity value_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "severity value_synonym" Description: ""
--     * Slot: severity value_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "severity value_category" Description: ""
--     * Slot: severity value_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "severity value_type" Description: ""
--     * Slot: severity value_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "severity value_has_attribute" Description: ""
--     * Slot: severity value_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "entity_category" Description: ""
--     * Slot: entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "entity_type" Description: ""
--     * Slot: entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "entity_has_attribute" Description: ""
--     * Slot: entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "named thing_provided_by" Description: ""
--     * Slot: named thing_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "named thing_xref" Description: ""
--     * Slot: named thing_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "named thing_synonym" Description: ""
--     * Slot: named thing_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "named thing_category" Description: ""
--     * Slot: named thing_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "named thing_type" Description: ""
--     * Slot: named thing_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "named thing_has_attribute" Description: ""
--     * Slot: named thing_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "organism taxon_provided_by" Description: ""
--     * Slot: organism taxon_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "organism taxon_xref" Description: ""
--     * Slot: organism taxon_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "organism taxon_synonym" Description: ""
--     * Slot: organism taxon_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "organism taxon_category" Description: ""
--     * Slot: organism taxon_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "organism taxon_type" Description: ""
--     * Slot: organism taxon_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "organism taxon_has_attribute" Description: ""
--     * Slot: organism taxon_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "event_provided_by" Description: ""
--     * Slot: event_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "event_xref" Description: ""
--     * Slot: event_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "event_synonym" Description: ""
--     * Slot: event_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "event_category" Description: ""
--     * Slot: event_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "event_type" Description: ""
--     * Slot: event_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "event_has_attribute" Description: ""
--     * Slot: event_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "administrative entity_provided_by" Description: ""
--     * Slot: administrative entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "administrative entity_xref" Description: ""
--     * Slot: administrative entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "administrative entity_synonym" Description: ""
--     * Slot: administrative entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "administrative entity_category" Description: ""
--     * Slot: administrative entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "administrative entity_type" Description: ""
--     * Slot: administrative entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "administrative entity_has_attribute" Description: ""
--     * Slot: administrative entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "study result_provided_by" Description: ""
--     * Slot: study result_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "study result_xref" Description: ""
--     * Slot: study result_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "study result_synonym" Description: ""
--     * Slot: study result_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "study result_category" Description: ""
--     * Slot: study result_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "study result_type" Description: ""
--     * Slot: study result_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "study result_has_attribute" Description: ""
--     * Slot: study result_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "study_provided_by" Description: ""
--     * Slot: study_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "study_xref" Description: ""
--     * Slot: study_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "study_synonym" Description: ""
--     * Slot: study_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "study_category" Description: ""
--     * Slot: study_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "study_type" Description: ""
--     * Slot: study_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "study_has_attribute" Description: ""
--     * Slot: study_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "study variable_provided_by" Description: ""
--     * Slot: study variable_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "study variable_xref" Description: ""
--     * Slot: study variable_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "study variable_synonym" Description: ""
--     * Slot: study variable_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "study variable_category" Description: ""
--     * Slot: study variable_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "study variable_type" Description: ""
--     * Slot: study variable_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "study variable_has_attribute" Description: ""
--     * Slot: study variable_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "common data element_provided_by" Description: ""
--     * Slot: common data element_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "common data element_xref" Description: ""
--     * Slot: common data element_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "common data element_synonym" Description: ""
--     * Slot: common data element_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "common data element_category" Description: ""
--     * Slot: common data element_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "common data element_type" Description: ""
--     * Slot: common data element_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "common data element_has_attribute" Description: ""
--     * Slot: common data element_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "concept count analysis result_provided_by" Description: ""
--     * Slot: concept count analysis result_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "concept count analysis result_xref" Description: ""
--     * Slot: concept count analysis result_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "concept count analysis result_synonym" Description: ""
--     * Slot: concept count analysis result_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "concept count analysis result_category" Description: ""
--     * Slot: concept count analysis result_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "concept count analysis result_type" Description: ""
--     * Slot: concept count analysis result_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "concept count analysis result_has_attribute" Description: ""
--     * Slot: concept count analysis result_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "observed expected frequency analysis result_provided_by" Description: ""
--     * Slot: observed expected frequency analysis result_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "observed expected frequency analysis result_xref" Description: ""
--     * Slot: observed expected frequency analysis result_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "observed expected frequency analysis result_synonym" Description: ""
--     * Slot: observed expected frequency analysis result_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "observed expected frequency analysis result_category" Description: ""
--     * Slot: observed expected frequency analysis result_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "observed expected frequency analysis result_type" Description: ""
--     * Slot: observed expected frequency analysis result_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "observed expected frequency analysis result_has_attribute" Description: ""
--     * Slot: observed expected frequency analysis result_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "relative frequency analysis result_provided_by" Description: ""
--     * Slot: relative frequency analysis result_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "relative frequency analysis result_xref" Description: ""
--     * Slot: relative frequency analysis result_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "relative frequency analysis result_synonym" Description: ""
--     * Slot: relative frequency analysis result_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "relative frequency analysis result_category" Description: ""
--     * Slot: relative frequency analysis result_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "relative frequency analysis result_type" Description: ""
--     * Slot: relative frequency analysis result_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "relative frequency analysis result_has_attribute" Description: ""
--     * Slot: relative frequency analysis result_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "text mining result_provided_by" Description: ""
--     * Slot: text mining result_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "text mining result_xref" Description: ""
--     * Slot: text mining result_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "text mining result_synonym" Description: ""
--     * Slot: text mining result_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "text mining result_category" Description: ""
--     * Slot: text mining result_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "text mining result_type" Description: ""
--     * Slot: text mining result_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "text mining result_has_attribute" Description: ""
--     * Slot: text mining result_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "chi squared analysis result_provided_by" Description: ""
--     * Slot: chi squared analysis result_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "chi squared analysis result_xref" Description: ""
--     * Slot: chi squared analysis result_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "chi squared analysis result_synonym" Description: ""
--     * Slot: chi squared analysis result_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "chi squared analysis result_category" Description: ""
--     * Slot: chi squared analysis result_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "chi squared analysis result_type" Description: ""
--     * Slot: chi squared analysis result_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "chi squared analysis result_has_attribute" Description: ""
--     * Slot: chi squared analysis result_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "log odds analysis result_provided_by" Description: ""
--     * Slot: log odds analysis result_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "log odds analysis result_xref" Description: ""
--     * Slot: log odds analysis result_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "log odds analysis result_synonym" Description: ""
--     * Slot: log odds analysis result_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "log odds analysis result_category" Description: ""
--     * Slot: log odds analysis result_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "log odds analysis result_type" Description: ""
--     * Slot: log odds analysis result_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "log odds analysis result_has_attribute" Description: ""
--     * Slot: log odds analysis result_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "agent_affiliation" Description: ""
--     * Slot: agent_id Description: Autocreated FK slot
--     * Slot: affiliation Description: a professional relationship between one provider (often a person) within another provider (often an organization). Target provider identity should be specified by a CURIE. Providers may have multiple affiliations.
-- # Class: "agent_provided_by" Description: ""
--     * Slot: agent_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "agent_xref" Description: ""
--     * Slot: agent_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "agent_synonym" Description: ""
--     * Slot: agent_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "agent_category" Description: ""
--     * Slot: agent_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "agent_type" Description: ""
--     * Slot: agent_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "agent_has_attribute" Description: ""
--     * Slot: agent_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "information content entity_provided_by" Description: ""
--     * Slot: information content entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "information content entity_xref" Description: ""
--     * Slot: information content entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "information content entity_synonym" Description: ""
--     * Slot: information content entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "information content entity_category" Description: ""
--     * Slot: information content entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "information content entity_type" Description: ""
--     * Slot: information content entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "information content entity_has_attribute" Description: ""
--     * Slot: information content entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "dataset_provided_by" Description: ""
--     * Slot: dataset_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "dataset_xref" Description: ""
--     * Slot: dataset_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "dataset_synonym" Description: ""
--     * Slot: dataset_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "dataset_category" Description: ""
--     * Slot: dataset_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "dataset_type" Description: ""
--     * Slot: dataset_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "dataset_has_attribute" Description: ""
--     * Slot: dataset_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "dataset distribution_provided_by" Description: ""
--     * Slot: dataset distribution_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "dataset distribution_xref" Description: ""
--     * Slot: dataset distribution_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "dataset distribution_synonym" Description: ""
--     * Slot: dataset distribution_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "dataset distribution_category" Description: ""
--     * Slot: dataset distribution_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "dataset distribution_type" Description: ""
--     * Slot: dataset distribution_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "dataset distribution_has_attribute" Description: ""
--     * Slot: dataset distribution_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "dataset version_provided_by" Description: ""
--     * Slot: dataset version_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "dataset version_xref" Description: ""
--     * Slot: dataset version_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "dataset version_synonym" Description: ""
--     * Slot: dataset version_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "dataset version_category" Description: ""
--     * Slot: dataset version_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "dataset version_type" Description: ""
--     * Slot: dataset version_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "dataset version_has_attribute" Description: ""
--     * Slot: dataset version_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "dataset summary_provided_by" Description: ""
--     * Slot: dataset summary_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "dataset summary_xref" Description: ""
--     * Slot: dataset summary_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "dataset summary_synonym" Description: ""
--     * Slot: dataset summary_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "dataset summary_category" Description: ""
--     * Slot: dataset summary_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "dataset summary_type" Description: ""
--     * Slot: dataset summary_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "dataset summary_has_attribute" Description: ""
--     * Slot: dataset summary_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "confidence level_provided_by" Description: ""
--     * Slot: confidence level_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "confidence level_xref" Description: ""
--     * Slot: confidence level_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "confidence level_synonym" Description: ""
--     * Slot: confidence level_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "confidence level_category" Description: ""
--     * Slot: confidence level_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "confidence level_type" Description: ""
--     * Slot: confidence level_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "confidence level_has_attribute" Description: ""
--     * Slot: confidence level_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "evidence type_provided_by" Description: ""
--     * Slot: evidence type_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "evidence type_xref" Description: ""
--     * Slot: evidence type_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "evidence type_synonym" Description: ""
--     * Slot: evidence type_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "evidence type_category" Description: ""
--     * Slot: evidence type_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "evidence type_type" Description: ""
--     * Slot: evidence type_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "evidence type_has_attribute" Description: ""
--     * Slot: evidence type_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "publication_authors" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: authors_id Description: connects an publication to the list of authors who contributed to the publication. This property should be a comma-delimited list of author names. It is recommended that an author's name be formatted as "surname, firstname initial.".   Note that this property is a node annotation expressing the citation list of authorship which might typically otherwise be more completely documented in biolink:PublicationToProviderAssociation defined edges which point to full details about an author and possibly, some qualifiers which clarify the specific status of a given author in the publication.
-- # Class: "publication_pages" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: pages Description: When a 2-tuple of page numbers are provided, they represent the start and end page of the publication within its parent publication context. For books, this may be set to the total number of pages of the book.
-- # Class: "publication_keywords" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: keywords Description: keywords tagging a publication
-- # Class: "publication_mesh_terms" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: mesh_terms Description: mesh terms tagging a publication
-- # Class: "publication_xref" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "publication_publication_type" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: publication_type Description: Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.
-- # Class: "publication_provided_by" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "publication_synonym" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "publication_category" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "publication_type" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "publication_has_attribute" Description: ""
--     * Slot: publication_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "book_authors" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: authors_id Description: connects an publication to the list of authors who contributed to the publication. This property should be a comma-delimited list of author names. It is recommended that an author's name be formatted as "surname, firstname initial.".   Note that this property is a node annotation expressing the citation list of authorship which might typically otherwise be more completely documented in biolink:PublicationToProviderAssociation defined edges which point to full details about an author and possibly, some qualifiers which clarify the specific status of a given author in the publication.
-- # Class: "book_pages" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: pages Description: When a 2-tuple of page numbers are provided, they represent the start and end page of the publication within its parent publication context. For books, this may be set to the total number of pages of the book.
-- # Class: "book_keywords" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: keywords Description: keywords tagging a publication
-- # Class: "book_mesh_terms" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: mesh_terms Description: mesh terms tagging a publication
-- # Class: "book_xref" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "book_publication_type" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: publication_type Description: Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.
-- # Class: "book_provided_by" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "book_synonym" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "book_category" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "book_type" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: type Description: Should generally be set to an ontology class defined term for 'book'.
-- # Class: "book_has_attribute" Description: ""
--     * Slot: book_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "book chapter_authors" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: authors_id Description: connects an publication to the list of authors who contributed to the publication. This property should be a comma-delimited list of author names. It is recommended that an author's name be formatted as "surname, firstname initial.".   Note that this property is a node annotation expressing the citation list of authorship which might typically otherwise be more completely documented in biolink:PublicationToProviderAssociation defined edges which point to full details about an author and possibly, some qualifiers which clarify the specific status of a given author in the publication.
-- # Class: "book chapter_pages" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: pages Description: When a 2-tuple of page numbers are provided, they represent the start and end page of the publication within its parent publication context. For books, this may be set to the total number of pages of the book.
-- # Class: "book chapter_keywords" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: keywords Description: keywords tagging a publication
-- # Class: "book chapter_mesh_terms" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: mesh_terms Description: mesh terms tagging a publication
-- # Class: "book chapter_xref" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "book chapter_publication_type" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: publication_type Description: Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.
-- # Class: "book chapter_provided_by" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "book chapter_synonym" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "book chapter_category" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "book chapter_type" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "book chapter_has_attribute" Description: ""
--     * Slot: book chapter_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "serial_authors" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: authors_id Description: connects an publication to the list of authors who contributed to the publication. This property should be a comma-delimited list of author names. It is recommended that an author's name be formatted as "surname, firstname initial.".   Note that this property is a node annotation expressing the citation list of authorship which might typically otherwise be more completely documented in biolink:PublicationToProviderAssociation defined edges which point to full details about an author and possibly, some qualifiers which clarify the specific status of a given author in the publication.
-- # Class: "serial_pages" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: pages Description: When a 2-tuple of page numbers are provided, they represent the start and end page of the publication within its parent publication context. For books, this may be set to the total number of pages of the book.
-- # Class: "serial_keywords" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: keywords Description: keywords tagging a publication
-- # Class: "serial_mesh_terms" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: mesh_terms Description: mesh terms tagging a publication
-- # Class: "serial_xref" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "serial_publication_type" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: publication_type Description: Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.
-- # Class: "serial_provided_by" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "serial_synonym" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "serial_category" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "serial_type" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: type Description: Should generally be set to an ontology class defined term for 'serial' or 'journal'.
-- # Class: "serial_has_attribute" Description: ""
--     * Slot: serial_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "article_authors" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: authors_id Description: connects an publication to the list of authors who contributed to the publication. This property should be a comma-delimited list of author names. It is recommended that an author's name be formatted as "surname, firstname initial.".   Note that this property is a node annotation expressing the citation list of authorship which might typically otherwise be more completely documented in biolink:PublicationToProviderAssociation defined edges which point to full details about an author and possibly, some qualifiers which clarify the specific status of a given author in the publication.
-- # Class: "article_pages" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: pages Description: When a 2-tuple of page numbers are provided, they represent the start and end page of the publication within its parent publication context. For books, this may be set to the total number of pages of the book.
-- # Class: "article_keywords" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: keywords Description: keywords tagging a publication
-- # Class: "article_mesh_terms" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: mesh_terms Description: mesh terms tagging a publication
-- # Class: "article_xref" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "article_publication_type" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: publication_type Description: Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.
-- # Class: "article_provided_by" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "article_synonym" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "article_category" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "article_type" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "article_has_attribute" Description: ""
--     * Slot: article_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "journal article_authors" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: authors_id Description: connects an publication to the list of authors who contributed to the publication. This property should be a comma-delimited list of author names. It is recommended that an author's name be formatted as "surname, firstname initial.".   Note that this property is a node annotation expressing the citation list of authorship which might typically otherwise be more completely documented in biolink:PublicationToProviderAssociation defined edges which point to full details about an author and possibly, some qualifiers which clarify the specific status of a given author in the publication.
-- # Class: "journal article_pages" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: pages Description: When a 2-tuple of page numbers are provided, they represent the start and end page of the publication within its parent publication context. For books, this may be set to the total number of pages of the book.
-- # Class: "journal article_keywords" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: keywords Description: keywords tagging a publication
-- # Class: "journal article_mesh_terms" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: mesh_terms Description: mesh terms tagging a publication
-- # Class: "journal article_xref" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "journal article_publication_type" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: publication_type Description: Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.
-- # Class: "journal article_provided_by" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "journal article_synonym" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "journal article_category" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "journal article_type" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "journal article_has_attribute" Description: ""
--     * Slot: journal article_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "patent_authors" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: authors_id Description: connects an publication to the list of authors who contributed to the publication. This property should be a comma-delimited list of author names. It is recommended that an author's name be formatted as "surname, firstname initial.".   Note that this property is a node annotation expressing the citation list of authorship which might typically otherwise be more completely documented in biolink:PublicationToProviderAssociation defined edges which point to full details about an author and possibly, some qualifiers which clarify the specific status of a given author in the publication.
-- # Class: "patent_pages" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: pages Description: When a 2-tuple of page numbers are provided, they represent the start and end page of the publication within its parent publication context. For books, this may be set to the total number of pages of the book.
-- # Class: "patent_keywords" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: keywords Description: keywords tagging a publication
-- # Class: "patent_mesh_terms" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: mesh_terms Description: mesh terms tagging a publication
-- # Class: "patent_xref" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "patent_publication_type" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: publication_type Description: Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.
-- # Class: "patent_provided_by" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "patent_synonym" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "patent_category" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "patent_type" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "patent_has_attribute" Description: ""
--     * Slot: patent_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "web page_authors" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: authors_id Description: connects an publication to the list of authors who contributed to the publication. This property should be a comma-delimited list of author names. It is recommended that an author's name be formatted as "surname, firstname initial.".   Note that this property is a node annotation expressing the citation list of authorship which might typically otherwise be more completely documented in biolink:PublicationToProviderAssociation defined edges which point to full details about an author and possibly, some qualifiers which clarify the specific status of a given author in the publication.
-- # Class: "web page_pages" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: pages Description: When a 2-tuple of page numbers are provided, they represent the start and end page of the publication within its parent publication context. For books, this may be set to the total number of pages of the book.
-- # Class: "web page_keywords" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: keywords Description: keywords tagging a publication
-- # Class: "web page_mesh_terms" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: mesh_terms Description: mesh terms tagging a publication
-- # Class: "web page_xref" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "web page_publication_type" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: publication_type Description: Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.
-- # Class: "web page_provided_by" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "web page_synonym" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "web page_category" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "web page_type" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "web page_has_attribute" Description: ""
--     * Slot: web page_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "preprint publication_authors" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: authors_id Description: connects an publication to the list of authors who contributed to the publication. This property should be a comma-delimited list of author names. It is recommended that an author's name be formatted as "surname, firstname initial.".   Note that this property is a node annotation expressing the citation list of authorship which might typically otherwise be more completely documented in biolink:PublicationToProviderAssociation defined edges which point to full details about an author and possibly, some qualifiers which clarify the specific status of a given author in the publication.
-- # Class: "preprint publication_pages" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: pages Description: When a 2-tuple of page numbers are provided, they represent the start and end page of the publication within its parent publication context. For books, this may be set to the total number of pages of the book.
-- # Class: "preprint publication_keywords" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: keywords Description: keywords tagging a publication
-- # Class: "preprint publication_mesh_terms" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: mesh_terms Description: mesh terms tagging a publication
-- # Class: "preprint publication_xref" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "preprint publication_publication_type" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: publication_type Description: Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.
-- # Class: "preprint publication_provided_by" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "preprint publication_synonym" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "preprint publication_category" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "preprint publication_type" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "preprint publication_has_attribute" Description: ""
--     * Slot: preprint publication_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "drug label_authors" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: authors_id Description: connects an publication to the list of authors who contributed to the publication. This property should be a comma-delimited list of author names. It is recommended that an author's name be formatted as "surname, firstname initial.".   Note that this property is a node annotation expressing the citation list of authorship which might typically otherwise be more completely documented in biolink:PublicationToProviderAssociation defined edges which point to full details about an author and possibly, some qualifiers which clarify the specific status of a given author in the publication.
-- # Class: "drug label_pages" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: pages Description: When a 2-tuple of page numbers are provided, they represent the start and end page of the publication within its parent publication context. For books, this may be set to the total number of pages of the book.
-- # Class: "drug label_keywords" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: keywords Description: keywords tagging a publication
-- # Class: "drug label_mesh_terms" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: mesh_terms Description: mesh terms tagging a publication
-- # Class: "drug label_xref" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "drug label_publication_type" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: publication_type Description: Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.
-- # Class: "drug label_provided_by" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "drug label_synonym" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "drug label_category" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "drug label_type" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "drug label_has_attribute" Description: ""
--     * Slot: drug label_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "retrieval source_xref" Description: ""
--     * Slot: retrieval source_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "retrieval source_provided_by" Description: ""
--     * Slot: retrieval source_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "retrieval source_synonym" Description: ""
--     * Slot: retrieval source_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "retrieval source_category" Description: ""
--     * Slot: retrieval source_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "retrieval source_type" Description: ""
--     * Slot: retrieval source_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "retrieval source_has_attribute" Description: ""
--     * Slot: retrieval source_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "physical entity_provided_by" Description: ""
--     * Slot: physical entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "physical entity_xref" Description: ""
--     * Slot: physical entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "physical entity_synonym" Description: ""
--     * Slot: physical entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "physical entity_category" Description: ""
--     * Slot: physical entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "physical entity_type" Description: ""
--     * Slot: physical entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "physical entity_has_attribute" Description: ""
--     * Slot: physical entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "activity_provided_by" Description: ""
--     * Slot: activity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "activity_xref" Description: ""
--     * Slot: activity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "activity_synonym" Description: ""
--     * Slot: activity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "activity_category" Description: ""
--     * Slot: activity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "activity_type" Description: ""
--     * Slot: activity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "activity_has_attribute" Description: ""
--     * Slot: activity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "procedure_provided_by" Description: ""
--     * Slot: procedure_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "procedure_xref" Description: ""
--     * Slot: procedure_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "procedure_synonym" Description: ""
--     * Slot: procedure_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "procedure_category" Description: ""
--     * Slot: procedure_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "procedure_type" Description: ""
--     * Slot: procedure_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "procedure_has_attribute" Description: ""
--     * Slot: procedure_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "phenomenon_provided_by" Description: ""
--     * Slot: phenomenon_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "phenomenon_xref" Description: ""
--     * Slot: phenomenon_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "phenomenon_synonym" Description: ""
--     * Slot: phenomenon_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "phenomenon_category" Description: ""
--     * Slot: phenomenon_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "phenomenon_type" Description: ""
--     * Slot: phenomenon_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "phenomenon_has_attribute" Description: ""
--     * Slot: phenomenon_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "device_provided_by" Description: ""
--     * Slot: device_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "device_xref" Description: ""
--     * Slot: device_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "device_synonym" Description: ""
--     * Slot: device_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "device_category" Description: ""
--     * Slot: device_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "device_type" Description: ""
--     * Slot: device_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "device_has_attribute" Description: ""
--     * Slot: device_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "diagnostic aid_provided_by" Description: ""
--     * Slot: diagnostic aid_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "diagnostic aid_xref" Description: ""
--     * Slot: diagnostic aid_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "diagnostic aid_synonym" Description: ""
--     * Slot: diagnostic aid_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "diagnostic aid_category" Description: ""
--     * Slot: diagnostic aid_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "diagnostic aid_type" Description: ""
--     * Slot: diagnostic aid_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "diagnostic aid_has_attribute" Description: ""
--     * Slot: diagnostic aid_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "study population_in_taxon" Description: ""
--     * Slot: study population_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "study population_provided_by" Description: ""
--     * Slot: study population_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "study population_xref" Description: ""
--     * Slot: study population_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "study population_synonym" Description: ""
--     * Slot: study population_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "study population_category" Description: ""
--     * Slot: study population_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "study population_type" Description: ""
--     * Slot: study population_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "study population_has_attribute" Description: ""
--     * Slot: study population_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "material sample_provided_by" Description: ""
--     * Slot: material sample_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "material sample_xref" Description: ""
--     * Slot: material sample_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "material sample_synonym" Description: ""
--     * Slot: material sample_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "material sample_category" Description: ""
--     * Slot: material sample_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "material sample_type" Description: ""
--     * Slot: material sample_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "material sample_has_attribute" Description: ""
--     * Slot: material sample_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "planetary entity_provided_by" Description: ""
--     * Slot: planetary entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "planetary entity_xref" Description: ""
--     * Slot: planetary entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "planetary entity_synonym" Description: ""
--     * Slot: planetary entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "planetary entity_category" Description: ""
--     * Slot: planetary entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "planetary entity_type" Description: ""
--     * Slot: planetary entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "planetary entity_has_attribute" Description: ""
--     * Slot: planetary entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "environmental process_provided_by" Description: ""
--     * Slot: environmental process_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "environmental process_xref" Description: ""
--     * Slot: environmental process_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "environmental process_synonym" Description: ""
--     * Slot: environmental process_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "environmental process_category" Description: ""
--     * Slot: environmental process_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "environmental process_type" Description: ""
--     * Slot: environmental process_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "environmental process_has_attribute" Description: ""
--     * Slot: environmental process_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "environmental feature_provided_by" Description: ""
--     * Slot: environmental feature_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "environmental feature_xref" Description: ""
--     * Slot: environmental feature_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "environmental feature_synonym" Description: ""
--     * Slot: environmental feature_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "environmental feature_category" Description: ""
--     * Slot: environmental feature_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "environmental feature_type" Description: ""
--     * Slot: environmental feature_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "environmental feature_has_attribute" Description: ""
--     * Slot: environmental feature_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "geographic location_provided_by" Description: ""
--     * Slot: geographic location_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "geographic location_xref" Description: ""
--     * Slot: geographic location_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "geographic location_synonym" Description: ""
--     * Slot: geographic location_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "geographic location_category" Description: ""
--     * Slot: geographic location_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "geographic location_type" Description: ""
--     * Slot: geographic location_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "geographic location_has_attribute" Description: ""
--     * Slot: geographic location_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "geographic location at time_provided_by" Description: ""
--     * Slot: geographic location at time_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "geographic location at time_xref" Description: ""
--     * Slot: geographic location at time_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "geographic location at time_synonym" Description: ""
--     * Slot: geographic location at time_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "geographic location at time_category" Description: ""
--     * Slot: geographic location at time_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "geographic location at time_type" Description: ""
--     * Slot: geographic location at time_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "geographic location at time_has_attribute" Description: ""
--     * Slot: geographic location at time_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "thing with taxon_in_taxon" Description: ""
--     * Slot: thing with taxon_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "biological entity_in_taxon" Description: ""
--     * Slot: biological entity_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "biological entity_provided_by" Description: ""
--     * Slot: biological entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "biological entity_xref" Description: ""
--     * Slot: biological entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "biological entity_synonym" Description: ""
--     * Slot: biological entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "biological entity_category" Description: ""
--     * Slot: biological entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "biological entity_type" Description: ""
--     * Slot: biological entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "biological entity_has_attribute" Description: ""
--     * Slot: biological entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "molecular entity_available_from" Description: ""
--     * Slot: molecular entity_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "molecular entity_has_chemical_role" Description: ""
--     * Slot: molecular entity_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "molecular entity_provided_by" Description: ""
--     * Slot: molecular entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "molecular entity_xref" Description: ""
--     * Slot: molecular entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "molecular entity_synonym" Description: ""
--     * Slot: molecular entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "molecular entity_category" Description: ""
--     * Slot: molecular entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "molecular entity_type" Description: ""
--     * Slot: molecular entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "molecular entity_has_attribute" Description: ""
--     * Slot: molecular entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "chemical entity_available_from" Description: ""
--     * Slot: chemical entity_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "chemical entity_has_chemical_role" Description: ""
--     * Slot: chemical entity_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "chemical entity_provided_by" Description: ""
--     * Slot: chemical entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "chemical entity_xref" Description: ""
--     * Slot: chemical entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "chemical entity_synonym" Description: ""
--     * Slot: chemical entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "chemical entity_category" Description: ""
--     * Slot: chemical entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "chemical entity_type" Description: ""
--     * Slot: chemical entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "chemical entity_has_attribute" Description: ""
--     * Slot: chemical entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "small molecule_available_from" Description: ""
--     * Slot: small molecule_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "small molecule_has_chemical_role" Description: ""
--     * Slot: small molecule_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "small molecule_provided_by" Description: ""
--     * Slot: small molecule_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "small molecule_xref" Description: ""
--     * Slot: small molecule_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "small molecule_synonym" Description: ""
--     * Slot: small molecule_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "small molecule_category" Description: ""
--     * Slot: small molecule_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "small molecule_type" Description: ""
--     * Slot: small molecule_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "small molecule_has_attribute" Description: ""
--     * Slot: small molecule_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "chemical mixture_routes_of_delivery" Description: ""
--     * Slot: chemical mixture_id Description: Autocreated FK slot
--     * Slot: routes_of_delivery Description: the method or process of administering a pharmaceutical compound to achieve a therapeutic effect in humans or animals.
-- # Class: "chemical mixture_available_from" Description: ""
--     * Slot: chemical mixture_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "chemical mixture_has_chemical_role" Description: ""
--     * Slot: chemical mixture_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "chemical mixture_provided_by" Description: ""
--     * Slot: chemical mixture_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "chemical mixture_xref" Description: ""
--     * Slot: chemical mixture_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "chemical mixture_synonym" Description: ""
--     * Slot: chemical mixture_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "chemical mixture_category" Description: ""
--     * Slot: chemical mixture_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "chemical mixture_type" Description: ""
--     * Slot: chemical mixture_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "chemical mixture_has_attribute" Description: ""
--     * Slot: chemical mixture_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "nucleic acid entity_in_taxon" Description: ""
--     * Slot: nucleic acid entity_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "nucleic acid entity_available_from" Description: ""
--     * Slot: nucleic acid entity_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "nucleic acid entity_has_chemical_role" Description: ""
--     * Slot: nucleic acid entity_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "nucleic acid entity_provided_by" Description: ""
--     * Slot: nucleic acid entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "nucleic acid entity_xref" Description: ""
--     * Slot: nucleic acid entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "nucleic acid entity_synonym" Description: ""
--     * Slot: nucleic acid entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "nucleic acid entity_category" Description: ""
--     * Slot: nucleic acid entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "nucleic acid entity_type" Description: ""
--     * Slot: nucleic acid entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "nucleic acid entity_has_attribute" Description: ""
--     * Slot: nucleic acid entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "regulatory region_in_taxon" Description: ""
--     * Slot: regulatory region_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "regulatory region_provided_by" Description: ""
--     * Slot: regulatory region_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "regulatory region_xref" Description: ""
--     * Slot: regulatory region_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "regulatory region_synonym" Description: ""
--     * Slot: regulatory region_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "regulatory region_category" Description: ""
--     * Slot: regulatory region_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "regulatory region_type" Description: ""
--     * Slot: regulatory region_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "regulatory region_has_attribute" Description: ""
--     * Slot: regulatory region_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "accessible dna region_in_taxon" Description: ""
--     * Slot: accessible dna region_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "accessible dna region_provided_by" Description: ""
--     * Slot: accessible dna region_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "accessible dna region_xref" Description: ""
--     * Slot: accessible dna region_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "accessible dna region_synonym" Description: ""
--     * Slot: accessible dna region_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "accessible dna region_category" Description: ""
--     * Slot: accessible dna region_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "accessible dna region_type" Description: ""
--     * Slot: accessible dna region_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "accessible dna region_has_attribute" Description: ""
--     * Slot: accessible dna region_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "transcription factor binding site_in_taxon" Description: ""
--     * Slot: transcription factor binding site_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "transcription factor binding site_provided_by" Description: ""
--     * Slot: transcription factor binding site_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "transcription factor binding site_xref" Description: ""
--     * Slot: transcription factor binding site_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "transcription factor binding site_synonym" Description: ""
--     * Slot: transcription factor binding site_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "transcription factor binding site_category" Description: ""
--     * Slot: transcription factor binding site_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "transcription factor binding site_type" Description: ""
--     * Slot: transcription factor binding site_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "transcription factor binding site_has_attribute" Description: ""
--     * Slot: transcription factor binding site_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "molecular mixture_routes_of_delivery" Description: ""
--     * Slot: molecular mixture_id Description: Autocreated FK slot
--     * Slot: routes_of_delivery Description: the method or process of administering a pharmaceutical compound to achieve a therapeutic effect in humans or animals.
-- # Class: "molecular mixture_available_from" Description: ""
--     * Slot: molecular mixture_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "molecular mixture_has_chemical_role" Description: ""
--     * Slot: molecular mixture_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "molecular mixture_provided_by" Description: ""
--     * Slot: molecular mixture_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "molecular mixture_xref" Description: ""
--     * Slot: molecular mixture_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "molecular mixture_synonym" Description: ""
--     * Slot: molecular mixture_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "molecular mixture_category" Description: ""
--     * Slot: molecular mixture_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "molecular mixture_type" Description: ""
--     * Slot: molecular mixture_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "molecular mixture_has_attribute" Description: ""
--     * Slot: molecular mixture_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "complex molecular mixture_routes_of_delivery" Description: ""
--     * Slot: complex molecular mixture_id Description: Autocreated FK slot
--     * Slot: routes_of_delivery Description: the method or process of administering a pharmaceutical compound to achieve a therapeutic effect in humans or animals.
-- # Class: "complex molecular mixture_available_from" Description: ""
--     * Slot: complex molecular mixture_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "complex molecular mixture_has_chemical_role" Description: ""
--     * Slot: complex molecular mixture_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "complex molecular mixture_provided_by" Description: ""
--     * Slot: complex molecular mixture_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "complex molecular mixture_xref" Description: ""
--     * Slot: complex molecular mixture_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "complex molecular mixture_synonym" Description: ""
--     * Slot: complex molecular mixture_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "complex molecular mixture_category" Description: ""
--     * Slot: complex molecular mixture_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "complex molecular mixture_type" Description: ""
--     * Slot: complex molecular mixture_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "complex molecular mixture_has_attribute" Description: ""
--     * Slot: complex molecular mixture_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "biological process or activity_has_input" Description: ""
--     * Slot: biological process or activity_id Description: Autocreated FK slot
--     * Slot: has_input_id Description: holds between a process and a continuant, where the continuant is an input into the process
-- # Class: "biological process or activity_has_output" Description: ""
--     * Slot: biological process or activity_id Description: Autocreated FK slot
--     * Slot: has_output_id Description: holds between a process and a continuant, where the continuant is an output of the process
-- # Class: "biological process or activity_enabled_by" Description: ""
--     * Slot: biological process or activity_id Description: Autocreated FK slot
--     * Slot: enabled_by_id Description: holds between a process and a physical entity, where the physical entity executes the process
-- # Class: "biological process or activity_in_taxon" Description: ""
--     * Slot: biological process or activity_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "biological process or activity_provided_by" Description: ""
--     * Slot: biological process or activity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "biological process or activity_xref" Description: ""
--     * Slot: biological process or activity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "biological process or activity_synonym" Description: ""
--     * Slot: biological process or activity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "biological process or activity_category" Description: ""
--     * Slot: biological process or activity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "biological process or activity_type" Description: ""
--     * Slot: biological process or activity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "biological process or activity_has_attribute" Description: ""
--     * Slot: biological process or activity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "molecular activity_has_input" Description: ""
--     * Slot: molecular activity_id Description: Autocreated FK slot
--     * Slot: has_input_id Description: A chemical entity that is the input for the reaction
-- # Class: "molecular activity_has_output" Description: ""
--     * Slot: molecular activity_id Description: Autocreated FK slot
--     * Slot: has_output_id Description: A chemical entity that is the output for the reaction
-- # Class: "molecular activity_enabled_by" Description: ""
--     * Slot: molecular activity_id Description: Autocreated FK slot
--     * Slot: enabled_by_id Description: The gene product, gene, or complex that catalyzes the reaction
-- # Class: "molecular activity_in_taxon" Description: ""
--     * Slot: molecular activity_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "molecular activity_provided_by" Description: ""
--     * Slot: molecular activity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "molecular activity_xref" Description: ""
--     * Slot: molecular activity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "molecular activity_synonym" Description: ""
--     * Slot: molecular activity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "molecular activity_category" Description: ""
--     * Slot: molecular activity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "molecular activity_type" Description: ""
--     * Slot: molecular activity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "molecular activity_has_attribute" Description: ""
--     * Slot: molecular activity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "biological process_has_input" Description: ""
--     * Slot: biological process_id Description: Autocreated FK slot
--     * Slot: has_input_id Description: holds between a process and a continuant, where the continuant is an input into the process
-- # Class: "biological process_has_output" Description: ""
--     * Slot: biological process_id Description: Autocreated FK slot
--     * Slot: has_output_id Description: holds between a process and a continuant, where the continuant is an output of the process
-- # Class: "biological process_enabled_by" Description: ""
--     * Slot: biological process_id Description: Autocreated FK slot
--     * Slot: enabled_by_id Description: holds between a process and a physical entity, where the physical entity executes the process
-- # Class: "biological process_in_taxon" Description: ""
--     * Slot: biological process_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "biological process_provided_by" Description: ""
--     * Slot: biological process_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "biological process_xref" Description: ""
--     * Slot: biological process_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "biological process_synonym" Description: ""
--     * Slot: biological process_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "biological process_category" Description: ""
--     * Slot: biological process_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "biological process_type" Description: ""
--     * Slot: biological process_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "biological process_has_attribute" Description: ""
--     * Slot: biological process_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "pathway_has_input" Description: ""
--     * Slot: pathway_id Description: Autocreated FK slot
--     * Slot: has_input_id Description: holds between a process and a continuant, where the continuant is an input into the process
-- # Class: "pathway_has_output" Description: ""
--     * Slot: pathway_id Description: Autocreated FK slot
--     * Slot: has_output_id Description: holds between a process and a continuant, where the continuant is an output of the process
-- # Class: "pathway_enabled_by" Description: ""
--     * Slot: pathway_id Description: Autocreated FK slot
--     * Slot: enabled_by_id Description: holds between a process and a physical entity, where the physical entity executes the process
-- # Class: "pathway_in_taxon" Description: ""
--     * Slot: pathway_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "pathway_provided_by" Description: ""
--     * Slot: pathway_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "pathway_xref" Description: ""
--     * Slot: pathway_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "pathway_synonym" Description: ""
--     * Slot: pathway_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "pathway_category" Description: ""
--     * Slot: pathway_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "pathway_type" Description: ""
--     * Slot: pathway_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "pathway_has_attribute" Description: ""
--     * Slot: pathway_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "physiological process_has_input" Description: ""
--     * Slot: physiological process_id Description: Autocreated FK slot
--     * Slot: has_input_id Description: holds between a process and a continuant, where the continuant is an input into the process
-- # Class: "physiological process_has_output" Description: ""
--     * Slot: physiological process_id Description: Autocreated FK slot
--     * Slot: has_output_id Description: holds between a process and a continuant, where the continuant is an output of the process
-- # Class: "physiological process_enabled_by" Description: ""
--     * Slot: physiological process_id Description: Autocreated FK slot
--     * Slot: enabled_by_id Description: holds between a process and a physical entity, where the physical entity executes the process
-- # Class: "physiological process_in_taxon" Description: ""
--     * Slot: physiological process_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "physiological process_provided_by" Description: ""
--     * Slot: physiological process_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "physiological process_xref" Description: ""
--     * Slot: physiological process_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "physiological process_synonym" Description: ""
--     * Slot: physiological process_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "physiological process_category" Description: ""
--     * Slot: physiological process_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "physiological process_type" Description: ""
--     * Slot: physiological process_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "physiological process_has_attribute" Description: ""
--     * Slot: physiological process_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "behavior_has_input" Description: ""
--     * Slot: behavior_id Description: Autocreated FK slot
--     * Slot: has_input_id Description: holds between a process and a continuant, where the continuant is an input into the process
-- # Class: "behavior_has_output" Description: ""
--     * Slot: behavior_id Description: Autocreated FK slot
--     * Slot: has_output_id Description: holds between a process and a continuant, where the continuant is an output of the process
-- # Class: "behavior_enabled_by" Description: ""
--     * Slot: behavior_id Description: Autocreated FK slot
--     * Slot: enabled_by_id Description: holds between a process and a physical entity, where the physical entity executes the process
-- # Class: "behavior_in_taxon" Description: ""
--     * Slot: behavior_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "behavior_provided_by" Description: ""
--     * Slot: behavior_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "behavior_xref" Description: ""
--     * Slot: behavior_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "behavior_synonym" Description: ""
--     * Slot: behavior_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "behavior_category" Description: ""
--     * Slot: behavior_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "behavior_type" Description: ""
--     * Slot: behavior_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "behavior_has_attribute" Description: ""
--     * Slot: behavior_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "processed material_routes_of_delivery" Description: ""
--     * Slot: processed material_id Description: Autocreated FK slot
--     * Slot: routes_of_delivery Description: the method or process of administering a pharmaceutical compound to achieve a therapeutic effect in humans or animals.
-- # Class: "processed material_available_from" Description: ""
--     * Slot: processed material_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "processed material_has_chemical_role" Description: ""
--     * Slot: processed material_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "processed material_provided_by" Description: ""
--     * Slot: processed material_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "processed material_xref" Description: ""
--     * Slot: processed material_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "processed material_synonym" Description: ""
--     * Slot: processed material_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "processed material_category" Description: ""
--     * Slot: processed material_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "processed material_type" Description: ""
--     * Slot: processed material_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "processed material_has_attribute" Description: ""
--     * Slot: processed material_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "drug_routes_of_delivery" Description: ""
--     * Slot: drug_id Description: Autocreated FK slot
--     * Slot: routes_of_delivery Description: the method or process of administering a pharmaceutical compound to achieve a therapeutic effect in humans or animals.
-- # Class: "drug_available_from" Description: ""
--     * Slot: drug_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "drug_has_chemical_role" Description: ""
--     * Slot: drug_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "drug_provided_by" Description: ""
--     * Slot: drug_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "drug_xref" Description: ""
--     * Slot: drug_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "drug_synonym" Description: ""
--     * Slot: drug_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "drug_category" Description: ""
--     * Slot: drug_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "drug_type" Description: ""
--     * Slot: drug_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "drug_has_attribute" Description: ""
--     * Slot: drug_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "environmental food contaminant_available_from" Description: ""
--     * Slot: environmental food contaminant_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "environmental food contaminant_has_chemical_role" Description: ""
--     * Slot: environmental food contaminant_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "environmental food contaminant_provided_by" Description: ""
--     * Slot: environmental food contaminant_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "environmental food contaminant_xref" Description: ""
--     * Slot: environmental food contaminant_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "environmental food contaminant_synonym" Description: ""
--     * Slot: environmental food contaminant_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "environmental food contaminant_category" Description: ""
--     * Slot: environmental food contaminant_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "environmental food contaminant_type" Description: ""
--     * Slot: environmental food contaminant_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "environmental food contaminant_has_attribute" Description: ""
--     * Slot: environmental food contaminant_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "food additive_available_from" Description: ""
--     * Slot: food additive_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "food additive_has_chemical_role" Description: ""
--     * Slot: food additive_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "food additive_provided_by" Description: ""
--     * Slot: food additive_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "food additive_xref" Description: ""
--     * Slot: food additive_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "food additive_synonym" Description: ""
--     * Slot: food additive_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "food additive_category" Description: ""
--     * Slot: food additive_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "food additive_type" Description: ""
--     * Slot: food additive_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "food additive_has_attribute" Description: ""
--     * Slot: food additive_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "food_routes_of_delivery" Description: ""
--     * Slot: food_id Description: Autocreated FK slot
--     * Slot: routes_of_delivery Description: the method or process of administering a pharmaceutical compound to achieve a therapeutic effect in humans or animals.
-- # Class: "food_available_from" Description: ""
--     * Slot: food_id Description: Autocreated FK slot
--     * Slot: available_from Description: 
-- # Class: "food_has_chemical_role" Description: ""
--     * Slot: food_id Description: Autocreated FK slot
--     * Slot: has_chemical_role_id Description: A role is particular behaviour which a chemical entity may exhibit.
-- # Class: "food_provided_by" Description: ""
--     * Slot: food_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "food_xref" Description: ""
--     * Slot: food_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "food_synonym" Description: ""
--     * Slot: food_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "food_category" Description: ""
--     * Slot: food_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "food_type" Description: ""
--     * Slot: food_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "food_has_attribute" Description: ""
--     * Slot: food_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "organism attribute_has_quantitative_value" Description: ""
--     * Slot: organism attribute_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "organism attribute_provided_by" Description: ""
--     * Slot: organism attribute_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "organism attribute_xref" Description: ""
--     * Slot: organism attribute_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "organism attribute_synonym" Description: ""
--     * Slot: organism attribute_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "organism attribute_category" Description: ""
--     * Slot: organism attribute_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "organism attribute_type" Description: ""
--     * Slot: organism attribute_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "organism attribute_has_attribute" Description: ""
--     * Slot: organism attribute_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "phenotypic quality_has_quantitative_value" Description: ""
--     * Slot: phenotypic quality_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "phenotypic quality_provided_by" Description: ""
--     * Slot: phenotypic quality_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "phenotypic quality_xref" Description: ""
--     * Slot: phenotypic quality_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "phenotypic quality_synonym" Description: ""
--     * Slot: phenotypic quality_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "phenotypic quality_category" Description: ""
--     * Slot: phenotypic quality_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "phenotypic quality_type" Description: ""
--     * Slot: phenotypic quality_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "phenotypic quality_has_attribute" Description: ""
--     * Slot: phenotypic quality_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "genetic inheritance_in_taxon" Description: ""
--     * Slot: genetic inheritance_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "genetic inheritance_provided_by" Description: ""
--     * Slot: genetic inheritance_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "genetic inheritance_xref" Description: ""
--     * Slot: genetic inheritance_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "genetic inheritance_synonym" Description: ""
--     * Slot: genetic inheritance_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "genetic inheritance_category" Description: ""
--     * Slot: genetic inheritance_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "genetic inheritance_type" Description: ""
--     * Slot: genetic inheritance_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "genetic inheritance_has_attribute" Description: ""
--     * Slot: genetic inheritance_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "organismal entity_in_taxon" Description: ""
--     * Slot: organismal entity_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "organismal entity_provided_by" Description: ""
--     * Slot: organismal entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "organismal entity_xref" Description: ""
--     * Slot: organismal entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "organismal entity_synonym" Description: ""
--     * Slot: organismal entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "organismal entity_category" Description: ""
--     * Slot: organismal entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "organismal entity_type" Description: ""
--     * Slot: organismal entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "organismal entity_has_attribute" Description: ""
--     * Slot: organismal entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "bacterium_in_taxon" Description: ""
--     * Slot: bacterium_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "bacterium_provided_by" Description: ""
--     * Slot: bacterium_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "bacterium_xref" Description: ""
--     * Slot: bacterium_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "bacterium_synonym" Description: ""
--     * Slot: bacterium_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "bacterium_category" Description: ""
--     * Slot: bacterium_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "bacterium_type" Description: ""
--     * Slot: bacterium_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "bacterium_has_attribute" Description: ""
--     * Slot: bacterium_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "virus_in_taxon" Description: ""
--     * Slot: virus_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "virus_provided_by" Description: ""
--     * Slot: virus_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "virus_xref" Description: ""
--     * Slot: virus_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "virus_synonym" Description: ""
--     * Slot: virus_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "virus_category" Description: ""
--     * Slot: virus_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "virus_type" Description: ""
--     * Slot: virus_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "virus_has_attribute" Description: ""
--     * Slot: virus_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "cellular organism_in_taxon" Description: ""
--     * Slot: cellular organism_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "cellular organism_provided_by" Description: ""
--     * Slot: cellular organism_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "cellular organism_xref" Description: ""
--     * Slot: cellular organism_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "cellular organism_synonym" Description: ""
--     * Slot: cellular organism_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "cellular organism_category" Description: ""
--     * Slot: cellular organism_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "cellular organism_type" Description: ""
--     * Slot: cellular organism_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "cellular organism_has_attribute" Description: ""
--     * Slot: cellular organism_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "mammal_in_taxon" Description: ""
--     * Slot: mammal_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "mammal_provided_by" Description: ""
--     * Slot: mammal_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "mammal_xref" Description: ""
--     * Slot: mammal_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "mammal_synonym" Description: ""
--     * Slot: mammal_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "mammal_category" Description: ""
--     * Slot: mammal_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "mammal_type" Description: ""
--     * Slot: mammal_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "mammal_has_attribute" Description: ""
--     * Slot: mammal_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "human_in_taxon" Description: ""
--     * Slot: human_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "human_provided_by" Description: ""
--     * Slot: human_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "human_xref" Description: ""
--     * Slot: human_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "human_synonym" Description: ""
--     * Slot: human_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "human_category" Description: ""
--     * Slot: human_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "human_type" Description: ""
--     * Slot: human_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "human_has_attribute" Description: ""
--     * Slot: human_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "plant_in_taxon" Description: ""
--     * Slot: plant_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "plant_provided_by" Description: ""
--     * Slot: plant_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "plant_xref" Description: ""
--     * Slot: plant_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "plant_synonym" Description: ""
--     * Slot: plant_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "plant_category" Description: ""
--     * Slot: plant_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "plant_type" Description: ""
--     * Slot: plant_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "plant_has_attribute" Description: ""
--     * Slot: plant_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "invertebrate_in_taxon" Description: ""
--     * Slot: invertebrate_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "invertebrate_provided_by" Description: ""
--     * Slot: invertebrate_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "invertebrate_xref" Description: ""
--     * Slot: invertebrate_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "invertebrate_synonym" Description: ""
--     * Slot: invertebrate_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "invertebrate_category" Description: ""
--     * Slot: invertebrate_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "invertebrate_type" Description: ""
--     * Slot: invertebrate_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "invertebrate_has_attribute" Description: ""
--     * Slot: invertebrate_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "vertebrate_in_taxon" Description: ""
--     * Slot: vertebrate_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "vertebrate_provided_by" Description: ""
--     * Slot: vertebrate_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "vertebrate_xref" Description: ""
--     * Slot: vertebrate_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "vertebrate_synonym" Description: ""
--     * Slot: vertebrate_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "vertebrate_category" Description: ""
--     * Slot: vertebrate_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "vertebrate_type" Description: ""
--     * Slot: vertebrate_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "vertebrate_has_attribute" Description: ""
--     * Slot: vertebrate_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "fungus_in_taxon" Description: ""
--     * Slot: fungus_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "fungus_provided_by" Description: ""
--     * Slot: fungus_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "fungus_xref" Description: ""
--     * Slot: fungus_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "fungus_synonym" Description: ""
--     * Slot: fungus_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "fungus_category" Description: ""
--     * Slot: fungus_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "fungus_type" Description: ""
--     * Slot: fungus_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "fungus_has_attribute" Description: ""
--     * Slot: fungus_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "life stage_in_taxon" Description: ""
--     * Slot: life stage_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "life stage_provided_by" Description: ""
--     * Slot: life stage_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "life stage_xref" Description: ""
--     * Slot: life stage_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "life stage_synonym" Description: ""
--     * Slot: life stage_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "life stage_category" Description: ""
--     * Slot: life stage_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "life stage_type" Description: ""
--     * Slot: life stage_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "life stage_has_attribute" Description: ""
--     * Slot: life stage_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "individual organism_in_taxon" Description: ""
--     * Slot: individual organism_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "individual organism_provided_by" Description: ""
--     * Slot: individual organism_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "individual organism_xref" Description: ""
--     * Slot: individual organism_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "individual organism_synonym" Description: ""
--     * Slot: individual organism_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "individual organism_category" Description: ""
--     * Slot: individual organism_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "individual organism_type" Description: ""
--     * Slot: individual organism_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "individual organism_has_attribute" Description: ""
--     * Slot: individual organism_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "population of individual organisms_in_taxon" Description: ""
--     * Slot: population of individual organisms_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "population of individual organisms_provided_by" Description: ""
--     * Slot: population of individual organisms_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "population of individual organisms_xref" Description: ""
--     * Slot: population of individual organisms_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "population of individual organisms_synonym" Description: ""
--     * Slot: population of individual organisms_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "population of individual organisms_category" Description: ""
--     * Slot: population of individual organisms_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "population of individual organisms_type" Description: ""
--     * Slot: population of individual organisms_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "population of individual organisms_has_attribute" Description: ""
--     * Slot: population of individual organisms_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "disease or phenotypic feature_in_taxon" Description: ""
--     * Slot: disease or phenotypic feature_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "disease or phenotypic feature_provided_by" Description: ""
--     * Slot: disease or phenotypic feature_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "disease or phenotypic feature_xref" Description: ""
--     * Slot: disease or phenotypic feature_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "disease or phenotypic feature_synonym" Description: ""
--     * Slot: disease or phenotypic feature_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "disease or phenotypic feature_category" Description: ""
--     * Slot: disease or phenotypic feature_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "disease or phenotypic feature_type" Description: ""
--     * Slot: disease or phenotypic feature_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "disease or phenotypic feature_has_attribute" Description: ""
--     * Slot: disease or phenotypic feature_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "disease_in_taxon" Description: ""
--     * Slot: disease_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "disease_provided_by" Description: ""
--     * Slot: disease_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "disease_xref" Description: ""
--     * Slot: disease_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "disease_synonym" Description: ""
--     * Slot: disease_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "disease_category" Description: ""
--     * Slot: disease_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "disease_type" Description: ""
--     * Slot: disease_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "disease_has_attribute" Description: ""
--     * Slot: disease_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "phenotypic feature_in_taxon" Description: ""
--     * Slot: phenotypic feature_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "phenotypic feature_provided_by" Description: ""
--     * Slot: phenotypic feature_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "phenotypic feature_xref" Description: ""
--     * Slot: phenotypic feature_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "phenotypic feature_synonym" Description: ""
--     * Slot: phenotypic feature_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "phenotypic feature_category" Description: ""
--     * Slot: phenotypic feature_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "phenotypic feature_type" Description: ""
--     * Slot: phenotypic feature_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "phenotypic feature_has_attribute" Description: ""
--     * Slot: phenotypic feature_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "behavioral feature_in_taxon" Description: ""
--     * Slot: behavioral feature_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "behavioral feature_provided_by" Description: ""
--     * Slot: behavioral feature_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "behavioral feature_xref" Description: ""
--     * Slot: behavioral feature_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "behavioral feature_synonym" Description: ""
--     * Slot: behavioral feature_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "behavioral feature_category" Description: ""
--     * Slot: behavioral feature_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "behavioral feature_type" Description: ""
--     * Slot: behavioral feature_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "behavioral feature_has_attribute" Description: ""
--     * Slot: behavioral feature_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "anatomical entity_in_taxon" Description: ""
--     * Slot: anatomical entity_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "anatomical entity_provided_by" Description: ""
--     * Slot: anatomical entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "anatomical entity_xref" Description: ""
--     * Slot: anatomical entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "anatomical entity_synonym" Description: ""
--     * Slot: anatomical entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "anatomical entity_category" Description: ""
--     * Slot: anatomical entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "anatomical entity_type" Description: ""
--     * Slot: anatomical entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "anatomical entity_has_attribute" Description: ""
--     * Slot: anatomical entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "cellular component_in_taxon" Description: ""
--     * Slot: cellular component_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "cellular component_provided_by" Description: ""
--     * Slot: cellular component_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "cellular component_xref" Description: ""
--     * Slot: cellular component_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "cellular component_synonym" Description: ""
--     * Slot: cellular component_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "cellular component_category" Description: ""
--     * Slot: cellular component_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "cellular component_type" Description: ""
--     * Slot: cellular component_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "cellular component_has_attribute" Description: ""
--     * Slot: cellular component_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "cell_in_taxon" Description: ""
--     * Slot: cell_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "cell_provided_by" Description: ""
--     * Slot: cell_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "cell_xref" Description: ""
--     * Slot: cell_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "cell_synonym" Description: ""
--     * Slot: cell_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "cell_category" Description: ""
--     * Slot: cell_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "cell_type" Description: ""
--     * Slot: cell_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "cell_has_attribute" Description: ""
--     * Slot: cell_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "cell line_in_taxon" Description: ""
--     * Slot: cell line_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "cell line_provided_by" Description: ""
--     * Slot: cell line_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "cell line_xref" Description: ""
--     * Slot: cell line_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "cell line_synonym" Description: ""
--     * Slot: cell line_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "cell line_category" Description: ""
--     * Slot: cell line_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "cell line_type" Description: ""
--     * Slot: cell line_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "cell line_has_attribute" Description: ""
--     * Slot: cell line_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "gross anatomical structure_in_taxon" Description: ""
--     * Slot: gross anatomical structure_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "gross anatomical structure_provided_by" Description: ""
--     * Slot: gross anatomical structure_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "gross anatomical structure_xref" Description: ""
--     * Slot: gross anatomical structure_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "gross anatomical structure_synonym" Description: ""
--     * Slot: gross anatomical structure_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "gross anatomical structure_category" Description: ""
--     * Slot: gross anatomical structure_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "gross anatomical structure_type" Description: ""
--     * Slot: gross anatomical structure_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "gross anatomical structure_has_attribute" Description: ""
--     * Slot: gross anatomical structure_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "gene_xref" Description: ""
--     * Slot: gene_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "gene_in_taxon" Description: ""
--     * Slot: gene_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "gene_provided_by" Description: ""
--     * Slot: gene_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "gene_synonym" Description: ""
--     * Slot: gene_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "gene_category" Description: ""
--     * Slot: gene_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "gene_type" Description: ""
--     * Slot: gene_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "gene_has_attribute" Description: ""
--     * Slot: gene_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "gene product mixin_synonym" Description: ""
--     * Slot: gene product mixin_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "gene product mixin_xref" Description: ""
--     * Slot: gene product mixin_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "gene product isoform mixin_synonym" Description: ""
--     * Slot: gene product isoform mixin_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "gene product isoform mixin_xref" Description: ""
--     * Slot: gene product isoform mixin_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "macromolecular complex_in_taxon" Description: ""
--     * Slot: macromolecular complex_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "macromolecular complex_provided_by" Description: ""
--     * Slot: macromolecular complex_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "macromolecular complex_xref" Description: ""
--     * Slot: macromolecular complex_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "macromolecular complex_synonym" Description: ""
--     * Slot: macromolecular complex_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "macromolecular complex_category" Description: ""
--     * Slot: macromolecular complex_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "macromolecular complex_type" Description: ""
--     * Slot: macromolecular complex_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "macromolecular complex_has_attribute" Description: ""
--     * Slot: macromolecular complex_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "nucleosome modification_in_taxon" Description: ""
--     * Slot: nucleosome modification_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "nucleosome modification_provided_by" Description: ""
--     * Slot: nucleosome modification_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "nucleosome modification_xref" Description: ""
--     * Slot: nucleosome modification_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "nucleosome modification_synonym" Description: ""
--     * Slot: nucleosome modification_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "nucleosome modification_category" Description: ""
--     * Slot: nucleosome modification_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "nucleosome modification_type" Description: ""
--     * Slot: nucleosome modification_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "nucleosome modification_has_attribute" Description: ""
--     * Slot: nucleosome modification_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "genome_in_taxon" Description: ""
--     * Slot: genome_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "genome_provided_by" Description: ""
--     * Slot: genome_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "genome_xref" Description: ""
--     * Slot: genome_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "genome_synonym" Description: ""
--     * Slot: genome_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "genome_category" Description: ""
--     * Slot: genome_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "genome_type" Description: ""
--     * Slot: genome_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "genome_has_attribute" Description: ""
--     * Slot: genome_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "exon_in_taxon" Description: ""
--     * Slot: exon_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "exon_provided_by" Description: ""
--     * Slot: exon_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "exon_xref" Description: ""
--     * Slot: exon_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "exon_synonym" Description: ""
--     * Slot: exon_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "exon_category" Description: ""
--     * Slot: exon_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "exon_type" Description: ""
--     * Slot: exon_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "exon_has_attribute" Description: ""
--     * Slot: exon_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "transcript_in_taxon" Description: ""
--     * Slot: transcript_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "transcript_provided_by" Description: ""
--     * Slot: transcript_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "transcript_xref" Description: ""
--     * Slot: transcript_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "transcript_synonym" Description: ""
--     * Slot: transcript_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "transcript_category" Description: ""
--     * Slot: transcript_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "transcript_type" Description: ""
--     * Slot: transcript_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "transcript_has_attribute" Description: ""
--     * Slot: transcript_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "coding sequence_in_taxon" Description: ""
--     * Slot: coding sequence_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "coding sequence_provided_by" Description: ""
--     * Slot: coding sequence_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "coding sequence_xref" Description: ""
--     * Slot: coding sequence_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "coding sequence_synonym" Description: ""
--     * Slot: coding sequence_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "coding sequence_category" Description: ""
--     * Slot: coding sequence_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "coding sequence_type" Description: ""
--     * Slot: coding sequence_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "coding sequence_has_attribute" Description: ""
--     * Slot: coding sequence_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "polypeptide_in_taxon" Description: ""
--     * Slot: polypeptide_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "polypeptide_provided_by" Description: ""
--     * Slot: polypeptide_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "polypeptide_xref" Description: ""
--     * Slot: polypeptide_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "polypeptide_synonym" Description: ""
--     * Slot: polypeptide_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "polypeptide_category" Description: ""
--     * Slot: polypeptide_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "polypeptide_type" Description: ""
--     * Slot: polypeptide_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "polypeptide_has_attribute" Description: ""
--     * Slot: polypeptide_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "protein_synonym" Description: ""
--     * Slot: protein_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "protein_xref" Description: ""
--     * Slot: protein_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "protein_in_taxon" Description: ""
--     * Slot: protein_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "protein_provided_by" Description: ""
--     * Slot: protein_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "protein_category" Description: ""
--     * Slot: protein_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "protein_type" Description: ""
--     * Slot: protein_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "protein_has_attribute" Description: ""
--     * Slot: protein_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "protein isoform_synonym" Description: ""
--     * Slot: protein isoform_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "protein isoform_xref" Description: ""
--     * Slot: protein isoform_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "protein isoform_in_taxon" Description: ""
--     * Slot: protein isoform_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "protein isoform_provided_by" Description: ""
--     * Slot: protein isoform_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "protein isoform_category" Description: ""
--     * Slot: protein isoform_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "protein isoform_type" Description: ""
--     * Slot: protein isoform_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "protein isoform_has_attribute" Description: ""
--     * Slot: protein isoform_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "protein domain_has_gene_or_gene_product" Description: ""
--     * Slot: protein domain_id Description: Autocreated FK slot
--     * Slot: has_gene_or_gene_product_id Description: connects an entity with one or more gene or gene products
-- # Class: "protein domain_in_taxon" Description: ""
--     * Slot: protein domain_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "protein domain_provided_by" Description: ""
--     * Slot: protein domain_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "protein domain_xref" Description: ""
--     * Slot: protein domain_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "protein domain_synonym" Description: ""
--     * Slot: protein domain_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "protein domain_category" Description: ""
--     * Slot: protein domain_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "protein domain_type" Description: ""
--     * Slot: protein domain_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "protein domain_has_attribute" Description: ""
--     * Slot: protein domain_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "posttranslational modification_in_taxon" Description: ""
--     * Slot: posttranslational modification_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "posttranslational modification_provided_by" Description: ""
--     * Slot: posttranslational modification_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "posttranslational modification_xref" Description: ""
--     * Slot: posttranslational modification_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "posttranslational modification_synonym" Description: ""
--     * Slot: posttranslational modification_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "posttranslational modification_category" Description: ""
--     * Slot: posttranslational modification_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "posttranslational modification_type" Description: ""
--     * Slot: posttranslational modification_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "posttranslational modification_has_attribute" Description: ""
--     * Slot: posttranslational modification_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "protein family_has_gene_or_gene_product" Description: ""
--     * Slot: protein family_id Description: Autocreated FK slot
--     * Slot: has_gene_or_gene_product_id Description: connects an entity with one or more gene or gene products
-- # Class: "protein family_in_taxon" Description: ""
--     * Slot: protein family_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "protein family_provided_by" Description: ""
--     * Slot: protein family_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "protein family_xref" Description: ""
--     * Slot: protein family_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "protein family_synonym" Description: ""
--     * Slot: protein family_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "protein family_category" Description: ""
--     * Slot: protein family_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "protein family_type" Description: ""
--     * Slot: protein family_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "protein family_has_attribute" Description: ""
--     * Slot: protein family_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "nucleic acid sequence motif_in_taxon" Description: ""
--     * Slot: nucleic acid sequence motif_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "nucleic acid sequence motif_provided_by" Description: ""
--     * Slot: nucleic acid sequence motif_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "nucleic acid sequence motif_xref" Description: ""
--     * Slot: nucleic acid sequence motif_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "nucleic acid sequence motif_synonym" Description: ""
--     * Slot: nucleic acid sequence motif_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "nucleic acid sequence motif_category" Description: ""
--     * Slot: nucleic acid sequence motif_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "nucleic acid sequence motif_type" Description: ""
--     * Slot: nucleic acid sequence motif_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "nucleic acid sequence motif_has_attribute" Description: ""
--     * Slot: nucleic acid sequence motif_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "RNA product_synonym" Description: ""
--     * Slot: RNA product_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "RNA product_xref" Description: ""
--     * Slot: RNA product_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "RNA product_in_taxon" Description: ""
--     * Slot: RNA product_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "RNA product_provided_by" Description: ""
--     * Slot: RNA product_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "RNA product_category" Description: ""
--     * Slot: RNA product_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "RNA product_type" Description: ""
--     * Slot: RNA product_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "RNA product_has_attribute" Description: ""
--     * Slot: RNA product_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "RNA product isoform_synonym" Description: ""
--     * Slot: RNA product isoform_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "RNA product isoform_xref" Description: ""
--     * Slot: RNA product isoform_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "RNA product isoform_in_taxon" Description: ""
--     * Slot: RNA product isoform_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "RNA product isoform_provided_by" Description: ""
--     * Slot: RNA product isoform_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "RNA product isoform_category" Description: ""
--     * Slot: RNA product isoform_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "RNA product isoform_type" Description: ""
--     * Slot: RNA product isoform_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "RNA product isoform_has_attribute" Description: ""
--     * Slot: RNA product isoform_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "noncoding RNA product_synonym" Description: ""
--     * Slot: noncoding RNA product_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "noncoding RNA product_xref" Description: ""
--     * Slot: noncoding RNA product_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "noncoding RNA product_in_taxon" Description: ""
--     * Slot: noncoding RNA product_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "noncoding RNA product_provided_by" Description: ""
--     * Slot: noncoding RNA product_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "noncoding RNA product_category" Description: ""
--     * Slot: noncoding RNA product_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "noncoding RNA product_type" Description: ""
--     * Slot: noncoding RNA product_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "noncoding RNA product_has_attribute" Description: ""
--     * Slot: noncoding RNA product_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "microRNA_synonym" Description: ""
--     * Slot: microRNA_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "microRNA_xref" Description: ""
--     * Slot: microRNA_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "microRNA_in_taxon" Description: ""
--     * Slot: microRNA_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "microRNA_provided_by" Description: ""
--     * Slot: microRNA_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "microRNA_category" Description: ""
--     * Slot: microRNA_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "microRNA_type" Description: ""
--     * Slot: microRNA_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "microRNA_has_attribute" Description: ""
--     * Slot: microRNA_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "siRNA_synonym" Description: ""
--     * Slot: siRNA_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "siRNA_xref" Description: ""
--     * Slot: siRNA_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "siRNA_in_taxon" Description: ""
--     * Slot: siRNA_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "siRNA_provided_by" Description: ""
--     * Slot: siRNA_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "siRNA_category" Description: ""
--     * Slot: siRNA_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "siRNA_type" Description: ""
--     * Slot: siRNA_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "siRNA_has_attribute" Description: ""
--     * Slot: siRNA_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "gene grouping mixin_has_gene_or_gene_product" Description: ""
--     * Slot: gene grouping mixin_id Description: Autocreated FK slot
--     * Slot: has_gene_or_gene_product_id Description: connects an entity with one or more gene or gene products
-- # Class: "gene family_has_gene_or_gene_product" Description: ""
--     * Slot: gene family_id Description: Autocreated FK slot
--     * Slot: has_gene_or_gene_product_id Description: connects an entity with one or more gene or gene products
-- # Class: "gene family_in_taxon" Description: ""
--     * Slot: gene family_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "gene family_provided_by" Description: ""
--     * Slot: gene family_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "gene family_xref" Description: ""
--     * Slot: gene family_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "gene family_synonym" Description: ""
--     * Slot: gene family_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "gene family_category" Description: ""
--     * Slot: gene family_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "gene family_type" Description: ""
--     * Slot: gene family_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "gene family_has_attribute" Description: ""
--     * Slot: gene family_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "zygosity_has_quantitative_value" Description: ""
--     * Slot: zygosity_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "zygosity_provided_by" Description: ""
--     * Slot: zygosity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "zygosity_xref" Description: ""
--     * Slot: zygosity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "zygosity_synonym" Description: ""
--     * Slot: zygosity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "zygosity_category" Description: ""
--     * Slot: zygosity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "zygosity_type" Description: ""
--     * Slot: zygosity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "zygosity_has_attribute" Description: ""
--     * Slot: zygosity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "genotype_in_taxon" Description: ""
--     * Slot: genotype_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "genotype_provided_by" Description: ""
--     * Slot: genotype_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "genotype_xref" Description: ""
--     * Slot: genotype_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "genotype_synonym" Description: ""
--     * Slot: genotype_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "genotype_category" Description: ""
--     * Slot: genotype_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "genotype_type" Description: ""
--     * Slot: genotype_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "genotype_has_attribute" Description: ""
--     * Slot: genotype_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "haplotype_in_taxon" Description: ""
--     * Slot: haplotype_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "haplotype_provided_by" Description: ""
--     * Slot: haplotype_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "haplotype_xref" Description: ""
--     * Slot: haplotype_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "haplotype_synonym" Description: ""
--     * Slot: haplotype_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "haplotype_category" Description: ""
--     * Slot: haplotype_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "haplotype_type" Description: ""
--     * Slot: haplotype_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "haplotype_has_attribute" Description: ""
--     * Slot: haplotype_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "sequence variant_has_gene" Description: ""
--     * Slot: sequence variant_id Description: Autocreated FK slot
--     * Slot: has_gene_id Description: Each allele can be associated with any number of genes
-- # Class: "sequence variant_in_taxon" Description: ""
--     * Slot: sequence variant_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "sequence variant_provided_by" Description: ""
--     * Slot: sequence variant_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "sequence variant_xref" Description: ""
--     * Slot: sequence variant_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "sequence variant_synonym" Description: ""
--     * Slot: sequence variant_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "sequence variant_category" Description: ""
--     * Slot: sequence variant_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "sequence variant_type" Description: ""
--     * Slot: sequence variant_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "sequence variant_has_attribute" Description: ""
--     * Slot: sequence variant_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "snv_has_gene" Description: ""
--     * Slot: snv_id Description: Autocreated FK slot
--     * Slot: has_gene_id Description: Each allele can be associated with any number of genes
-- # Class: "snv_in_taxon" Description: ""
--     * Slot: snv_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "snv_provided_by" Description: ""
--     * Slot: snv_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "snv_xref" Description: ""
--     * Slot: snv_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "snv_synonym" Description: ""
--     * Slot: snv_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "snv_category" Description: ""
--     * Slot: snv_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "snv_type" Description: ""
--     * Slot: snv_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "snv_has_attribute" Description: ""
--     * Slot: snv_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "reagent targeted gene_in_taxon" Description: ""
--     * Slot: reagent targeted gene_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "reagent targeted gene_provided_by" Description: ""
--     * Slot: reagent targeted gene_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "reagent targeted gene_xref" Description: ""
--     * Slot: reagent targeted gene_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "reagent targeted gene_synonym" Description: ""
--     * Slot: reagent targeted gene_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "reagent targeted gene_category" Description: ""
--     * Slot: reagent targeted gene_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "reagent targeted gene_type" Description: ""
--     * Slot: reagent targeted gene_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "reagent targeted gene_has_attribute" Description: ""
--     * Slot: reagent targeted gene_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "clinical attribute_has_quantitative_value" Description: ""
--     * Slot: clinical attribute_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "clinical attribute_provided_by" Description: ""
--     * Slot: clinical attribute_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "clinical attribute_xref" Description: ""
--     * Slot: clinical attribute_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "clinical attribute_synonym" Description: ""
--     * Slot: clinical attribute_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "clinical attribute_category" Description: ""
--     * Slot: clinical attribute_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "clinical attribute_type" Description: ""
--     * Slot: clinical attribute_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "clinical attribute_has_attribute" Description: ""
--     * Slot: clinical attribute_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "clinical measurement_has_quantitative_value" Description: ""
--     * Slot: clinical measurement_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "clinical measurement_provided_by" Description: ""
--     * Slot: clinical measurement_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "clinical measurement_xref" Description: ""
--     * Slot: clinical measurement_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "clinical measurement_synonym" Description: ""
--     * Slot: clinical measurement_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "clinical measurement_category" Description: ""
--     * Slot: clinical measurement_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "clinical measurement_type" Description: ""
--     * Slot: clinical measurement_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "clinical measurement_has_attribute" Description: ""
--     * Slot: clinical measurement_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "clinical modifier_has_quantitative_value" Description: ""
--     * Slot: clinical modifier_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "clinical modifier_provided_by" Description: ""
--     * Slot: clinical modifier_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "clinical modifier_xref" Description: ""
--     * Slot: clinical modifier_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "clinical modifier_synonym" Description: ""
--     * Slot: clinical modifier_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "clinical modifier_category" Description: ""
--     * Slot: clinical modifier_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "clinical modifier_type" Description: ""
--     * Slot: clinical modifier_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "clinical modifier_has_attribute" Description: ""
--     * Slot: clinical modifier_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "clinical course_has_quantitative_value" Description: ""
--     * Slot: clinical course_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "clinical course_provided_by" Description: ""
--     * Slot: clinical course_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "clinical course_xref" Description: ""
--     * Slot: clinical course_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "clinical course_synonym" Description: ""
--     * Slot: clinical course_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "clinical course_category" Description: ""
--     * Slot: clinical course_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "clinical course_type" Description: ""
--     * Slot: clinical course_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "clinical course_has_attribute" Description: ""
--     * Slot: clinical course_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "onset_has_quantitative_value" Description: ""
--     * Slot: onset_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "onset_provided_by" Description: ""
--     * Slot: onset_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "onset_xref" Description: ""
--     * Slot: onset_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "onset_synonym" Description: ""
--     * Slot: onset_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "onset_category" Description: ""
--     * Slot: onset_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "onset_type" Description: ""
--     * Slot: onset_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "onset_has_attribute" Description: ""
--     * Slot: onset_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "clinical entity_provided_by" Description: ""
--     * Slot: clinical entity_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "clinical entity_xref" Description: ""
--     * Slot: clinical entity_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "clinical entity_synonym" Description: ""
--     * Slot: clinical entity_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "clinical entity_category" Description: ""
--     * Slot: clinical entity_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "clinical entity_type" Description: ""
--     * Slot: clinical entity_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "clinical entity_has_attribute" Description: ""
--     * Slot: clinical entity_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "clinical trial_provided_by" Description: ""
--     * Slot: clinical trial_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "clinical trial_xref" Description: ""
--     * Slot: clinical trial_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "clinical trial_synonym" Description: ""
--     * Slot: clinical trial_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "clinical trial_category" Description: ""
--     * Slot: clinical trial_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "clinical trial_type" Description: ""
--     * Slot: clinical trial_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "clinical trial_has_attribute" Description: ""
--     * Slot: clinical trial_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "clinical intervention_provided_by" Description: ""
--     * Slot: clinical intervention_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "clinical intervention_xref" Description: ""
--     * Slot: clinical intervention_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "clinical intervention_synonym" Description: ""
--     * Slot: clinical intervention_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "clinical intervention_category" Description: ""
--     * Slot: clinical intervention_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "clinical intervention_type" Description: ""
--     * Slot: clinical intervention_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "clinical intervention_has_attribute" Description: ""
--     * Slot: clinical intervention_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "clinical finding_in_taxon" Description: ""
--     * Slot: clinical finding_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "clinical finding_provided_by" Description: ""
--     * Slot: clinical finding_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "clinical finding_xref" Description: ""
--     * Slot: clinical finding_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "clinical finding_synonym" Description: ""
--     * Slot: clinical finding_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "clinical finding_category" Description: ""
--     * Slot: clinical finding_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "clinical finding_type" Description: ""
--     * Slot: clinical finding_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "clinical finding_has_attribute" Description: ""
--     * Slot: clinical finding_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "hospitalization_provided_by" Description: ""
--     * Slot: hospitalization_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "hospitalization_xref" Description: ""
--     * Slot: hospitalization_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "hospitalization_synonym" Description: ""
--     * Slot: hospitalization_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "hospitalization_category" Description: ""
--     * Slot: hospitalization_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "hospitalization_type" Description: ""
--     * Slot: hospitalization_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "hospitalization_has_attribute" Description: ""
--     * Slot: hospitalization_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "socioeconomic attribute_has_quantitative_value" Description: ""
--     * Slot: socioeconomic attribute_id Description: Autocreated FK slot
--     * Slot: has_quantitative_value_id Description: connects an attribute to a value
-- # Class: "socioeconomic attribute_provided_by" Description: ""
--     * Slot: socioeconomic attribute_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "socioeconomic attribute_xref" Description: ""
--     * Slot: socioeconomic attribute_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "socioeconomic attribute_synonym" Description: ""
--     * Slot: socioeconomic attribute_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "socioeconomic attribute_category" Description: ""
--     * Slot: socioeconomic attribute_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "socioeconomic attribute_type" Description: ""
--     * Slot: socioeconomic attribute_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "socioeconomic attribute_has_attribute" Description: ""
--     * Slot: socioeconomic attribute_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: connects any entity to an attribute
-- # Class: "case_in_taxon" Description: ""
--     * Slot: case_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "case_provided_by" Description: ""
--     * Slot: case_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "case_xref" Description: ""
--     * Slot: case_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two NamedThings.  This property should point to a database record or webpage that supports the existence of the edge, or gives more detail about the edge. This property can be used on a node or edge to provide multiple URIs or CURIE cross references.
-- # Class: "case_synonym" Description: ""
--     * Slot: case_id Description: Autocreated FK slot
--     * Slot: synonym Description: Alternate human-readable names for a thing
-- # Class: "case_category" Description: ""
--     * Slot: case_id Description: Autocreated FK slot
--     * Slot: category Description: Name of the high level ontology class in which this entity is categorized. Corresponds to the label for the biolink entity type class. In a neo4j database this MAY correspond to the neo4j label tag. In an RDF database it should be a biolink model class URI. This field is multi-valued. It should include values for ancestors of the biolink class; for example, a protein such as Shh would have category values `biolink:Protein`, `biolink:GeneProduct`, `biolink:MolecularEntity`. In an RDF database, nodes will typically have an rdf:type triples. This can be to the most specific biolink class, or potentially to a class more specific than something in biolink. For example, a sequence feature `f` may have a rdf:type assertion to a SO class such as TF_binding_site, which is more specific than anything in biolink. Here we would have categories {biolink:GenomicEntity, biolink:MolecularEntity, biolink:NamedThing}
-- # Class: "case_type" Description: ""
--     * Slot: case_id Description: Autocreated FK slot
--     * Slot: type Description: 
-- # Class: "case_has_attribute" Description: ""
--     * Slot: case_id Description: Autocreated FK slot
--     * Slot: has_attribute_id Description: may often be an organism attribute
-- # Class: "cohort_in_taxon" Description: ""
--     * Slot: cohort_id Description: Autocreated FK slot
--     * Slot: in_taxon_id Description: connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'
-- # Class: "cohort_provided_by" Description: ""
--     * Slot: cohort_id Description: Autocreated FK slot
--     * Slot: provided_by Description: The value in this node property represents the knowledge provider that created or assembled the node and all of its attributes.  Used internally to represent how a particular node made its way into a knowledge provider or graph.
-- # Class: "cohort_xref" Description: ""
--     * Slot: cohort_id Description: Autocreated FK slot
--     * Slot: xref Description: A database cross reference or alternative identifier for a NamedThing or edge between two Name