#!/usr/bin/env tclsh

#sbatch --account=lensktiPrj
#SBATCH --mail-user=mdekstrand@drexel.edu
#SBATCH -n 1
#SBATCH -c 8

if {[info exists info(HOSTNAME)]} {
    set host $info(HOSTNAME)
} else {
    set host [exec hostname 2>@stderr]
    set host [string trim $host]
}
puts "#R running on host $host"

foreach name [array names env] {
    if {[string match SLURM_* $name]} {
        puts stderr "#E $name=$env($name)"
    }
}

if {[info exists env(SLURM_JOB_CPUS_PER_NODE)]} {
    set ntasks $env(SLURM_JOB_CPUS_PER_NODE)
    set nthr $ntasks
    if {$nthr > 8} {
        set nthr 8
    }
    puts stderr "#R invoked with $ntasks CPUs"
    puts stderr "#R running with $nthr threads"
    set env(MKL_NUM_THREADS) $nthr
    set env(OMP_NUM_THREADS) $nthr
    puts stderr "#R using $ntasks LensKit tasks"
    set env(LK_NUM_PROCS) $ntasks
}
set env(MKL_THREADING_LAYER) tbb

puts stderr "#R running: [join $argv]"
exec {*}$argv >@stdout 2>@stderr
