import argparse
import os
import time
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

plotlocation = './plots/'


def plot_results(location, metric):
    li = []
    for l in os.listdir(location):
        df2 = pd.read_csv(os.path.join(location, l), index_col=None)
        print(l)
        l_split = l.split('+')
        df2['algo'] = l_split[0]
        model = ''
        rerank = l_split[1].split('_')[0]
        if len(l_split) > 2:
            model = l_split[2].split('_')[0]
            rerank = l_split[1]
        if model == '':
            model = 'Probabilistic'
        df2['model'] = model
        df2['rerank'] = rerank
        li.append(df2)
    df = pd.concat(li, axis=0, ignore_index=True)
    df2 = df[['iter', 'model', 'algo', 'rerank', metric]]
    df2 = df2[df2['iter'] != 0]
    df2 = df2[df2['rerank'] != 'lambdaRerank5']
    df2 = df2[df2['rerank'] != 'lambdaRerank10']

    os.makedirs(plotlocation, exist_ok=True)

    g = sns.relplot(data=df2, x="iter", y=metric, hue='algo', row='model', col="rerank", kind="line")  #, col_wrap = 3)
    g.savefig(plotlocation + metric + '_' + str(time.strftime("%Y%m%d-%H%M%S")) + '.pdf', bbox_inches='tight')

    g = sns.relplot(data=df2, x="iter", y=metric, hue='rerank', col="algo", kind="line")  #, col_wrap = 3)
    g.savefig(plotlocation + metric + '_' + str(time.strftime("%Y%m%d-%H%M%S")) + '.pdf', bbox_inches='tight')


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Plot results')
    parser.add_argument('-l', '--location', type=str,
                        help='location of file with result')
    parser.add_argument('-m', '--metric', type=str,
                        help='metric to use for the plot')

    args = parser.parse_args()
    plot_results(args.location, args.metric)
