import argparse
import os
import time
import pandas as pd
import matplotlib.pyplot as plt

plotlocation = './plots/'

def plot_results(location, metric):
    li = []
    for l in os.listdir(location):
        df2 = pd.read_csv(os.path.join(location,l), index_col=None)
        print (l)

        df2['model'] = l.replace('.csv', '')
        li.append(df2)
    df = pd.concat(li, axis=0, ignore_index=True)
    df2 = df[['iter', 'model', metric]]
    plot_df = (
        df2.pivot(index='iter', columns='model')
    )

    fig = plot_df.plot.line(title=f'{metric}', label='model').get_figure()
    fig.get_axes()[0].set_ylabel(metric)
    plt.legend([i[1].split('_')[0] for i in plot_df.columns], loc='upper center', bbox_to_anchor=(0.5, -0.05))

    fig.savefig(plotlocation+metric+'_'+str(time.strftime("%Y%m%d-%H%M%S"))+'.pdf', bbox_inches='tight')

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Plot results')
    parser.add_argument('-l', '--location', type=str,
                        help='location of file with result')
    parser.add_argument('-m', '--metric', type=str,
                        help='metric to use for the plot')
    
    args = parser.parse_args()
    plot_results(args.location, args.metric)
