"""
Script utilities.
"""

import sys
import logging
from argparse import Namespace

def init_logging(args: Namespace) -> int:
    if args.verbose:
        level = logging.DEBUG
    else:
        level = logging.INFO
    logging.basicConfig(stream=sys.stderr, level=level)
    # numba is noisy, turn off its debug messages even in verbose mode
    logging.getLogger('numba').setLevel(logging.INFO)
    return level

