import os
import pickle
import numpy as np
import argparse

from gbsim.eval import show_eval, save_eval

def load_initial(location):
    data_to_load = {"fan_test_data":None, "sum_listen":None, "fan_items_dict":None, "items_gender":None}
    for file_name in data_to_load:
        data = pickle.load(open(os.path.join(location, f"{file_name}.pkl"), 'rb'))
        data_to_load[file_name] = data
    return data_to_load


def load_iteration(location, iteration):
    loaded = np.load(os.path.join(location, iteration, "predicted.npz"))
    changes = pickle.load(open(os.path.join(location, iteration, "changes.pkl"), 'rb'))
    return loaded['data'], changes


def run_evaluation(location, output):
    iterations = [f.name for f in os.scandir(location) if f.is_dir()]
    data = load_initial(location)
    all_rets = []
    for iter in iterations:
        predicted, changes = load_iteration(location, iter)
        res = show_eval(predicted, data['fan_test_data'], data['fan_items_dict'],
                                data['items_gender'], data['sum_listen'], changes)
        all_rets.append(res)
    # Save results
    save_eval(all_rets, output, os.path.basename(location))


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Eval predicted recommendations.')
    parser.add_argument('-l', "--location")
    parser.add_argument('-o', "--output")
    args = parser.parse_args()
    run_evaluation(args.location, args.output)
