from scipy.stats import zipfian, loguniform, randint
from gbsim.torchimfsamp import TorchSampledMF


space = [
    # log-uniform (Zipf) distribution [5, 250]
    ('features', zipfian(1, 246, loc=4)),
    ('reg', loguniform(1.0e-5, 10)),
    ('epochs', randint(1, 15)),
]

def default():
    return TorchSampledMF(50, loss='bpr')

def from_params(features, reg, epochs, **kwargs):
    return TorchSampledMF(features, epochs=epochs, reg=reg, loss='bpr')