from scipy.stats import zipfian, loguniform, randint
from lenskit.algorithms.als import ImplicitMF


space = [
    # log-uniform (Zipf) distribution [5, 250]
    ('features', zipfian(1, 246, loc=4)),
    ('ureg', loguniform(1.0e-5, 10)),
    ('ireg', loguniform(1.0e-5, 10)),
    ('epochs', randint(10, 30)),
]

def default():
    return ImplicitMF(50, loss='bpr')

def from_params(features, ureg, ireg, epochs, **kwargs):
    return ImplicitMF(features, iterations=epochs, reg=(ureg,ireg))