## Description

This is the code from our RecSys 2024 shoprt paper:

> Christine Bauer, Andrés Ferraro, and Michael D. Ekstrand. 2024. It's Not You, It's Me: The Impact of Choice Models and Ranking Strategies on Gender Imbalance in Music Recommendation. In <cite>Proceedings of the 18th ACM Conference on Recommender Systems</cite> (RecSys '24). ACM. DOI [10.1145/3640457.3688163](https://dl.acm.org/doi/10.1145/3640457.3688163). arXiv:[2409.03781](https://arxiv.org/abs/2409.03781) [cs.IR]. 

## Environment Setup

The environment is specified by `environment.yml`. This can be used as-is on
Linux, but we have a locked dependency set with `conda-lock.`  To install:

    conda lock install -n music-sim

If you don't have `conda-lock` installed yet, do:

    conda install -n base -c conda-forge conda-lock

You can also directly install with `micromamba`:

    micromamba create -n music-sim -f conda-lock.yml

## Instructions

1.  Place your copy of the LastFM 2B data set in `data/lfm-2b`.  This data set
    is no longer publicly available for download, but those who have a copy can
    use it to reproduce our work.

2.  Re-run the scripts and experiments:

    ```console
    > dvc repro
    ```

    This will run the simulations, evaluate them, and produce the primary charts
    in the paper. 

