library(Seurat)
integration_velocity <- readRDS("single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/datasets/Integration/Integration_alpha0.8_cov0.5_clustered_focus_cholangiocytes_RNA_with_Hep_ctrl_matched_cell_velocity.rds")

DefaultAssay(integration_velocity) <- "RNA"
integration_velocity <- FindNeighbors(integration_velocity,dims = 1:30)
for(i in seq(0,1,0.1)){
  integration_velocity <- FindClusters(integration_velocity, resolution = i)
}
DimPlot(integration_velocity, group.by = "integrated_snn_res.0.5", label = T)



library(slingshot)
library(scales)
library(ggplot2)
library(viridis)
integration_velocity_diet <- DietSeurat(integration_velocity, graphs = "umap")
sce <- as.SingleCellExperiment(integration_velocity_diet)
Lin2 <- getLineages(sce, reducedDim = 'UMAP',clusterLabels = sce$integrated_snn_res.0.5, omega = TRUE, omega_scale = 1.55)
plot(reducedDims(sce)$UMAP,col = hue_pal()(length(levels(integration_velocity$integrated_snn_res.0.5)))[integration_velocity$integrated_snn_res.0.5], pch = 20, cex = 0.3)
lines(SlingshotDataSet(Lin2), lwd = 3, col = 'black', show.constraints = TRUE)
SlingshotDataSet(Lin2)
Lin2$slingshot@metadata$mst[]
Curves <- getCurves(Lin2)
plot(reducedDims(sce)$UMAP,col = hue_pal()(length(levels(integration_velocity$integrated_snn_res.0.5)))[integration_velocity$integrated_snn_res.0.5], pch = 20, cex = 0.3)
lines(SlingshotDataSet(Curves), lwd = 3, col = 'black', show.constraints = TRUE)

Lin1 <- getLineages(sce, reducedDim = 'UMAP',clusterLabels = sce$integrated_snn_res.0.5, omega = FALSE)
plot(reducedDims(sce)$UMAP,col = hue_pal()(length(levels(integration_velocity$integrated_snn_res.0.5)))[integration_velocity$integrated_snn_res.0.5], pch = 20, cex = 0.3)
lines(SlingshotDataSet(Lin1), lwd = 3, col = 'black', show.constraints = TRUE)
SlingshotDataSet(Lin1)
Lin2$slingshot@metadata$mst[]
Curves1 <- getCurves(Lin1)
plot(reducedDims(sce)$UMAP,col = hue_pal()(length(levels(integration_velocity$integrated_snn_res.0.5)))[integration_velocity$integrated_snn_res.0.5], pch = 20, cex = 0.3)
lines(SlingshotDataSet(Curves1), lwd = 3, col = 'black', show.constraints = TRUE)


pt <- slingPseudotime(Curves)
nms <- colnames(pt)
pal <- viridis(100, end = 0.95)
par(mfrow = c(2, 2))
for (i in nms) {
  colors <- pal[cut(pt[,i], breaks = 100)]
  plot(reducedDim(Curves), col = colors, pch = 16, cex = 0.5, main = i)
  lines(SlingshotDataSet(Lin2), lwd = 2, col = 'black', type = 'lineages')
}
slingPseudotime(Curves)
integration_velocity[["slingshot_lineage1"]] <- as.data.frame(slingPseudotime(Curves)[,1])
integration_velocity[["slingshot_lineage2"]] <- as.data.frame(slingPseudotime(Curves)[,2])
integration_velocity[["slingshot_lineage3"]] <- as.data.frame(slingPseudotime(Curves)[,3])
integration_velocity[["slingshot_lineage4"]] <- as.data.frame(slingPseudotime(Curves)[,4])

integration_velocity[["Pseudotime_slingshot"]] <- slingAvgPseudotime(Curves)

FeaturePlot(integration_velocity, features = "Pseudotime_slingshot")

library(SeuratDisk)
SaveH5Seurat(integration_velocity, filename= "integration_with_clustering.h5Seurat")
Convert("integration_with_clustering.h5Seurat", dest = "h5ad")

#### extract DDC cells from 2nd lineage of slingshot
tmp <- subset(integration_velocity, subset= slingshot_lineage2 != "NA" & dataset == "GSE157698")
Cells(tmp)
DefaultAssay(tmp) <- "RNA"
test <- as.matrix(tmp@assays$RNA@data)

hist(test,main = "Histogram logNormalize", xlab = "lineage 2 DDC cells", breaks = 100)
hist(tmp@assays$RNA@data@x,main = "Histogram logNormalize", xlab = "lineage 2 DDC cells", breaks = 100)
library(SeuratDisk)
SaveH5Seurat(tmp, filename= "DDC_cells_slingshot_lineage2.h5Seurat", overwrite = T)
Convert("DDC_cells_slingshot_lineage2.h5Seurat", dest = "h5ad")

DDC_lineage2 <- tmp
saveRDS(DDC_lineage2, "Integration_alpha0.8_cov0.5_clustered_focus_cholangiocytes_RNA_focus_DDC_cells_Slingshot_lineage2.rds")

