library(Seurat)
library(ggplot2)
library(dplyr)

##GSE157698 labelling
GSE157698 <- readRDS("GSE157698_filtered.rds")
f.clusters <- rep("Unknown", dim(GSE157698)[2])
names(f.clusters) <- colnames(GSE157698)
f.clusters[GSE157698$type %in% "Hepato" & GSE157698$orig.ident %in% "YFPw2" ] <- "Hep_YFP_Adult_DDC2wks"
f.clusters[GSE157698$type %in% "BEC" & GSE157698$orig.ident %in% "YFPw2"] <- "Hep_YFP_Adult_DDC2wks"
f.clusters[GSE157698$type %in% "Hepato" & GSE157698$orig.ident %in% "bulkw2"] <- "Hep_Adult_DDC2wks"
f.clusters[GSE157698$type %in% "BEC" & GSE157698$orig.ident %in% "bulkw2"] <- "BEC_Adult_DDC2wks"
f.clusters[GSE157698$type %in% "Hepato" & GSE157698$orig.ident %in% "YFPw3" ] <- "Hep_YFP_Adult_DDC3wks"
f.clusters[GSE157698$type %in% "BEC" & GSE157698$orig.ident %in% "YFPw3"] <- "Hep_YFP_Adult_DDC3wks"
f.clusters[GSE157698$type %in% "Hepato" & GSE157698$orig.ident %in% "bulkw3"] <- "Hep_Adult_DDC3wks"
f.clusters[GSE157698$type %in% "BEC" & GSE157698$orig.ident %in% "bulkw3"] <- "BEC_Adult_DDC3wks"
f.clusters[GSE157698$type %in% "Hepato" & GSE157698$orig.ident %in% "YFPw4" ] <- "Hep_YFP_Adult_DDC4wks"
f.clusters[GSE157698$type %in% "BEC" & GSE157698$orig.ident %in% "YFPw4"] <- "Hep_YFP_Adult_DDC4wks"
f.clusters[GSE157698$type %in% "Hepato" & GSE157698$orig.ident %in% "bulkw4"] <- "Hep_Adult_DDC4wks"
f.clusters[GSE157698$type %in% "BEC" & GSE157698$orig.ident %in% "bulkw4"] <- "BEC_Adult_DDC4wks"
f.clusters[GSE157698$type %in% "Hepato" & GSE157698$orig.ident %in% "YFPw6" ] <- "Hep_YFP_Adult_DDC6wks"
f.clusters[GSE157698$type %in% "BEC" & GSE157698$orig.ident %in% "YFPw6"] <- "Hep_YFP_Adult_DDC6wks"
f.clusters[GSE157698$type %in% "Hepato" & GSE157698$orig.ident %in% "bulkw6"] <- "Hep_Adult_DDC6wks"
f.clusters[GSE157698$type %in% "BEC" & GSE157698$orig.ident %in% "bulkw6"] <- "BEC_Adult_DDC6wks"
GSE157698[["labelling_semi_supervised"]] <- f.clusters
f.labelling <- rep("Unknown", dim(GSE157698)[2])
f.labelling[GSE157698$labelling_semi_supervised %in% "Hep_YFP_Adult_DDC2wks"] <- "Hep_YFP_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "Hep_YFP_Adult_DDC3wks"] <- "Hep_YFP_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "Hep_YFP_Adult_DDC4wks"] <- "Hep_YFP_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "Hep_YFP_Adult_DDC6wks"] <- "Hep_YFP_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "Hep_Adult_DDC2wks"] <- "Hep_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "Hep_Adult_DDC3wks"] <- "Hep_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "Hep_Adult_DDC4wks"] <- "Hep_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "Hep_Adult_DDC6wks"] <- "Hep_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "BEC_Adult_DDC2wks"] <- "BEC_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "BEC_Adult_DDC3wks"] <- "BEC_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "BEC_Adult_DDC4wks"] <- "BEC_Adult_DDC"
f.labelling[GSE157698$labelling_semi_supervised %in% "BEC_Adult_DDC6wks"] <- "BEC_Adult_DDC"
GSE157698[["labelling_digest"]] <- f.labelling
saveRDS(GSE157698,"GSE157698_labelled_filtered.rds")


##GSE151309 labelling

GSE151309 <- readRDS("GSE151309_filtered.rds")
f.clusters <- rep("Unknown", dim(GSE151309)[2])
names(f.clusters) <- colnames(GSE151309)
f.clusters[GSE151309$condition %in% "Hepato"] <- "Hep_Adult"
f.clusters[GSE151309$condition %in% "P14"] <- "Hep_D14"
f.clusters[GSE151309$condition %in% "PHx24"] <- "Hep_Adult_PHx24h"
f.clusters[GSE151309$condition %in% "PHx96"] <- "Hep_Adult_PHx96h"
f.clusters[GSE151309$condition %in% "PHx48"] <- "Hep_Adult_PHx48h"
GSE151309[["labelling_semi_supervised"]] <- f.clusters
f.labelling <- rep("Unknown", dim(GSE151309)[2])
f.labelling[GSE151309$labelling_semi_supervised %in% "Hep_Adult"] <- "Hep_Adult"
f.labelling[GSE151309$labelling_semi_supervised %in% "Hep_Adult_PHx24"] <- "Hep_Adult_PHx"
f.labelling[GSE151309$labelling_semi_supervised %in% "Hep_Adult_PHx48"] <- "Hep_Adult_PHx"
f.labelling[GSE151309$labelling_semi_supervised %in% "Hep_Adult_PHx96"] <- "Hep_Adult_PHx"
f.labelling[GSE151309$labelling_semi_supervised %in% "Hep_D14"] <- "Hep_PostNatal"
GSE151309[["labelling_digest"]] <- f.labelling
saveRDS(GSE151309,"GSE151309_labelled_filtered.rds")


##GSE158866 labelling
GSE158866 <- readRDS("GSE158866_filtered.rds")
f.clusters <- rep("Unknown", dim(GSE158866)[2])
names(f.clusters) <- colnames(GSE158866)
f.clusters[GSE158866$type %in% "PHx0"] <- "Hep_Adult"
f.clusters[GSE158866$type %in% "PHx48h"] <- "Hep_Adult_PHx48h"
GSE158866[["labelling_semi_supervised"]] <- f.clusters

f.labelling <- rep("Unknown", dim(GSE158866)[2])
f.labelling[GSE158866$labelling_semi_supervised %in% "Hep_Adult"] <- "Hep_Adult"
f.labelling[GSE158866$labelling_semi_supervised %in% "Hep_Adult_PHx48"] <- "Hep_Adult_PHx"
GSE158866[["labelling_digest"]] <- f.labelling
saveRDS(GSE158866,"GSE158866_labelled_filtered.rds")


##GSE136679 labelling
GSE136679 <- readRDS("GSE136679_filtered.rds")
f.clusters <- rep("Unknown", dim(GSE136679)[2])
names(f.clusters) <- colnames(GSE136679)
f.clusters[GSE136679$condition %in% "A24"] <- "Hep_Adult_A24h"
f.clusters[GSE136679$condition %in% "A48"] <- "Hep_Adult_A48h"
f.clusters[GSE136679$condition %in% "A6"] <- "Hep_Adult_A6h"
f.clusters[GSE136679$condition %in% "A96"] <- "Hep_Adult_A96h"
f.clusters[GSE136679$condition %in% "Hepato"] <- "Hep_Adult"
f.clusters[GSE136679$condition %in% "PH120"] <- "Hep_Adult_PHx120h"
f.clusters[GSE136679$condition %in% "PH3"] <- "Hep_Adult_PHx3h"
f.clusters[GSE136679$condition %in% "PHx48"] <- "Hep_Adult_PHx48h"
GSE136679[["labelling_semi_supervised"]] <- f.clusters
f.clusters <- rep("Unknown", dim(GSE136679)[2])
f.clusters[GSE136679$labelling_semi_supervised %in% "Hep_Adult_A24"] <- "Hep_Adult_APAP"
f.clusters[GSE136679$labelling_semi_supervised %in% "Hep_Adult_A48"] <- "Hep_Adult_APAP"
f.clusters[GSE136679$labelling_semi_supervised %in% "Hep_Adult_A6"] <- "Hep_Adult_APAP"
f.clusters[GSE136679$labelling_semi_supervised %in% "Hep_Adult_A96"] <- "Hep_Adult_APAP"
f.clusters[GSE136679$labelling_semi_supervised %in% "Hep_Adult_Control"] <- "Hep_Adult"
f.clusters[GSE136679$labelling_semi_supervised %in% "Hep_Adult_PHx3"] <- "Hep_Adult_PHx"
f.clusters[GSE136679$labelling_semi_supervised %in% "Hep_Adult_PHx48"] <- "Hep_Adult_PHx"
f.clusters[GSE136679$labelling_semi_supervised %in% "Hep_Adult_PHx120"] <- "Hep_Adult_PHx"
GSE136679[["labelling_digest"]] <- f.clusters
saveRDS(GSE171993,"GSE136679_labelled_filtered.rds")



##GSE171993 labelling
GSE171993 <- readRDS("GSE171993_filtered.rds")
f.clusters <- rep("Unknown", dim(GSE171993)[2])
names(f.clusters) <- colnames(GSE171993)
f.clusters[GSE171993$SCT_snn_res.0.2 %in% "6"] <- "BEC"
f.clusters[GSE171993$SCT_snn_res.0.2 %in% c("1","3")] <- "Hepato_post_natal"
f.clusters[GSE171993$SCT_snn_res.0.2 %in% c("0", "4", "2" ,"7", "5" ,"8" , "9")] <- "Hepato_D56"
GSE171993[["type"]] <- f.clusters

GSE171993$barcode[which(GSE171993$condition == "D56" & GSE171993$type != "BEC")] <- "GSE171993_Hep_D56"
GSE171993$barcode[which(GSE171993$condition == "D56" & GSE171993$type == "BEC")] <- "GSE171993_BEC_D56"
GSE171993$barcode[which(GSE171993$condition == "D1" & GSE171993$type == "BEC")] <- "GSE171993_BEC_D1"
GSE171993$barcode[which(GSE171993$condition == "D1" & GSE171993$type != "BEC")] <- "GSE171993_Hep_D1"
GSE171993$barcode[which(GSE171993$condition == "D3" & GSE171993$type == "BEC")] <- "GSE171993_BEC_D3"
GSE171993$barcode[which(GSE171993$condition == "D3" & GSE171993$type != "BEC")] <- "GSE171993_Hep_D3"
GSE171993$barcode[which(GSE171993$condition == "D7" & GSE171993$type == "BEC")] <- "GSE171993_BEC_D7"
GSE171993$barcode[which(GSE171993$condition == "D7" & GSE171993$type != "BEC")] <- "GSE171993_Hep_D7"
f.clusters <- rep("Unknown", dim(GSE171993)[2])
f.clusters[GSE171993$barcode %in% "GSE171993_Hep_D56"] <- "Hep_PostNatal"
f.clusters[GSE171993$barcode %in% "GSE171993_Hep_D1"] <- "Hep_PostNatal"
f.clusters[GSE171993$barcode %in% "GSE171993_Hep_D3"] <- "Hep_PostNatal"
f.clusters[GSE171993$barcode %in% "GSE171993_Hep_D7"] <- "Hep_PostNatal"
f.clusters[GSE171993$barcode %in% "GSE171993_BEC_D56"] <- "BEC_PostNatal"
f.clusters[GSE171993$barcode %in% "GSE171993_BEC_D1"] <- "BEC_PostNatal"
f.clusters[GSE171993$barcode %in% "GSE171993_BEC_D3"] <- "BEC_PostNatal"
f.clusters[GSE171993$barcode %in% "GSE171993_BEC_D7"] <- "BEC_PostNatal"
GSE171993[["labelling_digest"]] <- f.clusters
f.clusters <- rep("Unknown", dim(GSE171993)[2])
f.clusters[GSE171993$barcode %in% "GSE171993_Hep_D56"] <- "Hep_D56"
f.clusters[GSE171993$barcode %in% "GSE171993_Hep_D1"] <- "Hep_D1"
f.clusters[GSE171993$barcode %in% "GSE171993_Hep_D3"] <- "Hep_D3"
f.clusters[GSE171993$barcode %in% "GSE171993_Hep_D7"] <- "Hep_D7"
f.clusters[GSE171993$barcode %in% "GSE171993_BEC_D56"] <- "BEC_D56"
f.clusters[GSE171993$barcode %in% "GSE171993_BEC_D1"] <- "BEC_D1"
f.clusters[GSE171993$barcode %in% "GSE171993_BEC_D3"] <- "BEC_D3"
f.clusters[GSE171993$barcode %in% "GSE171993_BEC_D7"] <- "BEC_D7"
GSE171993[["labelling_semi_supervised"]] <- f.clusters
saveRDS(GGSE171993,"GSE171993_labelled_filtered.rds")

##GSE192742 labelling
GSE192742 <- readRDS("GSE192742_NAFLD_filtered.rds")
GSE192742[["type"]] <-GSE192742$annot
GSE192742$type[which(GSE192742$type == "Hepatocytes")] <- "Hepato"
GSE192742$type[which(GSE192742$type == "Cholangiocytes")] <- "BEC"
f.clusters <- rep("Unknown", dim(GSE192742)[2])
names(f.clusters) <- colnames(GSE192742)
f.clusters[GSE192742$type %in% "Hepato"] <- "GSE192742_Hep_Adult_NAFLD"
f.clusters[GSE192742$type %in% "BEC"] <- "GSE192742_BEC_Adult_NAFLD"
GSE192742[["barcode"]] <- f.clusters

f.clusters <- rep("Unknown", dim(GSE192742)[2])
f.clusters[GSE192742$barcode %in% "GSE192742_Hep_Adult_NAFLD"] <- "Hep_Adult_NAFLD"
f.clusters[GSE192742$barcode %in% "GSE192742_BEC_Adult_NAFLD"] <- "BEC_Adult_NAFLD"
GSE192742[["labelling_digest"]] <- f.clusters

f.clusters <- rep("Unknown", dim(GSE192742)[2])
names(f.clusters) <- colnames(GSE192742)
f.clusters[GSE192742$type %in% "Hepato"] <- "Hep_Adult_NAFLD"
f.clusters[GSE192742$type %in% "BEC"] <- "BEC_Adult_NAFLD"
GSE192742[["labelling_semi_supervised"]] <- f.clusters
saveRDS(GSE192742,"GSE192742_NAFLD_labelled_filtered.rds")

GSE192742_healthy <- readRDS("GSE192742_Healthy_filtered.rds")
GSE192742_healthy[["type"]] <-GSE192742_healthy$annot
GSE192742_healthy$type[which(GSE192742_healthy$type == "Hepatocytes")] <- "Hepato"
GSE192742_healthy$type[which(GSE192742_healthy$type == "Cholangiocytes")] <- "BEC"
f.clusters <- rep("Unknown", dim(GSE192742_healthy)[2])
names(f.clusters) <- colnames(GSE192742_healthy)
f.clusters[GSE192742_healthy$type %in% "Hepato"] <- "GSE192742_Hep_Adult"
f.clusters[GSE192742_healthy$type %in% "BEC"] <- "GSE192742_BEC_Adult"
GSE192742[["barcode"]] <- f.clusters
f.clusters <- rep("Unknown", dim(GSE192742_healthy)[2])
names(f.clusters) <- colnames(GSE192742_healthy)
f.clusters[GSE192742_healthy$type %in% "Hepato"] <- "Hep_Adult"
f.clusters[GSE192742_healthy$type %in% "BEC"] <- "BEC_Adult"
GSE192742_healthy[["labelling_semi_supervised"]] <- f.clusters
f.clusters <- rep("Unknown", dim(GSE192742)[2])
f.clusters[GSE192742_healthy$barcode %in% "GSE192742_Hep_Adult"] <- "Hep_Adult"
f.clusters[GSE192742_healthy$barcode %in% "GSE192742_BEC_Adult"] <- "BEC_Adult"
GSE192742_healthy[["labelling_digest"]] <- f.clusters
saveRDS(GSE192742_healthy,"GSE192742_Healthy_labelled_filtered.rds")

##GSE186554 labelling
GSE186554 <- readRDS("GSE186554_filtered.rds")
DimPlot(GSE186554,group.by = "orig.ident")
GSE186554[["type"]] <-"Hepato"
f.clusters <- rep("Unknown", dim(GSE186554)[2])
f.clusters[GSE186554$orig.ident %in% c("Control")] <- "GSE186554_Hep_Adult_Control"
f.clusters[GSE186554$orig.ident %in% c("LPS12h")] <- "GSE186554_Hep_Adult_LPS12"
f.clusters[GSE186554$orig.ident %in% c("LPS3h")] <- "GSE186554_Hep_Adult_LPS3"
GSE186554$barcode <- f.clusters

f.clusters[GSE186554$barcode %in% "GSE186554_Hep_Adult_Control"] <- "Hep_Adult"
f.clusters[GSE186554$barcode %in% "GSE186554_Hep_Adult_LPS12"] <- "Hep_Adult_LPS"
f.clusters[GSE186554$barcode %in% "GSE186554_Hep_Adult_LPS3"] <- "Hep_Adult_LPS"
GSE186554$labelling_digest <- f.clusters

f.clusters[GSE186554$orig.ident %in% c("Control")] <- "Hep_Adult"
f.clusters[GSE186554$orig.ident %in% c("LPS12h")] <- "Hep_Adult_LPS12h"
f.clusters[GSE186554$orig.ident %in% c("LPS3h")] <- "Hep_Adult_LPS3h"
GSE186554$labelling_semi_supervised <- f.clusters
saveRDS(GSE186554,"GSE186554_labelled_filtered.rds")

##zenodo6035873 labelling
zenodo6035873 <- readRDS("zenodo_6035873_filtered.rds")
DimPlot(zenodo6035873,group.by = "cell_type")
DimPlot(zenodo6035873,group.by = "time_point")
f.clusters <- rep("Unknown", dim(zenodo6035873)[2])
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "0"] <- "zenodo6035873_Hep_Adult_Control"
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "24"] <- "zenodo6035873_Hep_Adult_A24"
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "48"] <- "zenodo6035873_Hep_Adult_A48"
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "72"] <- "zenodo6035873_Hep_Adult_A72"
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "96"] <- "zenodo6035873_Hep_Adult_A96"
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "168"] <- "zenodo6035873_Hep_Adult_A168"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "0"] <- "zenodo6035873_BEC_Adult_Control"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "24"] <- "zenodo6035873_BEC_Adult_A24"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "48"] <- "zenodo6035873_BEC_Adult_A48"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "72"] <- "zenodo6035873_BEC_Adult_A72"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "96"] <- "zenodo6035873_BEC_Adult_A96"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "168"] <- "zenodo6035873_BEC_Adult_A168"
zenodo6035873$barcode <- f.clusters

f.clusters[zenodo6035873$barcode %in% c("zenodo6035873_Hep_Adult_Control")] <- "Hep_Adult"
f.clusters[zenodo6035873$barcode %in% c("zenodo6035873_Hep_Adult_A24","zenodo6035873_Hep_Adult_A48","zenodo6035873_Hep_Adult_A72","zenodo6035873_Hep_Adult_A96","zenodo6035873_Hep_Adult_A168")] <- "Hep_Adult_APAP"
f.clusters[zenodo6035873$barcode %in% c("zenodo6035873_BEC_Adult_A24","zenodo6035873_BEC_Adult_A48","zenodo6035873_BEC_Adult_A72","zenodo6035873_BEC_Adult_A96","zenodo6035873_BEC_Adult_A168")] <- "BEC_Adult_APAP"
f.clusters[zenodo6035873$barcode %in% "zenodo6035873_BEC_Adult_Control"] <- "BEC_Adult"
zenodo6035873$labelling_digest <- f.clusters

f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "0"] <- "Hep_Adult"
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "24"] <- "Hep_Adult_A24h"
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "48"] <- "Hep_Adult_A48h"
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "72"] <- "Hep_Adult_A72h"
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "96"] <- "Hep_Adult_A96h"
f.clusters[zenodo6035873$cell_type %in% c("Hep") & zenodo6035873$time_point %in% "168"] <- "Hep_Adult_A168h"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "0"] <- "BEC_Adult"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "24"] <- "BEC_Adult_A24h"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "48"] <- "BEC_Adult_A48h"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "72"] <- "BEC_Adult_A72h"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "96"] <- "BEC_Adult_A96h"
f.clusters[zenodo6035873$cell_type %in% c("Chol") & zenodo6035873$time_point %in% "168"] <- "BEC_Adult_A168h"
zenodo6035873$labelling_semi_supervised <- f.clusters

saveRDS(zenodo6035873,"zenodo6035873_labelled_filtered.rds")

##CRA002445 labelling
CRA002445 <- readRDS("CRA002445_filtered.rds")
f.clusters <- rep("Unknown", dim(CRA002445)[2])
names(f.clusters) <- colnames(CRA002445)
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E11"] <- "CRA002445_Hepatoblast_E11"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E11.5"] <- "CRA002445_Hepatoblast_E11.5"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E13"] <- "CRA002445_Hepatoblast_E13"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E14.5"] <- "CRA002445_Hepatoblast_E14.5"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E16"] <- "CRA002445_Hepatoblast_E16"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E17.5"] <- "CRA002445_Hepatoblast_E17.5"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E11"] <- "CRA002445_BEC_E11"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E11.5"] <- "CRA002445_BEC_E11.5"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E13"] <- "CRA002445_BEC_E13"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E14.5"] <- "CRA002445_BEC_E14.5"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E16"] <- "CRA002445_BEC_E16"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E17.5"] <- "CRA002445_BEC_E17.5"
CRA002445[["barcode"]] <- f.clusters
f.clusters <- rep("Unknown", dim(CRA002445)[2])
names(f.clusters) <- colnames(CRA002445)
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E11"] <- "Hepatoblast_E11"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E11.5"] <- "Hepatoblast_E11.5"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E13"] <- "Hepatoblast_E13"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E14.5"] <- "Hepatoblast_E14.5"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E16"] <- "Hepatoblast_E16"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(0,1,2,3,4,5,6,7) & CRA002445$orig.ident %in% "E17.5"] <- "Hepatoblast_E17.5"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E11"] <- "BEC_E11"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E11.5"] <- "BEC_E11.5"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E13"] <- "BEC_E13"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E14.5"] <- "BEC_E14.5"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E16"] <- "BEC_E16"
f.clusters[CRA002445$SCT_snn_res.0.2 %in% c(8) & CRA002445$orig.ident %in% "E17.5"] <- "BEC_E17.5"
CRA002445[["labelling_semi_supervised"]] <- f.clusters

CRA002445$labelling_digest <- "Progenitors_Embryo"
saveRDS(CRA002445,"CRA002445_labelled_filtered.rds")
