suppressPackageStartupMessages({
  library(Biostrings)
  library(BSgenome)
  library(eisaR)
  library(GenomicFeatures)
  library(SummarizedExperiment)
  library(tximeta)
  library(rjson)
  library(reticulate)
  library(SingleCellExperiment)
  library(scater)
})

gtf <- "~/annotation/mus_musculus/ensembl/v108/Mus_musculus.GRCm39.108.gtf.gz"
grl <- eisaR::getFeatureRanges(
  gtf = gtf,
  featureType = c("spliced", "intron"), 
  intronType = "separate", 
  flankLength = 90L, 
  joinOverlappingIntrons = FALSE, 
  verbose = TRUE
)

grl[4:6]

genome <- Biostrings::readDNAStringSet(
  "single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus_musculus.GRCm39.dna.primary_assembly.fa"
)

names(genome) <- sapply(strsplit(names(genome), " "), .subset, 1)
seqs <- GenomicFeatures::extractTranscriptSeqs(
  x = genome, 
  transcripts = grl
)
Biostrings::writeXStringSet(
  seqs, filepath = "single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.fa"
)

eisaR::exportToGtf(
  grl, 
  filepath = "single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.gtf"
)
head(metadata(grl)$corrgene)

write.table(
  metadata(grl)$corrgene, 
  file = "single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.features.tsv",
  row.names = FALSE, col.names = TRUE, quote = FALSE, sep = "\t"
)

df <- eisaR::getTx2Gene(
  grl, filepath = "single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.tx2gene.tsv"
)


######## in bash ######
#grep ">" GRCm38.primary_assembly.genome.fa | cut -d ">" -f 2 | cut -d " " -f 1 > GRCm38.primary_assembly.genome.chrnames.txt

# salmon index \
# -t <(cat gencode.vM24.annotation.expanded.fa GRCm38.primary_assembly.genome.fa) \
# -i gencode.vM24.annotation.expanded.sidx --gencode -p 32 \
# -d GRCm38.primary_assembly.genome.chrnames.txt

##########################################

tximeta::makeLinkedTxome(
  indexDir =  "~/single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus_musculus.annotation.expanded.sidx", 
  source = "LocalEnsembl", genome = "GRCm39", 
  organism = "Mus musculus", release = "108", 
  fasta = "~/single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.fa", 
  gtf = "~/single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.gtf", 
  write = TRUE, jsonFile = "~/single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.json"
)
rjson::fromJSON(file = "~/single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.json")
############ bash #################
#salmon alevin -l ISR -i single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.vM24.annotation.expanded.sidx \
# -1 mouse_f1.fastq.gz \
# -2 mouse_r2.fastq.gz \
# -o alevin_out -p 10 --tgMap single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.tx2gene.tsv \
# --chromiumV3 --expectCells 20000
#######################################
library(tximport)
library(fishpond)

test <- tximeta::loadLinkedTxome("~/single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.json")
txi <- tximeta::tximeta(coldata = data.frame(
  names = "Results_E11",
  files = "~/single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Results_E11/alevin/quants_mat.gz",
  stringsAsFactors = FALSE
), type = "alevin")
txi <- tximport("~/single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Results_E11/alevin/quants_mat.gz", type="alevin")
txi <- SummarizedExperiment(txi$counts)
cg <- read.delim("~/single_cell_analysis/single_cell_integration/ScRNAseq_mouse_liver_injury_atlas_v3/single_cell_alignment_for_velocity/Mus.musculus.annotation.expanded.features.tsv",header = TRUE, as.is = TRUE)
colnames(cg)[colnames(cg) == "intron"] <- "unspliced"
txis <- tximeta::splitSE(txi, cg, assayName = "counts")
