#Script to Analyze each dataset separatly. Example with CRA002445 :

#READ datasets :
E11 <- ReadMtx(mtx = "E11.0/filtered_feature_bc_matrix/E11_matrix.mtx.gz", features = "E11.0/filtered_feature_bc_matrix/E11_features.tsv.gz", cells = "E11.0/filtered_feature_bc_matrix/E11_barcodes.tsv.gz" )
E11 <- CreateSeuratObject(E11, min.cells = 3, min.features = 100, project = "E11")
E11.5 <- ReadMtx(mtx = "E11.5/filtered_feature_bc_matrix/matrix.mtx.gz", features = "E11.5/filtered_feature_bc_matrix/features.tsv.gz", cells = "E11.5/filtered_feature_bc_matrix/barcodes.tsv.gz" )
E11.5 <- CreateSeuratObject(E11.5, min.cells = 3, min.features = 100, project = "E11.5")
#... same command lines for each dataset of the study ...

#merge datasets
CRA002445 <- merge(x = E11, y = c(E11.5,E13,E14.5,E16,E17.5), add.cell.ids = c("E11","E11.5","E13","E14.5","E16","E17.5"))

#PLOT Percent Mitochondrial features :
CRA002445[["percent.mt"]] <- PercentageFeatureSet(CRA002445,pattern = "^mt")
VlnPlot(CRA002445, features = "percent.mt", pt.size = 0)

#FILTERING + PLOT results
CRA002445 <- subset(CRA002445, subset = nFeature_RNA > 1000 & nFeature_RNA < 5000 & percent.mt < 20)
VlnPlot(CRA002445,features = "nFeature_RNA", pt.size = 0)
VlnPlot(CRA002445, features = "percent.mt", pt.size = 0)

#NORMALIZATION
CRA002445 <- SCTransform(CRA002445)


#REDUCE DIMENSION
CRA002445 <- RunPCA(CRA002445)
CRA002445 <- FindNeighbors(CRA002445,dims = 1:30)
CRA002445 <- RunUMAP(CRA002445, dims = 1:30)

#CLUSTERING+PLOT
CRA002445 <- FindClusters(CRA002445, resolution = 0.3)
DimPlot(CRA002445, label = T)

#VIZUALISING MARKERS
##Identification hepatocytes markers
FeaturePlot(CRA002445, features = c("Alb", "Apoc3"))
DimPlot(CRA002445,label =T)

##Identification cholangiocytes markers
FeaturePlot(CRA002445, features = c("Sox9", "Epcam"))

##Identification hepatoblasts markers
FeaturePlot(CRA002445, features = c("Hnf4a", "Afp","Dlk1","Cd13","Fgb","Fxyd1","Gjb1","Id3"))

##Identification NPC markers
FeaturePlot(CRA002445, features = c("Col1a1", "Acta2","Lox","Pdgfrb","Des","Lrat","Dcn","Upk1b", "Cd248", "Eln","Clec4f","Itgam","Pecam1","Flt1","Vim","Gypa"))

#HIGHLIGHTING CLUSTERS OF INTEREST
test <- Cells(subset(CRA002445,idents = c(11,9,3,12,25)))
DimPlot(CRA002445, cells.highlight = test, order = T)+scale_color_manual(labels = c("Not kept", "kept"), values = c("gray", "red"))+theme(legend.position= "top", legend.text = element_text(size = 8))

#SELECTING CLUSTERS OF INTEREST
CRA002445 <- subset(CRA002445, idents = c(11,9,3,12,25))
DimPlot(CRA002445)

#SAVE Dataset in a RDS file
saveRDS(CRA002445,"CRA002445_filtered.rds")

