
# GitLab: Choudhury et al. (2020)

Start: 10 Minutes to revisit your notes / compare with your neighbour

Explain p.3 / how it works:

- show the gitlab repository/merge requests (highligh > 100.000 merged)
- show decision rights: merge

Main challenges (after the background, p. 5-6, focusing particularly on the challenges relevant to organizational culture)

- p. 6 - Professional isolation (lack of informal mentoring, including **serendipituous** face-to-face interactions)
- p. 12 - Building a cohesive organizational culture (selection/onboarding/socialization, mentoring)
- p. 14 - Absence of colocation: may hinder organizational identification and the development of shared mental models (identification is important for motivation/effort, mental models: conducive oraganizational culture with strong norms/values)
<!-- - Maintaining a healthy work-life balance / avoiding emotional exhaustion -->
<!-- - Transparency of compensation (is cost-of-living adjustment fair?, finding out that one is paid less than coworkers can harm motivation) - GitLab somehow overcomes the "salary taboo" -->

Organizing principles

- Reduce coordination requirements (decomposability/minimum viable change, sigmergy: coordinate through the work product and environemnt, see what others are doing)
- Granting operational autonomy (not strategic autonomy)
- Input control ("selection at the gate" - select for abilities: structuring work days, digital skills,...)
-> Illustrate: control (the GitLab-CEO mentioned the differences between a consensus/hierarchical culture) - input (hiring), process (behavior: shared norms/mental models, process/documentation), output (progress reports/meetings ...)
- Detailed onboarding process
- Open and transparent documentation to build trust (remember: trust meta-analysis)

Boundary conditions

- Document-based/digital work (not work on physical goods)
- Visibility of the work process and outcome (for stigmergic coordination)
- Transparent compensation only works when contributions are easily observable
- Risks generated by transparency must be low (e.g., privacy concerns, regulatory requirements)

<!-- - Negative feedback loop: fewer "remote fit" workers <-> remote no longer perceived as special (incentive) -->
<!-- 
TBD: does it fit with the discussion/summary? - adopt a communication/collaboration/coordination perspective:

- asynchronous (convenient access without waiting across timezones)
- Transparent, accessible, linkable (contrary to e-mail, tacit group memory (ominous: we change the process / we use workarounds), links: within the docs and from outside)
- Collaboratively editable (-> comparison with Wikis) https://about.gitlab.com/handbook/handbook-usage/#wiki-handbooks-dont-scale
-->

# Communication at GitLab

Have students read the communication section in the Gitlab handbook:
- split students in x groups
- analyze sections, summarize guidelines as well as most surprising and most useful point (briefly present to the class)
- share short abstract with GW, GW: create a summary and share for exams


Communication settings

- Negotiate
- Converge
- Convey / present
- Learn/problem-solve (interactive vs. how-to)
- Cocreate (pair-program)
- Socialize
- Coordinate in small teams or broadcast

Discussion:

- Means of communication/best practices, policies/guidelines
- formalizing informal communication at Gitlab: examples
- Short educational videos/explanations
- Timing and choice of communication media (e.g., for conflicts)
- Symbol sets: screen sharing, virtual reality, direct collaboration on code
- synchronous: e.g., pair programming 
- Modes of collaboration (synchronous/asynchronous)
- Live session sharing (have students try it/visualstudio) - mention the Kude/ISR paper on pair programming?
- netiquette - be sensitive: all going well/busy time? (green/orange/red), meeting policy (remote meeting, ....)

- How to facilitate small-talk? Put something personal in the background. Ask for oppinions/help
- How to connect? Humor? "Employee of the month" - not taking oneself too seriously... share your shortcomings/be vulnerable

-  Balance: efficiency (answer questions once/reprocessability), conflict, misunderstandings (task/relation)