---
title: "Teaching notes: Getting-things-done"
nav_exclude: true
---

# General announcements

Next week: start at 14.00 (stud. Vollversammlung)

## Recap

- Drivers of change: historical and organizational context (scientific management, which was shaped by the industrial revolutions and still influences the world of digital work)
- Change of organizations and work: facets of organization types, transaction costs and the possibility of smaller companies/freelances, war for talent and knowledge economy
- Different views on how digital work is or should change. Economists, New Work, Realist on how to find job satisfaction
- Cal Newport: Deep work - time blocking, avoid distraction, do the hard thinking

## Warm-up question

What's different about digital? Which skills do we need for digital work?

- Have students write ideas on the blackboard (activation and comparison/reflection when we go through the frameworks, without explicitly comparing them)


## Weritz grounded theory

Refer to the responses to the warm-up questions (you could imagine that these are the responses of CIOs, CEOs etc.).

## Gagné-Pratte: illustrate search

Show Ven-Diagram for the AND-OR terms

- Structure not arbitrary, but: concepts and synonym groups (Building-blocks)
- Importance of covering different synonyms and spelling variations
- Result: 459, with only 76 relevant: deliberately implement a broad search (accept irrelevant papers) for completeness

## Summary

|Dimension   | <div style="width:270px">DigComp (EU)</div>  | <div style="width:270px">Weritz (2022)</div>  | <div style="width:290px">Gagné-Pratte et al. (2022) </div> |   
|-------------|---|---|---|
| Focus  <br><br>|   |   |   |   
| Research design<br><br> |   |   |   |   
| Principal findings <br><br><br><br> | | | 
| Target audience <br><br> |   |   |   |  


## Overview of methods

- Deep work: time-blocking, distraction blocking, hard thinking
- Pomodoro: work 25 minutes, 5 minute break, after 4 runs: 30 mins break
- Eisenhower matrix: Wichtigkeit x Dringlichkeit (Discard, Delegate, Plan, Do immediately)
- Checklists: doctors, pilots (e.g., checklist manifesto)
- Bullet journalling: illustrate day plan (todo, done, info, meeting), weekly planner (days...., goals: practice, mails, workout)

## GTD method

- Highlight that priority is the last criterion (discuss how that makes sense)

# GTD Exercise

Notes:

- The following summarizes a scenario in which **groups of students** (3-6 students) implement a GTD system and complete the GTD steps for friend who is about to begin studying (hypothetical).
- The group selects one student who writes (maybe switch).
- Students may use the Internet for quick searches.
- Instructors provide an introduction and explain the tasks for each of the following episodes. It shoudl be announced how much time is available

## Introduction

When thinking about productivity and work systems, we may quickly consider different apps or software packages.

- Apps (as a technology) are flexible. They can be used or adapted effectively or ineffectively.
- Example: In apps like *Todoist*, users can create tasks like "complete the Bachelor", or "find a job". In such cases, it is apparent that the app is not used effectively because these items are long-term goals rather than specific tasks. They may sipmly clutter the task list.
- To use productivity apps effectively, it can be instructive to **consider work methods and principles**. Similarly, designers of apps may draw inspiration from such works to improve apps and guide users.

The focus of this session is on the **Getting-things-done** method, which was introduced by David Allen in 2001.

This method aims at organizing individual workflows effectively, and achieving "stress-free productivity" (main sources of stress: stuff/information overload, incompletes, open loops).

It differs from approaches like **Deep Work**, which focus more on highly concentrated work and hard thinking.


## Setup (week before the semester starts): 5-10 min

In the first episode, the groups should set up the system by creating the lists (digital folders) and artifacts on the blackboard (or Flipchart). The goal is to repeat/specify the different elements.

Expected outcome:

- Inbox
- Action lists
- Agenda
- To read, Calls, ...
- Project list
- Checklists
- Waiting for
- Reference material (e.g., data)
- Calendar
- Tickler

After groups have completed the initial setup, ask them **whether they would add anything beyond the GTD elements**, why, and whether it would be consistent with the GTD philosophy.

Discuss whether the e-mail, phone, workspace would require any particular setup for GTD.

Possible outcomes: E-Mail: waiting-for (self-cc)

## Organizing (few days before the semester): 5 min

A few days before the semester, the upcoming responsibilities are a bit overwhelming (e.g., anxious to miss deadlines, etc.). How could the system setup be used to prepare? Think about your first semester.

Expected outcome

- Create projects for each lecture
- Add reminders for exam registration

## Processing (first day with an overload of stuff): 10 min

Students are provided with input material to process according to the GTD workflow / add to different lists.

**Show the GTD workflow** slide using the beamer.

Discuss:

- how items were processed.
- the digital setup (inbox-directories on file-shares, waiting-for and self-cc in email)
- tickler setups (43 folders) and importance of having material activated at a given time (e.g., )

## Weekly review (Friday)

How would we conduct the review?

1. Review inbox and other lists (action, calendar, waiting-for, ...)
2. Review the week (anything to change?)
3. Prioritize (stop responding, start acting, think strategically, be aware of your workload/priorities when committing to new projects)

Cover different levels of planning:

- Projects
- Areas of focus and acountability
- One- to two-year goals and objectives
- Three- to five-year vision 
- Purpose and principles

<!-- 

Start:
- Info von anderen Studis (pull infos): "Webseite Uni Prüfung.png"
    - Regelm. Reminder? / pull - website monitoring?
    - Überschneidungen von Klausuren prüfen, ggf. Klausuren vorziehen (um Mindest-Anforderungen ECTS im Semester zu schaffen)
    - typisches Bsp: für selbstinitiativ Infos holen/regelm. prüfen/aktiv werden

- Mail vom PA: "Prüfungsanmeldungs Mail.png"
    - Infos zu Anmeldung

- Prüfungsterminplan: "Pruefungsterminplan_WS_2022_23.pdf"
    - Kalender: Prüfung/Vorbereitung
    - vor E-mail vom PA verfügbar

- Dezentral: in den Vorlesungs-Sessions oder von der Websites der Lehrstühle

- Flexnow-Anmeldung: wie in den Einführungstagen gelernt (oder im Flyer/Website)
    - https://www.uni-bamberg.de/pruefungsamt/flexnow/fn2sss/anleitungen/
    - Anmeldung: nicht in den letzten Stunden vor Deadline
    - Klausurverschiebungen: regelm. auf Flexnow prüfen (Info wird nicht per Mail verschickt)

- Lernplan: Unterlagen zu Vorlesung und Übung, Altklausuren der Fachschaft anfragen
    - Vorausschauend planen (Input von anderen rechtzeitig holen, Aufwand abschätzen, einteilen)
    - Letzte Vorlesung: Infos zu ausgeschlossenem Stoff mitbekommen (von Komillitonen) - zB. Lektüren ausgeschlossen?
    - Parallel planen (Schwerpunkte legen oder parallel lernen?), Pausen/Erholung?
        -> "projekte parallel planen"
    - zu gewissem Zeitpunkt/wöchentlich prüfen: Möglichkeit, von Prüfung abzumelden (je nach Studiengang) bzw. für ausgewählte Prüfungen nicht mehr zu lernen (Aufwand...)

Erweiterungen:
- Ggf.: bei Entwerfen von Checklisten/Prozessbeschreibungen das Bsp. wieder aufgreifen
- data -> obsidian/vl
- read: symlinked?
- waiting for: Altklausurenanfrage an die Fachschaft (self-cc)
- action-context.uni-vor-ort: Unterlagen (Paper) im Uninetz herunterladen / in der Bib nachschauen / im PA klären

VC-Kurs: Unterlagen step-by-step freigeben/Studis: herunterladen


TODO :
-  add digital work lecture slides as an input for the GTD exercise
- ggf. auch Übungsblätter mitgeben


TBD: wie bekommen die Studis die Unterlagen?
-> download and create folders/add everythign to inbox, then: sort?
-> how to show the solution? -> do the categorization live (and show a table overview afterwards) 


 -->