---
marp: true
header: 'Introduction to Digital Work'
theme: ub-theme
paginate: true
---

<!-- _class: lead -->

# Lecture 12 - Ethics and the future of work

---

<!-- _class: overview_part_5 -->

---

# Learning objectives

- Appreciate the ethical challenges arising in the future of digital work.
- Discuss ethical decisions in this context based on ethical theories.

---

# Ethical challenges in the future of digital work

![width:600px center](../material/ethics-challenges.jpg)

---

# Case 1: Fair compensation

![width:600px center](../material/compensation.jpg)

---

# Ethical theories

- Utilitarian (consequentialist) ethics
- Deontological ethics
- Virtue ethics

---

# Utilitarianism

Key proponents: Jeremy Bentham, John Stuart Mill

- Ethical decisions maximize the happiness for all individuals affected.
- Only consequences are considered to judge whether a decision is right or wrong (consequentialist approach).
- Utilitarianism is a rational normative approach that resembles economic assessments of costs and benefits.
- Criticism (example): In purely utilitarian ethics, the utility (or pleasure) of many may be used to justify suffering for individuals. Immoral actions may be justified based on their consequences.

---

# Deontology

Key proponents: Immanuel Kant, John Rawls, Thomas von Aquin

- A decision is morally right if the action itself is right under a series of rules and principles.
- People have the moral obligation to follow universal rules. Consequences are not taken into account, considering that bad intentions could accidentally lead to good consequences and vice versa.
- Categorical imperative (original version): "Act only according to that maxim whereby you can at the same time will that it should become a universal law."
- Criticism: In some situations, categorical rules can lead to an excessive extent of adverse consequences.

---

# Virtue ethics

Key proponents: Socrates, Niccolò Machiavelli, David Hume

- A virtuous person should practice good habits such as honesty, temperance, and generosity.
- Virtue ethics focuses more on the good life (eudaimonia), rather than explaining which actions are morally permitted.
- Criticism: In some cases, it can be hard to judge whether an action is immoral based on virtue ethics. Virtues may change throughout history and across cultures.

<!--  

---

# Break
-->

---

# Case 2: Workplace surveillance

![width:600px center](../material/surveillance.jpg)

---

# Case 3: Crowd-work platforms, exploitation, and the role of platform owners

![width:600px center](../material/food_delivery.jpg)

---

# Summary

- We considered three cases: Compensation, surveillance, and crowd-work
- Ethical theories covered: Utilitarianism, duty ethics, and virtue ethics
- There are more ethical perspectives, such as discourse ethics, libertarian, or communitarian approaches

<!-- 

---

<style scoped>
p {
    padding-left: 36px;
    text-indent: -36px;
}
</style>

# Materials

TODO
 -->

---

<!-- _class: overview_all -->

---
<!-- _class: centered -->

# Reminder: Please complete the evaluation!

# Next session: Questions and test exam