---
marp: true
header: 'Introduction to Digital Work'
theme: ub-theme
paginate: true
---

<!-- _class: lead -->

# Lecture 11 - Digital work and its futures

# Humans vs Machines

---

<!-- _class: overview_part_5 -->

---

<!-- _class: centered -->


# Warm-up question

- What is the future of human labor vis-à-vis machines?

![bg right:55% Humans vs machines width:600px](../material/Humans_machines.jpg)

<!-- 
- What are the key challenges in the future of work?

Simon Sinek: there's a lot in the air right now / nobody knows exactly where it will land
- example: remote work (people telling their managers that they've moved to Florida / Twitter calling back employees)

world economic forum:
https://www.youtube.com/watch?v=EuDnSqAo784


https://www.youtube.com/watch?v=JyTqt5G-phs

- Use videos to illustrate trends / get experts assessments

nice AI/automation/robotics examples (6 years old but interesting)
https://www.youtube.com/watch?v=dRw4d2Si8LA
-->


---

<style>
blockquote {
    border-top: 0.1em;
    font-size: 60%;
    margin-top: auto;
}
</style>

# Learning objectives

- Predict the replacement of human labor by machines in the near future using illustrative examples.
- Discuss possible futures* at the intersection of AI-based and human work.

> \* Note: In our context, the term "futures" is used to refer to different developments that are possible in the future (as discussed in prior literature, see [1](https://aisel.aisnet.org/jais/vol21/iss6/10/), or [2](https://aisel.aisnet.org/ecis2021_panels/2/)). In finance, the term "futures" has a different meaning.

---

# Research on the replacement of human labor

- The concept of **jobs** is relatively complex, and involves multiple skills, steps, and interactions.

- The replacement of human labour is commonly studied at the the level of individual **tasks**. For this unit of analysis, requirements are more narrow, making it easier to compare the performance of humans and machines.

- Focusing on individual tasks raises critical questions:

    - Which skills are easy to substitute by machines?
    - How easily can different jobs be disaggregated into individual tasks?
    - How does human labour evolve when machines replace or augment tasks? 

<!-- 
Example of a nurse: quality of care, emotional, clinical, administration, collaboration/learning
Example of a radiological diagnosis: True or False.

Note : the same disaggregation questions were asked in the outsourcing context (basically lowering the cost of human labor)

part of the equation could be customer self-service
-->

---

# Highly substitutable tasks

Extant research has identified task properties associated with automation (Deranty and Corbin): 

- Repetitive, documented, and atomic tasks with a clear objective
- Large amounts of data available for analysis
- Automated enactment does not raise ethical concerns

<!--
also: MithasWhitaker2007 Table 2
 - Routine (low-context) environments
f-->

---

# Non-substitutable skills

In an [HBR article](https://hbr.org/2018/07/7-skills-that-arent-about-to-be-automated), Gustein and Sviokla suggest the following skills are hard to substitute by AI:

- Communication
- Context
- Emotional competence
- Teaching
- Connections
- An ethical compass

<!-- 
TODO : Analyze the paper and link it
-> TBD: discuss (e.g., teaching: MOOC?)

teaching: the authors refer more to on-the-job training
-->

---

# Non-substitutable skills: IT

Atasoy, Banker, and Pavlou (2021) use panel data from Turkey to analyze how IT skills impact labor market outcomes:

- **Basic IT skills** increase **employment probability** due to increased labor force participation and a higher probability of transitioning from unemployment to employment (after deciding to work)
- **Advanced IT skills** help workers earn **higher wages** and increases the probability that they are employed in higher-paid jobs.

<!--
Note: similar to digital (technical) skills (in the first lectures)
[[AtasoyBankerPavlou2021]]
-->

--- 

# Disaggregation of human labour

Mithas and Whitaker propose a **theory of service disaggregation**: High information intensity makes an occupation more amenable to disaggregation because the activities in such occupations can be codified, standardized, and modularized.

- **Codifiability**: The extent to which knowledge can be converted into a form suitable for transfer across economic agents.
- **Standardizability**: A common framework and vocabulary to define business processes.
- **Modularizability**: The decomposition of a product or service into components.

<!-- 
TODO : check Table 1 for examples
 
<->
"high information-intensity and high-skill occupations appear to be relatively less vulnerable to global disaggregation."
-->
---

# Substitution of jobs

The "Job-Futuromat" is based on a task (dis)aggregation approach ([link](https://job-futuromat.iab.de/)):

![width:600px center](../material/futuromat.png)

<!-- 
- Man vs. machine (AI) discussions am Beispiel des [Job-Futuromat](https://job-futuromat.iab.de/) (Methode: Industrienahe Erhebung/Dekomposition in Kernanforderungen Analyse des Substituierbarkeitspotentials)
- IAB Substituierbarkeitspotentiale.pdf
-> give examples
 -->

---

<!-- _class: centered -->

# Break

---

# Possible futures at the intersection of AI-based and human work

- Scholars have discussed possible futures of AI job augmentation and replacement
- Their work builds on initial examples and attempts to derive a vision of the future
- These visions range from realistic (even outdated) to utopian or dystopian
- They are not based on conventional scientific evidence, but are important contributions to the discourse

<!--
TBD: "continuity of nature" assumption? 
 https://www.coursera.org/learn/ai-business-future-of-work/lecture/WEV1z/a-theory-of-ai-job-replacement -->

---

# Future 1

- When most jobs have become automated, human interaction will become the premium alternative
- Customers want to pay extra for having contact with a human representative
- Both AI and people will be employed at the same time for the same job

Example: Fast-food restaurants like McDonalds expand and test the use of AI ([The Guardian](https://www.theguardian.com/business/article/2024/jun/17/mcdonalds-ends-ai-drive-thru))

- Customer self-service
- Delivery services
- Restaurant automation

![bg right:35% width:350px](../material/robotic_waiter.jpg)

---

# Future 2

- Humans and machines have a complementary division of labor
- Computers will not be able to fully replicate human emotions
- Machines will carry out the repetitive tasks
- Humans would be supported by AI systems and become even more powerful

Example: Radiologists and AI

- In several cases, AI-based diagnostics is more accurate compared to a physician
- Physicians know the limitations of AI-based predictions and take responsibility for treatment decisions
- Patients prefer to interact with a physician

![bg right:35% width:400px](../material/healthcare.jpg)

<!-- 
(uncanny valley)
-->
---

# Future 3

- A human-centric view of AI
- People retain full control over AI development
- Machines will be allowed to take over those industries, jobs or tasks that no human wants to engage with
- People can choose to work in those jobs that give them a sense of satisfaction or fulfillment

Example: Industrial production and retail

- Cleaning and monitoring
- Logistics

![bg right:35% width:350px](../material/cleaning_robot.jpg)

---

# Future 4

- A physical and cognitive integration of humans and machines
- People will be able to have body and mind enhancement

Example: Elon Musk's Neuralink project - "A merger between biological and digital intelligence"

- 2017-05-05 Launch of Neuralink to develop Brain-computer interfaces
- 2023-05-25 Approval for clinical trials by the FDA
- 2024-01-29 Successful implantation with promising results
- 2024-02-20 Human participant is able to control a computer mouse through thought

![bg right:35% width:400px](../material/neuralink.jpg)

---

# Future 5

- Machines completely dominate over humans
- Interconnected AI systems are powerful and human behavior is imperfect
- AI forms systems that are more complex than the software that produces them (Artificial General Intelligence)
- The case for robot disobedience: Humans make mistakes in creating or mastering robots

Example: A thought experiment in the context of AI-controlled military drones ([The Guardian](https://www.theguardian.com/us-news/2023/jun/01/us-military-drone-ai-killed-operator-simulated-test), [Reuters](https://www.reuters.com/article/fact-check/simulation-of-ai-drone-killing-its-human-operator-was-hypothetical-air-force-sa-idUSL1N38023R/))

- An AI-controlled drone was given the task of destroying enemy air defense systems (objective function)
- The AI system learned that sometimes the operator interferred with that objective (learning)
- The system started to attack the operator or communication systems (unexpected and unintended behavior)

<!--
killer-drone scenario: reinforcement learning
-> is that the darkest scenario?

- Ray Kurzwall, Sam Harris

AI industry leaders: threat:
https://www.nytimes.com/2023/05/30/technology/ai-threat-warning.html
AI in organizational work impacts society (e.g., Facebook/fake news...)

drone "apparently" attacking commander
https://www.theregister.com/2023/06/02/ai_drone_simulation/


# Societal discourse and regulatory measures

EU: responsible AI

Challenges: when to prefer AI or human decisions
- decision process: Cognitive biases vs. training data problems
- decision outcome: ethical, "optimal", ... 

AI - also: Quantum Computing -->

---

# Organizational scholars' perspectives on the future of work

Adam Grant: Professor of organizational psychology at Wharton
Malcolm Gladwell: Journalist and NYT best-selling author

[Future of Work Conference: Getting Uncomfortable with the Future](https://www.youtube.com/watch?v=jH7IvThAoH0)

![width:500px center](../material/future-of-work-conference.png)

<!-- 
Grant: influential management thinker, youngest tenured professor at Wharton, 4x Org science, Books, 7x best professor at Wharton (by students)....
Gladwell: Journalist with honorary doctorates and best-sellers: outliers was nr1 on the NYT best seller list for three months
-->

---

<style scoped>
p {
    padding-left: 36px;
    text-indent: -36px;
}
</style>

# Materials

Atasoy, H., Banker, R. D., & Pavlou, P. A. (2021). Information technology skills and labor market outcomes for workers. *Information Systems Research*, 32(2), 437-461.

Deranty, J. P., & Corbin, T. (2022). Artificial Intelligence and work: a critical review of recent research from the social sciences. *AI & Society*, 1-17.

Gustein, A. J., & Sviokla, J. (7). Skills that aren’t about to be automated. *Harvard Business Review*.

Mithas, S., & Whitaker, J. (2007). Is the world flat or spiky? Information intensity, skills, and global service disaggregation. *Information Systems Research*, 18(3), 237-259.

<!--
TBD: blockchain networks/DAO and the implications/opportunities for the future of work (trust, disintermediation/direct interaction with objects)


ChatGPT:
- used as a coding co-pilot 
- Banned on UNSW campus
- example task for students: find the sources that led to a ChatGPT response
- potential pitfall: ChatGPT content is copyright licensed
- Blair Wang: potential way of addressing ChatGPT: include figures/diagrams (ChatGPT cannot do that yet), or require reflection related to the team

Check works of Tina Klüwer

Comparison: Humans vs. machines

[[JainPadmanabhanPavlouEtAl2018]]: ... the main intellectual advances will be made by men and computers working together in intimate association. (Licklider 1960)

Machines outperform humans in (most traditional economic measures)
- reliability (errors)
- cost of operation (think: production of intangible artefacts: cost of copying/... is close to zero)
- mechanical precision (surgeons)
- computational power
Humans outperform machines (more important when "basic needs" are met / Maslow?)
- compassion
- fairness
- democracy
- fulfillment
 
Futuromat: substituierbarkeit von Berufen
http://doku.iab.de/kurzber/2018/kb0418.pdf
-   Automatization (robots), industry 4.0 -> replace particular types of labor
- Machine capabilities: from powering the conveyor belt to surpassing surgeons in precision

- Types of digital work (classification)

- Digital work (Definition? - ggf. Begriff prägen? Bereiche klären: IT/Produktion/...?), Prozess, Verhalten, Technologie
- TBD: Competences for digital work (TBD),

-- Next chapters: implicitly: excell individually, excell in a team, excell with a crowd --> 
