#!/bin/bash

# 设置绘图参数
gmt gmtset FONT_ANNOT_PRIMARY=7.5p,Times-Roman,black MAP_FRAME_PEN=thinnest,black MAP_FRAME_WIDTH=1p MAP_TICK_LENGTH_PRIMARY=1.5p/1p MAP_TICK_PEN_PRIMARY=thinnest,black MAP_TITLE_OFFSET=6.5p MAP_GRID_PEN_PRIMARY=thinnest,grey,-- FONT_LABEL=8p,Times-Roman,black MAP_FRAME_AXES=WESnZ COLOR_NAN=white MAP_LABEL_OFFSET=1p MAP_ANNOT_OFFSET_PRIMARY=2.5p

gmt grd2cpt grav_obs.nc -R45/50/25/30 -Ctemperature.cpt -T-3.36/-0.39/0.01 -D -M > user.cpt
gmt grdimage grav_obs.nc -R45/50/25/30 -Cuser.cpt -Bxag+l"longitude (degree)" -Byag+l"latitude (degree)" -JL47.5/27.5/26.25/28.75/1.5i -K -P > plot_obs.ps
gmt psscale -Dx0.125i/-0.3i+w1.2i/0.05i+h -Cuser.cpt -Bx0.6 -By+lmGal -O -K >> plot_obs.ps
gmt pstext -R45/50/25/30 -JL47.5/27.5/26.25/28.75/1.5i -K -O <<- EOF >> plot_obs.ps
45.3,29.8,(a)
EOF

gmt grd2cpt geoid_obs.nc -R45/50/25/30 -Ctemperature.cpt -T-0.89/-0.51/0.01 -D -M > user.cpt
gmt grdimage geoid_obs.nc -R45/50/25/30 -Cuser.cpt -Bxag+l"longitude (degree)" -Byag+l"latitude (degree)" -JL47.5/27.5/26.25/28.75/1.5i -K -O -P -X2i >> plot_obs.ps
gmt psscale -Dx0.125i/-0.3i+w1.2i/0.05i+h -Cuser.cpt -Bx0.08 -By+lm -K -O >> plot_obs.ps
gmt pstext -R45/50/25/30 -JL47.5/27.5/26.25/28.75/1.5i -O <<- EOF >> plot_obs.ps
45.3,29.8,(b)
EOF

gmt psconvert plot_obs.ps -A -TEG -E300
# 删除临时文件 使用linux终端rm命令
rm plot_obs.ps user.cpt gmt.history gmt.conf
open plot_obs.png