/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#ifndef _GIST_OPTIONS_H
#define _GIST_OPTIONS_H

/* Genernal options */
#define GIST_LCG_OPTS        "lcg-setup"              // Parameters of the conjugate gradient methods.
#define GIST_LBFGS_OPTS      "lbfgs-setup"            // Parameters of the L-BFGS method.
#define GIST_LGD_OPTS        "lgd-setup"              // Parameters of the L-GD method.
#define GIST_IN_MS           "mspace-in"              // Input Gmsh (.msh) model file name.
#define GIST_OUT_MS          "mspace-out"             // Output Gmsh (.msh) model file name.
#define GIST_NODE_DATA       "node-data"              // Node data name(s).
#define GIST_FACE_DATA       "face-data"              // Face data name(s).
#define GIST_VOLU_DATA       "volume-data"            // Volume data name(s).
#define GIST_GMSH_PACKED     "gmsh-packed"            // If the node index in Gmsh file is starting from zero(packed) or one (not packed).
#define GIST_REF_EARTH       "ref-earth"              // Name of the 1D reference earth file.
#define GIST_REF_FRAME       "ref-frame"              // Name of the reference frame type. This option has the values of EarthMean|WGS84/<latitude>|<r>/<R>/<normal_g>.
#define GIST_REF_DATA        "ref-data"               // Inquire string for the 1D reference earth. This option has the format <radius>/<latitude>[/<type>].

/* Model options */
#define GIST_TOP_BND         "top-boundary"           // Name of the top interface of the modeling region.
#define GIST_BTM_BND         "bottom-boundary"        // Name of the bottom interface of the modeling region.
#define GIST_DEN             "density"                // Density model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_BKG_DEN         "density-bkg"            // Background density model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_REF_DEN         "density-ref"            // Reference density model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_ERR_DEN         "density-err"
#define GIST_TOPO_DEN        "density-topo"           // Topography dentiy model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_PRESSURE        "pressure"               // Pressure model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_BKG_PRESSURE    "pressure-bkg"           // Background pressure model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_REF_PRESSURE    "pressure-ref"           // Reference pressure model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_ERR_PRESSURE    "pressure-err"           // Error of the pressure model.
#define GIST_ERR_ELEVATION   "elevation-err"          // Error of the pressure model.
#define GIST_THERMAL         "thermal"                // Thermal model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_BKG_THERMAL     "thermal-bkg"            // Background thermal model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_REF_THERMAL     "thermal-ref"            // Reference thermal model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_ERR_THERMAL     "thermal-err"            // Error of the thermal model.
#define GIST_VS              "vs"                     // Vs model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_BKG_VS          "vs-bkg"                 // Background Vs model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_REF_VS          "vs-ref"                 // Reference Vs model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_ERR_VS          "vs-err"                 // Error of the Vs model.
#define GIST_VP              "vp"                     // Vp model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_BKG_VP          "vp-bkg"                 // Background Vp model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_REF_VP          "vp-ref"                 // Reference Vp model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_ERR_VP          "vp-err"                 // Error of the Vp model.
#define GIST_MINERAL         "mineral"                // Mineral model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_BKG_MINERAL     "mineral-bkg"            // Background mineral model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_REF_MINERAL     "mineral-ref"            // Reference mineral model. This option take suffixes '-tag', '-model' and '-value'.

/* Data options */
#define GIST_IN_GEOID        "geoid-in"               // Name of the input geoid observation file.
#define GIST_OUT_GEOID       "geoid-out"              // Name of the output geoid observation file.
#define GIST_ERR_GEOID       "geoid-err"              // Error of the geoid data.
#define GIST_MAT_GEOID       "geoid-mat"              // Name of the geoid kernel file.
#define GIST_IN_GRAVITY      "gravity-in"             // Name of the input gravity observation file.
#define GIST_OUT_GRAVITY     "gravity-out"            // Name of the output gravity observation file.
#define GIST_ERR_GRAVITY     "gravity-err"            // Error of the gravity data.
#define GIST_MAT_GRAVITY     "gravity-mat"            // Name of the gravity kernel file.
#define GIST_IN_HTFLOW       "heatflow-in"            // Name of the input heat-flow file.
#define GIST_OUT_HTFLOW      "heatflow-out"           // Name of the output heat-flow file.
#define GIST_TAG_HTFLOW      "heatflow-tag"           // Tag of the heatflow observation sites.
#define GIST_IN_PETROPHYS    "thermophysics-in"        // Name of the thermophysical reference grid file(s).
#define GIST_IN_ELEVATION    "elevation-in"           // Name of the input elevation data name.
#define GIST_OUT_ELEVATION   "elevation-out"          // Name of the output elevation file.

/* Inversion options */
#define GIST_WGT_DATA        "data-wgt"               // Weights of multiple data-misfit functions.
#define GIST_RMS_DATA        "data-rms"               // RMS threshold of the objective function for which the inversion process is to found.
#define GIST_WGT_SMTH        "smooth-wgt"             // Weight of the smoothness model constrain.
#define GIST_WGT_MINI        "minimal-wgt"            // Weight of the minimal model constrain.
#define GIST_WGT_REFM        "refmod-wgt"             // Weight of the reference model constrain.
#define GIST_WGT_DEP         "depth-wgt"              // Factor of the depth-weight for gravity and geoid inversions.
#define GIST_WGT_VOL         "volume-wgt"             // Factor of the volume-weight for gravity and geoid inversions.
#define GIST_WGT_MONO        "monotonic-wgt"          // Factor of the monotonic model constraint
#define GIST_WGT_REG         "regular-wgt"            // Weight of the regularization constrain.

/* Finite element options */
#define GIST_THERMAL_CNDT    "thermal-conduct"        // Thermal conductivity model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_THERMAL_PDCT    "thermal-product"        // Thermal productivity model. This option take suffixes '-tag', '-model' and '-value'.
#define GIST_THERMAL_BND     "thermal-boundary"       // Thermal boundary tag(s) and value(s). This option has the format <tag>/<value>.
#define GIST_THERMAL_LAYER   "thermal-layer"          // Thermal layer tags and values. This option has the format <ele-tag>/<top-tag>/<btm-tag>/<top-val>/<btm-val>.
#define GIST_THERMAL_FLOW    "thermal-heatflow"       // Heat-flow tag(s) and value(s). This option has the format <tag>/<heat-flow>.
//#define GIST_THERMAL_TRANS   "thermal-transfer"       // Heat-transfer tag(s) and value(s). This option has the format <tag>/<heat-flow>/<temperature-value>.
#define GIST_PRESS_BND       "pressure-boundary"      // Pressure boundary tag(s) and value(s). This option has the format <tag>/<temperature-value>.
#define GIST_PRESS_FACE      "pressure-interface"     // Pressures at an interface.

#endif // _GIST_OPTIONS_H