/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#ifndef _GIST_DICTIONARY_H
#define _GIST_DICTIONARY_H

#define FORWARD    "forward"
#define INVERSE    "inverse"
#define MINERAL    "mineral"
#define THERMAL    "thermal"
#define ELEVATION  "elevation"
#define PRESSURE   "pressure"
#define GRAVITY    "gravity"
#define GEOID      "geoid"
#define SWAVE      "vs"
#define PWAVE      "vp"

#define GMSH       "gmsh"
#define PACKED     "packed"
#define MODEL      "model"
#define DATA       "data"
#define FILE       "file"
#define INPUT      "input"
#define OUTPUT     "output"
#define KERNEL     "kernel"
#define EARTH1D    "earth1d"

#define VALUE      "value"
#define MODEL      "model"
#define TAG        "tag"
#define BACKGROUND "background"
#define REFERENCE  "reference"
#define INITIAL    "initial"

#define WEIGHT     "weight"
#define SMOOTH     "smooth"
#define MINIMAL    "minimal"
#define VOLUME     "volume"
#define DEPTH      "depth"
#define REGULAR    "regular"

#define ERROR      "error"
#define TOP        "top"
#define BOTTOM     "bottom"
#define TOPO       "topography"
#define BOUNDARY   "boundary"
#define LAYER      "layer"
#define HEATFLOW   "heatflow"
#define INTERFACE  "interface"
#define CONDUCT    "conduct"
#define PRODUCT    "product"

#define SOLVER     "solver"
#define LCG        "lcg"
#define LBFGS      "lbfgs"
#define LGD        "lgd"

#endif // _GIST_DICTIONARY_H