/********************************************************
 *     _____________________
 *    / ____/  _/ ___/_  __/
 *   / / __ / / \__ \ / /   
 *  / /_/ // / ___/ // /    
 *  \____/___//____//_/ 
 * Geophysical Inversions using Spherical Tetrahedral meshes (GIST)
 *
 * Copyright (c) 2022  Yi Zhang (yizhang-geo@zju.edu.cn)
 *
 * GIST is distributed under a dual licensing scheme. You can redistribute 
 * it and/or modify it under the terms of the GNU Affero General Public 
 * License (AGPL) as published by the Free Software Foundation, either version 
 * 3 of the License, or (at your option) any later version. You should have 
 * received a copy of the GNU Affero General Public License along with this 
 * program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * If the terms and conditions of the AGPL v.3. would prevent you from using 
 * the GIST, please consider the option to obtain a commercial license for a 
 * fee. These licenses are offered by the original author, Yi Zhang. As a rule, 
 * licenses are provided "as-is", unlimited in time for a one time fee. Please 
 * send corresponding requests to: yizhang-geo@zju.edu.cn. Please do not forget 
 * to include some description of your company and the realm of its activities. 
 * Also add information on how to contact you by electronic and paper mail.
 ******************************************************/

#include "thermophysics.h"

GIST::Thermophysics::Thermophysics()
{
    name_ = "Untitled"; unit_ = "Null";
	t_size_ = p_size_ = c_size_ = d_size_ = 0;
	t_min_ = p_min_ = c_min_ = 1e+30;
	t_max_ = p_max_ = c_max_ = -1e+30;
	dt_ = dp_ = dc_ = -1.0;
	rel_dt_ = rel_dp_ = rel_dc_ = -1.0;
	d_min_  = 1e+30; d_max_  = -1e+30;
}

GIST::Thermophysics::~Thermophysics()
{
    Clear();
}

void GIST::Thermophysics::Clear()
{
    name_ = "Untitled"; unit_ = "Null";
	t_size_ = p_size_ = c_size_ = d_size_ = 0;
	t_min_ = p_min_ = c_min_ = 1e+30;
	t_max_ = p_max_ = c_max_ = -1e+30;
	dt_ = dp_ = dc_ = -1.0;
	rel_dt_ = rel_dp_ = rel_dc_ = -1.0;
	d_min_  = 1e+30; d_max_  = -1e+30;
	if (!data_.empty())    data_.clear();
	if (!data_gt_.empty()) data_gt_.clear();
	if (!data_gp_.empty()) data_gp_.clear();
	if (!data_gc_.empty()) data_gc_.clear();
	return;
}

double GIST::Thermophysics::linear_cube_interpolate(double x0,double y0,double z0,double dx,double dy,double dz,double x,double y,double z,
	double d0,double d1,double d2,double d3,double d4,double d5,double d6,double d7)
{
	double xi0 = gctl::line_interpolate(x0, x0+dx, d0, d1, x);
	double xi1 = gctl::line_interpolate(x0, x0+dx, d3, d2, x);
	double xi2 = gctl::line_interpolate(x0, x0+dx, d4, d5, x);
	double xi3 = gctl::line_interpolate(x0, x0+dx, d7, d6, x);
	double yi0 = gctl::line_interpolate(y0, y0+dy, xi0, xi1, y);
	double yi1 = gctl::line_interpolate(y0, y0+dy, xi2, xi3, y);
	return gctl::line_interpolate(z0, z0+dz, yi0, yi1, z);
}

double GIST::Thermophysics::get_mini_temperature() const
{
	return t_min_;
}

double GIST::Thermophysics::get_maxi_temperature() const
{
	return t_max_;
}

double GIST::Thermophysics::get_mini_pressure() const
{
	return p_min_;
}

double GIST::Thermophysics::get_maxi_pressure() const
{
	return p_max_;
}

double GIST::Thermophysics::get_mini_mg() const
{
	return c_min_;
}

double GIST::Thermophysics::get_maxi_mg() const
{
	return c_max_;
}